package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.SmsAuthenticationMethodTargetCollectionRequest;
import odata.msgraph.client.beta.enums.AuthenticationMethodState;

@JsonPropertyOrder({
    "@odata.type", 
    "includeTargets"})
@JsonInclude(Include.NON_NULL)
public class SmsAuthenticationMethodConfiguration extends AuthenticationMethodConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.smsAuthenticationMethodConfiguration";
    }

    @JsonProperty("includeTargets")
    protected List<SmsAuthenticationMethodTarget> includeTargets;

    protected SmsAuthenticationMethodConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSmsAuthenticationMethodConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private AuthenticationMethodState state;
        private List<SmsAuthenticationMethodTarget> includeTargets;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder state(AuthenticationMethodState state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        public Builder includeTargets(List<SmsAuthenticationMethodTarget> includeTargets) {
            this.includeTargets = includeTargets;
            this.changedFields = changedFields.add("includeTargets");
            return this;
        }

        public Builder includeTargets(SmsAuthenticationMethodTarget... includeTargets) {
            return includeTargets(Arrays.asList(includeTargets));
        }

        public SmsAuthenticationMethodConfiguration build() {
            SmsAuthenticationMethodConfiguration _x = new SmsAuthenticationMethodConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.smsAuthenticationMethodConfiguration";
            _x.id = id;
            _x.state = state;
            _x.includeTargets = includeTargets;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public SmsAuthenticationMethodConfiguration withUnmappedField(String name, Object value) {
        SmsAuthenticationMethodConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="includeTargets")
    @JsonIgnore
    public SmsAuthenticationMethodTargetCollectionRequest getIncludeTargets() {
        return new SmsAuthenticationMethodTargetCollectionRequest(
                        contextPath.addSegment("includeTargets"), Optional.ofNullable(includeTargets));
    }

    public SmsAuthenticationMethodConfiguration withIncludeTargets(List<SmsAuthenticationMethodTarget> includeTargets) {
        SmsAuthenticationMethodConfiguration _x = _copy();
        _x.changedFields = changedFields.add("includeTargets");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.smsAuthenticationMethodConfiguration");
        _x.includeTargets = includeTargets;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SmsAuthenticationMethodConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SmsAuthenticationMethodConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SmsAuthenticationMethodConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SmsAuthenticationMethodConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SmsAuthenticationMethodConfiguration _copy() {
        SmsAuthenticationMethodConfiguration _x = new SmsAuthenticationMethodConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.state = state;
        _x.includeTargets = includeTargets;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SmsAuthenticationMethodConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("includeTargets=");
        b.append(this.includeTargets);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
