package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "skypeId"})
@JsonInclude(Include.NON_NULL)
public class SkypeUserConversationMember extends ConversationMember implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.skypeUserConversationMember";
    }

    @JsonProperty("skypeId")
    protected String skypeId;

    protected SkypeUserConversationMember() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSkypeUserConversationMember() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private List<String> roles;
        private String rolesNextLink;
        private OffsetDateTime visibleHistoryStartDateTime;
        private String skypeId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder roles(List<String> roles) {
            this.roles = roles;
            this.changedFields = changedFields.add("roles");
            return this;
        }

        public Builder roles(String... roles) {
            return roles(Arrays.asList(roles));
        }

        public Builder rolesNextLink(String rolesNextLink) {
            this.rolesNextLink = rolesNextLink;
            this.changedFields = changedFields.add("roles");
            return this;
        }

        public Builder visibleHistoryStartDateTime(OffsetDateTime visibleHistoryStartDateTime) {
            this.visibleHistoryStartDateTime = visibleHistoryStartDateTime;
            this.changedFields = changedFields.add("visibleHistoryStartDateTime");
            return this;
        }

        public Builder skypeId(String skypeId) {
            this.skypeId = skypeId;
            this.changedFields = changedFields.add("skypeId");
            return this;
        }

        public SkypeUserConversationMember build() {
            SkypeUserConversationMember _x = new SkypeUserConversationMember();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.skypeUserConversationMember";
            _x.id = id;
            _x.displayName = displayName;
            _x.roles = roles;
            _x.rolesNextLink = rolesNextLink;
            _x.visibleHistoryStartDateTime = visibleHistoryStartDateTime;
            _x.skypeId = skypeId;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="skypeId")
    @JsonIgnore
    public Optional<String> getSkypeId() {
        return Optional.ofNullable(skypeId);
    }

    public SkypeUserConversationMember withSkypeId(String skypeId) {
        SkypeUserConversationMember _x = _copy();
        _x.changedFields = changedFields.add("skypeId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeUserConversationMember");
        _x.skypeId = skypeId;
        return _x;
    }

    public SkypeUserConversationMember withUnmappedField(String name, Object value) {
        SkypeUserConversationMember _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SkypeUserConversationMember patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SkypeUserConversationMember _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SkypeUserConversationMember put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SkypeUserConversationMember _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SkypeUserConversationMember _copy() {
        SkypeUserConversationMember _x = new SkypeUserConversationMember();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.roles = roles;
        _x.visibleHistoryStartDateTime = visibleHistoryStartDateTime;
        _x.skypeId = skypeId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SkypeUserConversationMember[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("roles=");
        b.append(this.roles);
        b.append(", ");
        b.append("visibleHistoryStartDateTime=");
        b.append(this.visibleHistoryStartDateTime);
        b.append(", ");
        b.append("skypeId=");
        b.append(this.skypeId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
