package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.Deleted;
import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.complex.ItemReference;
import odata.msgraph.client.beta.complex.Root;
import odata.msgraph.client.beta.complex.SharepointIds;
import odata.msgraph.client.beta.complex.SiteCollection;
import odata.msgraph.client.beta.complex.SiteSettings;
import odata.msgraph.client.beta.entity.collection.request.BaseItemCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ColumnDefinitionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ContentTypeCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DriveCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ListCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PermissionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.RichLongRunningOperationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SiteCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SitePageCollectionRequest;
import odata.msgraph.client.beta.entity.request.DriveRequest;
import odata.msgraph.client.beta.entity.request.ItemAnalyticsRequest;
import odata.msgraph.client.beta.entity.request.OnenoteRequest;
import odata.msgraph.client.beta.termStore.entity.Store;
import odata.msgraph.client.beta.termStore.entity.request.StoreRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "deleted", 
    "displayName", 
    "root", 
    "settings", 
    "sharepointIds", 
    "siteCollection", 
    "columns", 
    "contentTypes", 
    "drive", 
    "drives", 
    "items", 
    "lists", 
    "operations", 
    "pages", 
    "permissions", 
    "sites", 
    "termStore", 
    "onenote"})
@JsonInclude(Include.NON_NULL)
public class Site extends BaseItem implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.site";
    }

    @JsonProperty("deleted")
    protected Deleted deleted;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("root")
    protected Root root;

    @JsonProperty("settings")
    protected SiteSettings settings;

    @JsonProperty("sharepointIds")
    protected SharepointIds sharepointIds;

    @JsonProperty("siteCollection")
    protected SiteCollection siteCollection;

    @JsonProperty("columns")
    protected List<ColumnDefinition> columns;

    @JsonProperty("contentTypes")
    protected List<ContentType> contentTypes;

    @JsonProperty("drive")
    protected Drive drive;

    @JsonProperty("drives")
    protected List<Drive> drives;

    @JsonProperty("items")
    protected List<BaseItem> items;

    @JsonProperty("lists")
    protected List<odata.msgraph.client.beta.entity.List> lists;

    @JsonProperty("operations")
    protected List<RichLongRunningOperation> operations;

    @JsonProperty("pages")
    protected List<SitePage> pages;

    @JsonProperty("permissions")
    protected List<Permission> permissions;

    @JsonProperty("sites")
    protected List<Site> sites;

    @JsonProperty("termStore")
    protected Store termStore;

    @JsonProperty("onenote")
    protected Onenote onenote;

    protected Site() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSite() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private IdentitySet createdBy;
        private OffsetDateTime createdDateTime;
        private String description;
        private String eTag;
        private IdentitySet lastModifiedBy;
        private OffsetDateTime lastModifiedDateTime;
        private String name;
        private ItemReference parentReference;
        private String webUrl;
        private Deleted deleted;
        private String displayName;
        private Root root;
        private SiteSettings settings;
        private SharepointIds sharepointIds;
        private SiteCollection siteCollection;
        private List<ColumnDefinition> columns;
        private List<ContentType> contentTypes;
        private Drive drive;
        private List<Drive> drives;
        private List<BaseItem> items;
        private List<odata.msgraph.client.beta.entity.List> lists;
        private List<RichLongRunningOperation> operations;
        private List<SitePage> pages;
        private List<Permission> permissions;
        private List<Site> sites;
        private Store termStore;
        private Onenote onenote;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder eTag(String eTag) {
            this.eTag = eTag;
            this.changedFields = changedFields.add("eTag");
            return this;
        }

        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder parentReference(ItemReference parentReference) {
            this.parentReference = parentReference;
            this.changedFields = changedFields.add("parentReference");
            return this;
        }

        public Builder webUrl(String webUrl) {
            this.webUrl = webUrl;
            this.changedFields = changedFields.add("webUrl");
            return this;
        }

        public Builder deleted(Deleted deleted) {
            this.deleted = deleted;
            this.changedFields = changedFields.add("deleted");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder root(Root root) {
            this.root = root;
            this.changedFields = changedFields.add("root");
            return this;
        }

        public Builder settings(SiteSettings settings) {
            this.settings = settings;
            this.changedFields = changedFields.add("settings");
            return this;
        }

        public Builder sharepointIds(SharepointIds sharepointIds) {
            this.sharepointIds = sharepointIds;
            this.changedFields = changedFields.add("sharepointIds");
            return this;
        }

        public Builder siteCollection(SiteCollection siteCollection) {
            this.siteCollection = siteCollection;
            this.changedFields = changedFields.add("siteCollection");
            return this;
        }

        public Builder columns(List<ColumnDefinition> columns) {
            this.columns = columns;
            this.changedFields = changedFields.add("columns");
            return this;
        }

        public Builder columns(ColumnDefinition... columns) {
            return columns(Arrays.asList(columns));
        }

        public Builder contentTypes(List<ContentType> contentTypes) {
            this.contentTypes = contentTypes;
            this.changedFields = changedFields.add("contentTypes");
            return this;
        }

        public Builder contentTypes(ContentType... contentTypes) {
            return contentTypes(Arrays.asList(contentTypes));
        }

        public Builder drive(Drive drive) {
            this.drive = drive;
            this.changedFields = changedFields.add("drive");
            return this;
        }

        public Builder drives(List<Drive> drives) {
            this.drives = drives;
            this.changedFields = changedFields.add("drives");
            return this;
        }

        public Builder drives(Drive... drives) {
            return drives(Arrays.asList(drives));
        }

        public Builder items(List<BaseItem> items) {
            this.items = items;
            this.changedFields = changedFields.add("items");
            return this;
        }

        public Builder items(BaseItem... items) {
            return items(Arrays.asList(items));
        }

        public Builder lists(List<odata.msgraph.client.beta.entity.List> lists) {
            this.lists = lists;
            this.changedFields = changedFields.add("lists");
            return this;
        }

        public Builder lists(odata.msgraph.client.beta.entity.List... lists) {
            return lists(Arrays.asList(lists));
        }

        public Builder operations(List<RichLongRunningOperation> operations) {
            this.operations = operations;
            this.changedFields = changedFields.add("operations");
            return this;
        }

        public Builder operations(RichLongRunningOperation... operations) {
            return operations(Arrays.asList(operations));
        }

        public Builder pages(List<SitePage> pages) {
            this.pages = pages;
            this.changedFields = changedFields.add("pages");
            return this;
        }

        public Builder pages(SitePage... pages) {
            return pages(Arrays.asList(pages));
        }

        public Builder permissions(List<Permission> permissions) {
            this.permissions = permissions;
            this.changedFields = changedFields.add("permissions");
            return this;
        }

        public Builder permissions(Permission... permissions) {
            return permissions(Arrays.asList(permissions));
        }

        public Builder sites(List<Site> sites) {
            this.sites = sites;
            this.changedFields = changedFields.add("sites");
            return this;
        }

        public Builder sites(Site... sites) {
            return sites(Arrays.asList(sites));
        }

        public Builder termStore(Store termStore) {
            this.termStore = termStore;
            this.changedFields = changedFields.add("termStore");
            return this;
        }

        public Builder onenote(Onenote onenote) {
            this.onenote = onenote;
            this.changedFields = changedFields.add("onenote");
            return this;
        }

        public Site build() {
            Site _x = new Site();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.site";
            _x.id = id;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.eTag = eTag;
            _x.lastModifiedBy = lastModifiedBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.name = name;
            _x.parentReference = parentReference;
            _x.webUrl = webUrl;
            _x.deleted = deleted;
            _x.displayName = displayName;
            _x.root = root;
            _x.settings = settings;
            _x.sharepointIds = sharepointIds;
            _x.siteCollection = siteCollection;
            _x.columns = columns;
            _x.contentTypes = contentTypes;
            _x.drive = drive;
            _x.drives = drives;
            _x.items = items;
            _x.lists = lists;
            _x.operations = operations;
            _x.pages = pages;
            _x.permissions = permissions;
            _x.sites = sites;
            _x.termStore = termStore;
            _x.onenote = onenote;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="deleted")
    @JsonIgnore
    public Optional<Deleted> getDeleted() {
        return Optional.ofNullable(deleted);
    }

    public Site withDeleted(Deleted deleted) {
        Site _x = _copy();
        _x.changedFields = changedFields.add("deleted");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.site");
        _x.deleted = deleted;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public Site withDisplayName(String displayName) {
        Site _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.site");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="root")
    @JsonIgnore
    public Optional<Root> getRoot() {
        return Optional.ofNullable(root);
    }

    public Site withRoot(Root root) {
        Site _x = _copy();
        _x.changedFields = changedFields.add("root");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.site");
        _x.root = root;
        return _x;
    }

    @Property(name="settings")
    @JsonIgnore
    public Optional<SiteSettings> getSettings() {
        return Optional.ofNullable(settings);
    }

    public Site withSettings(SiteSettings settings) {
        Site _x = _copy();
        _x.changedFields = changedFields.add("settings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.site");
        _x.settings = settings;
        return _x;
    }

    @Property(name="sharepointIds")
    @JsonIgnore
    public Optional<SharepointIds> getSharepointIds() {
        return Optional.ofNullable(sharepointIds);
    }

    public Site withSharepointIds(SharepointIds sharepointIds) {
        Site _x = _copy();
        _x.changedFields = changedFields.add("sharepointIds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.site");
        _x.sharepointIds = sharepointIds;
        return _x;
    }

    @Property(name="siteCollection")
    @JsonIgnore
    public Optional<SiteCollection> getSiteCollection() {
        return Optional.ofNullable(siteCollection);
    }

    public Site withSiteCollection(SiteCollection siteCollection) {
        Site _x = _copy();
        _x.changedFields = changedFields.add("siteCollection");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.site");
        _x.siteCollection = siteCollection;
        return _x;
    }

    public Site withUnmappedField(String name, Object value) {
        Site _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="analytics")
    @JsonIgnore
    public ItemAnalyticsRequest getAnalytics() {
        return new ItemAnalyticsRequest(contextPath.addSegment("analytics"), RequestHelper.getValue(unmappedFields, "analytics"));
    }

    @NavigationProperty(name="columns")
    @JsonIgnore
    public ColumnDefinitionCollectionRequest getColumns() {
        return new ColumnDefinitionCollectionRequest(
                        contextPath.addSegment("columns"), Optional.ofNullable(columns));
    }

    @NavigationProperty(name="contentTypes")
    @JsonIgnore
    public ContentTypeCollectionRequest getContentTypes() {
        return new ContentTypeCollectionRequest(
                        contextPath.addSegment("contentTypes"), Optional.ofNullable(contentTypes));
    }

    @NavigationProperty(name="drive")
    @JsonIgnore
    public DriveRequest getDrive() {
        return new DriveRequest(contextPath.addSegment("drive"), Optional.ofNullable(drive));
    }

    @NavigationProperty(name="drives")
    @JsonIgnore
    public DriveCollectionRequest getDrives() {
        return new DriveCollectionRequest(
                        contextPath.addSegment("drives"), Optional.ofNullable(drives));
    }

    @NavigationProperty(name="externalColumns")
    @JsonIgnore
    public ColumnDefinitionCollectionRequest getExternalColumns() {
        return new ColumnDefinitionCollectionRequest(
                        contextPath.addSegment("externalColumns"), RequestHelper.getValue(unmappedFields, "externalColumns"));
    }

    @NavigationProperty(name="items")
    @JsonIgnore
    public BaseItemCollectionRequest getItems() {
        return new BaseItemCollectionRequest(
                        contextPath.addSegment("items"), Optional.ofNullable(items));
    }

    @NavigationProperty(name="lists")
    @JsonIgnore
    public ListCollectionRequest getLists() {
        return new ListCollectionRequest(
                        contextPath.addSegment("lists"), Optional.ofNullable(lists));
    }

    @NavigationProperty(name="operations")
    @JsonIgnore
    public RichLongRunningOperationCollectionRequest getOperations() {
        return new RichLongRunningOperationCollectionRequest(
                        contextPath.addSegment("operations"), Optional.ofNullable(operations));
    }

    @NavigationProperty(name="pages")
    @JsonIgnore
    public SitePageCollectionRequest getPages() {
        return new SitePageCollectionRequest(
                        contextPath.addSegment("pages"), Optional.ofNullable(pages));
    }

    @NavigationProperty(name="permissions")
    @JsonIgnore
    public PermissionCollectionRequest getPermissions() {
        return new PermissionCollectionRequest(
                        contextPath.addSegment("permissions"), Optional.ofNullable(permissions));
    }

    @NavigationProperty(name="sites")
    @JsonIgnore
    public SiteCollectionRequest getSites() {
        return new SiteCollectionRequest(
                        contextPath.addSegment("sites"), Optional.ofNullable(sites));
    }

    @NavigationProperty(name="termStore")
    @JsonIgnore
    public StoreRequest getTermStore() {
        return new StoreRequest(contextPath.addSegment("termStore"), Optional.ofNullable(termStore));
    }

    @NavigationProperty(name="onenote")
    @JsonIgnore
    public OnenoteRequest getOnenote() {
        return new OnenoteRequest(contextPath.addSegment("onenote"), Optional.ofNullable(onenote));
    }

    public Site withColumns(List<ColumnDefinition> columns) {
        Site _x = _copy();
        _x.changedFields = changedFields.add("columns");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.site");
        _x.columns = columns;
        return _x;
    }

    public Site withContentTypes(List<ContentType> contentTypes) {
        Site _x = _copy();
        _x.changedFields = changedFields.add("contentTypes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.site");
        _x.contentTypes = contentTypes;
        return _x;
    }

    public Site withDrive(Drive drive) {
        Site _x = _copy();
        _x.changedFields = changedFields.add("drive");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.site");
        _x.drive = drive;
        return _x;
    }

    public Site withDrives(List<Drive> drives) {
        Site _x = _copy();
        _x.changedFields = changedFields.add("drives");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.site");
        _x.drives = drives;
        return _x;
    }

    public Site withItems(List<BaseItem> items) {
        Site _x = _copy();
        _x.changedFields = changedFields.add("items");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.site");
        _x.items = items;
        return _x;
    }

    public Site withLists(List<odata.msgraph.client.beta.entity.List> lists) {
        Site _x = _copy();
        _x.changedFields = changedFields.add("lists");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.site");
        _x.lists = lists;
        return _x;
    }

    public Site withOperations(List<RichLongRunningOperation> operations) {
        Site _x = _copy();
        _x.changedFields = changedFields.add("operations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.site");
        _x.operations = operations;
        return _x;
    }

    public Site withPages(List<SitePage> pages) {
        Site _x = _copy();
        _x.changedFields = changedFields.add("pages");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.site");
        _x.pages = pages;
        return _x;
    }

    public Site withPermissions(List<Permission> permissions) {
        Site _x = _copy();
        _x.changedFields = changedFields.add("permissions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.site");
        _x.permissions = permissions;
        return _x;
    }

    public Site withSites(List<Site> sites) {
        Site _x = _copy();
        _x.changedFields = changedFields.add("sites");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.site");
        _x.sites = sites;
        return _x;
    }

    public Site withTermStore(Store termStore) {
        Site _x = _copy();
        _x.changedFields = changedFields.add("termStore");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.site");
        _x.termStore = termStore;
        return _x;
    }

    public Site withOnenote(Onenote onenote) {
        Site _x = _copy();
        _x.changedFields = changedFields.add("onenote");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.site");
        _x.onenote = onenote;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Site patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Site _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Site put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Site _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Site _copy() {
        Site _x = new Site();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.eTag = eTag;
        _x.lastModifiedBy = lastModifiedBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.name = name;
        _x.parentReference = parentReference;
        _x.webUrl = webUrl;
        _x.deleted = deleted;
        _x.displayName = displayName;
        _x.root = root;
        _x.settings = settings;
        _x.sharepointIds = sharepointIds;
        _x.siteCollection = siteCollection;
        _x.columns = columns;
        _x.contentTypes = contentTypes;
        _x.drive = drive;
        _x.drives = drives;
        _x.items = items;
        _x.lists = lists;
        _x.operations = operations;
        _x.pages = pages;
        _x.permissions = permissions;
        _x.sites = sites;
        _x.termStore = termStore;
        _x.onenote = onenote;
        return _x;
    }

    @Function(name = "getActivitiesByInterval")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ItemActivityStat> getActivitiesByInterval(String startDateTime, String endDateTime, String interval) {
        Preconditions.checkNotNull(startDateTime, "startDateTime cannot be null");
        Preconditions.checkNotNull(endDateTime, "endDateTime cannot be null");
        Preconditions.checkNotNull(interval, "interval cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("startDateTime", "Edm.String", Checks.checkIsAscii(startDateTime))
            .put("endDateTime", "Edm.String", Checks.checkIsAscii(endDateTime))
            .put("interval", "Edm.String", Checks.checkIsAscii(interval))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getActivitiesByInterval"), ItemActivityStat.class, _parameters);
    }

    @Function(name = "getApplicableContentTypesForList")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ContentType> getApplicableContentTypesForList(String listId) {
        Preconditions.checkNotNull(listId, "listId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("listId", "Edm.String", Checks.checkIsAscii(listId))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getApplicableContentTypesForList"), ContentType.class, _parameters);
    }

    @Function(name = "getByPath")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Site> getByPath(String path) {
        Preconditions.checkNotNull(path, "path cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("path", "Edm.String", Checks.checkIsAscii(path))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<Site>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getByPath"), Site.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Site[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("eTag=");
        b.append(this.eTag);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("parentReference=");
        b.append(this.parentReference);
        b.append(", ");
        b.append("webUrl=");
        b.append(this.webUrl);
        b.append(", ");
        b.append("deleted=");
        b.append(this.deleted);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("root=");
        b.append(this.root);
        b.append(", ");
        b.append("settings=");
        b.append(this.settings);
        b.append(", ");
        b.append("sharepointIds=");
        b.append(this.sharepointIds);
        b.append(", ");
        b.append("siteCollection=");
        b.append(this.siteCollection);
        b.append(", ");
        b.append("columns=");
        b.append(this.columns);
        b.append(", ");
        b.append("contentTypes=");
        b.append(this.contentTypes);
        b.append(", ");
        b.append("drive=");
        b.append(this.drive);
        b.append(", ");
        b.append("drives=");
        b.append(this.drives);
        b.append(", ");
        b.append("items=");
        b.append(this.items);
        b.append(", ");
        b.append("lists=");
        b.append(this.lists);
        b.append(", ");
        b.append("operations=");
        b.append(this.operations);
        b.append(", ");
        b.append("pages=");
        b.append(this.pages);
        b.append(", ");
        b.append("permissions=");
        b.append(this.permissions);
        b.append(", ");
        b.append("sites=");
        b.append(this.sites);
        b.append(", ");
        b.append("termStore=");
        b.append(this.termStore);
        b.append(", ");
        b.append("onenote=");
        b.append(this.onenote);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
