package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.EmailIdentity;
import odata.msgraph.client.beta.complex.SimulationReport;
import odata.msgraph.client.beta.enums.PayloadDeliveryPlatform;
import odata.msgraph.client.beta.enums.SimulationAttackTechnique;
import odata.msgraph.client.beta.enums.SimulationAttackType;
import odata.msgraph.client.beta.enums.SimulationStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "attackTechnique", 
    "attackType", 
    "automationId", 
    "completionDateTime", 
    "createdBy", 
    "createdDateTime", 
    "description", 
    "displayName", 
    "isAutomated", 
    "lastModifiedBy", 
    "lastModifiedDateTime", 
    "launchDateTime", 
    "payloadDeliveryPlatform", 
    "report", 
    "status"})
@JsonInclude(Include.NON_NULL)
public class Simulation extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.simulation";
    }

    @JsonProperty("attackTechnique")
    protected SimulationAttackTechnique attackTechnique;

    @JsonProperty("attackType")
    protected SimulationAttackType attackType;

    @JsonProperty("automationId")
    protected String automationId;

    @JsonProperty("completionDateTime")
    protected OffsetDateTime completionDateTime;

    @JsonProperty("createdBy")
    protected EmailIdentity createdBy;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("isAutomated")
    protected Boolean isAutomated;

    @JsonProperty("lastModifiedBy")
    protected EmailIdentity lastModifiedBy;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("launchDateTime")
    protected OffsetDateTime launchDateTime;

    @JsonProperty("payloadDeliveryPlatform")
    protected PayloadDeliveryPlatform payloadDeliveryPlatform;

    @JsonProperty("report")
    protected SimulationReport report;

    @JsonProperty("status")
    protected SimulationStatus status;

    protected Simulation() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSimulation() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private SimulationAttackTechnique attackTechnique;
        private SimulationAttackType attackType;
        private String automationId;
        private OffsetDateTime completionDateTime;
        private EmailIdentity createdBy;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private Boolean isAutomated;
        private EmailIdentity lastModifiedBy;
        private OffsetDateTime lastModifiedDateTime;
        private OffsetDateTime launchDateTime;
        private PayloadDeliveryPlatform payloadDeliveryPlatform;
        private SimulationReport report;
        private SimulationStatus status;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder attackTechnique(SimulationAttackTechnique attackTechnique) {
            this.attackTechnique = attackTechnique;
            this.changedFields = changedFields.add("attackTechnique");
            return this;
        }

        public Builder attackType(SimulationAttackType attackType) {
            this.attackType = attackType;
            this.changedFields = changedFields.add("attackType");
            return this;
        }

        public Builder automationId(String automationId) {
            this.automationId = automationId;
            this.changedFields = changedFields.add("automationId");
            return this;
        }

        public Builder completionDateTime(OffsetDateTime completionDateTime) {
            this.completionDateTime = completionDateTime;
            this.changedFields = changedFields.add("completionDateTime");
            return this;
        }

        public Builder createdBy(EmailIdentity createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder isAutomated(Boolean isAutomated) {
            this.isAutomated = isAutomated;
            this.changedFields = changedFields.add("isAutomated");
            return this;
        }

        public Builder lastModifiedBy(EmailIdentity lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder launchDateTime(OffsetDateTime launchDateTime) {
            this.launchDateTime = launchDateTime;
            this.changedFields = changedFields.add("launchDateTime");
            return this;
        }

        public Builder payloadDeliveryPlatform(PayloadDeliveryPlatform payloadDeliveryPlatform) {
            this.payloadDeliveryPlatform = payloadDeliveryPlatform;
            this.changedFields = changedFields.add("payloadDeliveryPlatform");
            return this;
        }

        public Builder report(SimulationReport report) {
            this.report = report;
            this.changedFields = changedFields.add("report");
            return this;
        }

        public Builder status(SimulationStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Simulation build() {
            Simulation _x = new Simulation();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.simulation";
            _x.id = id;
            _x.attackTechnique = attackTechnique;
            _x.attackType = attackType;
            _x.automationId = automationId;
            _x.completionDateTime = completionDateTime;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.isAutomated = isAutomated;
            _x.lastModifiedBy = lastModifiedBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.launchDateTime = launchDateTime;
            _x.payloadDeliveryPlatform = payloadDeliveryPlatform;
            _x.report = report;
            _x.status = status;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="attackTechnique")
    @JsonIgnore
    public Optional<SimulationAttackTechnique> getAttackTechnique() {
        return Optional.ofNullable(attackTechnique);
    }

    public Simulation withAttackTechnique(SimulationAttackTechnique attackTechnique) {
        Simulation _x = _copy();
        _x.changedFields = changedFields.add("attackTechnique");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.simulation");
        _x.attackTechnique = attackTechnique;
        return _x;
    }

    @Property(name="attackType")
    @JsonIgnore
    public Optional<SimulationAttackType> getAttackType() {
        return Optional.ofNullable(attackType);
    }

    public Simulation withAttackType(SimulationAttackType attackType) {
        Simulation _x = _copy();
        _x.changedFields = changedFields.add("attackType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.simulation");
        _x.attackType = attackType;
        return _x;
    }

    @Property(name="automationId")
    @JsonIgnore
    public Optional<String> getAutomationId() {
        return Optional.ofNullable(automationId);
    }

    public Simulation withAutomationId(String automationId) {
        Simulation _x = _copy();
        _x.changedFields = changedFields.add("automationId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.simulation");
        _x.automationId = automationId;
        return _x;
    }

    @Property(name="completionDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCompletionDateTime() {
        return Optional.ofNullable(completionDateTime);
    }

    public Simulation withCompletionDateTime(OffsetDateTime completionDateTime) {
        Simulation _x = _copy();
        _x.changedFields = changedFields.add("completionDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.simulation");
        _x.completionDateTime = completionDateTime;
        return _x;
    }

    @Property(name="createdBy")
    @JsonIgnore
    public Optional<EmailIdentity> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    public Simulation withCreatedBy(EmailIdentity createdBy) {
        Simulation _x = _copy();
        _x.changedFields = changedFields.add("createdBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.simulation");
        _x.createdBy = createdBy;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public Simulation withCreatedDateTime(OffsetDateTime createdDateTime) {
        Simulation _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.simulation");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Simulation withDescription(String description) {
        Simulation _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.simulation");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public Simulation withDisplayName(String displayName) {
        Simulation _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.simulation");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="isAutomated")
    @JsonIgnore
    public Optional<Boolean> getIsAutomated() {
        return Optional.ofNullable(isAutomated);
    }

    public Simulation withIsAutomated(Boolean isAutomated) {
        Simulation _x = _copy();
        _x.changedFields = changedFields.add("isAutomated");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.simulation");
        _x.isAutomated = isAutomated;
        return _x;
    }

    @Property(name="lastModifiedBy")
    @JsonIgnore
    public Optional<EmailIdentity> getLastModifiedBy() {
        return Optional.ofNullable(lastModifiedBy);
    }

    public Simulation withLastModifiedBy(EmailIdentity lastModifiedBy) {
        Simulation _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.simulation");
        _x.lastModifiedBy = lastModifiedBy;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public Simulation withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        Simulation _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.simulation");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="launchDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLaunchDateTime() {
        return Optional.ofNullable(launchDateTime);
    }

    public Simulation withLaunchDateTime(OffsetDateTime launchDateTime) {
        Simulation _x = _copy();
        _x.changedFields = changedFields.add("launchDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.simulation");
        _x.launchDateTime = launchDateTime;
        return _x;
    }

    @Property(name="payloadDeliveryPlatform")
    @JsonIgnore
    public Optional<PayloadDeliveryPlatform> getPayloadDeliveryPlatform() {
        return Optional.ofNullable(payloadDeliveryPlatform);
    }

    public Simulation withPayloadDeliveryPlatform(PayloadDeliveryPlatform payloadDeliveryPlatform) {
        Simulation _x = _copy();
        _x.changedFields = changedFields.add("payloadDeliveryPlatform");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.simulation");
        _x.payloadDeliveryPlatform = payloadDeliveryPlatform;
        return _x;
    }

    @Property(name="report")
    @JsonIgnore
    public Optional<SimulationReport> getReport() {
        return Optional.ofNullable(report);
    }

    public Simulation withReport(SimulationReport report) {
        Simulation _x = _copy();
        _x.changedFields = changedFields.add("report");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.simulation");
        _x.report = report;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<SimulationStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public Simulation withStatus(SimulationStatus status) {
        Simulation _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.simulation");
        _x.status = status;
        return _x;
    }

    public Simulation withUnmappedField(String name, Object value) {
        Simulation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Simulation patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Simulation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Simulation put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Simulation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Simulation _copy() {
        Simulation _x = new Simulation();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.attackTechnique = attackTechnique;
        _x.attackType = attackType;
        _x.automationId = automationId;
        _x.completionDateTime = completionDateTime;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.isAutomated = isAutomated;
        _x.lastModifiedBy = lastModifiedBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.launchDateTime = launchDateTime;
        _x.payloadDeliveryPlatform = payloadDeliveryPlatform;
        _x.report = report;
        _x.status = status;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Simulation[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("attackTechnique=");
        b.append(this.attackTechnique);
        b.append(", ");
        b.append("attackType=");
        b.append(this.attackType);
        b.append(", ");
        b.append("automationId=");
        b.append(this.automationId);
        b.append(", ");
        b.append("completionDateTime=");
        b.append(this.completionDateTime);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("isAutomated=");
        b.append(this.isAutomated);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("launchDateTime=");
        b.append(this.launchDateTime);
        b.append(", ");
        b.append("payloadDeliveryPlatform=");
        b.append(this.payloadDeliveryPlatform);
        b.append(", ");
        b.append("report=");
        b.append(this.report);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
