package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.HttpMethod;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.StreamProvider;
import com.github.davidmoten.odata.client.StreamUploader;
import com.github.davidmoten.odata.client.StreamUploaderChunked;
import com.github.davidmoten.odata.client.StreamUploaderSingleCall;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.UploadStrategy;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "content", 
    "contentType", 
    "lastModifiedDateTime", 
    "name", 
    "size"})
@JsonInclude(Include.NON_NULL)
public class ServiceAnnouncementAttachment extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.serviceAnnouncementAttachment";
    }

    @JsonProperty("content")
    protected String content;

    @JsonProperty("contentType")
    protected String contentType;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("size")
    protected Integer size;

    protected ServiceAnnouncementAttachment() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderServiceAnnouncementAttachment() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String content;
        private String contentType;
        private OffsetDateTime lastModifiedDateTime;
        private String name;
        private Integer size;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder content(String content) {
            this.content = content;
            this.changedFields = changedFields.add("content");
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            this.changedFields = changedFields.add("contentType");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder size(Integer size) {
            this.size = size;
            this.changedFields = changedFields.add("size");
            return this;
        }

        public ServiceAnnouncementAttachment build() {
            ServiceAnnouncementAttachment _x = new ServiceAnnouncementAttachment();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.serviceAnnouncementAttachment";
            _x.id = id;
            _x.content = content;
            _x.contentType = contentType;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.name = name;
            _x.size = size;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="content")
    @JsonIgnore
    public Optional<StreamProvider> getContent() {
        return RequestHelper.createStreamForEdmStream(contextPath, this, "content", content);
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploader} which can be used to upload the stream
     * to the {@code content} property, using HTTP PATCH.
     *
     * @return a StreamUploader if upload permitted
     */
    @Property(name="content")
    public Optional<StreamUploaderSingleCall> patchContent() {
        return patchContent(UploadStrategy.singleCall());
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploaderChunked} which can be used to upload the stream
     * to the {@code content} property, using HTTP PATCH.
     *
     * @return a StreamUploaderChunked if upload permitted
     */
    @Property(name="content")
    public Optional<StreamUploaderChunked> patchChunkedContent() {
        return patchContent(UploadStrategy.chunked());
    }

    @Property(name="content")
    public <T extends StreamUploader<T>> Optional<T> patchContent(UploadStrategy<T> strategy) {
        return strategy.builder(contextPath.addSegment("content"), this, "content", HttpMethod.PATCH);
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploader} which can be used to upload the stream
     * to the {@code content} property, using HTTP POST.
     *
     * @return a StreamUploader if upload permitted
     */
    @Property(name="content")
    public Optional<StreamUploaderSingleCall> postContent() {
        return postContent(UploadStrategy.singleCall());
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploaderChunked} which can be used to upload the stream
     * to the {@code content} property, using HTTP POST.
     *
     * @return a StreamUploaderChunked if upload permitted
     */
    @Property(name="content")
    public Optional<StreamUploaderChunked> postChunkedContent() {
        return postContent(UploadStrategy.chunked());
    }

    @Property(name="content")
    public <T extends StreamUploader<T>> Optional<T> postContent(UploadStrategy<T> strategy) {
        return strategy.builder(contextPath.addSegment("content"), this, "content", HttpMethod.POST);
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploader} which can be used to upload the stream
     * to the {@code content} property, using HTTP PUT.
     *
     * @return a StreamUploader if upload permitted
     */
    @Property(name="content")
    public Optional<StreamUploaderSingleCall> putContent() {
        return putContent(UploadStrategy.singleCall());
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploaderChunked} which can be used to upload the stream
     * to the {@code content} property, using HTTP PUT.
     *
     * @return a StreamUploaderChunked if upload permitted
     */
    @Property(name="content")
    public Optional<StreamUploaderChunked> putChunkedContent() {
        return putContent(UploadStrategy.chunked());
    }

    @Property(name="content")
    public <T extends StreamUploader<T>> Optional<T> putContent(UploadStrategy<T> strategy) {
        return strategy.builder(contextPath.addSegment("content"), this, "content", HttpMethod.PUT);
    }

    @Property(name="contentType")
    @JsonIgnore
    public Optional<String> getContentType() {
        return Optional.ofNullable(contentType);
    }

    public ServiceAnnouncementAttachment withContentType(String contentType) {
        ServiceAnnouncementAttachment _x = _copy();
        _x.changedFields = changedFields.add("contentType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.serviceAnnouncementAttachment");
        _x.contentType = contentType;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public ServiceAnnouncementAttachment withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        ServiceAnnouncementAttachment _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.serviceAnnouncementAttachment");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public ServiceAnnouncementAttachment withName(String name) {
        ServiceAnnouncementAttachment _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.serviceAnnouncementAttachment");
        _x.name = name;
        return _x;
    }

    @Property(name="size")
    @JsonIgnore
    public Optional<Integer> getSize() {
        return Optional.ofNullable(size);
    }

    public ServiceAnnouncementAttachment withSize(Integer size) {
        ServiceAnnouncementAttachment _x = _copy();
        _x.changedFields = changedFields.add("size");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.serviceAnnouncementAttachment");
        _x.size = size;
        return _x;
    }

    public ServiceAnnouncementAttachment withUnmappedField(String name, Object value) {
        ServiceAnnouncementAttachment _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ServiceAnnouncementAttachment patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ServiceAnnouncementAttachment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ServiceAnnouncementAttachment put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ServiceAnnouncementAttachment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ServiceAnnouncementAttachment _copy() {
        ServiceAnnouncementAttachment _x = new ServiceAnnouncementAttachment();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.content = content;
        _x.contentType = contentType;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.name = name;
        _x.size = size;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ServiceAnnouncementAttachment[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("content=");
        b.append(this.content);
        b.append(", ");
        b.append("contentType=");
        b.append(this.contentType);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("size=");
        b.append(this.size);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
