package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.ServiceHealthCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ServiceHealthIssueCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ServiceUpdateMessageCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "healthOverviews", 
    "issues", 
    "messages"})
@JsonInclude(Include.NON_NULL)
public class ServiceAnnouncement extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.serviceAnnouncement";
    }

    @JsonProperty("healthOverviews")
    protected List<ServiceHealth> healthOverviews;

    @JsonProperty("issues")
    protected List<ServiceHealthIssue> issues;

    @JsonProperty("messages")
    protected List<ServiceUpdateMessage> messages;

    protected ServiceAnnouncement() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderServiceAnnouncement() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<ServiceHealth> healthOverviews;
        private List<ServiceHealthIssue> issues;
        private List<ServiceUpdateMessage> messages;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder healthOverviews(List<ServiceHealth> healthOverviews) {
            this.healthOverviews = healthOverviews;
            this.changedFields = changedFields.add("healthOverviews");
            return this;
        }

        public Builder healthOverviews(ServiceHealth... healthOverviews) {
            return healthOverviews(Arrays.asList(healthOverviews));
        }

        public Builder issues(List<ServiceHealthIssue> issues) {
            this.issues = issues;
            this.changedFields = changedFields.add("issues");
            return this;
        }

        public Builder issues(ServiceHealthIssue... issues) {
            return issues(Arrays.asList(issues));
        }

        public Builder messages(List<ServiceUpdateMessage> messages) {
            this.messages = messages;
            this.changedFields = changedFields.add("messages");
            return this;
        }

        public Builder messages(ServiceUpdateMessage... messages) {
            return messages(Arrays.asList(messages));
        }

        public ServiceAnnouncement build() {
            ServiceAnnouncement _x = new ServiceAnnouncement();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.serviceAnnouncement";
            _x.id = id;
            _x.healthOverviews = healthOverviews;
            _x.issues = issues;
            _x.messages = messages;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public ServiceAnnouncement withUnmappedField(String name, Object value) {
        ServiceAnnouncement _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="healthOverviews")
    @JsonIgnore
    public ServiceHealthCollectionRequest getHealthOverviews() {
        return new ServiceHealthCollectionRequest(
                        contextPath.addSegment("healthOverviews"), Optional.ofNullable(healthOverviews));
    }

    @NavigationProperty(name="issues")
    @JsonIgnore
    public ServiceHealthIssueCollectionRequest getIssues() {
        return new ServiceHealthIssueCollectionRequest(
                        contextPath.addSegment("issues"), Optional.ofNullable(issues));
    }

    @NavigationProperty(name="messages")
    @JsonIgnore
    public ServiceUpdateMessageCollectionRequest getMessages() {
        return new ServiceUpdateMessageCollectionRequest(
                        contextPath.addSegment("messages"), Optional.ofNullable(messages));
    }

    public ServiceAnnouncement withHealthOverviews(List<ServiceHealth> healthOverviews) {
        ServiceAnnouncement _x = _copy();
        _x.changedFields = changedFields.add("healthOverviews");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.serviceAnnouncement");
        _x.healthOverviews = healthOverviews;
        return _x;
    }

    public ServiceAnnouncement withIssues(List<ServiceHealthIssue> issues) {
        ServiceAnnouncement _x = _copy();
        _x.changedFields = changedFields.add("issues");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.serviceAnnouncement");
        _x.issues = issues;
        return _x;
    }

    public ServiceAnnouncement withMessages(List<ServiceUpdateMessage> messages) {
        ServiceAnnouncement _x = _copy();
        _x.changedFields = changedFields.add("messages");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.serviceAnnouncement");
        _x.messages = messages;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ServiceAnnouncement patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ServiceAnnouncement _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ServiceAnnouncement put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ServiceAnnouncement _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ServiceAnnouncement _copy() {
        ServiceAnnouncement _x = new ServiceAnnouncement();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.healthOverviews = healthOverviews;
        _x.issues = issues;
        _x.messages = messages;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ServiceAnnouncement[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("healthOverviews=");
        b.append(this.healthOverviews);
        b.append(", ");
        b.append("issues=");
        b.append(this.issues);
        b.append(", ");
        b.append("messages=");
        b.append(this.messages);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
