package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AutoLabeling;
import odata.msgraph.client.beta.complex.LabelActionBase;
import odata.msgraph.client.beta.complex.LabelPolicy;
import odata.msgraph.client.beta.entity.collection.request.SensitivityLabelCollectionRequest;
import odata.msgraph.client.beta.enums.ApplicationMode;
import odata.msgraph.client.beta.enums.SensitivityLabelTarget;

@JsonPropertyOrder({
    "@odata.type", 
    "applicableTo", 
    "applicationMode", 
    "assignedPolicies", 
    "autoLabeling", 
    "description", 
    "displayName", 
    "isDefault", 
    "isEndpointProtectionEnabled", 
    "labelActions", 
    "name", 
    "priority", 
    "toolTip", 
    "sublabels"})
@JsonInclude(Include.NON_NULL)
public class SensitivityLabel extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.sensitivityLabel";
    }

    @JsonProperty("applicableTo")
    protected SensitivityLabelTarget applicableTo;

    @JsonProperty("applicationMode")
    protected ApplicationMode applicationMode;

    @JsonProperty("assignedPolicies")
    protected List<LabelPolicy> assignedPolicies;

    @JsonProperty("assignedPolicies@nextLink")
    protected String assignedPoliciesNextLink;

    @JsonProperty("autoLabeling")
    protected AutoLabeling autoLabeling;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("isDefault")
    protected Boolean isDefault;

    @JsonProperty("isEndpointProtectionEnabled")
    protected Boolean isEndpointProtectionEnabled;

    @JsonProperty("labelActions")
    protected List<LabelActionBase> labelActions;

    @JsonProperty("labelActions@nextLink")
    protected String labelActionsNextLink;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("priority")
    protected Integer priority;

    @JsonProperty("toolTip")
    protected String toolTip;

    @JsonProperty("sublabels")
    protected List<SensitivityLabel> sublabels;

    protected SensitivityLabel() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSensitivityLabel() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private SensitivityLabelTarget applicableTo;
        private ApplicationMode applicationMode;
        private List<LabelPolicy> assignedPolicies;
        private String assignedPoliciesNextLink;
        private AutoLabeling autoLabeling;
        private String description;
        private String displayName;
        private Boolean isDefault;
        private Boolean isEndpointProtectionEnabled;
        private List<LabelActionBase> labelActions;
        private String labelActionsNextLink;
        private String name;
        private Integer priority;
        private String toolTip;
        private List<SensitivityLabel> sublabels;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder applicableTo(SensitivityLabelTarget applicableTo) {
            this.applicableTo = applicableTo;
            this.changedFields = changedFields.add("applicableTo");
            return this;
        }

        public Builder applicationMode(ApplicationMode applicationMode) {
            this.applicationMode = applicationMode;
            this.changedFields = changedFields.add("applicationMode");
            return this;
        }

        public Builder assignedPolicies(List<LabelPolicy> assignedPolicies) {
            this.assignedPolicies = assignedPolicies;
            this.changedFields = changedFields.add("assignedPolicies");
            return this;
        }

        public Builder assignedPolicies(LabelPolicy... assignedPolicies) {
            return assignedPolicies(Arrays.asList(assignedPolicies));
        }

        public Builder assignedPoliciesNextLink(String assignedPoliciesNextLink) {
            this.assignedPoliciesNextLink = assignedPoliciesNextLink;
            this.changedFields = changedFields.add("assignedPolicies");
            return this;
        }

        public Builder autoLabeling(AutoLabeling autoLabeling) {
            this.autoLabeling = autoLabeling;
            this.changedFields = changedFields.add("autoLabeling");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            this.changedFields = changedFields.add("isDefault");
            return this;
        }

        public Builder isEndpointProtectionEnabled(Boolean isEndpointProtectionEnabled) {
            this.isEndpointProtectionEnabled = isEndpointProtectionEnabled;
            this.changedFields = changedFields.add("isEndpointProtectionEnabled");
            return this;
        }

        public Builder labelActions(List<LabelActionBase> labelActions) {
            this.labelActions = labelActions;
            this.changedFields = changedFields.add("labelActions");
            return this;
        }

        public Builder labelActions(LabelActionBase... labelActions) {
            return labelActions(Arrays.asList(labelActions));
        }

        public Builder labelActionsNextLink(String labelActionsNextLink) {
            this.labelActionsNextLink = labelActionsNextLink;
            this.changedFields = changedFields.add("labelActions");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder priority(Integer priority) {
            this.priority = priority;
            this.changedFields = changedFields.add("priority");
            return this;
        }

        public Builder toolTip(String toolTip) {
            this.toolTip = toolTip;
            this.changedFields = changedFields.add("toolTip");
            return this;
        }

        public Builder sublabels(List<SensitivityLabel> sublabels) {
            this.sublabels = sublabels;
            this.changedFields = changedFields.add("sublabels");
            return this;
        }

        public Builder sublabels(SensitivityLabel... sublabels) {
            return sublabels(Arrays.asList(sublabels));
        }

        public SensitivityLabel build() {
            SensitivityLabel _x = new SensitivityLabel();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.sensitivityLabel";
            _x.id = id;
            _x.applicableTo = applicableTo;
            _x.applicationMode = applicationMode;
            _x.assignedPolicies = assignedPolicies;
            _x.assignedPoliciesNextLink = assignedPoliciesNextLink;
            _x.autoLabeling = autoLabeling;
            _x.description = description;
            _x.displayName = displayName;
            _x.isDefault = isDefault;
            _x.isEndpointProtectionEnabled = isEndpointProtectionEnabled;
            _x.labelActions = labelActions;
            _x.labelActionsNextLink = labelActionsNextLink;
            _x.name = name;
            _x.priority = priority;
            _x.toolTip = toolTip;
            _x.sublabels = sublabels;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="applicableTo")
    @JsonIgnore
    public Optional<SensitivityLabelTarget> getApplicableTo() {
        return Optional.ofNullable(applicableTo);
    }

    public SensitivityLabel withApplicableTo(SensitivityLabelTarget applicableTo) {
        SensitivityLabel _x = _copy();
        _x.changedFields = changedFields.add("applicableTo");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sensitivityLabel");
        _x.applicableTo = applicableTo;
        return _x;
    }

    @Property(name="applicationMode")
    @JsonIgnore
    public Optional<ApplicationMode> getApplicationMode() {
        return Optional.ofNullable(applicationMode);
    }

    public SensitivityLabel withApplicationMode(ApplicationMode applicationMode) {
        SensitivityLabel _x = _copy();
        _x.changedFields = changedFields.add("applicationMode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sensitivityLabel");
        _x.applicationMode = applicationMode;
        return _x;
    }

    @Property(name="assignedPolicies")
    @JsonIgnore
    public CollectionPage<LabelPolicy> getAssignedPolicies() {
        return new CollectionPage<LabelPolicy>(contextPath, LabelPolicy.class, this.assignedPolicies, Optional.ofNullable(assignedPoliciesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public SensitivityLabel withAssignedPolicies(List<LabelPolicy> assignedPolicies) {
        SensitivityLabel _x = _copy();
        _x.changedFields = changedFields.add("assignedPolicies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sensitivityLabel");
        _x.assignedPolicies = assignedPolicies;
        return _x;
    }

    @Property(name="assignedPolicies")
    @JsonIgnore
    public CollectionPage<LabelPolicy> getAssignedPolicies(HttpRequestOptions options) {
        return new CollectionPage<LabelPolicy>(contextPath, LabelPolicy.class, this.assignedPolicies, Optional.ofNullable(assignedPoliciesNextLink), Collections.emptyList(), options);
    }

    @Property(name="autoLabeling")
    @JsonIgnore
    public Optional<AutoLabeling> getAutoLabeling() {
        return Optional.ofNullable(autoLabeling);
    }

    public SensitivityLabel withAutoLabeling(AutoLabeling autoLabeling) {
        SensitivityLabel _x = _copy();
        _x.changedFields = changedFields.add("autoLabeling");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sensitivityLabel");
        _x.autoLabeling = autoLabeling;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public SensitivityLabel withDescription(String description) {
        SensitivityLabel _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sensitivityLabel");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public SensitivityLabel withDisplayName(String displayName) {
        SensitivityLabel _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sensitivityLabel");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="isDefault")
    @JsonIgnore
    public Optional<Boolean> getIsDefault() {
        return Optional.ofNullable(isDefault);
    }

    public SensitivityLabel withIsDefault(Boolean isDefault) {
        SensitivityLabel _x = _copy();
        _x.changedFields = changedFields.add("isDefault");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sensitivityLabel");
        _x.isDefault = isDefault;
        return _x;
    }

    @Property(name="isEndpointProtectionEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsEndpointProtectionEnabled() {
        return Optional.ofNullable(isEndpointProtectionEnabled);
    }

    public SensitivityLabel withIsEndpointProtectionEnabled(Boolean isEndpointProtectionEnabled) {
        SensitivityLabel _x = _copy();
        _x.changedFields = changedFields.add("isEndpointProtectionEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sensitivityLabel");
        _x.isEndpointProtectionEnabled = isEndpointProtectionEnabled;
        return _x;
    }

    @Property(name="labelActions")
    @JsonIgnore
    public CollectionPage<LabelActionBase> getLabelActions() {
        return new CollectionPage<LabelActionBase>(contextPath, LabelActionBase.class, this.labelActions, Optional.ofNullable(labelActionsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public SensitivityLabel withLabelActions(List<LabelActionBase> labelActions) {
        SensitivityLabel _x = _copy();
        _x.changedFields = changedFields.add("labelActions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sensitivityLabel");
        _x.labelActions = labelActions;
        return _x;
    }

    @Property(name="labelActions")
    @JsonIgnore
    public CollectionPage<LabelActionBase> getLabelActions(HttpRequestOptions options) {
        return new CollectionPage<LabelActionBase>(contextPath, LabelActionBase.class, this.labelActions, Optional.ofNullable(labelActionsNextLink), Collections.emptyList(), options);
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public SensitivityLabel withName(String name) {
        SensitivityLabel _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sensitivityLabel");
        _x.name = name;
        return _x;
    }

    @Property(name="priority")
    @JsonIgnore
    public Optional<Integer> getPriority() {
        return Optional.ofNullable(priority);
    }

    public SensitivityLabel withPriority(Integer priority) {
        SensitivityLabel _x = _copy();
        _x.changedFields = changedFields.add("priority");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sensitivityLabel");
        _x.priority = priority;
        return _x;
    }

    @Property(name="toolTip")
    @JsonIgnore
    public Optional<String> getToolTip() {
        return Optional.ofNullable(toolTip);
    }

    public SensitivityLabel withToolTip(String toolTip) {
        SensitivityLabel _x = _copy();
        _x.changedFields = changedFields.add("toolTip");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sensitivityLabel");
        _x.toolTip = toolTip;
        return _x;
    }

    public SensitivityLabel withUnmappedField(String name, Object value) {
        SensitivityLabel _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="sublabels")
    @JsonIgnore
    public SensitivityLabelCollectionRequest getSublabels() {
        return new SensitivityLabelCollectionRequest(
                        contextPath.addSegment("sublabels"), Optional.ofNullable(sublabels));
    }

    public SensitivityLabel withSublabels(List<SensitivityLabel> sublabels) {
        SensitivityLabel _x = _copy();
        _x.changedFields = changedFields.add("sublabels");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sensitivityLabel");
        _x.sublabels = sublabels;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SensitivityLabel patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SensitivityLabel _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SensitivityLabel put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SensitivityLabel _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SensitivityLabel _copy() {
        SensitivityLabel _x = new SensitivityLabel();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.applicableTo = applicableTo;
        _x.applicationMode = applicationMode;
        _x.assignedPolicies = assignedPolicies;
        _x.autoLabeling = autoLabeling;
        _x.description = description;
        _x.displayName = displayName;
        _x.isDefault = isDefault;
        _x.isEndpointProtectionEnabled = isEndpointProtectionEnabled;
        _x.labelActions = labelActions;
        _x.name = name;
        _x.priority = priority;
        _x.toolTip = toolTip;
        _x.sublabels = sublabels;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SensitivityLabel[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("applicableTo=");
        b.append(this.applicableTo);
        b.append(", ");
        b.append("applicationMode=");
        b.append(this.applicationMode);
        b.append(", ");
        b.append("assignedPolicies=");
        b.append(this.assignedPolicies);
        b.append(", ");
        b.append("autoLabeling=");
        b.append(this.autoLabeling);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("isDefault=");
        b.append(this.isDefault);
        b.append(", ");
        b.append("isEndpointProtectionEnabled=");
        b.append(this.isEndpointProtectionEnabled);
        b.append(", ");
        b.append("labelActions=");
        b.append(this.labelActions);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("priority=");
        b.append(this.priority);
        b.append(", ");
        b.append("toolTip=");
        b.append(this.toolTip);
        b.append(", ");
        b.append("sublabels=");
        b.append(this.sublabels);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
