package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.ClassificationMethod;
import odata.msgraph.client.beta.enums.SensitiveTypeScope;
import odata.msgraph.client.beta.enums.SensitiveTypeSource;

@JsonPropertyOrder({
    "@odata.type", 
    "classificationMethod", 
    "description", 
    "name", 
    "publisherName", 
    "rulePackageId", 
    "rulePackageType", 
    "scope", 
    "sensitiveTypeSource", 
    "state"})
@JsonInclude(Include.NON_NULL)
public class SensitiveType extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.sensitiveType";
    }

    @JsonProperty("classificationMethod")
    protected ClassificationMethod classificationMethod;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("publisherName")
    protected String publisherName;

    @JsonProperty("rulePackageId")
    protected String rulePackageId;

    @JsonProperty("rulePackageType")
    protected String rulePackageType;

    @JsonProperty("scope")
    protected SensitiveTypeScope scope;

    @JsonProperty("sensitiveTypeSource")
    protected SensitiveTypeSource sensitiveTypeSource;

    @JsonProperty("state")
    protected String state;

    protected SensitiveType() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSensitiveType() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private ClassificationMethod classificationMethod;
        private String description;
        private String name;
        private String publisherName;
        private String rulePackageId;
        private String rulePackageType;
        private SensitiveTypeScope scope;
        private SensitiveTypeSource sensitiveTypeSource;
        private String state;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder classificationMethod(ClassificationMethod classificationMethod) {
            this.classificationMethod = classificationMethod;
            this.changedFields = changedFields.add("classificationMethod");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder publisherName(String publisherName) {
            this.publisherName = publisherName;
            this.changedFields = changedFields.add("publisherName");
            return this;
        }

        public Builder rulePackageId(String rulePackageId) {
            this.rulePackageId = rulePackageId;
            this.changedFields = changedFields.add("rulePackageId");
            return this;
        }

        public Builder rulePackageType(String rulePackageType) {
            this.rulePackageType = rulePackageType;
            this.changedFields = changedFields.add("rulePackageType");
            return this;
        }

        public Builder scope(SensitiveTypeScope scope) {
            this.scope = scope;
            this.changedFields = changedFields.add("scope");
            return this;
        }

        public Builder sensitiveTypeSource(SensitiveTypeSource sensitiveTypeSource) {
            this.sensitiveTypeSource = sensitiveTypeSource;
            this.changedFields = changedFields.add("sensitiveTypeSource");
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        public SensitiveType build() {
            SensitiveType _x = new SensitiveType();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.sensitiveType";
            _x.id = id;
            _x.classificationMethod = classificationMethod;
            _x.description = description;
            _x.name = name;
            _x.publisherName = publisherName;
            _x.rulePackageId = rulePackageId;
            _x.rulePackageType = rulePackageType;
            _x.scope = scope;
            _x.sensitiveTypeSource = sensitiveTypeSource;
            _x.state = state;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="classificationMethod")
    @JsonIgnore
    public Optional<ClassificationMethod> getClassificationMethod() {
        return Optional.ofNullable(classificationMethod);
    }

    public SensitiveType withClassificationMethod(ClassificationMethod classificationMethod) {
        SensitiveType _x = _copy();
        _x.changedFields = changedFields.add("classificationMethod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sensitiveType");
        _x.classificationMethod = classificationMethod;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public SensitiveType withDescription(String description) {
        SensitiveType _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sensitiveType");
        _x.description = description;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public SensitiveType withName(String name) {
        SensitiveType _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sensitiveType");
        _x.name = name;
        return _x;
    }

    @Property(name="publisherName")
    @JsonIgnore
    public Optional<String> getPublisherName() {
        return Optional.ofNullable(publisherName);
    }

    public SensitiveType withPublisherName(String publisherName) {
        SensitiveType _x = _copy();
        _x.changedFields = changedFields.add("publisherName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sensitiveType");
        _x.publisherName = publisherName;
        return _x;
    }

    @Property(name="rulePackageId")
    @JsonIgnore
    public Optional<String> getRulePackageId() {
        return Optional.ofNullable(rulePackageId);
    }

    public SensitiveType withRulePackageId(String rulePackageId) {
        SensitiveType _x = _copy();
        _x.changedFields = changedFields.add("rulePackageId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sensitiveType");
        _x.rulePackageId = rulePackageId;
        return _x;
    }

    @Property(name="rulePackageType")
    @JsonIgnore
    public Optional<String> getRulePackageType() {
        return Optional.ofNullable(rulePackageType);
    }

    public SensitiveType withRulePackageType(String rulePackageType) {
        SensitiveType _x = _copy();
        _x.changedFields = changedFields.add("rulePackageType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sensitiveType");
        _x.rulePackageType = rulePackageType;
        return _x;
    }

    @Property(name="scope")
    @JsonIgnore
    public Optional<SensitiveTypeScope> getScope() {
        return Optional.ofNullable(scope);
    }

    public SensitiveType withScope(SensitiveTypeScope scope) {
        SensitiveType _x = _copy();
        _x.changedFields = changedFields.add("scope");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sensitiveType");
        _x.scope = scope;
        return _x;
    }

    @Property(name="sensitiveTypeSource")
    @JsonIgnore
    public Optional<SensitiveTypeSource> getSensitiveTypeSource() {
        return Optional.ofNullable(sensitiveTypeSource);
    }

    public SensitiveType withSensitiveTypeSource(SensitiveTypeSource sensitiveTypeSource) {
        SensitiveType _x = _copy();
        _x.changedFields = changedFields.add("sensitiveTypeSource");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sensitiveType");
        _x.sensitiveTypeSource = sensitiveTypeSource;
        return _x;
    }

    @Property(name="state")
    @JsonIgnore
    public Optional<String> getState() {
        return Optional.ofNullable(state);
    }

    public SensitiveType withState(String state) {
        SensitiveType _x = _copy();
        _x.changedFields = changedFields.add("state");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sensitiveType");
        _x.state = state;
        return _x;
    }

    public SensitiveType withUnmappedField(String name, Object value) {
        SensitiveType _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SensitiveType patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SensitiveType _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SensitiveType put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SensitiveType _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SensitiveType _copy() {
        SensitiveType _x = new SensitiveType();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.classificationMethod = classificationMethod;
        _x.description = description;
        _x.name = name;
        _x.publisherName = publisherName;
        _x.rulePackageId = rulePackageId;
        _x.rulePackageType = rulePackageType;
        _x.scope = scope;
        _x.sensitiveTypeSource = sensitiveTypeSource;
        _x.state = state;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SensitiveType[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("classificationMethod=");
        b.append(this.classificationMethod);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("publisherName=");
        b.append(this.publisherName);
        b.append(", ");
        b.append("rulePackageId=");
        b.append(this.rulePackageId);
        b.append(", ");
        b.append("rulePackageType=");
        b.append(this.rulePackageType);
        b.append(", ");
        b.append("scope=");
        b.append(this.scope);
        b.append(", ");
        b.append("sensitiveTypeSource=");
        b.append(this.sensitiveTypeSource);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
