package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.SecurityBaselineSettingStateCollectionRequest;
import odata.msgraph.client.beta.enums.SecurityBaselineComplianceState;


/**
 * <i>“Security baseline state for a device.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "securityBaselineTemplateId", 
    "state", 
    "userPrincipalName", 
    "settingStates"})
@JsonInclude(Include.NON_NULL)
public class SecurityBaselineState extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.securityBaselineState";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("securityBaselineTemplateId")
    protected String securityBaselineTemplateId;

    @JsonProperty("state")
    protected SecurityBaselineComplianceState state;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    @JsonProperty("settingStates")
    protected List<SecurityBaselineSettingState> settingStates;

    protected SecurityBaselineState() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSecurityBaselineState() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String securityBaselineTemplateId;
        private SecurityBaselineComplianceState state;
        private String userPrincipalName;
        private List<SecurityBaselineSettingState> settingStates;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The display name of the security baseline”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“The security baseline template id”</i>
         * 
         * @param securityBaselineTemplateId
         *            value of {@code securityBaselineTemplateId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder securityBaselineTemplateId(String securityBaselineTemplateId) {
            this.securityBaselineTemplateId = securityBaselineTemplateId;
            this.changedFields = changedFields.add("securityBaselineTemplateId");
            return this;
        }

        /**
         * <i>“Security baseline compliance state”</i>
         * 
         * @param state
         *            value of {@code state} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder state(SecurityBaselineComplianceState state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        /**
         * <i>“User Principal Name”</i>
         * 
         * @param userPrincipalName
         *            value of {@code userPrincipalName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        /**
         * <i>“The security baseline state for different settings for a device”</i>
         * 
         * @param settingStates
         *            value of {@code settingStates} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingStates(List<SecurityBaselineSettingState> settingStates) {
            this.settingStates = settingStates;
            this.changedFields = changedFields.add("settingStates");
            return this;
        }

        /**
         * <i>“The security baseline state for different settings for a device”</i>
         * 
         * @param settingStates
         *            value of {@code settingStates} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingStates(SecurityBaselineSettingState... settingStates) {
            return settingStates(Arrays.asList(settingStates));
        }

        public SecurityBaselineState build() {
            SecurityBaselineState _x = new SecurityBaselineState();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.securityBaselineState";
            _x.id = id;
            _x.displayName = displayName;
            _x.securityBaselineTemplateId = securityBaselineTemplateId;
            _x.state = state;
            _x.userPrincipalName = userPrincipalName;
            _x.settingStates = settingStates;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The display name of the security baseline”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The display name of the security baseline”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public SecurityBaselineState withDisplayName(String displayName) {
        SecurityBaselineState _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityBaselineState");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“The security baseline template id”</i>
     * 
     * @return property securityBaselineTemplateId
     */
    @Property(name="securityBaselineTemplateId")
    @JsonIgnore
    public Optional<String> getSecurityBaselineTemplateId() {
        return Optional.ofNullable(securityBaselineTemplateId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * securityBaselineTemplateId} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The security baseline template id”</i>
     * 
     * @param securityBaselineTemplateId
     *            new value of {@code securityBaselineTemplateId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code securityBaselineTemplateId} field changed
     */
    public SecurityBaselineState withSecurityBaselineTemplateId(String securityBaselineTemplateId) {
        SecurityBaselineState _x = _copy();
        _x.changedFields = changedFields.add("securityBaselineTemplateId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityBaselineState");
        _x.securityBaselineTemplateId = securityBaselineTemplateId;
        return _x;
    }

    /**
     * <i>“Security baseline compliance state”</i>
     * 
     * @return property state
     */
    @Property(name="state")
    @JsonIgnore
    public Optional<SecurityBaselineComplianceState> getState() {
        return Optional.ofNullable(state);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code state} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Security baseline compliance state”</i>
     * 
     * @param state
     *            new value of {@code state} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code state} field changed
     */
    public SecurityBaselineState withState(SecurityBaselineComplianceState state) {
        SecurityBaselineState _x = _copy();
        _x.changedFields = changedFields.add("state");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityBaselineState");
        _x.state = state;
        return _x;
    }

    /**
     * <i>“User Principal Name”</i>
     * 
     * @return property userPrincipalName
     */
    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userPrincipalName
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“User Principal Name”</i>
     * 
     * @param userPrincipalName
     *            new value of {@code userPrincipalName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userPrincipalName} field changed
     */
    public SecurityBaselineState withUserPrincipalName(String userPrincipalName) {
        SecurityBaselineState _x = _copy();
        _x.changedFields = changedFields.add("userPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityBaselineState");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    public SecurityBaselineState withUnmappedField(String name, Object value) {
        SecurityBaselineState _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“The security baseline state for different settings for a device”</i>
     * 
     * @return navigational property settingStates
     */
    @NavigationProperty(name="settingStates")
    @JsonIgnore
    public SecurityBaselineSettingStateCollectionRequest getSettingStates() {
        return new SecurityBaselineSettingStateCollectionRequest(
                        contextPath.addSegment("settingStates"), Optional.ofNullable(settingStates));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code settingStates}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The security baseline state for different settings for a device”</i>
     * 
     * @param settingStates
     *            new value of {@code settingStates} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingStates} field changed
     */
    public SecurityBaselineState withSettingStates(List<SecurityBaselineSettingState> settingStates) {
        SecurityBaselineState _x = _copy();
        _x.changedFields = changedFields.add("settingStates");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityBaselineState");
        _x.settingStates = settingStates;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SecurityBaselineState patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SecurityBaselineState _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SecurityBaselineState put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SecurityBaselineState _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SecurityBaselineState _copy() {
        SecurityBaselineState _x = new SecurityBaselineState();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.securityBaselineTemplateId = securityBaselineTemplateId;
        _x.state = state;
        _x.userPrincipalName = userPrincipalName;
        _x.settingStates = settingStates;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SecurityBaselineState[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("securityBaselineTemplateId=");
        b.append(this.securityBaselineTemplateId);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append(", ");
        b.append("settingStates=");
        b.append(this.settingStates);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
