package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.SecurityBaselineContributingPolicy;
import odata.msgraph.client.beta.complex.SettingSource;
import odata.msgraph.client.beta.enums.SecurityBaselineComplianceState;


/**
 * <i>“The security baseline compliance state of a setting for a device”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "contributingPolicies", 
    "errorCode", 
    "settingCategoryId", 
    "settingCategoryName", 
    "settingId", 
    "settingName", 
    "sourcePolicies", 
    "state"})
@JsonInclude(Include.NON_NULL)
public class SecurityBaselineSettingState extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.securityBaselineSettingState";
    }

    @JsonProperty("contributingPolicies")
    protected List<SecurityBaselineContributingPolicy> contributingPolicies;

    @JsonProperty("contributingPolicies@nextLink")
    protected String contributingPoliciesNextLink;

    @JsonProperty("errorCode")
    protected String errorCode;

    @JsonProperty("settingCategoryId")
    protected String settingCategoryId;

    @JsonProperty("settingCategoryName")
    protected String settingCategoryName;

    @JsonProperty("settingId")
    protected String settingId;

    @JsonProperty("settingName")
    protected String settingName;

    @JsonProperty("sourcePolicies")
    protected List<SettingSource> sourcePolicies;

    @JsonProperty("sourcePolicies@nextLink")
    protected String sourcePoliciesNextLink;

    @JsonProperty("state")
    protected SecurityBaselineComplianceState state;

    protected SecurityBaselineSettingState() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSecurityBaselineSettingState() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<SecurityBaselineContributingPolicy> contributingPolicies;
        private String contributingPoliciesNextLink;
        private String errorCode;
        private String settingCategoryId;
        private String settingCategoryName;
        private String settingId;
        private String settingName;
        private List<SettingSource> sourcePolicies;
        private String sourcePoliciesNextLink;
        private SecurityBaselineComplianceState state;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The policies that contribute to this setting instance”</i>
         * 
         * @param contributingPolicies
         *            value of {@code contributingPolicies} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contributingPolicies(List<SecurityBaselineContributingPolicy> contributingPolicies) {
            this.contributingPolicies = contributingPolicies;
            this.changedFields = changedFields.add("contributingPolicies");
            return this;
        }

        /**
         * <i>“The policies that contribute to this setting instance”</i>
         * 
         * @param contributingPolicies
         *            value of {@code contributingPolicies} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contributingPolicies(SecurityBaselineContributingPolicy... contributingPolicies) {
            return contributingPolicies(Arrays.asList(contributingPolicies));
        }

        /**
         * <i>“The policies that contribute to this setting instance”</i>
         * 
         * @param contributingPoliciesNextLink
         *            value of {@code contributingPolicies@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contributingPoliciesNextLink(String contributingPoliciesNextLink) {
            this.contributingPoliciesNextLink = contributingPoliciesNextLink;
            this.changedFields = changedFields.add("contributingPolicies");
            return this;
        }

        /**
         * <i>“The error code if the setting is in error state”</i>
         * 
         * @param errorCode
         *            value of {@code errorCode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            this.changedFields = changedFields.add("errorCode");
            return this;
        }

        /**
         * <i>“The setting category id which this setting belongs to”</i>
         * 
         * @param settingCategoryId
         *            value of {@code settingCategoryId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingCategoryId(String settingCategoryId) {
            this.settingCategoryId = settingCategoryId;
            this.changedFields = changedFields.add("settingCategoryId");
            return this;
        }

        /**
         * <i>“The setting category name which this setting belongs to”</i>
         * 
         * @param settingCategoryName
         *            value of {@code settingCategoryName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingCategoryName(String settingCategoryName) {
            this.settingCategoryName = settingCategoryName;
            this.changedFields = changedFields.add("settingCategoryName");
            return this;
        }

        /**
         * <i>“The setting id guid”</i>
         * 
         * @param settingId
         *            value of {@code settingId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingId(String settingId) {
            this.settingId = settingId;
            this.changedFields = changedFields.add("settingId");
            return this;
        }

        /**
         * <i>“The setting name that is being reported”</i>
         * 
         * @param settingName
         *            value of {@code settingName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingName(String settingName) {
            this.settingName = settingName;
            this.changedFields = changedFields.add("settingName");
            return this;
        }

        /**
         * <i>“The policies that contribute to this setting instance”</i>
         * 
         * @param sourcePolicies
         *            value of {@code sourcePolicies} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder sourcePolicies(List<SettingSource> sourcePolicies) {
            this.sourcePolicies = sourcePolicies;
            this.changedFields = changedFields.add("sourcePolicies");
            return this;
        }

        /**
         * <i>“The policies that contribute to this setting instance”</i>
         * 
         * @param sourcePolicies
         *            value of {@code sourcePolicies} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder sourcePolicies(SettingSource... sourcePolicies) {
            return sourcePolicies(Arrays.asList(sourcePolicies));
        }

        /**
         * <i>“The policies that contribute to this setting instance”</i>
         * 
         * @param sourcePoliciesNextLink
         *            value of {@code sourcePolicies@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder sourcePoliciesNextLink(String sourcePoliciesNextLink) {
            this.sourcePoliciesNextLink = sourcePoliciesNextLink;
            this.changedFields = changedFields.add("sourcePolicies");
            return this;
        }

        /**
         * <i>“The compliance state of the security baseline setting”</i>
         * 
         * @param state
         *            value of {@code state} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder state(SecurityBaselineComplianceState state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        public SecurityBaselineSettingState build() {
            SecurityBaselineSettingState _x = new SecurityBaselineSettingState();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.securityBaselineSettingState";
            _x.id = id;
            _x.contributingPolicies = contributingPolicies;
            _x.contributingPoliciesNextLink = contributingPoliciesNextLink;
            _x.errorCode = errorCode;
            _x.settingCategoryId = settingCategoryId;
            _x.settingCategoryName = settingCategoryName;
            _x.settingId = settingId;
            _x.settingName = settingName;
            _x.sourcePolicies = sourcePolicies;
            _x.sourcePoliciesNextLink = sourcePoliciesNextLink;
            _x.state = state;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The policies that contribute to this setting instance”</i>
     * 
     * @return property contributingPolicies
     */
    @Property(name="contributingPolicies")
    @JsonIgnore
    public CollectionPage<SecurityBaselineContributingPolicy> getContributingPolicies() {
        return new CollectionPage<SecurityBaselineContributingPolicy>(contextPath, SecurityBaselineContributingPolicy.class, this.contributingPolicies, Optional.ofNullable(contributingPoliciesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * contributingPolicies} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The policies that contribute to this setting instance”</i>
     * 
     * @param contributingPolicies
     *            new value of {@code contributingPolicies} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code contributingPolicies} field changed
     */
    public SecurityBaselineSettingState withContributingPolicies(List<SecurityBaselineContributingPolicy> contributingPolicies) {
        SecurityBaselineSettingState _x = _copy();
        _x.changedFields = changedFields.add("contributingPolicies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityBaselineSettingState");
        _x.contributingPolicies = contributingPolicies;
        return _x;
    }

    /**
     * <i>“The policies that contribute to this setting instance”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property contributingPolicies
     */
    @Property(name="contributingPolicies")
    @JsonIgnore
    public CollectionPage<SecurityBaselineContributingPolicy> getContributingPolicies(HttpRequestOptions options) {
        return new CollectionPage<SecurityBaselineContributingPolicy>(contextPath, SecurityBaselineContributingPolicy.class, this.contributingPolicies, Optional.ofNullable(contributingPoliciesNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“The error code if the setting is in error state”</i>
     * 
     * @return property errorCode
     */
    @Property(name="errorCode")
    @JsonIgnore
    public Optional<String> getErrorCode() {
        return Optional.ofNullable(errorCode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code errorCode} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The error code if the setting is in error state”</i>
     * 
     * @param errorCode
     *            new value of {@code errorCode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code errorCode} field changed
     */
    public SecurityBaselineSettingState withErrorCode(String errorCode) {
        SecurityBaselineSettingState _x = _copy();
        _x.changedFields = changedFields.add("errorCode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityBaselineSettingState");
        _x.errorCode = errorCode;
        return _x;
    }

    /**
     * <i>“The setting category id which this setting belongs to”</i>
     * 
     * @return property settingCategoryId
     */
    @Property(name="settingCategoryId")
    @JsonIgnore
    public Optional<String> getSettingCategoryId() {
        return Optional.ofNullable(settingCategoryId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code settingCategoryId
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The setting category id which this setting belongs to”</i>
     * 
     * @param settingCategoryId
     *            new value of {@code settingCategoryId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingCategoryId} field changed
     */
    public SecurityBaselineSettingState withSettingCategoryId(String settingCategoryId) {
        SecurityBaselineSettingState _x = _copy();
        _x.changedFields = changedFields.add("settingCategoryId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityBaselineSettingState");
        _x.settingCategoryId = settingCategoryId;
        return _x;
    }

    /**
     * <i>“The setting category name which this setting belongs to”</i>
     * 
     * @return property settingCategoryName
     */
    @Property(name="settingCategoryName")
    @JsonIgnore
    public Optional<String> getSettingCategoryName() {
        return Optional.ofNullable(settingCategoryName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * settingCategoryName} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The setting category name which this setting belongs to”</i>
     * 
     * @param settingCategoryName
     *            new value of {@code settingCategoryName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingCategoryName} field changed
     */
    public SecurityBaselineSettingState withSettingCategoryName(String settingCategoryName) {
        SecurityBaselineSettingState _x = _copy();
        _x.changedFields = changedFields.add("settingCategoryName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityBaselineSettingState");
        _x.settingCategoryName = settingCategoryName;
        return _x;
    }

    /**
     * <i>“The setting id guid”</i>
     * 
     * @return property settingId
     */
    @Property(name="settingId")
    @JsonIgnore
    public Optional<String> getSettingId() {
        return Optional.ofNullable(settingId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code settingId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The setting id guid”</i>
     * 
     * @param settingId
     *            new value of {@code settingId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingId} field changed
     */
    public SecurityBaselineSettingState withSettingId(String settingId) {
        SecurityBaselineSettingState _x = _copy();
        _x.changedFields = changedFields.add("settingId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityBaselineSettingState");
        _x.settingId = settingId;
        return _x;
    }

    /**
     * <i>“The setting name that is being reported”</i>
     * 
     * @return property settingName
     */
    @Property(name="settingName")
    @JsonIgnore
    public Optional<String> getSettingName() {
        return Optional.ofNullable(settingName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code settingName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The setting name that is being reported”</i>
     * 
     * @param settingName
     *            new value of {@code settingName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingName} field changed
     */
    public SecurityBaselineSettingState withSettingName(String settingName) {
        SecurityBaselineSettingState _x = _copy();
        _x.changedFields = changedFields.add("settingName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityBaselineSettingState");
        _x.settingName = settingName;
        return _x;
    }

    /**
     * <i>“The policies that contribute to this setting instance”</i>
     * 
     * @return property sourcePolicies
     */
    @Property(name="sourcePolicies")
    @JsonIgnore
    public CollectionPage<SettingSource> getSourcePolicies() {
        return new CollectionPage<SettingSource>(contextPath, SettingSource.class, this.sourcePolicies, Optional.ofNullable(sourcePoliciesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code sourcePolicies}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The policies that contribute to this setting instance”</i>
     * 
     * @param sourcePolicies
     *            new value of {@code sourcePolicies} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code sourcePolicies} field changed
     */
    public SecurityBaselineSettingState withSourcePolicies(List<SettingSource> sourcePolicies) {
        SecurityBaselineSettingState _x = _copy();
        _x.changedFields = changedFields.add("sourcePolicies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityBaselineSettingState");
        _x.sourcePolicies = sourcePolicies;
        return _x;
    }

    /**
     * <i>“The policies that contribute to this setting instance”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property sourcePolicies
     */
    @Property(name="sourcePolicies")
    @JsonIgnore
    public CollectionPage<SettingSource> getSourcePolicies(HttpRequestOptions options) {
        return new CollectionPage<SettingSource>(contextPath, SettingSource.class, this.sourcePolicies, Optional.ofNullable(sourcePoliciesNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“The compliance state of the security baseline setting”</i>
     * 
     * @return property state
     */
    @Property(name="state")
    @JsonIgnore
    public Optional<SecurityBaselineComplianceState> getState() {
        return Optional.ofNullable(state);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code state} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The compliance state of the security baseline setting”</i>
     * 
     * @param state
     *            new value of {@code state} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code state} field changed
     */
    public SecurityBaselineSettingState withState(SecurityBaselineComplianceState state) {
        SecurityBaselineSettingState _x = _copy();
        _x.changedFields = changedFields.add("state");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityBaselineSettingState");
        _x.state = state;
        return _x;
    }

    public SecurityBaselineSettingState withUnmappedField(String name, Object value) {
        SecurityBaselineSettingState _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SecurityBaselineSettingState patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SecurityBaselineSettingState _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SecurityBaselineSettingState put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SecurityBaselineSettingState _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SecurityBaselineSettingState _copy() {
        SecurityBaselineSettingState _x = new SecurityBaselineSettingState();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.contributingPolicies = contributingPolicies;
        _x.errorCode = errorCode;
        _x.settingCategoryId = settingCategoryId;
        _x.settingCategoryName = settingCategoryName;
        _x.settingId = settingId;
        _x.settingName = settingName;
        _x.sourcePolicies = sourcePolicies;
        _x.state = state;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SecurityBaselineSettingState[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("contributingPolicies=");
        b.append(this.contributingPolicies);
        b.append(", ");
        b.append("errorCode=");
        b.append(this.errorCode);
        b.append(", ");
        b.append("settingCategoryId=");
        b.append(this.settingCategoryId);
        b.append(", ");
        b.append("settingCategoryName=");
        b.append(this.settingCategoryName);
        b.append(", ");
        b.append("settingId=");
        b.append(this.settingId);
        b.append(", ");
        b.append("settingName=");
        b.append(this.settingName);
        b.append(", ");
        b.append("sourcePolicies=");
        b.append(this.sourcePolicies);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
