package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import microsoft.graph.security.entity.InformationProtection;
import microsoft.graph.security.entity.request.InformationProtectionEntityRequest;

import odata.msgraph.client.beta.complex.SecurityProviderStatus;
import odata.msgraph.client.beta.entity.collection.request.AlertCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CloudAppSecurityProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DomainSecurityProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.FileSecurityProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.HostSecurityProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.IpSecurityProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ProviderTenantSettingCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SecureScoreCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SecureScoreControlProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SecurityActionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TiIndicatorCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserSecurityProfileCollectionRequest;
import odata.msgraph.client.beta.entity.request.AttackSimulationRootRequest;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.CountRestrictions</b>
 * <p>
 * Countable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
 * <p>
 * Expandable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
 * <p>
 * Filterable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
 * <p>
 * Searchable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.SelectRestrictions</b>
 * <p>
 * Selectable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.SkipSupported</b>
 * <p>
 * true
 * <p>
 * <b>Org.OData.Capabilities.V1.SortRestrictions</b>
 * <p>
 * Sortable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.TopSupported</b>
 * <p>
 * false
 */@JsonPropertyOrder({
    "@odata.type", 
    "providerStatus", 
    "informationProtection", 
    "attackSimulation", 
    "alerts", 
    "cloudAppSecurityProfiles", 
    "domainSecurityProfiles", 
    "fileSecurityProfiles", 
    "hostSecurityProfiles", 
    "ipSecurityProfiles", 
    "providerTenantSettings", 
    "secureScoreControlProfiles", 
    "secureScores", 
    "securityActions", 
    "tiIndicators", 
    "userSecurityProfiles"})
@JsonInclude(Include.NON_NULL)
public class Security extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.security";
    }

    @JsonProperty("providerStatus")
    protected List<SecurityProviderStatus> providerStatus;

    @JsonProperty("providerStatus@nextLink")
    protected String providerStatusNextLink;

    @JsonProperty("informationProtection")
    protected InformationProtection informationProtection;

    @JsonProperty("attackSimulation")
    protected AttackSimulationRoot attackSimulation;

    @JsonProperty("alerts")
    protected List<Alert> alerts;

    @JsonProperty("cloudAppSecurityProfiles")
    protected List<CloudAppSecurityProfile> cloudAppSecurityProfiles;

    @JsonProperty("domainSecurityProfiles")
    protected List<DomainSecurityProfile> domainSecurityProfiles;

    @JsonProperty("fileSecurityProfiles")
    protected List<FileSecurityProfile> fileSecurityProfiles;

    @JsonProperty("hostSecurityProfiles")
    protected List<HostSecurityProfile> hostSecurityProfiles;

    @JsonProperty("ipSecurityProfiles")
    protected List<IpSecurityProfile> ipSecurityProfiles;

    @JsonProperty("providerTenantSettings")
    protected List<ProviderTenantSetting> providerTenantSettings;

    @JsonProperty("secureScoreControlProfiles")
    protected List<SecureScoreControlProfile> secureScoreControlProfiles;

    @JsonProperty("secureScores")
    protected List<SecureScore> secureScores;

    @JsonProperty("securityActions")
    protected List<SecurityAction> securityActions;

    @JsonProperty("tiIndicators")
    protected List<TiIndicator> tiIndicators;

    @JsonProperty("userSecurityProfiles")
    protected List<UserSecurityProfile> userSecurityProfiles;

    protected Security() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSecurity() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<SecurityProviderStatus> providerStatus;
        private String providerStatusNextLink;
        private InformationProtection informationProtection;
        private AttackSimulationRoot attackSimulation;
        private List<Alert> alerts;
        private List<CloudAppSecurityProfile> cloudAppSecurityProfiles;
        private List<DomainSecurityProfile> domainSecurityProfiles;
        private List<FileSecurityProfile> fileSecurityProfiles;
        private List<HostSecurityProfile> hostSecurityProfiles;
        private List<IpSecurityProfile> ipSecurityProfiles;
        private List<ProviderTenantSetting> providerTenantSettings;
        private List<SecureScoreControlProfile> secureScoreControlProfiles;
        private List<SecureScore> secureScores;
        private List<SecurityAction> securityActions;
        private List<TiIndicator> tiIndicators;
        private List<UserSecurityProfile> userSecurityProfiles;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder providerStatus(List<SecurityProviderStatus> providerStatus) {
            this.providerStatus = providerStatus;
            this.changedFields = changedFields.add("providerStatus");
            return this;
        }

        public Builder providerStatus(SecurityProviderStatus... providerStatus) {
            return providerStatus(Arrays.asList(providerStatus));
        }

        public Builder providerStatusNextLink(String providerStatusNextLink) {
            this.providerStatusNextLink = providerStatusNextLink;
            this.changedFields = changedFields.add("providerStatus");
            return this;
        }

        public Builder informationProtection(InformationProtection informationProtection) {
            this.informationProtection = informationProtection;
            this.changedFields = changedFields.add("informationProtection");
            return this;
        }

        public Builder attackSimulation(AttackSimulationRoot attackSimulation) {
            this.attackSimulation = attackSimulation;
            this.changedFields = changedFields.add("attackSimulation");
            return this;
        }

        public Builder alerts(List<Alert> alerts) {
            this.alerts = alerts;
            this.changedFields = changedFields.add("alerts");
            return this;
        }

        public Builder alerts(Alert... alerts) {
            return alerts(Arrays.asList(alerts));
        }

        public Builder cloudAppSecurityProfiles(List<CloudAppSecurityProfile> cloudAppSecurityProfiles) {
            this.cloudAppSecurityProfiles = cloudAppSecurityProfiles;
            this.changedFields = changedFields.add("cloudAppSecurityProfiles");
            return this;
        }

        public Builder cloudAppSecurityProfiles(CloudAppSecurityProfile... cloudAppSecurityProfiles) {
            return cloudAppSecurityProfiles(Arrays.asList(cloudAppSecurityProfiles));
        }

        public Builder domainSecurityProfiles(List<DomainSecurityProfile> domainSecurityProfiles) {
            this.domainSecurityProfiles = domainSecurityProfiles;
            this.changedFields = changedFields.add("domainSecurityProfiles");
            return this;
        }

        public Builder domainSecurityProfiles(DomainSecurityProfile... domainSecurityProfiles) {
            return domainSecurityProfiles(Arrays.asList(domainSecurityProfiles));
        }

        public Builder fileSecurityProfiles(List<FileSecurityProfile> fileSecurityProfiles) {
            this.fileSecurityProfiles = fileSecurityProfiles;
            this.changedFields = changedFields.add("fileSecurityProfiles");
            return this;
        }

        public Builder fileSecurityProfiles(FileSecurityProfile... fileSecurityProfiles) {
            return fileSecurityProfiles(Arrays.asList(fileSecurityProfiles));
        }

        public Builder hostSecurityProfiles(List<HostSecurityProfile> hostSecurityProfiles) {
            this.hostSecurityProfiles = hostSecurityProfiles;
            this.changedFields = changedFields.add("hostSecurityProfiles");
            return this;
        }

        public Builder hostSecurityProfiles(HostSecurityProfile... hostSecurityProfiles) {
            return hostSecurityProfiles(Arrays.asList(hostSecurityProfiles));
        }

        public Builder ipSecurityProfiles(List<IpSecurityProfile> ipSecurityProfiles) {
            this.ipSecurityProfiles = ipSecurityProfiles;
            this.changedFields = changedFields.add("ipSecurityProfiles");
            return this;
        }

        public Builder ipSecurityProfiles(IpSecurityProfile... ipSecurityProfiles) {
            return ipSecurityProfiles(Arrays.asList(ipSecurityProfiles));
        }

        public Builder providerTenantSettings(List<ProviderTenantSetting> providerTenantSettings) {
            this.providerTenantSettings = providerTenantSettings;
            this.changedFields = changedFields.add("providerTenantSettings");
            return this;
        }

        public Builder providerTenantSettings(ProviderTenantSetting... providerTenantSettings) {
            return providerTenantSettings(Arrays.asList(providerTenantSettings));
        }

        public Builder secureScoreControlProfiles(List<SecureScoreControlProfile> secureScoreControlProfiles) {
            this.secureScoreControlProfiles = secureScoreControlProfiles;
            this.changedFields = changedFields.add("secureScoreControlProfiles");
            return this;
        }

        public Builder secureScoreControlProfiles(SecureScoreControlProfile... secureScoreControlProfiles) {
            return secureScoreControlProfiles(Arrays.asList(secureScoreControlProfiles));
        }

        public Builder secureScores(List<SecureScore> secureScores) {
            this.secureScores = secureScores;
            this.changedFields = changedFields.add("secureScores");
            return this;
        }

        public Builder secureScores(SecureScore... secureScores) {
            return secureScores(Arrays.asList(secureScores));
        }

        public Builder securityActions(List<SecurityAction> securityActions) {
            this.securityActions = securityActions;
            this.changedFields = changedFields.add("securityActions");
            return this;
        }

        public Builder securityActions(SecurityAction... securityActions) {
            return securityActions(Arrays.asList(securityActions));
        }

        public Builder tiIndicators(List<TiIndicator> tiIndicators) {
            this.tiIndicators = tiIndicators;
            this.changedFields = changedFields.add("tiIndicators");
            return this;
        }

        public Builder tiIndicators(TiIndicator... tiIndicators) {
            return tiIndicators(Arrays.asList(tiIndicators));
        }

        public Builder userSecurityProfiles(List<UserSecurityProfile> userSecurityProfiles) {
            this.userSecurityProfiles = userSecurityProfiles;
            this.changedFields = changedFields.add("userSecurityProfiles");
            return this;
        }

        public Builder userSecurityProfiles(UserSecurityProfile... userSecurityProfiles) {
            return userSecurityProfiles(Arrays.asList(userSecurityProfiles));
        }

        public Security build() {
            Security _x = new Security();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.security";
            _x.id = id;
            _x.providerStatus = providerStatus;
            _x.providerStatusNextLink = providerStatusNextLink;
            _x.informationProtection = informationProtection;
            _x.attackSimulation = attackSimulation;
            _x.alerts = alerts;
            _x.cloudAppSecurityProfiles = cloudAppSecurityProfiles;
            _x.domainSecurityProfiles = domainSecurityProfiles;
            _x.fileSecurityProfiles = fileSecurityProfiles;
            _x.hostSecurityProfiles = hostSecurityProfiles;
            _x.ipSecurityProfiles = ipSecurityProfiles;
            _x.providerTenantSettings = providerTenantSettings;
            _x.secureScoreControlProfiles = secureScoreControlProfiles;
            _x.secureScores = secureScores;
            _x.securityActions = securityActions;
            _x.tiIndicators = tiIndicators;
            _x.userSecurityProfiles = userSecurityProfiles;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="providerStatus")
    @JsonIgnore
    public CollectionPage<SecurityProviderStatus> getProviderStatus() {
        return new CollectionPage<SecurityProviderStatus>(contextPath, SecurityProviderStatus.class, this.providerStatus, Optional.ofNullable(providerStatusNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public Security withProviderStatus(List<SecurityProviderStatus> providerStatus) {
        Security _x = _copy();
        _x.changedFields = changedFields.add("providerStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.security");
        _x.providerStatus = providerStatus;
        return _x;
    }

    @Property(name="providerStatus")
    @JsonIgnore
    public CollectionPage<SecurityProviderStatus> getProviderStatus(HttpRequestOptions options) {
        return new CollectionPage<SecurityProviderStatus>(contextPath, SecurityProviderStatus.class, this.providerStatus, Optional.ofNullable(providerStatusNextLink), Collections.emptyList(), options);
    }

    public Security withUnmappedField(String name, Object value) {
        Security _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="informationProtection")
    @JsonIgnore
    public InformationProtectionEntityRequest getInformationProtection() {
        return new InformationProtectionEntityRequest(contextPath.addSegment("informationProtection"), Optional.ofNullable(informationProtection));
    }

    @NavigationProperty(name="attackSimulation")
    @JsonIgnore
    public AttackSimulationRootRequest getAttackSimulation() {
        return new AttackSimulationRootRequest(contextPath.addSegment("attackSimulation"), Optional.ofNullable(attackSimulation));
    }

    @NavigationProperty(name="alerts")
    @JsonIgnore
    public AlertCollectionRequest getAlerts() {
        return new AlertCollectionRequest(
                        contextPath.addSegment("alerts"), Optional.ofNullable(alerts));
    }

    @NavigationProperty(name="cloudAppSecurityProfiles")
    @JsonIgnore
    public CloudAppSecurityProfileCollectionRequest getCloudAppSecurityProfiles() {
        return new CloudAppSecurityProfileCollectionRequest(
                        contextPath.addSegment("cloudAppSecurityProfiles"), Optional.ofNullable(cloudAppSecurityProfiles));
    }

    @NavigationProperty(name="domainSecurityProfiles")
    @JsonIgnore
    public DomainSecurityProfileCollectionRequest getDomainSecurityProfiles() {
        return new DomainSecurityProfileCollectionRequest(
                        contextPath.addSegment("domainSecurityProfiles"), Optional.ofNullable(domainSecurityProfiles));
    }

    @NavigationProperty(name="fileSecurityProfiles")
    @JsonIgnore
    public FileSecurityProfileCollectionRequest getFileSecurityProfiles() {
        return new FileSecurityProfileCollectionRequest(
                        contextPath.addSegment("fileSecurityProfiles"), Optional.ofNullable(fileSecurityProfiles));
    }

    @NavigationProperty(name="hostSecurityProfiles")
    @JsonIgnore
    public HostSecurityProfileCollectionRequest getHostSecurityProfiles() {
        return new HostSecurityProfileCollectionRequest(
                        contextPath.addSegment("hostSecurityProfiles"), Optional.ofNullable(hostSecurityProfiles));
    }

    @NavigationProperty(name="ipSecurityProfiles")
    @JsonIgnore
    public IpSecurityProfileCollectionRequest getIpSecurityProfiles() {
        return new IpSecurityProfileCollectionRequest(
                        contextPath.addSegment("ipSecurityProfiles"), Optional.ofNullable(ipSecurityProfiles));
    }

    @NavigationProperty(name="providerTenantSettings")
    @JsonIgnore
    public ProviderTenantSettingCollectionRequest getProviderTenantSettings() {
        return new ProviderTenantSettingCollectionRequest(
                        contextPath.addSegment("providerTenantSettings"), Optional.ofNullable(providerTenantSettings));
    }

    @NavigationProperty(name="secureScoreControlProfiles")
    @JsonIgnore
    public SecureScoreControlProfileCollectionRequest getSecureScoreControlProfiles() {
        return new SecureScoreControlProfileCollectionRequest(
                        contextPath.addSegment("secureScoreControlProfiles"), Optional.ofNullable(secureScoreControlProfiles));
    }

    @NavigationProperty(name="secureScores")
    @JsonIgnore
    public SecureScoreCollectionRequest getSecureScores() {
        return new SecureScoreCollectionRequest(
                        contextPath.addSegment("secureScores"), Optional.ofNullable(secureScores));
    }

    @NavigationProperty(name="securityActions")
    @JsonIgnore
    public SecurityActionCollectionRequest getSecurityActions() {
        return new SecurityActionCollectionRequest(
                        contextPath.addSegment("securityActions"), Optional.ofNullable(securityActions));
    }

    @NavigationProperty(name="tiIndicators")
    @JsonIgnore
    public TiIndicatorCollectionRequest getTiIndicators() {
        return new TiIndicatorCollectionRequest(
                        contextPath.addSegment("tiIndicators"), Optional.ofNullable(tiIndicators));
    }

    @NavigationProperty(name="userSecurityProfiles")
    @JsonIgnore
    public UserSecurityProfileCollectionRequest getUserSecurityProfiles() {
        return new UserSecurityProfileCollectionRequest(
                        contextPath.addSegment("userSecurityProfiles"), Optional.ofNullable(userSecurityProfiles));
    }

    public Security withInformationProtection(InformationProtection informationProtection) {
        Security _x = _copy();
        _x.changedFields = changedFields.add("informationProtection");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.security");
        _x.informationProtection = informationProtection;
        return _x;
    }

    public Security withAttackSimulation(AttackSimulationRoot attackSimulation) {
        Security _x = _copy();
        _x.changedFields = changedFields.add("attackSimulation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.security");
        _x.attackSimulation = attackSimulation;
        return _x;
    }

    public Security withAlerts(List<Alert> alerts) {
        Security _x = _copy();
        _x.changedFields = changedFields.add("alerts");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.security");
        _x.alerts = alerts;
        return _x;
    }

    public Security withCloudAppSecurityProfiles(List<CloudAppSecurityProfile> cloudAppSecurityProfiles) {
        Security _x = _copy();
        _x.changedFields = changedFields.add("cloudAppSecurityProfiles");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.security");
        _x.cloudAppSecurityProfiles = cloudAppSecurityProfiles;
        return _x;
    }

    public Security withDomainSecurityProfiles(List<DomainSecurityProfile> domainSecurityProfiles) {
        Security _x = _copy();
        _x.changedFields = changedFields.add("domainSecurityProfiles");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.security");
        _x.domainSecurityProfiles = domainSecurityProfiles;
        return _x;
    }

    public Security withFileSecurityProfiles(List<FileSecurityProfile> fileSecurityProfiles) {
        Security _x = _copy();
        _x.changedFields = changedFields.add("fileSecurityProfiles");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.security");
        _x.fileSecurityProfiles = fileSecurityProfiles;
        return _x;
    }

    public Security withHostSecurityProfiles(List<HostSecurityProfile> hostSecurityProfiles) {
        Security _x = _copy();
        _x.changedFields = changedFields.add("hostSecurityProfiles");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.security");
        _x.hostSecurityProfiles = hostSecurityProfiles;
        return _x;
    }

    public Security withIpSecurityProfiles(List<IpSecurityProfile> ipSecurityProfiles) {
        Security _x = _copy();
        _x.changedFields = changedFields.add("ipSecurityProfiles");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.security");
        _x.ipSecurityProfiles = ipSecurityProfiles;
        return _x;
    }

    public Security withProviderTenantSettings(List<ProviderTenantSetting> providerTenantSettings) {
        Security _x = _copy();
        _x.changedFields = changedFields.add("providerTenantSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.security");
        _x.providerTenantSettings = providerTenantSettings;
        return _x;
    }

    public Security withSecureScoreControlProfiles(List<SecureScoreControlProfile> secureScoreControlProfiles) {
        Security _x = _copy();
        _x.changedFields = changedFields.add("secureScoreControlProfiles");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.security");
        _x.secureScoreControlProfiles = secureScoreControlProfiles;
        return _x;
    }

    public Security withSecureScores(List<SecureScore> secureScores) {
        Security _x = _copy();
        _x.changedFields = changedFields.add("secureScores");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.security");
        _x.secureScores = secureScores;
        return _x;
    }

    public Security withSecurityActions(List<SecurityAction> securityActions) {
        Security _x = _copy();
        _x.changedFields = changedFields.add("securityActions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.security");
        _x.securityActions = securityActions;
        return _x;
    }

    public Security withTiIndicators(List<TiIndicator> tiIndicators) {
        Security _x = _copy();
        _x.changedFields = changedFields.add("tiIndicators");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.security");
        _x.tiIndicators = tiIndicators;
        return _x;
    }

    public Security withUserSecurityProfiles(List<UserSecurityProfile> userSecurityProfiles) {
        Security _x = _copy();
        _x.changedFields = changedFields.add("userSecurityProfiles");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.security");
        _x.userSecurityProfiles = userSecurityProfiles;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Security patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Security _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Security put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Security _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Security _copy() {
        Security _x = new Security();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.providerStatus = providerStatus;
        _x.informationProtection = informationProtection;
        _x.attackSimulation = attackSimulation;
        _x.alerts = alerts;
        _x.cloudAppSecurityProfiles = cloudAppSecurityProfiles;
        _x.domainSecurityProfiles = domainSecurityProfiles;
        _x.fileSecurityProfiles = fileSecurityProfiles;
        _x.hostSecurityProfiles = hostSecurityProfiles;
        _x.ipSecurityProfiles = ipSecurityProfiles;
        _x.providerTenantSettings = providerTenantSettings;
        _x.secureScoreControlProfiles = secureScoreControlProfiles;
        _x.secureScores = secureScores;
        _x.securityActions = securityActions;
        _x.tiIndicators = tiIndicators;
        _x.userSecurityProfiles = userSecurityProfiles;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Security[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("providerStatus=");
        b.append(this.providerStatus);
        b.append(", ");
        b.append("informationProtection=");
        b.append(this.informationProtection);
        b.append(", ");
        b.append("attackSimulation=");
        b.append(this.attackSimulation);
        b.append(", ");
        b.append("alerts=");
        b.append(this.alerts);
        b.append(", ");
        b.append("cloudAppSecurityProfiles=");
        b.append(this.cloudAppSecurityProfiles);
        b.append(", ");
        b.append("domainSecurityProfiles=");
        b.append(this.domainSecurityProfiles);
        b.append(", ");
        b.append("fileSecurityProfiles=");
        b.append(this.fileSecurityProfiles);
        b.append(", ");
        b.append("hostSecurityProfiles=");
        b.append(this.hostSecurityProfiles);
        b.append(", ");
        b.append("ipSecurityProfiles=");
        b.append(this.ipSecurityProfiles);
        b.append(", ");
        b.append("providerTenantSettings=");
        b.append(this.providerTenantSettings);
        b.append(", ");
        b.append("secureScoreControlProfiles=");
        b.append(this.secureScoreControlProfiles);
        b.append(", ");
        b.append("secureScores=");
        b.append(this.secureScores);
        b.append(", ");
        b.append("securityActions=");
        b.append(this.securityActions);
        b.append(", ");
        b.append("tiIndicators=");
        b.append(this.tiIndicators);
        b.append(", ");
        b.append("userSecurityProfiles=");
        b.append(this.userSecurityProfiles);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
