package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Double;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AverageComparativeScore;
import odata.msgraph.client.beta.complex.ControlScore;
import odata.msgraph.client.beta.complex.SecurityVendorInformation;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.CountRestrictions</b>
 * <p>
 * Countable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
 * <p>
 * Filterable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.SelectRestrictions</b>
 * <p>
 * Selectable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.SkipSupported</b>
 * <p>
 * true
 * <p>
 * <b>Org.OData.Capabilities.V1.SortRestrictions</b>
 * <p>
 * Sortable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.TopSupported</b>
 * <p>
 * true
 */@JsonPropertyOrder({
    "@odata.type", 
    "activeUserCount", 
    "averageComparativeScores", 
    "azureTenantId", 
    "controlScores", 
    "createdDateTime", 
    "currentScore", 
    "enabledServices", 
    "licensedUserCount", 
    "maxScore", 
    "vendorInformation"})
@JsonInclude(Include.NON_NULL)
public class SecureScore extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.secureScore";
    }

    @JsonProperty("activeUserCount")
    protected Integer activeUserCount;

    @JsonProperty("averageComparativeScores")
    protected List<AverageComparativeScore> averageComparativeScores;

    @JsonProperty("averageComparativeScores@nextLink")
    protected String averageComparativeScoresNextLink;

    @JsonProperty("azureTenantId")
    protected String azureTenantId;

    @JsonProperty("controlScores")
    protected List<ControlScore> controlScores;

    @JsonProperty("controlScores@nextLink")
    protected String controlScoresNextLink;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("currentScore")
    protected Double currentScore;

    @JsonProperty("enabledServices")
    protected List<String> enabledServices;

    @JsonProperty("enabledServices@nextLink")
    protected String enabledServicesNextLink;

    @JsonProperty("licensedUserCount")
    protected Integer licensedUserCount;

    @JsonProperty("maxScore")
    protected Double maxScore;

    @JsonProperty("vendorInformation")
    protected SecurityVendorInformation vendorInformation;

    protected SecureScore() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSecureScore() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer activeUserCount;
        private List<AverageComparativeScore> averageComparativeScores;
        private String averageComparativeScoresNextLink;
        private String azureTenantId;
        private List<ControlScore> controlScores;
        private String controlScoresNextLink;
        private OffsetDateTime createdDateTime;
        private Double currentScore;
        private List<String> enabledServices;
        private String enabledServicesNextLink;
        private Integer licensedUserCount;
        private Double maxScore;
        private SecurityVendorInformation vendorInformation;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder activeUserCount(Integer activeUserCount) {
            this.activeUserCount = activeUserCount;
            this.changedFields = changedFields.add("activeUserCount");
            return this;
        }

        public Builder averageComparativeScores(List<AverageComparativeScore> averageComparativeScores) {
            this.averageComparativeScores = averageComparativeScores;
            this.changedFields = changedFields.add("averageComparativeScores");
            return this;
        }

        public Builder averageComparativeScores(AverageComparativeScore... averageComparativeScores) {
            return averageComparativeScores(Arrays.asList(averageComparativeScores));
        }

        public Builder averageComparativeScoresNextLink(String averageComparativeScoresNextLink) {
            this.averageComparativeScoresNextLink = averageComparativeScoresNextLink;
            this.changedFields = changedFields.add("averageComparativeScores");
            return this;
        }

        public Builder azureTenantId(String azureTenantId) {
            this.azureTenantId = azureTenantId;
            this.changedFields = changedFields.add("azureTenantId");
            return this;
        }

        public Builder controlScores(List<ControlScore> controlScores) {
            this.controlScores = controlScores;
            this.changedFields = changedFields.add("controlScores");
            return this;
        }

        public Builder controlScores(ControlScore... controlScores) {
            return controlScores(Arrays.asList(controlScores));
        }

        public Builder controlScoresNextLink(String controlScoresNextLink) {
            this.controlScoresNextLink = controlScoresNextLink;
            this.changedFields = changedFields.add("controlScores");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder currentScore(Double currentScore) {
            this.currentScore = currentScore;
            this.changedFields = changedFields.add("currentScore");
            return this;
        }

        public Builder enabledServices(List<String> enabledServices) {
            this.enabledServices = enabledServices;
            this.changedFields = changedFields.add("enabledServices");
            return this;
        }

        public Builder enabledServices(String... enabledServices) {
            return enabledServices(Arrays.asList(enabledServices));
        }

        public Builder enabledServicesNextLink(String enabledServicesNextLink) {
            this.enabledServicesNextLink = enabledServicesNextLink;
            this.changedFields = changedFields.add("enabledServices");
            return this;
        }

        public Builder licensedUserCount(Integer licensedUserCount) {
            this.licensedUserCount = licensedUserCount;
            this.changedFields = changedFields.add("licensedUserCount");
            return this;
        }

        public Builder maxScore(Double maxScore) {
            this.maxScore = maxScore;
            this.changedFields = changedFields.add("maxScore");
            return this;
        }

        public Builder vendorInformation(SecurityVendorInformation vendorInformation) {
            this.vendorInformation = vendorInformation;
            this.changedFields = changedFields.add("vendorInformation");
            return this;
        }

        public SecureScore build() {
            SecureScore _x = new SecureScore();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.secureScore";
            _x.id = id;
            _x.activeUserCount = activeUserCount;
            _x.averageComparativeScores = averageComparativeScores;
            _x.averageComparativeScoresNextLink = averageComparativeScoresNextLink;
            _x.azureTenantId = azureTenantId;
            _x.controlScores = controlScores;
            _x.controlScoresNextLink = controlScoresNextLink;
            _x.createdDateTime = createdDateTime;
            _x.currentScore = currentScore;
            _x.enabledServices = enabledServices;
            _x.enabledServicesNextLink = enabledServicesNextLink;
            _x.licensedUserCount = licensedUserCount;
            _x.maxScore = maxScore;
            _x.vendorInformation = vendorInformation;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="activeUserCount")
    @JsonIgnore
    public Optional<Integer> getActiveUserCount() {
        return Optional.ofNullable(activeUserCount);
    }

    public SecureScore withActiveUserCount(Integer activeUserCount) {
        SecureScore _x = _copy();
        _x.changedFields = changedFields.add("activeUserCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.secureScore");
        _x.activeUserCount = activeUserCount;
        return _x;
    }

    @Property(name="averageComparativeScores")
    @JsonIgnore
    public CollectionPage<AverageComparativeScore> getAverageComparativeScores() {
        return new CollectionPage<AverageComparativeScore>(contextPath, AverageComparativeScore.class, this.averageComparativeScores, Optional.ofNullable(averageComparativeScoresNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public SecureScore withAverageComparativeScores(List<AverageComparativeScore> averageComparativeScores) {
        SecureScore _x = _copy();
        _x.changedFields = changedFields.add("averageComparativeScores");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.secureScore");
        _x.averageComparativeScores = averageComparativeScores;
        return _x;
    }

    @Property(name="averageComparativeScores")
    @JsonIgnore
    public CollectionPage<AverageComparativeScore> getAverageComparativeScores(HttpRequestOptions options) {
        return new CollectionPage<AverageComparativeScore>(contextPath, AverageComparativeScore.class, this.averageComparativeScores, Optional.ofNullable(averageComparativeScoresNextLink), Collections.emptyList(), options);
    }

    @Property(name="azureTenantId")
    @JsonIgnore
    public Optional<String> getAzureTenantId() {
        return Optional.ofNullable(azureTenantId);
    }

    public SecureScore withAzureTenantId(String azureTenantId) {
        SecureScore _x = _copy();
        _x.changedFields = changedFields.add("azureTenantId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.secureScore");
        _x.azureTenantId = azureTenantId;
        return _x;
    }

    @Property(name="controlScores")
    @JsonIgnore
    public CollectionPage<ControlScore> getControlScores() {
        return new CollectionPage<ControlScore>(contextPath, ControlScore.class, this.controlScores, Optional.ofNullable(controlScoresNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public SecureScore withControlScores(List<ControlScore> controlScores) {
        SecureScore _x = _copy();
        _x.changedFields = changedFields.add("controlScores");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.secureScore");
        _x.controlScores = controlScores;
        return _x;
    }

    @Property(name="controlScores")
    @JsonIgnore
    public CollectionPage<ControlScore> getControlScores(HttpRequestOptions options) {
        return new CollectionPage<ControlScore>(contextPath, ControlScore.class, this.controlScores, Optional.ofNullable(controlScoresNextLink), Collections.emptyList(), options);
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public SecureScore withCreatedDateTime(OffsetDateTime createdDateTime) {
        SecureScore _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.secureScore");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="currentScore")
    @JsonIgnore
    public Optional<Double> getCurrentScore() {
        return Optional.ofNullable(currentScore);
    }

    public SecureScore withCurrentScore(Double currentScore) {
        SecureScore _x = _copy();
        _x.changedFields = changedFields.add("currentScore");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.secureScore");
        _x.currentScore = currentScore;
        return _x;
    }

    @Property(name="enabledServices")
    @JsonIgnore
    public CollectionPage<String> getEnabledServices() {
        return new CollectionPage<String>(contextPath, String.class, this.enabledServices, Optional.ofNullable(enabledServicesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public SecureScore withEnabledServices(List<String> enabledServices) {
        SecureScore _x = _copy();
        _x.changedFields = changedFields.add("enabledServices");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.secureScore");
        _x.enabledServices = enabledServices;
        return _x;
    }

    @Property(name="enabledServices")
    @JsonIgnore
    public CollectionPage<String> getEnabledServices(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.enabledServices, Optional.ofNullable(enabledServicesNextLink), Collections.emptyList(), options);
    }

    @Property(name="licensedUserCount")
    @JsonIgnore
    public Optional<Integer> getLicensedUserCount() {
        return Optional.ofNullable(licensedUserCount);
    }

    public SecureScore withLicensedUserCount(Integer licensedUserCount) {
        SecureScore _x = _copy();
        _x.changedFields = changedFields.add("licensedUserCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.secureScore");
        _x.licensedUserCount = licensedUserCount;
        return _x;
    }

    @Property(name="maxScore")
    @JsonIgnore
    public Optional<Double> getMaxScore() {
        return Optional.ofNullable(maxScore);
    }

    public SecureScore withMaxScore(Double maxScore) {
        SecureScore _x = _copy();
        _x.changedFields = changedFields.add("maxScore");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.secureScore");
        _x.maxScore = maxScore;
        return _x;
    }

    @Property(name="vendorInformation")
    @JsonIgnore
    public Optional<SecurityVendorInformation> getVendorInformation() {
        return Optional.ofNullable(vendorInformation);
    }

    public SecureScore withVendorInformation(SecurityVendorInformation vendorInformation) {
        SecureScore _x = _copy();
        _x.changedFields = changedFields.add("vendorInformation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.secureScore");
        _x.vendorInformation = vendorInformation;
        return _x;
    }

    public SecureScore withUnmappedField(String name, Object value) {
        SecureScore _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SecureScore patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SecureScore _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SecureScore put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SecureScore _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SecureScore _copy() {
        SecureScore _x = new SecureScore();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.activeUserCount = activeUserCount;
        _x.averageComparativeScores = averageComparativeScores;
        _x.azureTenantId = azureTenantId;
        _x.controlScores = controlScores;
        _x.createdDateTime = createdDateTime;
        _x.currentScore = currentScore;
        _x.enabledServices = enabledServices;
        _x.licensedUserCount = licensedUserCount;
        _x.maxScore = maxScore;
        _x.vendorInformation = vendorInformation;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SecureScore[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("activeUserCount=");
        b.append(this.activeUserCount);
        b.append(", ");
        b.append("averageComparativeScores=");
        b.append(this.averageComparativeScores);
        b.append(", ");
        b.append("azureTenantId=");
        b.append(this.azureTenantId);
        b.append(", ");
        b.append("controlScores=");
        b.append(this.controlScores);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("currentScore=");
        b.append(this.currentScore);
        b.append(", ");
        b.append("enabledServices=");
        b.append(this.enabledServices);
        b.append(", ");
        b.append("licensedUserCount=");
        b.append(this.licensedUserCount);
        b.append(", ");
        b.append("maxScore=");
        b.append(this.maxScore);
        b.append(", ");
        b.append("vendorInformation=");
        b.append(this.vendorInformation);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
