package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.Property;


/**
 * <p>
 * <b>Org.OData.Core.V1.Revisions</b>
 */@JsonPropertyOrder({
    "@odata.type", 
    "baseType", 
    "properties"})
@JsonInclude(Include.NON_NULL)
public class Schema extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.schema";
    }

    @JsonProperty("baseType")
    protected String baseType;

    @JsonProperty("properties")
    protected List<Property> properties;

    @JsonProperty("properties@nextLink")
    protected String propertiesNextLink;

    protected Schema() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSchema() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String baseType;
        private List<Property> properties;
        private String propertiesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder baseType(String baseType) {
            this.baseType = baseType;
            this.changedFields = changedFields.add("baseType");
            return this;
        }

        public Builder properties(List<Property> properties) {
            this.properties = properties;
            this.changedFields = changedFields.add("properties");
            return this;
        }

        public Builder properties(Property... properties) {
            return properties(Arrays.asList(properties));
        }

        public Builder propertiesNextLink(String propertiesNextLink) {
            this.propertiesNextLink = propertiesNextLink;
            this.changedFields = changedFields.add("properties");
            return this;
        }

        public Schema build() {
            Schema _x = new Schema();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.schema";
            _x.id = id;
            _x.baseType = baseType;
            _x.properties = properties;
            _x.propertiesNextLink = propertiesNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @com.github.davidmoten.odata.client.annotation.Property(name="baseType")
    @JsonIgnore
    public Optional<String> getBaseType() {
        return Optional.ofNullable(baseType);
    }

    public Schema withBaseType(String baseType) {
        Schema _x = _copy();
        _x.changedFields = changedFields.add("baseType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.schema");
        _x.baseType = baseType;
        return _x;
    }

    @com.github.davidmoten.odata.client.annotation.Property(name="properties")
    @JsonIgnore
    public CollectionPage<Property> getProperties() {
        return new CollectionPage<Property>(contextPath, Property.class, this.properties, Optional.ofNullable(propertiesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public Schema withProperties(List<Property> properties) {
        Schema _x = _copy();
        _x.changedFields = changedFields.add("properties");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.schema");
        _x.properties = properties;
        return _x;
    }

    @com.github.davidmoten.odata.client.annotation.Property(name="properties")
    @JsonIgnore
    public CollectionPage<Property> getProperties(HttpRequestOptions options) {
        return new CollectionPage<Property>(contextPath, Property.class, this.properties, Optional.ofNullable(propertiesNextLink), Collections.emptyList(), options);
    }

    public Schema withUnmappedField(String name, Object value) {
        Schema _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Schema patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Schema _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Schema put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Schema _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Schema _copy() {
        Schema _x = new Schema();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.baseType = baseType;
        _x.properties = properties;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Schema[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("baseType=");
        b.append(this.baseType);
        b.append(", ");
        b.append("properties=");
        b.append(this.properties);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
