package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.ExternalDomainNameCollectionRequest;
import odata.msgraph.client.beta.enums.AuthenticationProtocol;

@JsonPropertyOrder({
    "@odata.type", 
    "domains"})
@JsonInclude(Include.NON_NULL)
public class SamlOrWsFedExternalDomainFederation extends SamlOrWsFedProvider implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.samlOrWsFedExternalDomainFederation";
    }

    @JsonProperty("domains")
    protected List<ExternalDomainName> domains;

    protected SamlOrWsFedExternalDomainFederation() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSamlOrWsFedExternalDomainFederation() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String issuerUri;
        private String metadataExchangeUri;
        private String passiveSignInUri;
        private AuthenticationProtocol preferredAuthenticationProtocol;
        private String signingCertificate;
        private List<ExternalDomainName> domains;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder issuerUri(String issuerUri) {
            this.issuerUri = issuerUri;
            this.changedFields = changedFields.add("issuerUri");
            return this;
        }

        public Builder metadataExchangeUri(String metadataExchangeUri) {
            this.metadataExchangeUri = metadataExchangeUri;
            this.changedFields = changedFields.add("metadataExchangeUri");
            return this;
        }

        public Builder passiveSignInUri(String passiveSignInUri) {
            this.passiveSignInUri = passiveSignInUri;
            this.changedFields = changedFields.add("passiveSignInUri");
            return this;
        }

        public Builder preferredAuthenticationProtocol(AuthenticationProtocol preferredAuthenticationProtocol) {
            this.preferredAuthenticationProtocol = preferredAuthenticationProtocol;
            this.changedFields = changedFields.add("preferredAuthenticationProtocol");
            return this;
        }

        public Builder signingCertificate(String signingCertificate) {
            this.signingCertificate = signingCertificate;
            this.changedFields = changedFields.add("signingCertificate");
            return this;
        }

        public Builder domains(List<ExternalDomainName> domains) {
            this.domains = domains;
            this.changedFields = changedFields.add("domains");
            return this;
        }

        public Builder domains(ExternalDomainName... domains) {
            return domains(Arrays.asList(domains));
        }

        public SamlOrWsFedExternalDomainFederation build() {
            SamlOrWsFedExternalDomainFederation _x = new SamlOrWsFedExternalDomainFederation();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.samlOrWsFedExternalDomainFederation";
            _x.id = id;
            _x.displayName = displayName;
            _x.issuerUri = issuerUri;
            _x.metadataExchangeUri = metadataExchangeUri;
            _x.passiveSignInUri = passiveSignInUri;
            _x.preferredAuthenticationProtocol = preferredAuthenticationProtocol;
            _x.signingCertificate = signingCertificate;
            _x.domains = domains;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public SamlOrWsFedExternalDomainFederation withUnmappedField(String name, Object value) {
        SamlOrWsFedExternalDomainFederation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="domains")
    @JsonIgnore
    public ExternalDomainNameCollectionRequest getDomains() {
        return new ExternalDomainNameCollectionRequest(
                        contextPath.addSegment("domains"), Optional.ofNullable(domains));
    }

    public SamlOrWsFedExternalDomainFederation withDomains(List<ExternalDomainName> domains) {
        SamlOrWsFedExternalDomainFederation _x = _copy();
        _x.changedFields = changedFields.add("domains");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.samlOrWsFedExternalDomainFederation");
        _x.domains = domains;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SamlOrWsFedExternalDomainFederation patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SamlOrWsFedExternalDomainFederation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SamlOrWsFedExternalDomainFederation put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SamlOrWsFedExternalDomainFederation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SamlOrWsFedExternalDomainFederation _copy() {
        SamlOrWsFedExternalDomainFederation _x = new SamlOrWsFedExternalDomainFederation();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.issuerUri = issuerUri;
        _x.metadataExchangeUri = metadataExchangeUri;
        _x.passiveSignInUri = passiveSignInUri;
        _x.preferredAuthenticationProtocol = preferredAuthenticationProtocol;
        _x.signingCertificate = signingCertificate;
        _x.domains = domains;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SamlOrWsFedExternalDomainFederation[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("issuerUri=");
        b.append(this.issuerUri);
        b.append(", ");
        b.append("metadataExchangeUri=");
        b.append(this.metadataExchangeUri);
        b.append(", ");
        b.append("passiveSignInUri=");
        b.append(this.passiveSignInUri);
        b.append(", ");
        b.append("preferredAuthenticationProtocol=");
        b.append(this.preferredAuthenticationProtocol);
        b.append(", ");
        b.append("signingCertificate=");
        b.append(this.signingCertificate);
        b.append(", ");
        b.append("domains=");
        b.append(this.domains);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
