package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

import odata.msgraph.client.beta.complex.PostalAddressType;
import odata.msgraph.client.beta.entity.collection.request.SalesOrderLineCollectionRequest;
import odata.msgraph.client.beta.entity.request.CurrencyRequest;
import odata.msgraph.client.beta.entity.request.CustomerRequest;
import odata.msgraph.client.beta.entity.request.PaymentTermRequest;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
 * <p>
 * Deletable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
 * <p>
 * Insertable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
 * <p>
 * Updatable = true
 */@JsonPropertyOrder({
    "@odata.type", 
    "billingPostalAddress", 
    "billToCustomerId", 
    "billToCustomerNumber", 
    "billToName", 
    "currencyCode", 
    "currencyId", 
    "customerId", 
    "customerName", 
    "customerNumber", 
    "discountAmount", 
    "discountAppliedBeforeTax", 
    "email", 
    "externalDocumentNumber", 
    "fullyShipped", 
    "lastModifiedDateTime", 
    "number", 
    "orderDate", 
    "partialShipping", 
    "paymentTermsId", 
    "phoneNumber", 
    "pricesIncludeTax", 
    "requestedDeliveryDate", 
    "salesperson", 
    "sellingPostalAddress", 
    "shippingPostalAddress", 
    "shipToContact", 
    "shipToName", 
    "status", 
    "totalAmountExcludingTax", 
    "totalAmountIncludingTax", 
    "totalTaxAmount", 
    "currency", 
    "customer", 
    "paymentTerm", 
    "salesOrderLines"})
@JsonInclude(Include.NON_NULL)
public class SalesOrder extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.salesOrder";
    }

    @JsonProperty("billingPostalAddress")
    protected PostalAddressType billingPostalAddress;

    @JsonProperty("billToCustomerId")
    protected UUID billToCustomerId;

    @JsonProperty("billToCustomerNumber")
    protected String billToCustomerNumber;

    @JsonProperty("billToName")
    protected String billToName;

    @JsonProperty("currencyCode")
    protected String currencyCode;

    @JsonProperty("currencyId")
    protected UUID currencyId;

    @JsonProperty("customerId")
    protected UUID customerId;

    @JsonProperty("customerName")
    protected String customerName;

    @JsonProperty("customerNumber")
    protected String customerNumber;

    @JsonProperty("discountAmount")
    protected BigDecimal discountAmount;

    @JsonProperty("discountAppliedBeforeTax")
    protected Boolean discountAppliedBeforeTax;

    @JsonProperty("email")
    protected String email;

    @JsonProperty("externalDocumentNumber")
    protected String externalDocumentNumber;

    @JsonProperty("fullyShipped")
    protected Boolean fullyShipped;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("number")
    protected String number;

    @JsonProperty("orderDate")
    protected LocalDate orderDate;

    @JsonProperty("partialShipping")
    protected Boolean partialShipping;

    @JsonProperty("paymentTermsId")
    protected UUID paymentTermsId;

    @JsonProperty("phoneNumber")
    protected String phoneNumber;

    @JsonProperty("pricesIncludeTax")
    protected Boolean pricesIncludeTax;

    @JsonProperty("requestedDeliveryDate")
    protected LocalDate requestedDeliveryDate;

    @JsonProperty("salesperson")
    protected String salesperson;

    @JsonProperty("sellingPostalAddress")
    protected PostalAddressType sellingPostalAddress;

    @JsonProperty("shippingPostalAddress")
    protected PostalAddressType shippingPostalAddress;

    @JsonProperty("shipToContact")
    protected String shipToContact;

    @JsonProperty("shipToName")
    protected String shipToName;

    @JsonProperty("status")
    protected String status;

    @JsonProperty("totalAmountExcludingTax")
    protected BigDecimal totalAmountExcludingTax;

    @JsonProperty("totalAmountIncludingTax")
    protected BigDecimal totalAmountIncludingTax;

    @JsonProperty("totalTaxAmount")
    protected BigDecimal totalTaxAmount;

    @JsonProperty("currency")
    protected Currency currency;

    @JsonProperty("customer")
    protected Customer customer;

    @JsonProperty("paymentTerm")
    protected PaymentTerm paymentTerm;

    @JsonProperty("salesOrderLines")
    protected List<SalesOrderLine> salesOrderLines;

    protected SalesOrder() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSalesOrder() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private PostalAddressType billingPostalAddress;
        private UUID billToCustomerId;
        private String billToCustomerNumber;
        private String billToName;
        private String currencyCode;
        private UUID currencyId;
        private UUID customerId;
        private String customerName;
        private String customerNumber;
        private BigDecimal discountAmount;
        private Boolean discountAppliedBeforeTax;
        private String email;
        private String externalDocumentNumber;
        private Boolean fullyShipped;
        private OffsetDateTime lastModifiedDateTime;
        private String number;
        private LocalDate orderDate;
        private Boolean partialShipping;
        private UUID paymentTermsId;
        private String phoneNumber;
        private Boolean pricesIncludeTax;
        private LocalDate requestedDeliveryDate;
        private String salesperson;
        private PostalAddressType sellingPostalAddress;
        private PostalAddressType shippingPostalAddress;
        private String shipToContact;
        private String shipToName;
        private String status;
        private BigDecimal totalAmountExcludingTax;
        private BigDecimal totalAmountIncludingTax;
        private BigDecimal totalTaxAmount;
        private Currency currency;
        private Customer customer;
        private PaymentTerm paymentTerm;
        private List<SalesOrderLine> salesOrderLines;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder billingPostalAddress(PostalAddressType billingPostalAddress) {
            this.billingPostalAddress = billingPostalAddress;
            this.changedFields = changedFields.add("billingPostalAddress");
            return this;
        }

        public Builder billToCustomerId(UUID billToCustomerId) {
            this.billToCustomerId = billToCustomerId;
            this.changedFields = changedFields.add("billToCustomerId");
            return this;
        }

        public Builder billToCustomerNumber(String billToCustomerNumber) {
            this.billToCustomerNumber = billToCustomerNumber;
            this.changedFields = changedFields.add("billToCustomerNumber");
            return this;
        }

        public Builder billToName(String billToName) {
            this.billToName = billToName;
            this.changedFields = changedFields.add("billToName");
            return this;
        }

        public Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            this.changedFields = changedFields.add("currencyCode");
            return this;
        }

        public Builder currencyId(UUID currencyId) {
            this.currencyId = currencyId;
            this.changedFields = changedFields.add("currencyId");
            return this;
        }

        public Builder customerId(UUID customerId) {
            this.customerId = customerId;
            this.changedFields = changedFields.add("customerId");
            return this;
        }

        public Builder customerName(String customerName) {
            this.customerName = customerName;
            this.changedFields = changedFields.add("customerName");
            return this;
        }

        public Builder customerNumber(String customerNumber) {
            this.customerNumber = customerNumber;
            this.changedFields = changedFields.add("customerNumber");
            return this;
        }

        public Builder discountAmount(BigDecimal discountAmount) {
            this.discountAmount = discountAmount;
            this.changedFields = changedFields.add("discountAmount");
            return this;
        }

        public Builder discountAppliedBeforeTax(Boolean discountAppliedBeforeTax) {
            this.discountAppliedBeforeTax = discountAppliedBeforeTax;
            this.changedFields = changedFields.add("discountAppliedBeforeTax");
            return this;
        }

        public Builder email(String email) {
            this.email = email;
            this.changedFields = changedFields.add("email");
            return this;
        }

        public Builder externalDocumentNumber(String externalDocumentNumber) {
            this.externalDocumentNumber = externalDocumentNumber;
            this.changedFields = changedFields.add("externalDocumentNumber");
            return this;
        }

        public Builder fullyShipped(Boolean fullyShipped) {
            this.fullyShipped = fullyShipped;
            this.changedFields = changedFields.add("fullyShipped");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder number(String number) {
            this.number = number;
            this.changedFields = changedFields.add("number");
            return this;
        }

        public Builder orderDate(LocalDate orderDate) {
            this.orderDate = orderDate;
            this.changedFields = changedFields.add("orderDate");
            return this;
        }

        public Builder partialShipping(Boolean partialShipping) {
            this.partialShipping = partialShipping;
            this.changedFields = changedFields.add("partialShipping");
            return this;
        }

        public Builder paymentTermsId(UUID paymentTermsId) {
            this.paymentTermsId = paymentTermsId;
            this.changedFields = changedFields.add("paymentTermsId");
            return this;
        }

        public Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            this.changedFields = changedFields.add("phoneNumber");
            return this;
        }

        public Builder pricesIncludeTax(Boolean pricesIncludeTax) {
            this.pricesIncludeTax = pricesIncludeTax;
            this.changedFields = changedFields.add("pricesIncludeTax");
            return this;
        }

        public Builder requestedDeliveryDate(LocalDate requestedDeliveryDate) {
            this.requestedDeliveryDate = requestedDeliveryDate;
            this.changedFields = changedFields.add("requestedDeliveryDate");
            return this;
        }

        public Builder salesperson(String salesperson) {
            this.salesperson = salesperson;
            this.changedFields = changedFields.add("salesperson");
            return this;
        }

        public Builder sellingPostalAddress(PostalAddressType sellingPostalAddress) {
            this.sellingPostalAddress = sellingPostalAddress;
            this.changedFields = changedFields.add("sellingPostalAddress");
            return this;
        }

        public Builder shippingPostalAddress(PostalAddressType shippingPostalAddress) {
            this.shippingPostalAddress = shippingPostalAddress;
            this.changedFields = changedFields.add("shippingPostalAddress");
            return this;
        }

        public Builder shipToContact(String shipToContact) {
            this.shipToContact = shipToContact;
            this.changedFields = changedFields.add("shipToContact");
            return this;
        }

        public Builder shipToName(String shipToName) {
            this.shipToName = shipToName;
            this.changedFields = changedFields.add("shipToName");
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder totalAmountExcludingTax(BigDecimal totalAmountExcludingTax) {
            this.totalAmountExcludingTax = totalAmountExcludingTax;
            this.changedFields = changedFields.add("totalAmountExcludingTax");
            return this;
        }

        public Builder totalAmountIncludingTax(BigDecimal totalAmountIncludingTax) {
            this.totalAmountIncludingTax = totalAmountIncludingTax;
            this.changedFields = changedFields.add("totalAmountIncludingTax");
            return this;
        }

        public Builder totalTaxAmount(BigDecimal totalTaxAmount) {
            this.totalTaxAmount = totalTaxAmount;
            this.changedFields = changedFields.add("totalTaxAmount");
            return this;
        }

        public Builder currency(Currency currency) {
            this.currency = currency;
            this.changedFields = changedFields.add("currency");
            return this;
        }

        public Builder customer(Customer customer) {
            this.customer = customer;
            this.changedFields = changedFields.add("customer");
            return this;
        }

        public Builder paymentTerm(PaymentTerm paymentTerm) {
            this.paymentTerm = paymentTerm;
            this.changedFields = changedFields.add("paymentTerm");
            return this;
        }

        public Builder salesOrderLines(List<SalesOrderLine> salesOrderLines) {
            this.salesOrderLines = salesOrderLines;
            this.changedFields = changedFields.add("salesOrderLines");
            return this;
        }

        public Builder salesOrderLines(SalesOrderLine... salesOrderLines) {
            return salesOrderLines(Arrays.asList(salesOrderLines));
        }

        public SalesOrder build() {
            SalesOrder _x = new SalesOrder();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.salesOrder";
            _x.id = id;
            _x.billingPostalAddress = billingPostalAddress;
            _x.billToCustomerId = billToCustomerId;
            _x.billToCustomerNumber = billToCustomerNumber;
            _x.billToName = billToName;
            _x.currencyCode = currencyCode;
            _x.currencyId = currencyId;
            _x.customerId = customerId;
            _x.customerName = customerName;
            _x.customerNumber = customerNumber;
            _x.discountAmount = discountAmount;
            _x.discountAppliedBeforeTax = discountAppliedBeforeTax;
            _x.email = email;
            _x.externalDocumentNumber = externalDocumentNumber;
            _x.fullyShipped = fullyShipped;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.number = number;
            _x.orderDate = orderDate;
            _x.partialShipping = partialShipping;
            _x.paymentTermsId = paymentTermsId;
            _x.phoneNumber = phoneNumber;
            _x.pricesIncludeTax = pricesIncludeTax;
            _x.requestedDeliveryDate = requestedDeliveryDate;
            _x.salesperson = salesperson;
            _x.sellingPostalAddress = sellingPostalAddress;
            _x.shippingPostalAddress = shippingPostalAddress;
            _x.shipToContact = shipToContact;
            _x.shipToName = shipToName;
            _x.status = status;
            _x.totalAmountExcludingTax = totalAmountExcludingTax;
            _x.totalAmountIncludingTax = totalAmountIncludingTax;
            _x.totalTaxAmount = totalTaxAmount;
            _x.currency = currency;
            _x.customer = customer;
            _x.paymentTerm = paymentTerm;
            _x.salesOrderLines = salesOrderLines;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="billingPostalAddress")
    @JsonIgnore
    public Optional<PostalAddressType> getBillingPostalAddress() {
        return Optional.ofNullable(billingPostalAddress);
    }

    public SalesOrder withBillingPostalAddress(PostalAddressType billingPostalAddress) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("billingPostalAddress");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.billingPostalAddress = billingPostalAddress;
        return _x;
    }

    @Property(name="billToCustomerId")
    @JsonIgnore
    public Optional<UUID> getBillToCustomerId() {
        return Optional.ofNullable(billToCustomerId);
    }

    public SalesOrder withBillToCustomerId(UUID billToCustomerId) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("billToCustomerId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.billToCustomerId = billToCustomerId;
        return _x;
    }

    @Property(name="billToCustomerNumber")
    @JsonIgnore
    public Optional<String> getBillToCustomerNumber() {
        return Optional.ofNullable(billToCustomerNumber);
    }

    public SalesOrder withBillToCustomerNumber(String billToCustomerNumber) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("billToCustomerNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.billToCustomerNumber = billToCustomerNumber;
        return _x;
    }

    @Property(name="billToName")
    @JsonIgnore
    public Optional<String> getBillToName() {
        return Optional.ofNullable(billToName);
    }

    public SalesOrder withBillToName(String billToName) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("billToName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.billToName = billToName;
        return _x;
    }

    @Property(name="currencyCode")
    @JsonIgnore
    public Optional<String> getCurrencyCode() {
        return Optional.ofNullable(currencyCode);
    }

    public SalesOrder withCurrencyCode(String currencyCode) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("currencyCode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.currencyCode = currencyCode;
        return _x;
    }

    @Property(name="currencyId")
    @JsonIgnore
    public Optional<UUID> getCurrencyId() {
        return Optional.ofNullable(currencyId);
    }

    public SalesOrder withCurrencyId(UUID currencyId) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("currencyId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.currencyId = currencyId;
        return _x;
    }

    @Property(name="customerId")
    @JsonIgnore
    public Optional<UUID> getCustomerId() {
        return Optional.ofNullable(customerId);
    }

    public SalesOrder withCustomerId(UUID customerId) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("customerId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.customerId = customerId;
        return _x;
    }

    @Property(name="customerName")
    @JsonIgnore
    public Optional<String> getCustomerName() {
        return Optional.ofNullable(customerName);
    }

    public SalesOrder withCustomerName(String customerName) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("customerName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.customerName = customerName;
        return _x;
    }

    @Property(name="customerNumber")
    @JsonIgnore
    public Optional<String> getCustomerNumber() {
        return Optional.ofNullable(customerNumber);
    }

    public SalesOrder withCustomerNumber(String customerNumber) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("customerNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.customerNumber = customerNumber;
        return _x;
    }

    @Property(name="discountAmount")
    @JsonIgnore
    public Optional<BigDecimal> getDiscountAmount() {
        return Optional.ofNullable(discountAmount);
    }

    public SalesOrder withDiscountAmount(BigDecimal discountAmount) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("discountAmount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.discountAmount = discountAmount;
        return _x;
    }

    @Property(name="discountAppliedBeforeTax")
    @JsonIgnore
    public Optional<Boolean> getDiscountAppliedBeforeTax() {
        return Optional.ofNullable(discountAppliedBeforeTax);
    }

    public SalesOrder withDiscountAppliedBeforeTax(Boolean discountAppliedBeforeTax) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("discountAppliedBeforeTax");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.discountAppliedBeforeTax = discountAppliedBeforeTax;
        return _x;
    }

    @Property(name="email")
    @JsonIgnore
    public Optional<String> getEmail() {
        return Optional.ofNullable(email);
    }

    public SalesOrder withEmail(String email) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("email");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.email = email;
        return _x;
    }

    @Property(name="externalDocumentNumber")
    @JsonIgnore
    public Optional<String> getExternalDocumentNumber() {
        return Optional.ofNullable(externalDocumentNumber);
    }

    public SalesOrder withExternalDocumentNumber(String externalDocumentNumber) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("externalDocumentNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.externalDocumentNumber = externalDocumentNumber;
        return _x;
    }

    @Property(name="fullyShipped")
    @JsonIgnore
    public Optional<Boolean> getFullyShipped() {
        return Optional.ofNullable(fullyShipped);
    }

    public SalesOrder withFullyShipped(Boolean fullyShipped) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("fullyShipped");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.fullyShipped = fullyShipped;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public SalesOrder withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="number")
    @JsonIgnore
    public Optional<String> getNumber() {
        return Optional.ofNullable(number);
    }

    public SalesOrder withNumber(String number) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("number");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.number = number;
        return _x;
    }

    @Property(name="orderDate")
    @JsonIgnore
    public Optional<LocalDate> getOrderDate() {
        return Optional.ofNullable(orderDate);
    }

    public SalesOrder withOrderDate(LocalDate orderDate) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("orderDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.orderDate = orderDate;
        return _x;
    }

    @Property(name="partialShipping")
    @JsonIgnore
    public Optional<Boolean> getPartialShipping() {
        return Optional.ofNullable(partialShipping);
    }

    public SalesOrder withPartialShipping(Boolean partialShipping) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("partialShipping");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.partialShipping = partialShipping;
        return _x;
    }

    @Property(name="paymentTermsId")
    @JsonIgnore
    public Optional<UUID> getPaymentTermsId() {
        return Optional.ofNullable(paymentTermsId);
    }

    public SalesOrder withPaymentTermsId(UUID paymentTermsId) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("paymentTermsId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.paymentTermsId = paymentTermsId;
        return _x;
    }

    @Property(name="phoneNumber")
    @JsonIgnore
    public Optional<String> getPhoneNumber() {
        return Optional.ofNullable(phoneNumber);
    }

    public SalesOrder withPhoneNumber(String phoneNumber) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("phoneNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.phoneNumber = phoneNumber;
        return _x;
    }

    @Property(name="pricesIncludeTax")
    @JsonIgnore
    public Optional<Boolean> getPricesIncludeTax() {
        return Optional.ofNullable(pricesIncludeTax);
    }

    public SalesOrder withPricesIncludeTax(Boolean pricesIncludeTax) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("pricesIncludeTax");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.pricesIncludeTax = pricesIncludeTax;
        return _x;
    }

    @Property(name="requestedDeliveryDate")
    @JsonIgnore
    public Optional<LocalDate> getRequestedDeliveryDate() {
        return Optional.ofNullable(requestedDeliveryDate);
    }

    public SalesOrder withRequestedDeliveryDate(LocalDate requestedDeliveryDate) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("requestedDeliveryDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.requestedDeliveryDate = requestedDeliveryDate;
        return _x;
    }

    @Property(name="salesperson")
    @JsonIgnore
    public Optional<String> getSalesperson() {
        return Optional.ofNullable(salesperson);
    }

    public SalesOrder withSalesperson(String salesperson) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("salesperson");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.salesperson = salesperson;
        return _x;
    }

    @Property(name="sellingPostalAddress")
    @JsonIgnore
    public Optional<PostalAddressType> getSellingPostalAddress() {
        return Optional.ofNullable(sellingPostalAddress);
    }

    public SalesOrder withSellingPostalAddress(PostalAddressType sellingPostalAddress) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("sellingPostalAddress");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.sellingPostalAddress = sellingPostalAddress;
        return _x;
    }

    @Property(name="shippingPostalAddress")
    @JsonIgnore
    public Optional<PostalAddressType> getShippingPostalAddress() {
        return Optional.ofNullable(shippingPostalAddress);
    }

    public SalesOrder withShippingPostalAddress(PostalAddressType shippingPostalAddress) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("shippingPostalAddress");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.shippingPostalAddress = shippingPostalAddress;
        return _x;
    }

    @Property(name="shipToContact")
    @JsonIgnore
    public Optional<String> getShipToContact() {
        return Optional.ofNullable(shipToContact);
    }

    public SalesOrder withShipToContact(String shipToContact) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("shipToContact");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.shipToContact = shipToContact;
        return _x;
    }

    @Property(name="shipToName")
    @JsonIgnore
    public Optional<String> getShipToName() {
        return Optional.ofNullable(shipToName);
    }

    public SalesOrder withShipToName(String shipToName) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("shipToName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.shipToName = shipToName;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<String> getStatus() {
        return Optional.ofNullable(status);
    }

    public SalesOrder withStatus(String status) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.status = status;
        return _x;
    }

    @Property(name="totalAmountExcludingTax")
    @JsonIgnore
    public Optional<BigDecimal> getTotalAmountExcludingTax() {
        return Optional.ofNullable(totalAmountExcludingTax);
    }

    public SalesOrder withTotalAmountExcludingTax(BigDecimal totalAmountExcludingTax) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("totalAmountExcludingTax");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.totalAmountExcludingTax = totalAmountExcludingTax;
        return _x;
    }

    @Property(name="totalAmountIncludingTax")
    @JsonIgnore
    public Optional<BigDecimal> getTotalAmountIncludingTax() {
        return Optional.ofNullable(totalAmountIncludingTax);
    }

    public SalesOrder withTotalAmountIncludingTax(BigDecimal totalAmountIncludingTax) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("totalAmountIncludingTax");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.totalAmountIncludingTax = totalAmountIncludingTax;
        return _x;
    }

    @Property(name="totalTaxAmount")
    @JsonIgnore
    public Optional<BigDecimal> getTotalTaxAmount() {
        return Optional.ofNullable(totalTaxAmount);
    }

    public SalesOrder withTotalTaxAmount(BigDecimal totalTaxAmount) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("totalTaxAmount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.totalTaxAmount = totalTaxAmount;
        return _x;
    }

    public SalesOrder withUnmappedField(String name, Object value) {
        SalesOrder _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="currency")
    @JsonIgnore
    public CurrencyRequest getCurrency() {
        return new CurrencyRequest(contextPath.addSegment("currency"), Optional.ofNullable(currency));
    }

    @NavigationProperty(name="customer")
    @JsonIgnore
    public CustomerRequest getCustomer() {
        return new CustomerRequest(contextPath.addSegment("customer"), Optional.ofNullable(customer));
    }

    @NavigationProperty(name="paymentTerm")
    @JsonIgnore
    public PaymentTermRequest getPaymentTerm() {
        return new PaymentTermRequest(contextPath.addSegment("paymentTerm"), Optional.ofNullable(paymentTerm));
    }

    @NavigationProperty(name="salesOrderLines")
    @JsonIgnore
    public SalesOrderLineCollectionRequest getSalesOrderLines() {
        return new SalesOrderLineCollectionRequest(
                        contextPath.addSegment("salesOrderLines"), Optional.ofNullable(salesOrderLines));
    }

    public SalesOrder withCurrency(Currency currency) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("currency");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.currency = currency;
        return _x;
    }

    public SalesOrder withCustomer(Customer customer) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("customer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.customer = customer;
        return _x;
    }

    public SalesOrder withPaymentTerm(PaymentTerm paymentTerm) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("paymentTerm");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.paymentTerm = paymentTerm;
        return _x;
    }

    public SalesOrder withSalesOrderLines(List<SalesOrderLine> salesOrderLines) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("salesOrderLines");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.salesOrderLines = salesOrderLines;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SalesOrder patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SalesOrder _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SalesOrder put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SalesOrder _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SalesOrder _copy() {
        SalesOrder _x = new SalesOrder();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.billingPostalAddress = billingPostalAddress;
        _x.billToCustomerId = billToCustomerId;
        _x.billToCustomerNumber = billToCustomerNumber;
        _x.billToName = billToName;
        _x.currencyCode = currencyCode;
        _x.currencyId = currencyId;
        _x.customerId = customerId;
        _x.customerName = customerName;
        _x.customerNumber = customerNumber;
        _x.discountAmount = discountAmount;
        _x.discountAppliedBeforeTax = discountAppliedBeforeTax;
        _x.email = email;
        _x.externalDocumentNumber = externalDocumentNumber;
        _x.fullyShipped = fullyShipped;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.number = number;
        _x.orderDate = orderDate;
        _x.partialShipping = partialShipping;
        _x.paymentTermsId = paymentTermsId;
        _x.phoneNumber = phoneNumber;
        _x.pricesIncludeTax = pricesIncludeTax;
        _x.requestedDeliveryDate = requestedDeliveryDate;
        _x.salesperson = salesperson;
        _x.sellingPostalAddress = sellingPostalAddress;
        _x.shippingPostalAddress = shippingPostalAddress;
        _x.shipToContact = shipToContact;
        _x.shipToName = shipToName;
        _x.status = status;
        _x.totalAmountExcludingTax = totalAmountExcludingTax;
        _x.totalAmountIncludingTax = totalAmountIncludingTax;
        _x.totalTaxAmount = totalTaxAmount;
        _x.currency = currency;
        _x.customer = customer;
        _x.paymentTerm = paymentTerm;
        _x.salesOrderLines = salesOrderLines;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SalesOrder[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("billingPostalAddress=");
        b.append(this.billingPostalAddress);
        b.append(", ");
        b.append("billToCustomerId=");
        b.append(this.billToCustomerId);
        b.append(", ");
        b.append("billToCustomerNumber=");
        b.append(this.billToCustomerNumber);
        b.append(", ");
        b.append("billToName=");
        b.append(this.billToName);
        b.append(", ");
        b.append("currencyCode=");
        b.append(this.currencyCode);
        b.append(", ");
        b.append("currencyId=");
        b.append(this.currencyId);
        b.append(", ");
        b.append("customerId=");
        b.append(this.customerId);
        b.append(", ");
        b.append("customerName=");
        b.append(this.customerName);
        b.append(", ");
        b.append("customerNumber=");
        b.append(this.customerNumber);
        b.append(", ");
        b.append("discountAmount=");
        b.append(this.discountAmount);
        b.append(", ");
        b.append("discountAppliedBeforeTax=");
        b.append(this.discountAppliedBeforeTax);
        b.append(", ");
        b.append("email=");
        b.append(this.email);
        b.append(", ");
        b.append("externalDocumentNumber=");
        b.append(this.externalDocumentNumber);
        b.append(", ");
        b.append("fullyShipped=");
        b.append(this.fullyShipped);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("number=");
        b.append(this.number);
        b.append(", ");
        b.append("orderDate=");
        b.append(this.orderDate);
        b.append(", ");
        b.append("partialShipping=");
        b.append(this.partialShipping);
        b.append(", ");
        b.append("paymentTermsId=");
        b.append(this.paymentTermsId);
        b.append(", ");
        b.append("phoneNumber=");
        b.append(this.phoneNumber);
        b.append(", ");
        b.append("pricesIncludeTax=");
        b.append(this.pricesIncludeTax);
        b.append(", ");
        b.append("requestedDeliveryDate=");
        b.append(this.requestedDeliveryDate);
        b.append(", ");
        b.append("salesperson=");
        b.append(this.salesperson);
        b.append(", ");
        b.append("sellingPostalAddress=");
        b.append(this.sellingPostalAddress);
        b.append(", ");
        b.append("shippingPostalAddress=");
        b.append(this.shippingPostalAddress);
        b.append(", ");
        b.append("shipToContact=");
        b.append(this.shipToContact);
        b.append(", ");
        b.append("shipToName=");
        b.append(this.shipToName);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("totalAmountExcludingTax=");
        b.append(this.totalAmountExcludingTax);
        b.append(", ");
        b.append("totalAmountIncludingTax=");
        b.append(this.totalAmountIncludingTax);
        b.append(", ");
        b.append("totalTaxAmount=");
        b.append(this.totalTaxAmount);
        b.append(", ");
        b.append("currency=");
        b.append(this.currency);
        b.append(", ");
        b.append("customer=");
        b.append(this.customer);
        b.append(", ");
        b.append("paymentTerm=");
        b.append(this.paymentTerm);
        b.append(", ");
        b.append("salesOrderLines=");
        b.append(this.salesOrderLines);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
