package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.OutlookGeoCoordinates;
import odata.msgraph.client.beta.complex.PhysicalAddress;
import odata.msgraph.client.beta.entity.collection.request.RoomCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "emailAddress", 
    "rooms"})
@JsonInclude(Include.NON_NULL)
public class RoomList extends Place implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.roomList";
    }

    @JsonProperty("emailAddress")
    protected String emailAddress;

    @JsonProperty("rooms")
    protected List<Room> rooms;

    protected RoomList() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderRoomList() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private PhysicalAddress address;
        private String displayName;
        private OutlookGeoCoordinates geoCoordinates;
        private String phone;
        private String emailAddress;
        private List<Room> rooms;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder address(PhysicalAddress address) {
            this.address = address;
            this.changedFields = changedFields.add("address");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder geoCoordinates(OutlookGeoCoordinates geoCoordinates) {
            this.geoCoordinates = geoCoordinates;
            this.changedFields = changedFields.add("geoCoordinates");
            return this;
        }

        public Builder phone(String phone) {
            this.phone = phone;
            this.changedFields = changedFields.add("phone");
            return this;
        }

        public Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            this.changedFields = changedFields.add("emailAddress");
            return this;
        }

        public Builder rooms(List<Room> rooms) {
            this.rooms = rooms;
            this.changedFields = changedFields.add("rooms");
            return this;
        }

        public Builder rooms(Room... rooms) {
            return rooms(Arrays.asList(rooms));
        }

        public RoomList build() {
            RoomList _x = new RoomList();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.roomList";
            _x.id = id;
            _x.address = address;
            _x.displayName = displayName;
            _x.geoCoordinates = geoCoordinates;
            _x.phone = phone;
            _x.emailAddress = emailAddress;
            _x.rooms = rooms;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="emailAddress")
    @JsonIgnore
    public Optional<String> getEmailAddress() {
        return Optional.ofNullable(emailAddress);
    }

    public RoomList withEmailAddress(String emailAddress) {
        RoomList _x = _copy();
        _x.changedFields = changedFields.add("emailAddress");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.roomList");
        _x.emailAddress = emailAddress;
        return _x;
    }

    public RoomList withUnmappedField(String name, Object value) {
        RoomList _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="rooms")
    @JsonIgnore
    public RoomCollectionRequest getRooms() {
        return new RoomCollectionRequest(
                        contextPath.addSegment("rooms"), Optional.ofNullable(rooms));
    }

    public RoomList withRooms(List<Room> rooms) {
        RoomList _x = _copy();
        _x.changedFields = changedFields.add("rooms");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.roomList");
        _x.rooms = rooms;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public RoomList patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        RoomList _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public RoomList put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        RoomList _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private RoomList _copy() {
        RoomList _x = new RoomList();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.address = address;
        _x.displayName = displayName;
        _x.geoCoordinates = geoCoordinates;
        _x.phone = phone;
        _x.emailAddress = emailAddress;
        _x.rooms = rooms;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RoomList[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("address=");
        b.append(this.address);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("geoCoordinates=");
        b.append(this.geoCoordinates);
        b.append(", ");
        b.append("phone=");
        b.append(this.phone);
        b.append(", ");
        b.append("emailAddress=");
        b.append(this.emailAddress);
        b.append(", ");
        b.append("rooms=");
        b.append(this.rooms);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
