package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.OutlookGeoCoordinates;
import odata.msgraph.client.beta.complex.PhysicalAddress;
import odata.msgraph.client.beta.enums.BookingType;

@JsonPropertyOrder({
    "@odata.type", 
    "audioDeviceName", 
    "bookingType", 
    "building", 
    "capacity", 
    "displayDeviceName", 
    "emailAddress", 
    "floorLabel", 
    "floorNumber", 
    "isWheelChairAccessible", 
    "label", 
    "nickname", 
    "tags", 
    "videoDeviceName"})
@JsonInclude(Include.NON_NULL)
public class Room extends Place implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.room";
    }

    @JsonProperty("audioDeviceName")
    protected String audioDeviceName;

    @JsonProperty("bookingType")
    protected BookingType bookingType;

    @JsonProperty("building")
    protected String building;

    @JsonProperty("capacity")
    protected Integer capacity;

    @JsonProperty("displayDeviceName")
    protected String displayDeviceName;

    @JsonProperty("emailAddress")
    protected String emailAddress;

    @JsonProperty("floorLabel")
    protected String floorLabel;

    @JsonProperty("floorNumber")
    protected Integer floorNumber;

    @JsonProperty("isWheelChairAccessible")
    protected Boolean isWheelChairAccessible;

    @JsonProperty("label")
    protected String label;

    @JsonProperty("nickname")
    protected String nickname;

    @JsonProperty("tags")
    protected List<String> tags;

    @JsonProperty("tags@nextLink")
    protected String tagsNextLink;

    @JsonProperty("videoDeviceName")
    protected String videoDeviceName;

    protected Room() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderRoom() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private PhysicalAddress address;
        private String displayName;
        private OutlookGeoCoordinates geoCoordinates;
        private String phone;
        private String audioDeviceName;
        private BookingType bookingType;
        private String building;
        private Integer capacity;
        private String displayDeviceName;
        private String emailAddress;
        private String floorLabel;
        private Integer floorNumber;
        private Boolean isWheelChairAccessible;
        private String label;
        private String nickname;
        private List<String> tags;
        private String tagsNextLink;
        private String videoDeviceName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder address(PhysicalAddress address) {
            this.address = address;
            this.changedFields = changedFields.add("address");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder geoCoordinates(OutlookGeoCoordinates geoCoordinates) {
            this.geoCoordinates = geoCoordinates;
            this.changedFields = changedFields.add("geoCoordinates");
            return this;
        }

        public Builder phone(String phone) {
            this.phone = phone;
            this.changedFields = changedFields.add("phone");
            return this;
        }

        public Builder audioDeviceName(String audioDeviceName) {
            this.audioDeviceName = audioDeviceName;
            this.changedFields = changedFields.add("audioDeviceName");
            return this;
        }

        public Builder bookingType(BookingType bookingType) {
            this.bookingType = bookingType;
            this.changedFields = changedFields.add("bookingType");
            return this;
        }

        public Builder building(String building) {
            this.building = building;
            this.changedFields = changedFields.add("building");
            return this;
        }

        public Builder capacity(Integer capacity) {
            this.capacity = capacity;
            this.changedFields = changedFields.add("capacity");
            return this;
        }

        public Builder displayDeviceName(String displayDeviceName) {
            this.displayDeviceName = displayDeviceName;
            this.changedFields = changedFields.add("displayDeviceName");
            return this;
        }

        public Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            this.changedFields = changedFields.add("emailAddress");
            return this;
        }

        public Builder floorLabel(String floorLabel) {
            this.floorLabel = floorLabel;
            this.changedFields = changedFields.add("floorLabel");
            return this;
        }

        public Builder floorNumber(Integer floorNumber) {
            this.floorNumber = floorNumber;
            this.changedFields = changedFields.add("floorNumber");
            return this;
        }

        public Builder isWheelChairAccessible(Boolean isWheelChairAccessible) {
            this.isWheelChairAccessible = isWheelChairAccessible;
            this.changedFields = changedFields.add("isWheelChairAccessible");
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            this.changedFields = changedFields.add("label");
            return this;
        }

        public Builder nickname(String nickname) {
            this.nickname = nickname;
            this.changedFields = changedFields.add("nickname");
            return this;
        }

        public Builder tags(List<String> tags) {
            this.tags = tags;
            this.changedFields = changedFields.add("tags");
            return this;
        }

        public Builder tags(String... tags) {
            return tags(Arrays.asList(tags));
        }

        public Builder tagsNextLink(String tagsNextLink) {
            this.tagsNextLink = tagsNextLink;
            this.changedFields = changedFields.add("tags");
            return this;
        }

        public Builder videoDeviceName(String videoDeviceName) {
            this.videoDeviceName = videoDeviceName;
            this.changedFields = changedFields.add("videoDeviceName");
            return this;
        }

        public Room build() {
            Room _x = new Room();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.room";
            _x.id = id;
            _x.address = address;
            _x.displayName = displayName;
            _x.geoCoordinates = geoCoordinates;
            _x.phone = phone;
            _x.audioDeviceName = audioDeviceName;
            _x.bookingType = bookingType;
            _x.building = building;
            _x.capacity = capacity;
            _x.displayDeviceName = displayDeviceName;
            _x.emailAddress = emailAddress;
            _x.floorLabel = floorLabel;
            _x.floorNumber = floorNumber;
            _x.isWheelChairAccessible = isWheelChairAccessible;
            _x.label = label;
            _x.nickname = nickname;
            _x.tags = tags;
            _x.tagsNextLink = tagsNextLink;
            _x.videoDeviceName = videoDeviceName;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="audioDeviceName")
    @JsonIgnore
    public Optional<String> getAudioDeviceName() {
        return Optional.ofNullable(audioDeviceName);
    }

    public Room withAudioDeviceName(String audioDeviceName) {
        Room _x = _copy();
        _x.changedFields = changedFields.add("audioDeviceName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.room");
        _x.audioDeviceName = audioDeviceName;
        return _x;
    }

    @Property(name="bookingType")
    @JsonIgnore
    public Optional<BookingType> getBookingType() {
        return Optional.ofNullable(bookingType);
    }

    public Room withBookingType(BookingType bookingType) {
        Room _x = _copy();
        _x.changedFields = changedFields.add("bookingType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.room");
        _x.bookingType = bookingType;
        return _x;
    }

    @Property(name="building")
    @JsonIgnore
    public Optional<String> getBuilding() {
        return Optional.ofNullable(building);
    }

    public Room withBuilding(String building) {
        Room _x = _copy();
        _x.changedFields = changedFields.add("building");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.room");
        _x.building = building;
        return _x;
    }

    @Property(name="capacity")
    @JsonIgnore
    public Optional<Integer> getCapacity() {
        return Optional.ofNullable(capacity);
    }

    public Room withCapacity(Integer capacity) {
        Room _x = _copy();
        _x.changedFields = changedFields.add("capacity");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.room");
        _x.capacity = capacity;
        return _x;
    }

    @Property(name="displayDeviceName")
    @JsonIgnore
    public Optional<String> getDisplayDeviceName() {
        return Optional.ofNullable(displayDeviceName);
    }

    public Room withDisplayDeviceName(String displayDeviceName) {
        Room _x = _copy();
        _x.changedFields = changedFields.add("displayDeviceName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.room");
        _x.displayDeviceName = displayDeviceName;
        return _x;
    }

    @Property(name="emailAddress")
    @JsonIgnore
    public Optional<String> getEmailAddress() {
        return Optional.ofNullable(emailAddress);
    }

    public Room withEmailAddress(String emailAddress) {
        Room _x = _copy();
        _x.changedFields = changedFields.add("emailAddress");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.room");
        _x.emailAddress = emailAddress;
        return _x;
    }

    @Property(name="floorLabel")
    @JsonIgnore
    public Optional<String> getFloorLabel() {
        return Optional.ofNullable(floorLabel);
    }

    public Room withFloorLabel(String floorLabel) {
        Room _x = _copy();
        _x.changedFields = changedFields.add("floorLabel");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.room");
        _x.floorLabel = floorLabel;
        return _x;
    }

    @Property(name="floorNumber")
    @JsonIgnore
    public Optional<Integer> getFloorNumber() {
        return Optional.ofNullable(floorNumber);
    }

    public Room withFloorNumber(Integer floorNumber) {
        Room _x = _copy();
        _x.changedFields = changedFields.add("floorNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.room");
        _x.floorNumber = floorNumber;
        return _x;
    }

    @Property(name="isWheelChairAccessible")
    @JsonIgnore
    public Optional<Boolean> getIsWheelChairAccessible() {
        return Optional.ofNullable(isWheelChairAccessible);
    }

    public Room withIsWheelChairAccessible(Boolean isWheelChairAccessible) {
        Room _x = _copy();
        _x.changedFields = changedFields.add("isWheelChairAccessible");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.room");
        _x.isWheelChairAccessible = isWheelChairAccessible;
        return _x;
    }

    @Property(name="label")
    @JsonIgnore
    public Optional<String> getLabel() {
        return Optional.ofNullable(label);
    }

    public Room withLabel(String label) {
        Room _x = _copy();
        _x.changedFields = changedFields.add("label");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.room");
        _x.label = label;
        return _x;
    }

    @Property(name="nickname")
    @JsonIgnore
    public Optional<String> getNickname() {
        return Optional.ofNullable(nickname);
    }

    public Room withNickname(String nickname) {
        Room _x = _copy();
        _x.changedFields = changedFields.add("nickname");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.room");
        _x.nickname = nickname;
        return _x;
    }

    @Property(name="tags")
    @JsonIgnore
    public CollectionPage<String> getTags() {
        return new CollectionPage<String>(contextPath, String.class, this.tags, Optional.ofNullable(tagsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public Room withTags(List<String> tags) {
        Room _x = _copy();
        _x.changedFields = changedFields.add("tags");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.room");
        _x.tags = tags;
        return _x;
    }

    @Property(name="tags")
    @JsonIgnore
    public CollectionPage<String> getTags(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.tags, Optional.ofNullable(tagsNextLink), Collections.emptyList(), options);
    }

    @Property(name="videoDeviceName")
    @JsonIgnore
    public Optional<String> getVideoDeviceName() {
        return Optional.ofNullable(videoDeviceName);
    }

    public Room withVideoDeviceName(String videoDeviceName) {
        Room _x = _copy();
        _x.changedFields = changedFields.add("videoDeviceName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.room");
        _x.videoDeviceName = videoDeviceName;
        return _x;
    }

    public Room withUnmappedField(String name, Object value) {
        Room _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Room patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Room _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Room put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Room _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Room _copy() {
        Room _x = new Room();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.address = address;
        _x.displayName = displayName;
        _x.geoCoordinates = geoCoordinates;
        _x.phone = phone;
        _x.audioDeviceName = audioDeviceName;
        _x.bookingType = bookingType;
        _x.building = building;
        _x.capacity = capacity;
        _x.displayDeviceName = displayDeviceName;
        _x.emailAddress = emailAddress;
        _x.floorLabel = floorLabel;
        _x.floorNumber = floorNumber;
        _x.isWheelChairAccessible = isWheelChairAccessible;
        _x.label = label;
        _x.nickname = nickname;
        _x.tags = tags;
        _x.videoDeviceName = videoDeviceName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Room[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("address=");
        b.append(this.address);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("geoCoordinates=");
        b.append(this.geoCoordinates);
        b.append(", ");
        b.append("phone=");
        b.append(this.phone);
        b.append(", ");
        b.append("audioDeviceName=");
        b.append(this.audioDeviceName);
        b.append(", ");
        b.append("bookingType=");
        b.append(this.bookingType);
        b.append(", ");
        b.append("building=");
        b.append(this.building);
        b.append(", ");
        b.append("capacity=");
        b.append(this.capacity);
        b.append(", ");
        b.append("displayDeviceName=");
        b.append(this.displayDeviceName);
        b.append(", ");
        b.append("emailAddress=");
        b.append(this.emailAddress);
        b.append(", ");
        b.append("floorLabel=");
        b.append(this.floorLabel);
        b.append(", ");
        b.append("floorNumber=");
        b.append(this.floorNumber);
        b.append(", ");
        b.append("isWheelChairAccessible=");
        b.append(this.isWheelChairAccessible);
        b.append(", ");
        b.append("label=");
        b.append(this.label);
        b.append(", ");
        b.append("nickname=");
        b.append(this.nickname);
        b.append(", ");
        b.append("tags=");
        b.append(this.tags);
        b.append(", ");
        b.append("videoDeviceName=");
        b.append(this.videoDeviceName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
