package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.RiskUserActivity;
import odata.msgraph.client.beta.enums.RiskDetail;
import odata.msgraph.client.beta.enums.RiskLevel;
import odata.msgraph.client.beta.enums.RiskState;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
 * <p>
 * Filterable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.SelectRestrictions</b>
 * <p>
 * Selectable = true
 */@JsonPropertyOrder({
    "@odata.type", 
    "activity", 
    "initiatedBy", 
    "userId"})
@JsonInclude(Include.NON_NULL)
public class RiskyUserHistoryItem extends RiskyUser implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.riskyUserHistoryItem";
    }

    @JsonProperty("activity")
    protected RiskUserActivity activity;

    @JsonProperty("initiatedBy")
    protected String initiatedBy;

    @JsonProperty("userId")
    protected String userId;

    protected RiskyUserHistoryItem() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderRiskyUserHistoryItem() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Boolean isDeleted;
        private Boolean isProcessing;
        private RiskDetail riskDetail;
        private OffsetDateTime riskLastUpdatedDateTime;
        private RiskLevel riskLevel;
        private RiskState riskState;
        private String userDisplayName;
        private String userPrincipalName;
        private List<RiskyUserHistoryItem> history;
        private RiskUserActivity activity;
        private String initiatedBy;
        private String userId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder isDeleted(Boolean isDeleted) {
            this.isDeleted = isDeleted;
            this.changedFields = changedFields.add("isDeleted");
            return this;
        }

        public Builder isProcessing(Boolean isProcessing) {
            this.isProcessing = isProcessing;
            this.changedFields = changedFields.add("isProcessing");
            return this;
        }

        public Builder riskDetail(RiskDetail riskDetail) {
            this.riskDetail = riskDetail;
            this.changedFields = changedFields.add("riskDetail");
            return this;
        }

        public Builder riskLastUpdatedDateTime(OffsetDateTime riskLastUpdatedDateTime) {
            this.riskLastUpdatedDateTime = riskLastUpdatedDateTime;
            this.changedFields = changedFields.add("riskLastUpdatedDateTime");
            return this;
        }

        public Builder riskLevel(RiskLevel riskLevel) {
            this.riskLevel = riskLevel;
            this.changedFields = changedFields.add("riskLevel");
            return this;
        }

        public Builder riskState(RiskState riskState) {
            this.riskState = riskState;
            this.changedFields = changedFields.add("riskState");
            return this;
        }

        public Builder userDisplayName(String userDisplayName) {
            this.userDisplayName = userDisplayName;
            this.changedFields = changedFields.add("userDisplayName");
            return this;
        }

        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public Builder history(List<RiskyUserHistoryItem> history) {
            this.history = history;
            this.changedFields = changedFields.add("history");
            return this;
        }

        public Builder history(RiskyUserHistoryItem... history) {
            return history(Arrays.asList(history));
        }

        public Builder activity(RiskUserActivity activity) {
            this.activity = activity;
            this.changedFields = changedFields.add("activity");
            return this;
        }

        public Builder initiatedBy(String initiatedBy) {
            this.initiatedBy = initiatedBy;
            this.changedFields = changedFields.add("initiatedBy");
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            this.changedFields = changedFields.add("userId");
            return this;
        }

        public RiskyUserHistoryItem build() {
            RiskyUserHistoryItem _x = new RiskyUserHistoryItem();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.riskyUserHistoryItem";
            _x.id = id;
            _x.isDeleted = isDeleted;
            _x.isProcessing = isProcessing;
            _x.riskDetail = riskDetail;
            _x.riskLastUpdatedDateTime = riskLastUpdatedDateTime;
            _x.riskLevel = riskLevel;
            _x.riskState = riskState;
            _x.userDisplayName = userDisplayName;
            _x.userPrincipalName = userPrincipalName;
            _x.history = history;
            _x.activity = activity;
            _x.initiatedBy = initiatedBy;
            _x.userId = userId;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="activity")
    @JsonIgnore
    public Optional<RiskUserActivity> getActivity() {
        return Optional.ofNullable(activity);
    }

    public RiskyUserHistoryItem withActivity(RiskUserActivity activity) {
        RiskyUserHistoryItem _x = _copy();
        _x.changedFields = changedFields.add("activity");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.riskyUserHistoryItem");
        _x.activity = activity;
        return _x;
    }

    @Property(name="initiatedBy")
    @JsonIgnore
    public Optional<String> getInitiatedBy() {
        return Optional.ofNullable(initiatedBy);
    }

    public RiskyUserHistoryItem withInitiatedBy(String initiatedBy) {
        RiskyUserHistoryItem _x = _copy();
        _x.changedFields = changedFields.add("initiatedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.riskyUserHistoryItem");
        _x.initiatedBy = initiatedBy;
        return _x;
    }

    @Property(name="userId")
    @JsonIgnore
    public Optional<String> getUserId() {
        return Optional.ofNullable(userId);
    }

    public RiskyUserHistoryItem withUserId(String userId) {
        RiskyUserHistoryItem _x = _copy();
        _x.changedFields = changedFields.add("userId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.riskyUserHistoryItem");
        _x.userId = userId;
        return _x;
    }

    public RiskyUserHistoryItem withUnmappedField(String name, Object value) {
        RiskyUserHistoryItem _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public RiskyUserHistoryItem patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        RiskyUserHistoryItem _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public RiskyUserHistoryItem put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        RiskyUserHistoryItem _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private RiskyUserHistoryItem _copy() {
        RiskyUserHistoryItem _x = new RiskyUserHistoryItem();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.isDeleted = isDeleted;
        _x.isProcessing = isProcessing;
        _x.riskDetail = riskDetail;
        _x.riskLastUpdatedDateTime = riskLastUpdatedDateTime;
        _x.riskLevel = riskLevel;
        _x.riskState = riskState;
        _x.userDisplayName = userDisplayName;
        _x.userPrincipalName = userPrincipalName;
        _x.history = history;
        _x.activity = activity;
        _x.initiatedBy = initiatedBy;
        _x.userId = userId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RiskyUserHistoryItem[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("isDeleted=");
        b.append(this.isDeleted);
        b.append(", ");
        b.append("isProcessing=");
        b.append(this.isProcessing);
        b.append(", ");
        b.append("riskDetail=");
        b.append(this.riskDetail);
        b.append(", ");
        b.append("riskLastUpdatedDateTime=");
        b.append(this.riskLastUpdatedDateTime);
        b.append(", ");
        b.append("riskLevel=");
        b.append(this.riskLevel);
        b.append(", ");
        b.append("riskState=");
        b.append(this.riskState);
        b.append(", ");
        b.append("userDisplayName=");
        b.append(this.userDisplayName);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append(", ");
        b.append("history=");
        b.append(this.history);
        b.append(", ");
        b.append("activity=");
        b.append(this.activity);
        b.append(", ");
        b.append("initiatedBy=");
        b.append(this.initiatedBy);
        b.append(", ");
        b.append("userId=");
        b.append(this.userId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
