package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.RiskyServicePrincipalHistoryItemCollectionRequest;
import odata.msgraph.client.beta.enums.RiskDetail;
import odata.msgraph.client.beta.enums.RiskLevel;
import odata.msgraph.client.beta.enums.RiskState;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.CountRestrictions</b>
 * <p>
 * Countable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
 * <p>
 * Filterable = true
 */@JsonPropertyOrder({
    "@odata.type", 
    "accountEnabled", 
    "appId", 
    "displayName", 
    "isProcessing", 
    "riskDetail", 
    "riskLastUpdatedDateTime", 
    "riskLevel", 
    "riskState", 
    "servicePrincipalType", 
    "history"})
@JsonInclude(Include.NON_NULL)
public class RiskyServicePrincipal extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.riskyServicePrincipal";
    }

    @JsonProperty("accountEnabled")
    protected Boolean accountEnabled;

    @JsonProperty("appId")
    protected String appId;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("isProcessing")
    protected Boolean isProcessing;

    @JsonProperty("riskDetail")
    protected RiskDetail riskDetail;

    @JsonProperty("riskLastUpdatedDateTime")
    protected OffsetDateTime riskLastUpdatedDateTime;

    @JsonProperty("riskLevel")
    protected RiskLevel riskLevel;

    @JsonProperty("riskState")
    protected RiskState riskState;

    @JsonProperty("servicePrincipalType")
    protected String servicePrincipalType;

    @JsonProperty("history")
    protected List<RiskyServicePrincipalHistoryItem> history;

    protected RiskyServicePrincipal() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderRiskyServicePrincipal() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Boolean accountEnabled;
        private String appId;
        private String displayName;
        private Boolean isProcessing;
        private RiskDetail riskDetail;
        private OffsetDateTime riskLastUpdatedDateTime;
        private RiskLevel riskLevel;
        private RiskState riskState;
        private String servicePrincipalType;
        private List<RiskyServicePrincipalHistoryItem> history;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder accountEnabled(Boolean accountEnabled) {
            this.accountEnabled = accountEnabled;
            this.changedFields = changedFields.add("accountEnabled");
            return this;
        }

        public Builder appId(String appId) {
            this.appId = appId;
            this.changedFields = changedFields.add("appId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder isProcessing(Boolean isProcessing) {
            this.isProcessing = isProcessing;
            this.changedFields = changedFields.add("isProcessing");
            return this;
        }

        public Builder riskDetail(RiskDetail riskDetail) {
            this.riskDetail = riskDetail;
            this.changedFields = changedFields.add("riskDetail");
            return this;
        }

        public Builder riskLastUpdatedDateTime(OffsetDateTime riskLastUpdatedDateTime) {
            this.riskLastUpdatedDateTime = riskLastUpdatedDateTime;
            this.changedFields = changedFields.add("riskLastUpdatedDateTime");
            return this;
        }

        public Builder riskLevel(RiskLevel riskLevel) {
            this.riskLevel = riskLevel;
            this.changedFields = changedFields.add("riskLevel");
            return this;
        }

        public Builder riskState(RiskState riskState) {
            this.riskState = riskState;
            this.changedFields = changedFields.add("riskState");
            return this;
        }

        public Builder servicePrincipalType(String servicePrincipalType) {
            this.servicePrincipalType = servicePrincipalType;
            this.changedFields = changedFields.add("servicePrincipalType");
            return this;
        }

        public Builder history(List<RiskyServicePrincipalHistoryItem> history) {
            this.history = history;
            this.changedFields = changedFields.add("history");
            return this;
        }

        public Builder history(RiskyServicePrincipalHistoryItem... history) {
            return history(Arrays.asList(history));
        }

        public RiskyServicePrincipal build() {
            RiskyServicePrincipal _x = new RiskyServicePrincipal();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.riskyServicePrincipal";
            _x.id = id;
            _x.accountEnabled = accountEnabled;
            _x.appId = appId;
            _x.displayName = displayName;
            _x.isProcessing = isProcessing;
            _x.riskDetail = riskDetail;
            _x.riskLastUpdatedDateTime = riskLastUpdatedDateTime;
            _x.riskLevel = riskLevel;
            _x.riskState = riskState;
            _x.servicePrincipalType = servicePrincipalType;
            _x.history = history;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="accountEnabled")
    @JsonIgnore
    public Optional<Boolean> getAccountEnabled() {
        return Optional.ofNullable(accountEnabled);
    }

    public RiskyServicePrincipal withAccountEnabled(Boolean accountEnabled) {
        RiskyServicePrincipal _x = _copy();
        _x.changedFields = changedFields.add("accountEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.riskyServicePrincipal");
        _x.accountEnabled = accountEnabled;
        return _x;
    }

    @Property(name="appId")
    @JsonIgnore
    public Optional<String> getAppId() {
        return Optional.ofNullable(appId);
    }

    public RiskyServicePrincipal withAppId(String appId) {
        RiskyServicePrincipal _x = _copy();
        _x.changedFields = changedFields.add("appId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.riskyServicePrincipal");
        _x.appId = appId;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public RiskyServicePrincipal withDisplayName(String displayName) {
        RiskyServicePrincipal _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.riskyServicePrincipal");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="isProcessing")
    @JsonIgnore
    public Optional<Boolean> getIsProcessing() {
        return Optional.ofNullable(isProcessing);
    }

    public RiskyServicePrincipal withIsProcessing(Boolean isProcessing) {
        RiskyServicePrincipal _x = _copy();
        _x.changedFields = changedFields.add("isProcessing");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.riskyServicePrincipal");
        _x.isProcessing = isProcessing;
        return _x;
    }

    @Property(name="riskDetail")
    @JsonIgnore
    public Optional<RiskDetail> getRiskDetail() {
        return Optional.ofNullable(riskDetail);
    }

    public RiskyServicePrincipal withRiskDetail(RiskDetail riskDetail) {
        RiskyServicePrincipal _x = _copy();
        _x.changedFields = changedFields.add("riskDetail");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.riskyServicePrincipal");
        _x.riskDetail = riskDetail;
        return _x;
    }

    @Property(name="riskLastUpdatedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getRiskLastUpdatedDateTime() {
        return Optional.ofNullable(riskLastUpdatedDateTime);
    }

    public RiskyServicePrincipal withRiskLastUpdatedDateTime(OffsetDateTime riskLastUpdatedDateTime) {
        RiskyServicePrincipal _x = _copy();
        _x.changedFields = changedFields.add("riskLastUpdatedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.riskyServicePrincipal");
        _x.riskLastUpdatedDateTime = riskLastUpdatedDateTime;
        return _x;
    }

    @Property(name="riskLevel")
    @JsonIgnore
    public Optional<RiskLevel> getRiskLevel() {
        return Optional.ofNullable(riskLevel);
    }

    public RiskyServicePrincipal withRiskLevel(RiskLevel riskLevel) {
        RiskyServicePrincipal _x = _copy();
        _x.changedFields = changedFields.add("riskLevel");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.riskyServicePrincipal");
        _x.riskLevel = riskLevel;
        return _x;
    }

    @Property(name="riskState")
    @JsonIgnore
    public Optional<RiskState> getRiskState() {
        return Optional.ofNullable(riskState);
    }

    public RiskyServicePrincipal withRiskState(RiskState riskState) {
        RiskyServicePrincipal _x = _copy();
        _x.changedFields = changedFields.add("riskState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.riskyServicePrincipal");
        _x.riskState = riskState;
        return _x;
    }

    @Property(name="servicePrincipalType")
    @JsonIgnore
    public Optional<String> getServicePrincipalType() {
        return Optional.ofNullable(servicePrincipalType);
    }

    public RiskyServicePrincipal withServicePrincipalType(String servicePrincipalType) {
        RiskyServicePrincipal _x = _copy();
        _x.changedFields = changedFields.add("servicePrincipalType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.riskyServicePrincipal");
        _x.servicePrincipalType = servicePrincipalType;
        return _x;
    }

    public RiskyServicePrincipal withUnmappedField(String name, Object value) {
        RiskyServicePrincipal _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="history")
    @JsonIgnore
    public RiskyServicePrincipalHistoryItemCollectionRequest getHistory() {
        return new RiskyServicePrincipalHistoryItemCollectionRequest(
                        contextPath.addSegment("history"), Optional.ofNullable(history));
    }

    public RiskyServicePrincipal withHistory(List<RiskyServicePrincipalHistoryItem> history) {
        RiskyServicePrincipal _x = _copy();
        _x.changedFields = changedFields.add("history");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.riskyServicePrincipal");
        _x.history = history;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public RiskyServicePrincipal patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        RiskyServicePrincipal _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public RiskyServicePrincipal put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        RiskyServicePrincipal _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private RiskyServicePrincipal _copy() {
        RiskyServicePrincipal _x = new RiskyServicePrincipal();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.accountEnabled = accountEnabled;
        _x.appId = appId;
        _x.displayName = displayName;
        _x.isProcessing = isProcessing;
        _x.riskDetail = riskDetail;
        _x.riskLastUpdatedDateTime = riskLastUpdatedDateTime;
        _x.riskLevel = riskLevel;
        _x.riskState = riskState;
        _x.servicePrincipalType = servicePrincipalType;
        _x.history = history;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RiskyServicePrincipal[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("accountEnabled=");
        b.append(this.accountEnabled);
        b.append(", ");
        b.append("appId=");
        b.append(this.appId);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("isProcessing=");
        b.append(this.isProcessing);
        b.append(", ");
        b.append("riskDetail=");
        b.append(this.riskDetail);
        b.append(", ");
        b.append("riskLastUpdatedDateTime=");
        b.append(this.riskLastUpdatedDateTime);
        b.append(", ");
        b.append("riskLevel=");
        b.append(this.riskLevel);
        b.append(", ");
        b.append("riskState=");
        b.append(this.riskState);
        b.append(", ");
        b.append("servicePrincipalType=");
        b.append(this.servicePrincipalType);
        b.append(", ");
        b.append("history=");
        b.append(this.history);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
