package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.FunctionRequestReturningStream;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ArchivedPrintJob;
import odata.msgraph.client.beta.complex.AttackSimulationRepeatOffender;
import odata.msgraph.client.beta.complex.AttackSimulationSimulationUserCoverage;
import odata.msgraph.client.beta.complex.AttackSimulationTrainingUserCoverage;
import odata.msgraph.client.beta.complex.Report;
import odata.msgraph.client.beta.entity.collection.request.ApplicationSignInDetailedSummaryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CredentialUserRegistrationDetailsCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PrintUsageByPrinterCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PrintUsageByUserCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserCredentialUsageDetailsCollectionRequest;
import odata.msgraph.client.beta.entity.request.AuthenticationMethodsRootRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "applicationSignInDetailedSummary", 
    "authenticationMethods", 
    "credentialUserRegistrationDetails", 
    "userCredentialUsageDetails", 
    "dailyPrintUsageByPrinter", 
    "dailyPrintUsageByUser", 
    "dailyPrintUsageSummariesByPrinter", 
    "dailyPrintUsageSummariesByUser", 
    "monthlyPrintUsageByPrinter", 
    "monthlyPrintUsageByUser", 
    "monthlyPrintUsageSummariesByPrinter", 
    "monthlyPrintUsageSummariesByUser"})
@JsonInclude(Include.NON_NULL)
public class ReportRoot extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.reportRoot";
    }

    @JsonProperty("applicationSignInDetailedSummary")
    protected List<ApplicationSignInDetailedSummary> applicationSignInDetailedSummary;

    @JsonProperty("authenticationMethods")
    protected AuthenticationMethodsRoot authenticationMethods;

    @JsonProperty("credentialUserRegistrationDetails")
    protected List<CredentialUserRegistrationDetails> credentialUserRegistrationDetails;

    @JsonProperty("userCredentialUsageDetails")
    protected List<UserCredentialUsageDetails> userCredentialUsageDetails;

    @JsonProperty("dailyPrintUsageByPrinter")
    protected List<PrintUsageByPrinter> dailyPrintUsageByPrinter;

    @JsonProperty("dailyPrintUsageByUser")
    protected List<PrintUsageByUser> dailyPrintUsageByUser;

    @JsonProperty("dailyPrintUsageSummariesByPrinter")
    protected List<PrintUsageByPrinter> dailyPrintUsageSummariesByPrinter;

    @JsonProperty("dailyPrintUsageSummariesByUser")
    protected List<PrintUsageByUser> dailyPrintUsageSummariesByUser;

    @JsonProperty("monthlyPrintUsageByPrinter")
    protected List<PrintUsageByPrinter> monthlyPrintUsageByPrinter;

    @JsonProperty("monthlyPrintUsageByUser")
    protected List<PrintUsageByUser> monthlyPrintUsageByUser;

    @JsonProperty("monthlyPrintUsageSummariesByPrinter")
    protected List<PrintUsageByPrinter> monthlyPrintUsageSummariesByPrinter;

    @JsonProperty("monthlyPrintUsageSummariesByUser")
    protected List<PrintUsageByUser> monthlyPrintUsageSummariesByUser;

    protected ReportRoot() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderReportRoot() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<ApplicationSignInDetailedSummary> applicationSignInDetailedSummary;
        private AuthenticationMethodsRoot authenticationMethods;
        private List<CredentialUserRegistrationDetails> credentialUserRegistrationDetails;
        private List<UserCredentialUsageDetails> userCredentialUsageDetails;
        private List<PrintUsageByPrinter> dailyPrintUsageByPrinter;
        private List<PrintUsageByUser> dailyPrintUsageByUser;
        private List<PrintUsageByPrinter> dailyPrintUsageSummariesByPrinter;
        private List<PrintUsageByUser> dailyPrintUsageSummariesByUser;
        private List<PrintUsageByPrinter> monthlyPrintUsageByPrinter;
        private List<PrintUsageByUser> monthlyPrintUsageByUser;
        private List<PrintUsageByPrinter> monthlyPrintUsageSummariesByPrinter;
        private List<PrintUsageByUser> monthlyPrintUsageSummariesByUser;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder applicationSignInDetailedSummary(List<ApplicationSignInDetailedSummary> applicationSignInDetailedSummary) {
            this.applicationSignInDetailedSummary = applicationSignInDetailedSummary;
            this.changedFields = changedFields.add("applicationSignInDetailedSummary");
            return this;
        }

        public Builder applicationSignInDetailedSummary(ApplicationSignInDetailedSummary... applicationSignInDetailedSummary) {
            return applicationSignInDetailedSummary(Arrays.asList(applicationSignInDetailedSummary));
        }

        public Builder authenticationMethods(AuthenticationMethodsRoot authenticationMethods) {
            this.authenticationMethods = authenticationMethods;
            this.changedFields = changedFields.add("authenticationMethods");
            return this;
        }

        public Builder credentialUserRegistrationDetails(List<CredentialUserRegistrationDetails> credentialUserRegistrationDetails) {
            this.credentialUserRegistrationDetails = credentialUserRegistrationDetails;
            this.changedFields = changedFields.add("credentialUserRegistrationDetails");
            return this;
        }

        public Builder credentialUserRegistrationDetails(CredentialUserRegistrationDetails... credentialUserRegistrationDetails) {
            return credentialUserRegistrationDetails(Arrays.asList(credentialUserRegistrationDetails));
        }

        public Builder userCredentialUsageDetails(List<UserCredentialUsageDetails> userCredentialUsageDetails) {
            this.userCredentialUsageDetails = userCredentialUsageDetails;
            this.changedFields = changedFields.add("userCredentialUsageDetails");
            return this;
        }

        public Builder userCredentialUsageDetails(UserCredentialUsageDetails... userCredentialUsageDetails) {
            return userCredentialUsageDetails(Arrays.asList(userCredentialUsageDetails));
        }

        public Builder dailyPrintUsageByPrinter(List<PrintUsageByPrinter> dailyPrintUsageByPrinter) {
            this.dailyPrintUsageByPrinter = dailyPrintUsageByPrinter;
            this.changedFields = changedFields.add("dailyPrintUsageByPrinter");
            return this;
        }

        public Builder dailyPrintUsageByPrinter(PrintUsageByPrinter... dailyPrintUsageByPrinter) {
            return dailyPrintUsageByPrinter(Arrays.asList(dailyPrintUsageByPrinter));
        }

        public Builder dailyPrintUsageByUser(List<PrintUsageByUser> dailyPrintUsageByUser) {
            this.dailyPrintUsageByUser = dailyPrintUsageByUser;
            this.changedFields = changedFields.add("dailyPrintUsageByUser");
            return this;
        }

        public Builder dailyPrintUsageByUser(PrintUsageByUser... dailyPrintUsageByUser) {
            return dailyPrintUsageByUser(Arrays.asList(dailyPrintUsageByUser));
        }

        public Builder dailyPrintUsageSummariesByPrinter(List<PrintUsageByPrinter> dailyPrintUsageSummariesByPrinter) {
            this.dailyPrintUsageSummariesByPrinter = dailyPrintUsageSummariesByPrinter;
            this.changedFields = changedFields.add("dailyPrintUsageSummariesByPrinter");
            return this;
        }

        public Builder dailyPrintUsageSummariesByPrinter(PrintUsageByPrinter... dailyPrintUsageSummariesByPrinter) {
            return dailyPrintUsageSummariesByPrinter(Arrays.asList(dailyPrintUsageSummariesByPrinter));
        }

        public Builder dailyPrintUsageSummariesByUser(List<PrintUsageByUser> dailyPrintUsageSummariesByUser) {
            this.dailyPrintUsageSummariesByUser = dailyPrintUsageSummariesByUser;
            this.changedFields = changedFields.add("dailyPrintUsageSummariesByUser");
            return this;
        }

        public Builder dailyPrintUsageSummariesByUser(PrintUsageByUser... dailyPrintUsageSummariesByUser) {
            return dailyPrintUsageSummariesByUser(Arrays.asList(dailyPrintUsageSummariesByUser));
        }

        public Builder monthlyPrintUsageByPrinter(List<PrintUsageByPrinter> monthlyPrintUsageByPrinter) {
            this.monthlyPrintUsageByPrinter = monthlyPrintUsageByPrinter;
            this.changedFields = changedFields.add("monthlyPrintUsageByPrinter");
            return this;
        }

        public Builder monthlyPrintUsageByPrinter(PrintUsageByPrinter... monthlyPrintUsageByPrinter) {
            return monthlyPrintUsageByPrinter(Arrays.asList(monthlyPrintUsageByPrinter));
        }

        public Builder monthlyPrintUsageByUser(List<PrintUsageByUser> monthlyPrintUsageByUser) {
            this.monthlyPrintUsageByUser = monthlyPrintUsageByUser;
            this.changedFields = changedFields.add("monthlyPrintUsageByUser");
            return this;
        }

        public Builder monthlyPrintUsageByUser(PrintUsageByUser... monthlyPrintUsageByUser) {
            return monthlyPrintUsageByUser(Arrays.asList(monthlyPrintUsageByUser));
        }

        public Builder monthlyPrintUsageSummariesByPrinter(List<PrintUsageByPrinter> monthlyPrintUsageSummariesByPrinter) {
            this.monthlyPrintUsageSummariesByPrinter = monthlyPrintUsageSummariesByPrinter;
            this.changedFields = changedFields.add("monthlyPrintUsageSummariesByPrinter");
            return this;
        }

        public Builder monthlyPrintUsageSummariesByPrinter(PrintUsageByPrinter... monthlyPrintUsageSummariesByPrinter) {
            return monthlyPrintUsageSummariesByPrinter(Arrays.asList(monthlyPrintUsageSummariesByPrinter));
        }

        public Builder monthlyPrintUsageSummariesByUser(List<PrintUsageByUser> monthlyPrintUsageSummariesByUser) {
            this.monthlyPrintUsageSummariesByUser = monthlyPrintUsageSummariesByUser;
            this.changedFields = changedFields.add("monthlyPrintUsageSummariesByUser");
            return this;
        }

        public Builder monthlyPrintUsageSummariesByUser(PrintUsageByUser... monthlyPrintUsageSummariesByUser) {
            return monthlyPrintUsageSummariesByUser(Arrays.asList(monthlyPrintUsageSummariesByUser));
        }

        public ReportRoot build() {
            ReportRoot _x = new ReportRoot();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.reportRoot";
            _x.id = id;
            _x.applicationSignInDetailedSummary = applicationSignInDetailedSummary;
            _x.authenticationMethods = authenticationMethods;
            _x.credentialUserRegistrationDetails = credentialUserRegistrationDetails;
            _x.userCredentialUsageDetails = userCredentialUsageDetails;
            _x.dailyPrintUsageByPrinter = dailyPrintUsageByPrinter;
            _x.dailyPrintUsageByUser = dailyPrintUsageByUser;
            _x.dailyPrintUsageSummariesByPrinter = dailyPrintUsageSummariesByPrinter;
            _x.dailyPrintUsageSummariesByUser = dailyPrintUsageSummariesByUser;
            _x.monthlyPrintUsageByPrinter = monthlyPrintUsageByPrinter;
            _x.monthlyPrintUsageByUser = monthlyPrintUsageByUser;
            _x.monthlyPrintUsageSummariesByPrinter = monthlyPrintUsageSummariesByPrinter;
            _x.monthlyPrintUsageSummariesByUser = monthlyPrintUsageSummariesByUser;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public ReportRoot withUnmappedField(String name, Object value) {
        ReportRoot _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="applicationSignInDetailedSummary")
    @JsonIgnore
    public ApplicationSignInDetailedSummaryCollectionRequest getApplicationSignInDetailedSummary() {
        return new ApplicationSignInDetailedSummaryCollectionRequest(
                        contextPath.addSegment("applicationSignInDetailedSummary"), Optional.ofNullable(applicationSignInDetailedSummary));
    }

    @NavigationProperty(name="authenticationMethods")
    @JsonIgnore
    public AuthenticationMethodsRootRequest getAuthenticationMethods() {
        return new AuthenticationMethodsRootRequest(contextPath.addSegment("authenticationMethods"), Optional.ofNullable(authenticationMethods));
    }

    @NavigationProperty(name="credentialUserRegistrationDetails")
    @JsonIgnore
    public CredentialUserRegistrationDetailsCollectionRequest getCredentialUserRegistrationDetails() {
        return new CredentialUserRegistrationDetailsCollectionRequest(
                        contextPath.addSegment("credentialUserRegistrationDetails"), Optional.ofNullable(credentialUserRegistrationDetails));
    }

    @NavigationProperty(name="userCredentialUsageDetails")
    @JsonIgnore
    public UserCredentialUsageDetailsCollectionRequest getUserCredentialUsageDetails() {
        return new UserCredentialUsageDetailsCollectionRequest(
                        contextPath.addSegment("userCredentialUsageDetails"), Optional.ofNullable(userCredentialUsageDetails));
    }

    @NavigationProperty(name="dailyPrintUsageByPrinter")
    @JsonIgnore
    public PrintUsageByPrinterCollectionRequest getDailyPrintUsageByPrinter() {
        return new PrintUsageByPrinterCollectionRequest(
                        contextPath.addSegment("dailyPrintUsageByPrinter"), Optional.ofNullable(dailyPrintUsageByPrinter));
    }

    @NavigationProperty(name="dailyPrintUsageByUser")
    @JsonIgnore
    public PrintUsageByUserCollectionRequest getDailyPrintUsageByUser() {
        return new PrintUsageByUserCollectionRequest(
                        contextPath.addSegment("dailyPrintUsageByUser"), Optional.ofNullable(dailyPrintUsageByUser));
    }

    @NavigationProperty(name="dailyPrintUsageSummariesByPrinter")
    @JsonIgnore
    public PrintUsageByPrinterCollectionRequest getDailyPrintUsageSummariesByPrinter() {
        return new PrintUsageByPrinterCollectionRequest(
                        contextPath.addSegment("dailyPrintUsageSummariesByPrinter"), Optional.ofNullable(dailyPrintUsageSummariesByPrinter));
    }

    @NavigationProperty(name="dailyPrintUsageSummariesByUser")
    @JsonIgnore
    public PrintUsageByUserCollectionRequest getDailyPrintUsageSummariesByUser() {
        return new PrintUsageByUserCollectionRequest(
                        contextPath.addSegment("dailyPrintUsageSummariesByUser"), Optional.ofNullable(dailyPrintUsageSummariesByUser));
    }

    @NavigationProperty(name="monthlyPrintUsageByPrinter")
    @JsonIgnore
    public PrintUsageByPrinterCollectionRequest getMonthlyPrintUsageByPrinter() {
        return new PrintUsageByPrinterCollectionRequest(
                        contextPath.addSegment("monthlyPrintUsageByPrinter"), Optional.ofNullable(monthlyPrintUsageByPrinter));
    }

    @NavigationProperty(name="monthlyPrintUsageByUser")
    @JsonIgnore
    public PrintUsageByUserCollectionRequest getMonthlyPrintUsageByUser() {
        return new PrintUsageByUserCollectionRequest(
                        contextPath.addSegment("monthlyPrintUsageByUser"), Optional.ofNullable(monthlyPrintUsageByUser));
    }

    @NavigationProperty(name="monthlyPrintUsageSummariesByPrinter")
    @JsonIgnore
    public PrintUsageByPrinterCollectionRequest getMonthlyPrintUsageSummariesByPrinter() {
        return new PrintUsageByPrinterCollectionRequest(
                        contextPath.addSegment("monthlyPrintUsageSummariesByPrinter"), Optional.ofNullable(monthlyPrintUsageSummariesByPrinter));
    }

    @NavigationProperty(name="monthlyPrintUsageSummariesByUser")
    @JsonIgnore
    public PrintUsageByUserCollectionRequest getMonthlyPrintUsageSummariesByUser() {
        return new PrintUsageByUserCollectionRequest(
                        contextPath.addSegment("monthlyPrintUsageSummariesByUser"), Optional.ofNullable(monthlyPrintUsageSummariesByUser));
    }

    public ReportRoot withApplicationSignInDetailedSummary(List<ApplicationSignInDetailedSummary> applicationSignInDetailedSummary) {
        ReportRoot _x = _copy();
        _x.changedFields = changedFields.add("applicationSignInDetailedSummary");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.reportRoot");
        _x.applicationSignInDetailedSummary = applicationSignInDetailedSummary;
        return _x;
    }

    public ReportRoot withAuthenticationMethods(AuthenticationMethodsRoot authenticationMethods) {
        ReportRoot _x = _copy();
        _x.changedFields = changedFields.add("authenticationMethods");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.reportRoot");
        _x.authenticationMethods = authenticationMethods;
        return _x;
    }

    public ReportRoot withCredentialUserRegistrationDetails(List<CredentialUserRegistrationDetails> credentialUserRegistrationDetails) {
        ReportRoot _x = _copy();
        _x.changedFields = changedFields.add("credentialUserRegistrationDetails");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.reportRoot");
        _x.credentialUserRegistrationDetails = credentialUserRegistrationDetails;
        return _x;
    }

    public ReportRoot withUserCredentialUsageDetails(List<UserCredentialUsageDetails> userCredentialUsageDetails) {
        ReportRoot _x = _copy();
        _x.changedFields = changedFields.add("userCredentialUsageDetails");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.reportRoot");
        _x.userCredentialUsageDetails = userCredentialUsageDetails;
        return _x;
    }

    public ReportRoot withDailyPrintUsageByPrinter(List<PrintUsageByPrinter> dailyPrintUsageByPrinter) {
        ReportRoot _x = _copy();
        _x.changedFields = changedFields.add("dailyPrintUsageByPrinter");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.reportRoot");
        _x.dailyPrintUsageByPrinter = dailyPrintUsageByPrinter;
        return _x;
    }

    public ReportRoot withDailyPrintUsageByUser(List<PrintUsageByUser> dailyPrintUsageByUser) {
        ReportRoot _x = _copy();
        _x.changedFields = changedFields.add("dailyPrintUsageByUser");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.reportRoot");
        _x.dailyPrintUsageByUser = dailyPrintUsageByUser;
        return _x;
    }

    public ReportRoot withDailyPrintUsageSummariesByPrinter(List<PrintUsageByPrinter> dailyPrintUsageSummariesByPrinter) {
        ReportRoot _x = _copy();
        _x.changedFields = changedFields.add("dailyPrintUsageSummariesByPrinter");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.reportRoot");
        _x.dailyPrintUsageSummariesByPrinter = dailyPrintUsageSummariesByPrinter;
        return _x;
    }

    public ReportRoot withDailyPrintUsageSummariesByUser(List<PrintUsageByUser> dailyPrintUsageSummariesByUser) {
        ReportRoot _x = _copy();
        _x.changedFields = changedFields.add("dailyPrintUsageSummariesByUser");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.reportRoot");
        _x.dailyPrintUsageSummariesByUser = dailyPrintUsageSummariesByUser;
        return _x;
    }

    public ReportRoot withMonthlyPrintUsageByPrinter(List<PrintUsageByPrinter> monthlyPrintUsageByPrinter) {
        ReportRoot _x = _copy();
        _x.changedFields = changedFields.add("monthlyPrintUsageByPrinter");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.reportRoot");
        _x.monthlyPrintUsageByPrinter = monthlyPrintUsageByPrinter;
        return _x;
    }

    public ReportRoot withMonthlyPrintUsageByUser(List<PrintUsageByUser> monthlyPrintUsageByUser) {
        ReportRoot _x = _copy();
        _x.changedFields = changedFields.add("monthlyPrintUsageByUser");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.reportRoot");
        _x.monthlyPrintUsageByUser = monthlyPrintUsageByUser;
        return _x;
    }

    public ReportRoot withMonthlyPrintUsageSummariesByPrinter(List<PrintUsageByPrinter> monthlyPrintUsageSummariesByPrinter) {
        ReportRoot _x = _copy();
        _x.changedFields = changedFields.add("monthlyPrintUsageSummariesByPrinter");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.reportRoot");
        _x.monthlyPrintUsageSummariesByPrinter = monthlyPrintUsageSummariesByPrinter;
        return _x;
    }

    public ReportRoot withMonthlyPrintUsageSummariesByUser(List<PrintUsageByUser> monthlyPrintUsageSummariesByUser) {
        ReportRoot _x = _copy();
        _x.changedFields = changedFields.add("monthlyPrintUsageSummariesByUser");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.reportRoot");
        _x.monthlyPrintUsageSummariesByUser = monthlyPrintUsageSummariesByUser;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ReportRoot patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ReportRoot _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ReportRoot put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ReportRoot _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ReportRoot _copy() {
        ReportRoot _x = new ReportRoot();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.applicationSignInDetailedSummary = applicationSignInDetailedSummary;
        _x.authenticationMethods = authenticationMethods;
        _x.credentialUserRegistrationDetails = credentialUserRegistrationDetails;
        _x.userCredentialUsageDetails = userCredentialUsageDetails;
        _x.dailyPrintUsageByPrinter = dailyPrintUsageByPrinter;
        _x.dailyPrintUsageByUser = dailyPrintUsageByUser;
        _x.dailyPrintUsageSummariesByPrinter = dailyPrintUsageSummariesByPrinter;
        _x.dailyPrintUsageSummariesByUser = dailyPrintUsageSummariesByUser;
        _x.monthlyPrintUsageByPrinter = monthlyPrintUsageByPrinter;
        _x.monthlyPrintUsageByUser = monthlyPrintUsageByUser;
        _x.monthlyPrintUsageSummariesByPrinter = monthlyPrintUsageSummariesByPrinter;
        _x.monthlyPrintUsageSummariesByUser = monthlyPrintUsageSummariesByUser;
        return _x;
    }

    @Function(name = "getAzureADApplicationSignInSummary")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ApplicationSignInSummary> getAzureADApplicationSignInSummary(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getAzureADApplicationSignInSummary"), ApplicationSignInSummary.class, _parameters);
    }

    @Function(name = "getAzureADFeatureUsage")
    @JsonIgnore
    public CollectionPageNonEntityRequest<AzureADFeatureUsage> getAzureADFeatureUsage(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getAzureADFeatureUsage"), AzureADFeatureUsage.class, _parameters);
    }

    @Function(name = "getAzureADLicenseUsage")
    @JsonIgnore
    public CollectionPageNonEntityRequest<AzureADLicenseUsage> getAzureADLicenseUsage(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getAzureADLicenseUsage"), AzureADLicenseUsage.class, _parameters);
    }

    @Function(name = "getAzureADUserFeatureUsage")
    @JsonIgnore
    public CollectionPageNonEntityRequest<AzureADUserFeatureUsage> getAzureADUserFeatureUsage() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getAzureADUserFeatureUsage"), AzureADUserFeatureUsage.class, _parameters);
    }

    @Function(name = "getCredentialUsageSummary")
    @JsonIgnore
    public CollectionPageNonEntityRequest<CredentialUsageSummary> getCredentialUsageSummary(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getCredentialUsageSummary"), CredentialUsageSummary.class, _parameters);
    }

    @Function(name = "getCredentialUserRegistrationCount")
    @JsonIgnore
    public CollectionPageNonEntityRequest<CredentialUserRegistrationCount> getCredentialUserRegistrationCount() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getCredentialUserRegistrationCount"), CredentialUserRegistrationCount.class, _parameters);
    }

    @Function(name = "getRelyingPartyDetailedSummary")
    @JsonIgnore
    public CollectionPageNonEntityRequest<RelyingPartyDetailedSummary> getRelyingPartyDetailedSummary(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getRelyingPartyDetailedSummary"), RelyingPartyDetailedSummary.class, _parameters);
    }

    @Function(name = "deviceConfigurationDeviceActivity")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Report> deviceConfigurationDeviceActivity() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<Report>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.deviceConfigurationDeviceActivity"), Report.class, _parameters);
    }

    @Function(name = "deviceConfigurationUserActivity")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Report> deviceConfigurationUserActivity() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<Report>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.deviceConfigurationUserActivity"), Report.class, _parameters);
    }

    @Function(name = "managedDeviceEnrollmentAbandonmentDetails")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Report> managedDeviceEnrollmentAbandonmentDetails(Integer skip, Integer top, String filter, String skipToken) {
        Preconditions.checkNotNull(skip, "skip cannot be null");
        Preconditions.checkNotNull(top, "top cannot be null");
        Preconditions.checkNotNull(filter, "filter cannot be null");
        Preconditions.checkNotNull(skipToken, "skipToken cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .put("skipToken", "Edm.String", Checks.checkIsAscii(skipToken))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<Report>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.managedDeviceEnrollmentAbandonmentDetails"), Report.class, _parameters);
    }

    @Function(name = "managedDeviceEnrollmentAbandonmentSummary")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Report> managedDeviceEnrollmentAbandonmentSummary(Integer skip, Integer top, String filter, String skipToken) {
        Preconditions.checkNotNull(skip, "skip cannot be null");
        Preconditions.checkNotNull(top, "top cannot be null");
        Preconditions.checkNotNull(filter, "filter cannot be null");
        Preconditions.checkNotNull(skipToken, "skipToken cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .put("skipToken", "Edm.String", Checks.checkIsAscii(skipToken))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<Report>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.managedDeviceEnrollmentAbandonmentSummary"), Report.class, _parameters);
    }

    @Function(name = "managedDeviceEnrollmentFailureDetails")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Report> managedDeviceEnrollmentFailureDetails() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<Report>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.managedDeviceEnrollmentFailureDetails"), Report.class, _parameters);
    }

    @Function(name = "managedDeviceEnrollmentFailureDetails")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Report> managedDeviceEnrollmentFailureDetails_Function(Integer skip, Integer top, String filter, String skipToken) {
        Preconditions.checkNotNull(skip, "skip cannot be null");
        Preconditions.checkNotNull(top, "top cannot be null");
        Preconditions.checkNotNull(filter, "filter cannot be null");
        Preconditions.checkNotNull(skipToken, "skipToken cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .put("skipToken", "Edm.String", Checks.checkIsAscii(skipToken))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<Report>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.managedDeviceEnrollmentFailureDetails"), Report.class, _parameters);
    }

    @Function(name = "managedDeviceEnrollmentFailureTrends")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Report> managedDeviceEnrollmentFailureTrends() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<Report>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.managedDeviceEnrollmentFailureTrends"), Report.class, _parameters);
    }

    @Function(name = "managedDeviceEnrollmentTopFailures")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Report> managedDeviceEnrollmentTopFailures() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<Report>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.managedDeviceEnrollmentTopFailures"), Report.class, _parameters);
    }

    @Function(name = "managedDeviceEnrollmentTopFailures")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Report> managedDeviceEnrollmentTopFailures_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<Report>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.managedDeviceEnrollmentTopFailures"), Report.class, _parameters);
    }

    @Function(name = "getBrowserDistributionUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getBrowserDistributionUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getBrowserDistributionUserCounts"), _parameters);
    }

    @Function(name = "getBrowserUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getBrowserUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getBrowserUserCounts"), _parameters);
    }

    @Function(name = "getBrowserUserDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getBrowserUserDetail(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getBrowserUserDetail"), _parameters);
    }

    @Function(name = "getEmailActivityCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getEmailActivityCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getEmailActivityCounts"), _parameters);
    }

    @Function(name = "getEmailActivityUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getEmailActivityUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getEmailActivityUserCounts"), _parameters);
    }

    @Function(name = "getEmailActivityUserDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getEmailActivityUserDetail(LocalDate date) {
        Preconditions.checkNotNull(date, "date cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "Edm.Date", date)
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getEmailActivityUserDetail"), _parameters);
    }

    @Function(name = "getEmailActivityUserDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getEmailActivityUserDetail_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getEmailActivityUserDetail"), _parameters);
    }

    @Function(name = "getEmailAppUsageAppsUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getEmailAppUsageAppsUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getEmailAppUsageAppsUserCounts"), _parameters);
    }

    @Function(name = "getEmailAppUsageUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getEmailAppUsageUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getEmailAppUsageUserCounts"), _parameters);
    }

    @Function(name = "getEmailAppUsageUserDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getEmailAppUsageUserDetail(LocalDate date) {
        Preconditions.checkNotNull(date, "date cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "Edm.Date", date)
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getEmailAppUsageUserDetail"), _parameters);
    }

    @Function(name = "getEmailAppUsageUserDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getEmailAppUsageUserDetail_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getEmailAppUsageUserDetail"), _parameters);
    }

    @Function(name = "getEmailAppUsageVersionsUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getEmailAppUsageVersionsUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getEmailAppUsageVersionsUserCounts"), _parameters);
    }

    @Function(name = "getM365AppPlatformUserCounts")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Report> getM365AppPlatformUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<Report>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getM365AppPlatformUserCounts"), Report.class, _parameters);
    }

    @Function(name = "getM365AppUserCounts")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Report> getM365AppUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<Report>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getM365AppUserCounts"), Report.class, _parameters);
    }

    @Function(name = "getM365AppUserDetail")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Report> getM365AppUserDetail(LocalDate date) {
        Preconditions.checkNotNull(date, "date cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "Edm.Date", date)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<Report>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getM365AppUserDetail"), Report.class, _parameters);
    }

    @Function(name = "getM365AppUserDetail")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Report> getM365AppUserDetail_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<Report>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getM365AppUserDetail"), Report.class, _parameters);
    }

    @Function(name = "getMailboxUsageDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getMailboxUsageDetail(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getMailboxUsageDetail"), _parameters);
    }

    @Function(name = "getMailboxUsageMailboxCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getMailboxUsageMailboxCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getMailboxUsageMailboxCounts"), _parameters);
    }

    @Function(name = "getMailboxUsageQuotaStatusMailboxCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getMailboxUsageQuotaStatusMailboxCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getMailboxUsageQuotaStatusMailboxCounts"), _parameters);
    }

    @Function(name = "getMailboxUsageStorage")
    @JsonIgnore
    public FunctionRequestReturningStream getMailboxUsageStorage(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getMailboxUsageStorage"), _parameters);
    }

    @Function(name = "getOffice365ActivationCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getOffice365ActivationCounts() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOffice365ActivationCounts"), _parameters);
    }

    @Function(name = "getOffice365ActivationsUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getOffice365ActivationsUserCounts() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOffice365ActivationsUserCounts"), _parameters);
    }

    @Function(name = "getOffice365ActivationsUserDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getOffice365ActivationsUserDetail() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOffice365ActivationsUserDetail"), _parameters);
    }

    @Function(name = "getOffice365ActiveUserCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Office365ActiveUserCounts> getOffice365ActiveUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOffice365ActiveUserCounts"), Office365ActiveUserCounts.class, _parameters);
    }

    @Function(name = "getOffice365ActiveUserDetail")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Office365ActiveUserDetail> getOffice365ActiveUserDetail(LocalDate date) {
        Preconditions.checkNotNull(date, "date cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "Edm.Date", date)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOffice365ActiveUserDetail"), Office365ActiveUserDetail.class, _parameters);
    }

    @Function(name = "getOffice365ActiveUserDetail")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Office365ActiveUserDetail> getOffice365ActiveUserDetail_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOffice365ActiveUserDetail"), Office365ActiveUserDetail.class, _parameters);
    }

    @Function(name = "getOffice365GroupsActivityCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Office365GroupsActivityCounts> getOffice365GroupsActivityCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOffice365GroupsActivityCounts"), Office365GroupsActivityCounts.class, _parameters);
    }

    @Function(name = "getOffice365GroupsActivityDetail")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Office365GroupsActivityDetail> getOffice365GroupsActivityDetail(LocalDate date) {
        Preconditions.checkNotNull(date, "date cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "Edm.Date", date)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOffice365GroupsActivityDetail"), Office365GroupsActivityDetail.class, _parameters);
    }

    @Function(name = "getOffice365GroupsActivityDetail")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Office365GroupsActivityDetail> getOffice365GroupsActivityDetail_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOffice365GroupsActivityDetail"), Office365GroupsActivityDetail.class, _parameters);
    }

    @Function(name = "getOffice365GroupsActivityFileCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Office365GroupsActivityFileCounts> getOffice365GroupsActivityFileCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOffice365GroupsActivityFileCounts"), Office365GroupsActivityFileCounts.class, _parameters);
    }

    @Function(name = "getOffice365GroupsActivityGroupCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Office365GroupsActivityGroupCounts> getOffice365GroupsActivityGroupCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOffice365GroupsActivityGroupCounts"), Office365GroupsActivityGroupCounts.class, _parameters);
    }

    @Function(name = "getOffice365GroupsActivityStorage")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Office365GroupsActivityStorage> getOffice365GroupsActivityStorage(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOffice365GroupsActivityStorage"), Office365GroupsActivityStorage.class, _parameters);
    }

    @Function(name = "getOffice365ServicesUserCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Office365ServicesUserCounts> getOffice365ServicesUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOffice365ServicesUserCounts"), Office365ServicesUserCounts.class, _parameters);
    }

    @Function(name = "getOneDriveActivityFileCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getOneDriveActivityFileCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOneDriveActivityFileCounts"), _parameters);
    }

    @Function(name = "getOneDriveActivityUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getOneDriveActivityUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOneDriveActivityUserCounts"), _parameters);
    }

    @Function(name = "getOneDriveActivityUserDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getOneDriveActivityUserDetail(LocalDate date) {
        Preconditions.checkNotNull(date, "date cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "Edm.Date", date)
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOneDriveActivityUserDetail"), _parameters);
    }

    @Function(name = "getOneDriveActivityUserDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getOneDriveActivityUserDetail_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOneDriveActivityUserDetail"), _parameters);
    }

    @Function(name = "getOneDriveUsageAccountCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getOneDriveUsageAccountCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOneDriveUsageAccountCounts"), _parameters);
    }

    @Function(name = "getOneDriveUsageAccountDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getOneDriveUsageAccountDetail(LocalDate date) {
        Preconditions.checkNotNull(date, "date cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "Edm.Date", date)
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOneDriveUsageAccountDetail"), _parameters);
    }

    @Function(name = "getOneDriveUsageAccountDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getOneDriveUsageAccountDetail_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOneDriveUsageAccountDetail"), _parameters);
    }

    @Function(name = "getOneDriveUsageFileCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getOneDriveUsageFileCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOneDriveUsageFileCounts"), _parameters);
    }

    @Function(name = "getOneDriveUsageStorage")
    @JsonIgnore
    public FunctionRequestReturningStream getOneDriveUsageStorage(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOneDriveUsageStorage"), _parameters);
    }

    @Function(name = "getSharePointActivityFileCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getSharePointActivityFileCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSharePointActivityFileCounts"), _parameters);
    }

    @Function(name = "getSharePointActivityPages")
    @JsonIgnore
    public FunctionRequestReturningStream getSharePointActivityPages(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSharePointActivityPages"), _parameters);
    }

    @Function(name = "getSharePointActivityUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getSharePointActivityUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSharePointActivityUserCounts"), _parameters);
    }

    @Function(name = "getSharePointActivityUserDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getSharePointActivityUserDetail(LocalDate date) {
        Preconditions.checkNotNull(date, "date cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "Edm.Date", date)
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSharePointActivityUserDetail"), _parameters);
    }

    @Function(name = "getSharePointActivityUserDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getSharePointActivityUserDetail_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSharePointActivityUserDetail"), _parameters);
    }

    @Function(name = "getSharePointSiteUsageDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getSharePointSiteUsageDetail(LocalDate date) {
        Preconditions.checkNotNull(date, "date cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "Edm.Date", date)
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSharePointSiteUsageDetail"), _parameters);
    }

    @Function(name = "getSharePointSiteUsageDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getSharePointSiteUsageDetail_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSharePointSiteUsageDetail"), _parameters);
    }

    @Function(name = "getSharePointSiteUsageFileCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getSharePointSiteUsageFileCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSharePointSiteUsageFileCounts"), _parameters);
    }

    @Function(name = "getSharePointSiteUsagePages")
    @JsonIgnore
    public FunctionRequestReturningStream getSharePointSiteUsagePages(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSharePointSiteUsagePages"), _parameters);
    }

    @Function(name = "getSharePointSiteUsageSiteCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getSharePointSiteUsageSiteCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSharePointSiteUsageSiteCounts"), _parameters);
    }

    @Function(name = "getSharePointSiteUsageStorage")
    @JsonIgnore
    public FunctionRequestReturningStream getSharePointSiteUsageStorage(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSharePointSiteUsageStorage"), _parameters);
    }

    @Function(name = "getSkypeForBusinessActivityCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getSkypeForBusinessActivityCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessActivityCounts"), _parameters);
    }

    @Function(name = "getSkypeForBusinessActivityUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getSkypeForBusinessActivityUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessActivityUserCounts"), _parameters);
    }

    @Function(name = "getSkypeForBusinessActivityUserDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getSkypeForBusinessActivityUserDetail(LocalDate date) {
        Preconditions.checkNotNull(date, "date cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "Edm.Date", date)
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessActivityUserDetail"), _parameters);
    }

    @Function(name = "getSkypeForBusinessActivityUserDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getSkypeForBusinessActivityUserDetail_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessActivityUserDetail"), _parameters);
    }

    @Function(name = "getSkypeForBusinessDeviceUsageDistributionUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getSkypeForBusinessDeviceUsageDistributionUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessDeviceUsageDistributionUserCounts"), _parameters);
    }

    @Function(name = "getSkypeForBusinessDeviceUsageUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getSkypeForBusinessDeviceUsageUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessDeviceUsageUserCounts"), _parameters);
    }

    @Function(name = "getSkypeForBusinessDeviceUsageUserDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getSkypeForBusinessDeviceUsageUserDetail(LocalDate date) {
        Preconditions.checkNotNull(date, "date cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "Edm.Date", date)
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessDeviceUsageUserDetail"), _parameters);
    }

    @Function(name = "getSkypeForBusinessDeviceUsageUserDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getSkypeForBusinessDeviceUsageUserDetail_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessDeviceUsageUserDetail"), _parameters);
    }

    @Function(name = "getSkypeForBusinessOrganizerActivityCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getSkypeForBusinessOrganizerActivityCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessOrganizerActivityCounts"), _parameters);
    }

    @Function(name = "getSkypeForBusinessOrganizerActivityMinuteCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getSkypeForBusinessOrganizerActivityMinuteCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessOrganizerActivityMinuteCounts"), _parameters);
    }

    @Function(name = "getSkypeForBusinessOrganizerActivityUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getSkypeForBusinessOrganizerActivityUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessOrganizerActivityUserCounts"), _parameters);
    }

    @Function(name = "getSkypeForBusinessParticipantActivityCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getSkypeForBusinessParticipantActivityCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessParticipantActivityCounts"), _parameters);
    }

    @Function(name = "getSkypeForBusinessParticipantActivityMinuteCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getSkypeForBusinessParticipantActivityMinuteCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessParticipantActivityMinuteCounts"), _parameters);
    }

    @Function(name = "getSkypeForBusinessParticipantActivityUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getSkypeForBusinessParticipantActivityUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessParticipantActivityUserCounts"), _parameters);
    }

    @Function(name = "getSkypeForBusinessPeerToPeerActivityCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getSkypeForBusinessPeerToPeerActivityCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessPeerToPeerActivityCounts"), _parameters);
    }

    @Function(name = "getSkypeForBusinessPeerToPeerActivityMinuteCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getSkypeForBusinessPeerToPeerActivityMinuteCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessPeerToPeerActivityMinuteCounts"), _parameters);
    }

    @Function(name = "getSkypeForBusinessPeerToPeerActivityUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getSkypeForBusinessPeerToPeerActivityUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessPeerToPeerActivityUserCounts"), _parameters);
    }

    @Function(name = "getTeamsDeviceUsageDistributionTotalUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getTeamsDeviceUsageDistributionTotalUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTeamsDeviceUsageDistributionTotalUserCounts"), _parameters);
    }

    @Function(name = "getTeamsDeviceUsageDistributionUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getTeamsDeviceUsageDistributionUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTeamsDeviceUsageDistributionUserCounts"), _parameters);
    }

    @Function(name = "getTeamsDeviceUsageTotalUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getTeamsDeviceUsageTotalUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTeamsDeviceUsageTotalUserCounts"), _parameters);
    }

    @Function(name = "getTeamsDeviceUsageUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getTeamsDeviceUsageUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTeamsDeviceUsageUserCounts"), _parameters);
    }

    @Function(name = "getTeamsDeviceUsageUserDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getTeamsDeviceUsageUserDetail(LocalDate date) {
        Preconditions.checkNotNull(date, "date cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "Edm.Date", date)
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTeamsDeviceUsageUserDetail"), _parameters);
    }

    @Function(name = "getTeamsDeviceUsageUserDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getTeamsDeviceUsageUserDetail_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTeamsDeviceUsageUserDetail"), _parameters);
    }

    @Function(name = "getTeamsTeamActivityCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getTeamsTeamActivityCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTeamsTeamActivityCounts"), _parameters);
    }

    @Function(name = "getTeamsTeamActivityDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getTeamsTeamActivityDetail(LocalDate date) {
        Preconditions.checkNotNull(date, "date cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "Edm.Date", date)
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTeamsTeamActivityDetail"), _parameters);
    }

    @Function(name = "getTeamsTeamActivityDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getTeamsTeamActivityDetail_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTeamsTeamActivityDetail"), _parameters);
    }

    @Function(name = "getTeamsTeamActivityDistributionCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getTeamsTeamActivityDistributionCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTeamsTeamActivityDistributionCounts"), _parameters);
    }

    @Function(name = "getTeamsUserActivityCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getTeamsUserActivityCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTeamsUserActivityCounts"), _parameters);
    }

    @Function(name = "getTeamsUserActivityDistributionTotalUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getTeamsUserActivityDistributionTotalUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTeamsUserActivityDistributionTotalUserCounts"), _parameters);
    }

    @Function(name = "getTeamsUserActivityDistributionUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getTeamsUserActivityDistributionUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTeamsUserActivityDistributionUserCounts"), _parameters);
    }

    @Function(name = "getTeamsUserActivityTotalCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getTeamsUserActivityTotalCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTeamsUserActivityTotalCounts"), _parameters);
    }

    @Function(name = "getTeamsUserActivityTotalDistributionCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getTeamsUserActivityTotalDistributionCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTeamsUserActivityTotalDistributionCounts"), _parameters);
    }

    @Function(name = "getTeamsUserActivityTotalUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getTeamsUserActivityTotalUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTeamsUserActivityTotalUserCounts"), _parameters);
    }

    @Function(name = "getTeamsUserActivityUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getTeamsUserActivityUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTeamsUserActivityUserCounts"), _parameters);
    }

    @Function(name = "getTeamsUserActivityUserDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getTeamsUserActivityUserDetail(LocalDate date) {
        Preconditions.checkNotNull(date, "date cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "Edm.Date", date)
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTeamsUserActivityUserDetail"), _parameters);
    }

    @Function(name = "getTeamsUserActivityUserDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getTeamsUserActivityUserDetail_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTeamsUserActivityUserDetail"), _parameters);
    }

    @Function(name = "getYammerActivityCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getYammerActivityCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getYammerActivityCounts"), _parameters);
    }

    @Function(name = "getYammerActivityUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getYammerActivityUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getYammerActivityUserCounts"), _parameters);
    }

    @Function(name = "getYammerActivityUserDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getYammerActivityUserDetail(LocalDate date) {
        Preconditions.checkNotNull(date, "date cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "Edm.Date", date)
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getYammerActivityUserDetail"), _parameters);
    }

    @Function(name = "getYammerActivityUserDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getYammerActivityUserDetail_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getYammerActivityUserDetail"), _parameters);
    }

    @Function(name = "getYammerDeviceUsageDistributionUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getYammerDeviceUsageDistributionUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getYammerDeviceUsageDistributionUserCounts"), _parameters);
    }

    @Function(name = "getYammerDeviceUsageUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getYammerDeviceUsageUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getYammerDeviceUsageUserCounts"), _parameters);
    }

    @Function(name = "getYammerDeviceUsageUserDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getYammerDeviceUsageUserDetail(LocalDate date) {
        Preconditions.checkNotNull(date, "date cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "Edm.Date", date)
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getYammerDeviceUsageUserDetail"), _parameters);
    }

    @Function(name = "getYammerDeviceUsageUserDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getYammerDeviceUsageUserDetail_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getYammerDeviceUsageUserDetail"), _parameters);
    }

    @Function(name = "getYammerGroupsActivityCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getYammerGroupsActivityCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getYammerGroupsActivityCounts"), _parameters);
    }

    @Function(name = "getYammerGroupsActivityDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getYammerGroupsActivityDetail(LocalDate date) {
        Preconditions.checkNotNull(date, "date cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "Edm.Date", date)
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getYammerGroupsActivityDetail"), _parameters);
    }

    @Function(name = "getYammerGroupsActivityDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getYammerGroupsActivityDetail_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getYammerGroupsActivityDetail"), _parameters);
    }

    @Function(name = "getYammerGroupsActivityGroupCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getYammerGroupsActivityGroupCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getYammerGroupsActivityGroupCounts"), _parameters);
    }

    @Function(name = "getGroupArchivedPrintJobs")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ArchivedPrintJob> getGroupArchivedPrintJobs(String groupId, OffsetDateTime startDateTime, OffsetDateTime endDateTime) {
        Preconditions.checkNotNull(groupId, "groupId cannot be null");
        Preconditions.checkNotNull(startDateTime, "startDateTime cannot be null");
        Preconditions.checkNotNull(endDateTime, "endDateTime cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("groupId", "Edm.String", Checks.checkIsAscii(groupId))
            .put("startDateTime", "Edm.DateTimeOffset", startDateTime)
            .put("endDateTime", "Edm.DateTimeOffset", endDateTime)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getGroupArchivedPrintJobs"), ArchivedPrintJob.class, _parameters);
    }

    @Function(name = "getPrinterArchivedPrintJobs")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ArchivedPrintJob> getPrinterArchivedPrintJobs(String printerId, OffsetDateTime startDateTime, OffsetDateTime endDateTime) {
        Preconditions.checkNotNull(printerId, "printerId cannot be null");
        Preconditions.checkNotNull(startDateTime, "startDateTime cannot be null");
        Preconditions.checkNotNull(endDateTime, "endDateTime cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("printerId", "Edm.String", Checks.checkIsAscii(printerId))
            .put("startDateTime", "Edm.DateTimeOffset", startDateTime)
            .put("endDateTime", "Edm.DateTimeOffset", endDateTime)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getPrinterArchivedPrintJobs"), ArchivedPrintJob.class, _parameters);
    }

    @Function(name = "getUserArchivedPrintJobs")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ArchivedPrintJob> getUserArchivedPrintJobs(String userId, OffsetDateTime startDateTime, OffsetDateTime endDateTime) {
        Preconditions.checkNotNull(userId, "userId cannot be null");
        Preconditions.checkNotNull(startDateTime, "startDateTime cannot be null");
        Preconditions.checkNotNull(endDateTime, "endDateTime cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("userId", "Edm.String", Checks.checkIsAscii(userId))
            .put("startDateTime", "Edm.DateTimeOffset", startDateTime)
            .put("endDateTime", "Edm.DateTimeOffset", endDateTime)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getUserArchivedPrintJobs"), ArchivedPrintJob.class, _parameters);
    }

    @Function(name = "getTenantSecureScores")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Report> getTenantSecureScores(Integer period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.Int32", period)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<Report>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTenantSecureScores"), Report.class, _parameters);
    }

    @Function(name = "getAttackSimulationRepeatOffenders")
    @JsonIgnore
    public CollectionPageNonEntityRequest<AttackSimulationRepeatOffender> getAttackSimulationRepeatOffenders() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getAttackSimulationRepeatOffenders"), AttackSimulationRepeatOffender.class, _parameters);
    }

    @Function(name = "getAttackSimulationSimulationUserCoverage")
    @JsonIgnore
    public CollectionPageNonEntityRequest<AttackSimulationSimulationUserCoverage> getAttackSimulationSimulationUserCoverage() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getAttackSimulationSimulationUserCoverage"), AttackSimulationSimulationUserCoverage.class, _parameters);
    }

    @Function(name = "getAttackSimulationTrainingUserCoverage")
    @JsonIgnore
    public CollectionPageNonEntityRequest<AttackSimulationTrainingUserCoverage> getAttackSimulationTrainingUserCoverage() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getAttackSimulationTrainingUserCoverage"), AttackSimulationTrainingUserCoverage.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ReportRoot[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("applicationSignInDetailedSummary=");
        b.append(this.applicationSignInDetailedSummary);
        b.append(", ");
        b.append("authenticationMethods=");
        b.append(this.authenticationMethods);
        b.append(", ");
        b.append("credentialUserRegistrationDetails=");
        b.append(this.credentialUserRegistrationDetails);
        b.append(", ");
        b.append("userCredentialUsageDetails=");
        b.append(this.userCredentialUsageDetails);
        b.append(", ");
        b.append("dailyPrintUsageByPrinter=");
        b.append(this.dailyPrintUsageByPrinter);
        b.append(", ");
        b.append("dailyPrintUsageByUser=");
        b.append(this.dailyPrintUsageByUser);
        b.append(", ");
        b.append("dailyPrintUsageSummariesByPrinter=");
        b.append(this.dailyPrintUsageSummariesByPrinter);
        b.append(", ");
        b.append("dailyPrintUsageSummariesByUser=");
        b.append(this.dailyPrintUsageSummariesByUser);
        b.append(", ");
        b.append("monthlyPrintUsageByPrinter=");
        b.append(this.monthlyPrintUsageByPrinter);
        b.append(", ");
        b.append("monthlyPrintUsageByUser=");
        b.append(this.monthlyPrintUsageByUser);
        b.append(", ");
        b.append("monthlyPrintUsageSummariesByPrinter=");
        b.append(this.monthlyPrintUsageSummariesByPrinter);
        b.append(", ");
        b.append("monthlyPrintUsageSummariesByUser=");
        b.append(this.monthlyPrintUsageSummariesByUser);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
