package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.enums.RemoteAssistanceOnboardingStatus;


/**
 * <i>“RemoteAssistPartner resources represent the metadata and status of a given
 * Remote Assistance partner service.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "lastConnectionDateTime", 
    "onboardingRequestExpiryDateTime", 
    "onboardingStatus", 
    "onboardingUrl"})
@JsonInclude(Include.NON_NULL)
public class RemoteAssistancePartner extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.remoteAssistancePartner";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("lastConnectionDateTime")
    protected OffsetDateTime lastConnectionDateTime;

    @JsonProperty("onboardingRequestExpiryDateTime")
    protected OffsetDateTime onboardingRequestExpiryDateTime;

    @JsonProperty("onboardingStatus")
    protected RemoteAssistanceOnboardingStatus onboardingStatus;

    @JsonProperty("onboardingUrl")
    protected String onboardingUrl;

    protected RemoteAssistancePartner() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderRemoteAssistancePartner() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private OffsetDateTime lastConnectionDateTime;
        private OffsetDateTime onboardingRequestExpiryDateTime;
        private RemoteAssistanceOnboardingStatus onboardingStatus;
        private String onboardingUrl;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Display name of the partner.”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“Timestamp of the last request sent to Intune by the TEM partner.”</i>
         * 
         * @param lastConnectionDateTime
         *            value of {@code lastConnectionDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastConnectionDateTime(OffsetDateTime lastConnectionDateTime) {
            this.lastConnectionDateTime = lastConnectionDateTime;
            this.changedFields = changedFields.add("lastConnectionDateTime");
            return this;
        }

        /**
         * <i>“When the OnboardingStatus is Onboarding, This is the date time when the
         * onboarding request expires.”</i>
         * 
         * @param onboardingRequestExpiryDateTime
         *            value of {@code onboardingRequestExpiryDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder onboardingRequestExpiryDateTime(OffsetDateTime onboardingRequestExpiryDateTime) {
            this.onboardingRequestExpiryDateTime = onboardingRequestExpiryDateTime;
            this.changedFields = changedFields.add("onboardingRequestExpiryDateTime");
            return this;
        }

        /**
         * <i>“A friendly description of the current TeamViewer connector status”</i>
         * 
         * @param onboardingStatus
         *            value of {@code onboardingStatus} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder onboardingStatus(RemoteAssistanceOnboardingStatus onboardingStatus) {
            this.onboardingStatus = onboardingStatus;
            this.changedFields = changedFields.add("onboardingStatus");
            return this;
        }

        /**
         * <i>“URL of the partner's onboarding portal, where an administrator can configure
         * their Remote Assistance service.”</i>
         * 
         * @param onboardingUrl
         *            value of {@code onboardingUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder onboardingUrl(String onboardingUrl) {
            this.onboardingUrl = onboardingUrl;
            this.changedFields = changedFields.add("onboardingUrl");
            return this;
        }

        public RemoteAssistancePartner build() {
            RemoteAssistancePartner _x = new RemoteAssistancePartner();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.remoteAssistancePartner";
            _x.id = id;
            _x.displayName = displayName;
            _x.lastConnectionDateTime = lastConnectionDateTime;
            _x.onboardingRequestExpiryDateTime = onboardingRequestExpiryDateTime;
            _x.onboardingStatus = onboardingStatus;
            _x.onboardingUrl = onboardingUrl;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Display name of the partner.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Display name of the partner.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public RemoteAssistancePartner withDisplayName(String displayName) {
        RemoteAssistancePartner _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.remoteAssistancePartner");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“Timestamp of the last request sent to Intune by the TEM partner.”</i>
     * 
     * @return property lastConnectionDateTime
     */
    @Property(name="lastConnectionDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastConnectionDateTime() {
        return Optional.ofNullable(lastConnectionDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastConnectionDateTime} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Timestamp of the last request sent to Intune by the TEM partner.”</i>
     * 
     * @param lastConnectionDateTime
     *            new value of {@code lastConnectionDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastConnectionDateTime} field changed
     */
    public RemoteAssistancePartner withLastConnectionDateTime(OffsetDateTime lastConnectionDateTime) {
        RemoteAssistancePartner _x = _copy();
        _x.changedFields = changedFields.add("lastConnectionDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.remoteAssistancePartner");
        _x.lastConnectionDateTime = lastConnectionDateTime;
        return _x;
    }

    /**
     * <i>“When the OnboardingStatus is Onboarding, This is the date time when the
     * onboarding request expires.”</i>
     * 
     * @return property onboardingRequestExpiryDateTime
     */
    @Property(name="onboardingRequestExpiryDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOnboardingRequestExpiryDateTime() {
        return Optional.ofNullable(onboardingRequestExpiryDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * onboardingRequestExpiryDateTime} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“When the OnboardingStatus is Onboarding, This is the date time when the
     * onboarding request expires.”</i>
     * 
     * @param onboardingRequestExpiryDateTime
     *            new value of {@code onboardingRequestExpiryDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code onboardingRequestExpiryDateTime} field changed
     */
    public RemoteAssistancePartner withOnboardingRequestExpiryDateTime(OffsetDateTime onboardingRequestExpiryDateTime) {
        RemoteAssistancePartner _x = _copy();
        _x.changedFields = changedFields.add("onboardingRequestExpiryDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.remoteAssistancePartner");
        _x.onboardingRequestExpiryDateTime = onboardingRequestExpiryDateTime;
        return _x;
    }

    /**
     * <i>“A friendly description of the current TeamViewer connector status”</i>
     * 
     * @return property onboardingStatus
     */
    @Property(name="onboardingStatus")
    @JsonIgnore
    public Optional<RemoteAssistanceOnboardingStatus> getOnboardingStatus() {
        return Optional.ofNullable(onboardingStatus);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code onboardingStatus}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“A friendly description of the current TeamViewer connector status”</i>
     * 
     * @param onboardingStatus
     *            new value of {@code onboardingStatus} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code onboardingStatus} field changed
     */
    public RemoteAssistancePartner withOnboardingStatus(RemoteAssistanceOnboardingStatus onboardingStatus) {
        RemoteAssistancePartner _x = _copy();
        _x.changedFields = changedFields.add("onboardingStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.remoteAssistancePartner");
        _x.onboardingStatus = onboardingStatus;
        return _x;
    }

    /**
     * <i>“URL of the partner's onboarding portal, where an administrator can configure
     * their Remote Assistance service.”</i>
     * 
     * @return property onboardingUrl
     */
    @Property(name="onboardingUrl")
    @JsonIgnore
    public Optional<String> getOnboardingUrl() {
        return Optional.ofNullable(onboardingUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code onboardingUrl}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“URL of the partner's onboarding portal, where an administrator can configure
     * their Remote Assistance service.”</i>
     * 
     * @param onboardingUrl
     *            new value of {@code onboardingUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code onboardingUrl} field changed
     */
    public RemoteAssistancePartner withOnboardingUrl(String onboardingUrl) {
        RemoteAssistancePartner _x = _copy();
        _x.changedFields = changedFields.add("onboardingUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.remoteAssistancePartner");
        _x.onboardingUrl = onboardingUrl;
        return _x;
    }

    public RemoteAssistancePartner withUnmappedField(String name, Object value) {
        RemoteAssistancePartner _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public RemoteAssistancePartner patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        RemoteAssistancePartner _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public RemoteAssistancePartner put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        RemoteAssistancePartner _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private RemoteAssistancePartner _copy() {
        RemoteAssistancePartner _x = new RemoteAssistancePartner();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.lastConnectionDateTime = lastConnectionDateTime;
        _x.onboardingRequestExpiryDateTime = onboardingRequestExpiryDateTime;
        _x.onboardingStatus = onboardingStatus;
        _x.onboardingUrl = onboardingUrl;
        return _x;
    }

    @Action(name = "disconnect")
    @JsonIgnore
    public ActionRequestNoReturn disconnect() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.disconnect"), _parameters);
    }

    @Action(name = "beginOnboarding")
    @JsonIgnore
    public ActionRequestNoReturn beginOnboarding() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.beginOnboarding"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RemoteAssistancePartner[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastConnectionDateTime=");
        b.append(this.lastConnectionDateTime);
        b.append(", ");
        b.append("onboardingRequestExpiryDateTime=");
        b.append(this.onboardingRequestExpiryDateTime);
        b.append(", ");
        b.append("onboardingStatus=");
        b.append(this.onboardingStatus);
        b.append(", ");
        b.append("onboardingUrl=");
        b.append(this.onboardingUrl);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
