package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.LocaleInfo;
import odata.msgraph.client.beta.complex.RegionalFormatOverrides;
import odata.msgraph.client.beta.complex.TranslationPreferences;

@JsonPropertyOrder({
    "@odata.type", 
    "authoringLanguages", 
    "defaultDisplayLanguage", 
    "defaultRegionalFormat", 
    "defaultSpeechInputLanguage", 
    "defaultTranslationLanguage", 
    "regionalFormatOverrides", 
    "translationPreferences"})
@JsonInclude(Include.NON_NULL)
public class RegionalAndLanguageSettings extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.regionalAndLanguageSettings";
    }

    @JsonProperty("authoringLanguages")
    protected List<LocaleInfo> authoringLanguages;

    @JsonProperty("authoringLanguages@nextLink")
    protected String authoringLanguagesNextLink;

    @JsonProperty("defaultDisplayLanguage")
    protected LocaleInfo defaultDisplayLanguage;

    @JsonProperty("defaultRegionalFormat")
    protected LocaleInfo defaultRegionalFormat;

    @JsonProperty("defaultSpeechInputLanguage")
    protected LocaleInfo defaultSpeechInputLanguage;

    @JsonProperty("defaultTranslationLanguage")
    protected LocaleInfo defaultTranslationLanguage;

    @JsonProperty("regionalFormatOverrides")
    protected RegionalFormatOverrides regionalFormatOverrides;

    @JsonProperty("translationPreferences")
    protected TranslationPreferences translationPreferences;

    protected RegionalAndLanguageSettings() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderRegionalAndLanguageSettings() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<LocaleInfo> authoringLanguages;
        private String authoringLanguagesNextLink;
        private LocaleInfo defaultDisplayLanguage;
        private LocaleInfo defaultRegionalFormat;
        private LocaleInfo defaultSpeechInputLanguage;
        private LocaleInfo defaultTranslationLanguage;
        private RegionalFormatOverrides regionalFormatOverrides;
        private TranslationPreferences translationPreferences;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder authoringLanguages(List<LocaleInfo> authoringLanguages) {
            this.authoringLanguages = authoringLanguages;
            this.changedFields = changedFields.add("authoringLanguages");
            return this;
        }

        public Builder authoringLanguages(LocaleInfo... authoringLanguages) {
            return authoringLanguages(Arrays.asList(authoringLanguages));
        }

        public Builder authoringLanguagesNextLink(String authoringLanguagesNextLink) {
            this.authoringLanguagesNextLink = authoringLanguagesNextLink;
            this.changedFields = changedFields.add("authoringLanguages");
            return this;
        }

        public Builder defaultDisplayLanguage(LocaleInfo defaultDisplayLanguage) {
            this.defaultDisplayLanguage = defaultDisplayLanguage;
            this.changedFields = changedFields.add("defaultDisplayLanguage");
            return this;
        }

        public Builder defaultRegionalFormat(LocaleInfo defaultRegionalFormat) {
            this.defaultRegionalFormat = defaultRegionalFormat;
            this.changedFields = changedFields.add("defaultRegionalFormat");
            return this;
        }

        public Builder defaultSpeechInputLanguage(LocaleInfo defaultSpeechInputLanguage) {
            this.defaultSpeechInputLanguage = defaultSpeechInputLanguage;
            this.changedFields = changedFields.add("defaultSpeechInputLanguage");
            return this;
        }

        public Builder defaultTranslationLanguage(LocaleInfo defaultTranslationLanguage) {
            this.defaultTranslationLanguage = defaultTranslationLanguage;
            this.changedFields = changedFields.add("defaultTranslationLanguage");
            return this;
        }

        public Builder regionalFormatOverrides(RegionalFormatOverrides regionalFormatOverrides) {
            this.regionalFormatOverrides = regionalFormatOverrides;
            this.changedFields = changedFields.add("regionalFormatOverrides");
            return this;
        }

        public Builder translationPreferences(TranslationPreferences translationPreferences) {
            this.translationPreferences = translationPreferences;
            this.changedFields = changedFields.add("translationPreferences");
            return this;
        }

        public RegionalAndLanguageSettings build() {
            RegionalAndLanguageSettings _x = new RegionalAndLanguageSettings();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.regionalAndLanguageSettings";
            _x.id = id;
            _x.authoringLanguages = authoringLanguages;
            _x.authoringLanguagesNextLink = authoringLanguagesNextLink;
            _x.defaultDisplayLanguage = defaultDisplayLanguage;
            _x.defaultRegionalFormat = defaultRegionalFormat;
            _x.defaultSpeechInputLanguage = defaultSpeechInputLanguage;
            _x.defaultTranslationLanguage = defaultTranslationLanguage;
            _x.regionalFormatOverrides = regionalFormatOverrides;
            _x.translationPreferences = translationPreferences;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="authoringLanguages")
    @JsonIgnore
    public CollectionPage<LocaleInfo> getAuthoringLanguages() {
        return new CollectionPage<LocaleInfo>(contextPath, LocaleInfo.class, this.authoringLanguages, Optional.ofNullable(authoringLanguagesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public RegionalAndLanguageSettings withAuthoringLanguages(List<LocaleInfo> authoringLanguages) {
        RegionalAndLanguageSettings _x = _copy();
        _x.changedFields = changedFields.add("authoringLanguages");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.regionalAndLanguageSettings");
        _x.authoringLanguages = authoringLanguages;
        return _x;
    }

    @Property(name="authoringLanguages")
    @JsonIgnore
    public CollectionPage<LocaleInfo> getAuthoringLanguages(HttpRequestOptions options) {
        return new CollectionPage<LocaleInfo>(contextPath, LocaleInfo.class, this.authoringLanguages, Optional.ofNullable(authoringLanguagesNextLink), Collections.emptyList(), options);
    }

    @Property(name="defaultDisplayLanguage")
    @JsonIgnore
    public Optional<LocaleInfo> getDefaultDisplayLanguage() {
        return Optional.ofNullable(defaultDisplayLanguage);
    }

    public RegionalAndLanguageSettings withDefaultDisplayLanguage(LocaleInfo defaultDisplayLanguage) {
        RegionalAndLanguageSettings _x = _copy();
        _x.changedFields = changedFields.add("defaultDisplayLanguage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.regionalAndLanguageSettings");
        _x.defaultDisplayLanguage = defaultDisplayLanguage;
        return _x;
    }

    @Property(name="defaultRegionalFormat")
    @JsonIgnore
    public Optional<LocaleInfo> getDefaultRegionalFormat() {
        return Optional.ofNullable(defaultRegionalFormat);
    }

    public RegionalAndLanguageSettings withDefaultRegionalFormat(LocaleInfo defaultRegionalFormat) {
        RegionalAndLanguageSettings _x = _copy();
        _x.changedFields = changedFields.add("defaultRegionalFormat");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.regionalAndLanguageSettings");
        _x.defaultRegionalFormat = defaultRegionalFormat;
        return _x;
    }

    @Property(name="defaultSpeechInputLanguage")
    @JsonIgnore
    public Optional<LocaleInfo> getDefaultSpeechInputLanguage() {
        return Optional.ofNullable(defaultSpeechInputLanguage);
    }

    public RegionalAndLanguageSettings withDefaultSpeechInputLanguage(LocaleInfo defaultSpeechInputLanguage) {
        RegionalAndLanguageSettings _x = _copy();
        _x.changedFields = changedFields.add("defaultSpeechInputLanguage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.regionalAndLanguageSettings");
        _x.defaultSpeechInputLanguage = defaultSpeechInputLanguage;
        return _x;
    }

    @Property(name="defaultTranslationLanguage")
    @JsonIgnore
    public Optional<LocaleInfo> getDefaultTranslationLanguage() {
        return Optional.ofNullable(defaultTranslationLanguage);
    }

    public RegionalAndLanguageSettings withDefaultTranslationLanguage(LocaleInfo defaultTranslationLanguage) {
        RegionalAndLanguageSettings _x = _copy();
        _x.changedFields = changedFields.add("defaultTranslationLanguage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.regionalAndLanguageSettings");
        _x.defaultTranslationLanguage = defaultTranslationLanguage;
        return _x;
    }

    @Property(name="regionalFormatOverrides")
    @JsonIgnore
    public Optional<RegionalFormatOverrides> getRegionalFormatOverrides() {
        return Optional.ofNullable(regionalFormatOverrides);
    }

    public RegionalAndLanguageSettings withRegionalFormatOverrides(RegionalFormatOverrides regionalFormatOverrides) {
        RegionalAndLanguageSettings _x = _copy();
        _x.changedFields = changedFields.add("regionalFormatOverrides");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.regionalAndLanguageSettings");
        _x.regionalFormatOverrides = regionalFormatOverrides;
        return _x;
    }

    @Property(name="translationPreferences")
    @JsonIgnore
    public Optional<TranslationPreferences> getTranslationPreferences() {
        return Optional.ofNullable(translationPreferences);
    }

    public RegionalAndLanguageSettings withTranslationPreferences(TranslationPreferences translationPreferences) {
        RegionalAndLanguageSettings _x = _copy();
        _x.changedFields = changedFields.add("translationPreferences");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.regionalAndLanguageSettings");
        _x.translationPreferences = translationPreferences;
        return _x;
    }

    public RegionalAndLanguageSettings withUnmappedField(String name, Object value) {
        RegionalAndLanguageSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public RegionalAndLanguageSettings patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        RegionalAndLanguageSettings _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public RegionalAndLanguageSettings put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        RegionalAndLanguageSettings _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private RegionalAndLanguageSettings _copy() {
        RegionalAndLanguageSettings _x = new RegionalAndLanguageSettings();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.authoringLanguages = authoringLanguages;
        _x.defaultDisplayLanguage = defaultDisplayLanguage;
        _x.defaultRegionalFormat = defaultRegionalFormat;
        _x.defaultSpeechInputLanguage = defaultSpeechInputLanguage;
        _x.defaultTranslationLanguage = defaultTranslationLanguage;
        _x.regionalFormatOverrides = regionalFormatOverrides;
        _x.translationPreferences = translationPreferences;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RegionalAndLanguageSettings[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("authoringLanguages=");
        b.append(this.authoringLanguages);
        b.append(", ");
        b.append("defaultDisplayLanguage=");
        b.append(this.defaultDisplayLanguage);
        b.append(", ");
        b.append("defaultRegionalFormat=");
        b.append(this.defaultRegionalFormat);
        b.append(", ");
        b.append("defaultSpeechInputLanguage=");
        b.append(this.defaultSpeechInputLanguage);
        b.append(", ");
        b.append("defaultTranslationLanguage=");
        b.append(this.defaultTranslationLanguage);
        b.append(", ");
        b.append("regionalFormatOverrides=");
        b.append(this.regionalFormatOverrides);
        b.append(", ");
        b.append("translationPreferences=");
        b.append(this.translationPreferences);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
