package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ResultInfo;
import odata.msgraph.client.beta.enums.OperationStatus;
import odata.msgraph.client.beta.enums.RecordCompletionReason;

@JsonPropertyOrder({
    "@odata.type", 
    "completionReason", 
    "recordingAccessToken", 
    "recordingLocation"})
@JsonInclude(Include.NON_NULL)
public class RecordOperation extends CommsOperation implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.recordOperation";
    }

    @JsonProperty("completionReason")
    protected RecordCompletionReason completionReason;

    @JsonProperty("recordingAccessToken")
    protected String recordingAccessToken;

    @JsonProperty("recordingLocation")
    protected String recordingLocation;

    protected RecordOperation() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderRecordOperation() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String clientContext;
        private ResultInfo resultInfo;
        private OperationStatus status;
        private RecordCompletionReason completionReason;
        private String recordingAccessToken;
        private String recordingLocation;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder clientContext(String clientContext) {
            this.clientContext = clientContext;
            this.changedFields = changedFields.add("clientContext");
            return this;
        }

        public Builder resultInfo(ResultInfo resultInfo) {
            this.resultInfo = resultInfo;
            this.changedFields = changedFields.add("resultInfo");
            return this;
        }

        public Builder status(OperationStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder completionReason(RecordCompletionReason completionReason) {
            this.completionReason = completionReason;
            this.changedFields = changedFields.add("completionReason");
            return this;
        }

        public Builder recordingAccessToken(String recordingAccessToken) {
            this.recordingAccessToken = recordingAccessToken;
            this.changedFields = changedFields.add("recordingAccessToken");
            return this;
        }

        public Builder recordingLocation(String recordingLocation) {
            this.recordingLocation = recordingLocation;
            this.changedFields = changedFields.add("recordingLocation");
            return this;
        }

        public RecordOperation build() {
            RecordOperation _x = new RecordOperation();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.recordOperation";
            _x.id = id;
            _x.clientContext = clientContext;
            _x.resultInfo = resultInfo;
            _x.status = status;
            _x.completionReason = completionReason;
            _x.recordingAccessToken = recordingAccessToken;
            _x.recordingLocation = recordingLocation;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="completionReason")
    @JsonIgnore
    public Optional<RecordCompletionReason> getCompletionReason() {
        return Optional.ofNullable(completionReason);
    }

    public RecordOperation withCompletionReason(RecordCompletionReason completionReason) {
        RecordOperation _x = _copy();
        _x.changedFields = changedFields.add("completionReason");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.recordOperation");
        _x.completionReason = completionReason;
        return _x;
    }

    @Property(name="recordingAccessToken")
    @JsonIgnore
    public Optional<String> getRecordingAccessToken() {
        return Optional.ofNullable(recordingAccessToken);
    }

    public RecordOperation withRecordingAccessToken(String recordingAccessToken) {
        RecordOperation _x = _copy();
        _x.changedFields = changedFields.add("recordingAccessToken");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.recordOperation");
        _x.recordingAccessToken = recordingAccessToken;
        return _x;
    }

    @Property(name="recordingLocation")
    @JsonIgnore
    public Optional<String> getRecordingLocation() {
        return Optional.ofNullable(recordingLocation);
    }

    public RecordOperation withRecordingLocation(String recordingLocation) {
        RecordOperation _x = _copy();
        _x.changedFields = changedFields.add("recordingLocation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.recordOperation");
        _x.recordingLocation = recordingLocation;
        return _x;
    }

    public RecordOperation withUnmappedField(String name, Object value) {
        RecordOperation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public RecordOperation patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        RecordOperation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public RecordOperation put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        RecordOperation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private RecordOperation _copy() {
        RecordOperation _x = new RecordOperation();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.clientContext = clientContext;
        _x.resultInfo = resultInfo;
        _x.status = status;
        _x.completionReason = completionReason;
        _x.recordingAccessToken = recordingAccessToken;
        _x.recordingLocation = recordingLocation;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RecordOperation[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("clientContext=");
        b.append(this.clientContext);
        b.append(", ");
        b.append("resultInfo=");
        b.append(this.resultInfo);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("completionReason=");
        b.append(this.completionReason);
        b.append(", ");
        b.append("recordingAccessToken=");
        b.append(this.recordingAccessToken);
        b.append(", ");
        b.append("recordingLocation=");
        b.append(this.recordingLocation);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
