package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.KeyValue;
import odata.msgraph.client.beta.enums.RecommendationStatus;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
 * <p>
 * Filterable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.SkipSupported</b>
 * <p>
 * true
 * <p>
 * <b>Org.OData.Capabilities.V1.TopSupported</b>
 * <p>
 * true
 */@JsonPropertyOrder({
    "@odata.type", 
    "addedDateTime", 
    "additionalDetails", 
    "apiUrl", 
    "displayName", 
    "owner", 
    "portalUrl", 
    "rank", 
    "recommendationId", 
    "resourceType", 
    "status"})
@JsonInclude(Include.NON_NULL)
public class RecommendationResource extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.recommendationResource";
    }

    @JsonProperty("addedDateTime")
    protected OffsetDateTime addedDateTime;

    @JsonProperty("additionalDetails")
    protected List<KeyValue> additionalDetails;

    @JsonProperty("additionalDetails@nextLink")
    protected String additionalDetailsNextLink;

    @JsonProperty("apiUrl")
    protected String apiUrl;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("owner")
    protected String owner;

    @JsonProperty("portalUrl")
    protected String portalUrl;

    @JsonProperty("rank")
    protected Integer rank;

    @JsonProperty("recommendationId")
    protected String recommendationId;

    @JsonProperty("resourceType")
    protected String resourceType;

    @JsonProperty("status")
    protected RecommendationStatus status;

    protected RecommendationResource() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderRecommendationResource() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime addedDateTime;
        private List<KeyValue> additionalDetails;
        private String additionalDetailsNextLink;
        private String apiUrl;
        private String displayName;
        private String owner;
        private String portalUrl;
        private Integer rank;
        private String recommendationId;
        private String resourceType;
        private RecommendationStatus status;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder addedDateTime(OffsetDateTime addedDateTime) {
            this.addedDateTime = addedDateTime;
            this.changedFields = changedFields.add("addedDateTime");
            return this;
        }

        public Builder additionalDetails(List<KeyValue> additionalDetails) {
            this.additionalDetails = additionalDetails;
            this.changedFields = changedFields.add("additionalDetails");
            return this;
        }

        public Builder additionalDetails(KeyValue... additionalDetails) {
            return additionalDetails(Arrays.asList(additionalDetails));
        }

        public Builder additionalDetailsNextLink(String additionalDetailsNextLink) {
            this.additionalDetailsNextLink = additionalDetailsNextLink;
            this.changedFields = changedFields.add("additionalDetails");
            return this;
        }

        public Builder apiUrl(String apiUrl) {
            this.apiUrl = apiUrl;
            this.changedFields = changedFields.add("apiUrl");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder owner(String owner) {
            this.owner = owner;
            this.changedFields = changedFields.add("owner");
            return this;
        }

        public Builder portalUrl(String portalUrl) {
            this.portalUrl = portalUrl;
            this.changedFields = changedFields.add("portalUrl");
            return this;
        }

        public Builder rank(Integer rank) {
            this.rank = rank;
            this.changedFields = changedFields.add("rank");
            return this;
        }

        public Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            this.changedFields = changedFields.add("recommendationId");
            return this;
        }

        public Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            this.changedFields = changedFields.add("resourceType");
            return this;
        }

        public Builder status(RecommendationStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public RecommendationResource build() {
            RecommendationResource _x = new RecommendationResource();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.recommendationResource";
            _x.id = id;
            _x.addedDateTime = addedDateTime;
            _x.additionalDetails = additionalDetails;
            _x.additionalDetailsNextLink = additionalDetailsNextLink;
            _x.apiUrl = apiUrl;
            _x.displayName = displayName;
            _x.owner = owner;
            _x.portalUrl = portalUrl;
            _x.rank = rank;
            _x.recommendationId = recommendationId;
            _x.resourceType = resourceType;
            _x.status = status;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="addedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getAddedDateTime() {
        return Optional.ofNullable(addedDateTime);
    }

    public RecommendationResource withAddedDateTime(OffsetDateTime addedDateTime) {
        RecommendationResource _x = _copy();
        _x.changedFields = changedFields.add("addedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.recommendationResource");
        _x.addedDateTime = addedDateTime;
        return _x;
    }

    @Property(name="additionalDetails")
    @JsonIgnore
    public CollectionPage<KeyValue> getAdditionalDetails() {
        return new CollectionPage<KeyValue>(contextPath, KeyValue.class, this.additionalDetails, Optional.ofNullable(additionalDetailsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public RecommendationResource withAdditionalDetails(List<KeyValue> additionalDetails) {
        RecommendationResource _x = _copy();
        _x.changedFields = changedFields.add("additionalDetails");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.recommendationResource");
        _x.additionalDetails = additionalDetails;
        return _x;
    }

    @Property(name="additionalDetails")
    @JsonIgnore
    public CollectionPage<KeyValue> getAdditionalDetails(HttpRequestOptions options) {
        return new CollectionPage<KeyValue>(contextPath, KeyValue.class, this.additionalDetails, Optional.ofNullable(additionalDetailsNextLink), Collections.emptyList(), options);
    }

    @Property(name="apiUrl")
    @JsonIgnore
    public Optional<String> getApiUrl() {
        return Optional.ofNullable(apiUrl);
    }

    public RecommendationResource withApiUrl(String apiUrl) {
        RecommendationResource _x = _copy();
        _x.changedFields = changedFields.add("apiUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.recommendationResource");
        _x.apiUrl = apiUrl;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public RecommendationResource withDisplayName(String displayName) {
        RecommendationResource _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.recommendationResource");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="owner")
    @JsonIgnore
    public Optional<String> getOwner() {
        return Optional.ofNullable(owner);
    }

    public RecommendationResource withOwner(String owner) {
        RecommendationResource _x = _copy();
        _x.changedFields = changedFields.add("owner");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.recommendationResource");
        _x.owner = owner;
        return _x;
    }

    @Property(name="portalUrl")
    @JsonIgnore
    public Optional<String> getPortalUrl() {
        return Optional.ofNullable(portalUrl);
    }

    public RecommendationResource withPortalUrl(String portalUrl) {
        RecommendationResource _x = _copy();
        _x.changedFields = changedFields.add("portalUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.recommendationResource");
        _x.portalUrl = portalUrl;
        return _x;
    }

    @Property(name="rank")
    @JsonIgnore
    public Optional<Integer> getRank() {
        return Optional.ofNullable(rank);
    }

    public RecommendationResource withRank(Integer rank) {
        RecommendationResource _x = _copy();
        _x.changedFields = changedFields.add("rank");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.recommendationResource");
        _x.rank = rank;
        return _x;
    }

    @Property(name="recommendationId")
    @JsonIgnore
    public Optional<String> getRecommendationId() {
        return Optional.ofNullable(recommendationId);
    }

    public RecommendationResource withRecommendationId(String recommendationId) {
        RecommendationResource _x = _copy();
        _x.changedFields = changedFields.add("recommendationId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.recommendationResource");
        _x.recommendationId = recommendationId;
        return _x;
    }

    @Property(name="resourceType")
    @JsonIgnore
    public Optional<String> getResourceType() {
        return Optional.ofNullable(resourceType);
    }

    public RecommendationResource withResourceType(String resourceType) {
        RecommendationResource _x = _copy();
        _x.changedFields = changedFields.add("resourceType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.recommendationResource");
        _x.resourceType = resourceType;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<RecommendationStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public RecommendationResource withStatus(RecommendationStatus status) {
        RecommendationResource _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.recommendationResource");
        _x.status = status;
        return _x;
    }

    public RecommendationResource withUnmappedField(String name, Object value) {
        RecommendationResource _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public RecommendationResource patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        RecommendationResource _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public RecommendationResource put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        RecommendationResource _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private RecommendationResource _copy() {
        RecommendationResource _x = new RecommendationResource();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.addedDateTime = addedDateTime;
        _x.additionalDetails = additionalDetails;
        _x.apiUrl = apiUrl;
        _x.displayName = displayName;
        _x.owner = owner;
        _x.portalUrl = portalUrl;
        _x.rank = rank;
        _x.recommendationId = recommendationId;
        _x.resourceType = resourceType;
        _x.status = status;
        return _x;
    }

    @Action(name = "complete")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<RecommendationResource> complete() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<RecommendationResource>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.complete"), RecommendationResource.class, _parameters);
    }

    @Action(name = "dismiss")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<RecommendationResource> dismiss(String dismissReason) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("dismissReason", "Edm.String", Checks.checkIsAscii(dismissReason))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<RecommendationResource>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.dismiss"), RecommendationResource.class, _parameters);
    }

    @Action(name = "postpone")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<RecommendationResource> postpone(OffsetDateTime postponeUntilDateTime) {
        Preconditions.checkNotNull(postponeUntilDateTime, "postponeUntilDateTime cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("postponeUntilDateTime", "Edm.DateTimeOffset", postponeUntilDateTime)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<RecommendationResource>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.postpone"), RecommendationResource.class, _parameters);
    }

    @Action(name = "reactivate")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<RecommendationResource> reactivate() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<RecommendationResource>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.reactivate"), RecommendationResource.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RecommendationResource[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("addedDateTime=");
        b.append(this.addedDateTime);
        b.append(", ");
        b.append("additionalDetails=");
        b.append(this.additionalDetails);
        b.append(", ");
        b.append("apiUrl=");
        b.append(this.apiUrl);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("owner=");
        b.append(this.owner);
        b.append(", ");
        b.append("portalUrl=");
        b.append(this.portalUrl);
        b.append(", ");
        b.append("rank=");
        b.append(this.rank);
        b.append(", ");
        b.append("recommendationId=");
        b.append(this.recommendationId);
        b.append(", ");
        b.append("resourceType=");
        b.append(this.resourceType);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
