package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ActionStep;
import odata.msgraph.client.beta.entity.collection.request.RecommendationResourceCollectionRequest;
import odata.msgraph.client.beta.enums.RecommendationCategory;
import odata.msgraph.client.beta.enums.RecommendationPriority;
import odata.msgraph.client.beta.enums.RecommendationStatus;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
 * <p>
 * Filterable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.SkipSupported</b>
 * <p>
 * false
 * <p>
 * <b>Org.OData.Capabilities.V1.TopSupported</b>
 * <p>
 * true
 */@JsonPropertyOrder({
    "@odata.type", 
    "actionSteps", 
    "benefits", 
    "category", 
    "createdDateTime", 
    "displayName", 
    "impactStartDateTime", 
    "impactType", 
    "insights", 
    "lastCheckedDateTime", 
    "lastModifiedBy", 
    "lastModifiedDateTime", 
    "postponeUntilDateTime", 
    "priority", 
    "status", 
    "impactedResources"})
@JsonInclude(Include.NON_NULL)
public class Recommendation extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.recommendation";
    }

    @JsonProperty("actionSteps")
    protected List<ActionStep> actionSteps;

    @JsonProperty("actionSteps@nextLink")
    protected String actionStepsNextLink;

    @JsonProperty("benefits")
    protected String benefits;

    @JsonProperty("category")
    protected RecommendationCategory category;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("impactStartDateTime")
    protected OffsetDateTime impactStartDateTime;

    @JsonProperty("impactType")
    protected String impactType;

    @JsonProperty("insights")
    protected String insights;

    @JsonProperty("lastCheckedDateTime")
    protected OffsetDateTime lastCheckedDateTime;

    @JsonProperty("lastModifiedBy")
    protected String lastModifiedBy;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("postponeUntilDateTime")
    protected OffsetDateTime postponeUntilDateTime;

    @JsonProperty("priority")
    protected RecommendationPriority priority;

    @JsonProperty("status")
    protected RecommendationStatus status;

    @JsonProperty("impactedResources")
    protected List<RecommendationResource> impactedResources;

    protected Recommendation() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderRecommendation() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<ActionStep> actionSteps;
        private String actionStepsNextLink;
        private String benefits;
        private RecommendationCategory category;
        private OffsetDateTime createdDateTime;
        private String displayName;
        private OffsetDateTime impactStartDateTime;
        private String impactType;
        private String insights;
        private OffsetDateTime lastCheckedDateTime;
        private String lastModifiedBy;
        private OffsetDateTime lastModifiedDateTime;
        private OffsetDateTime postponeUntilDateTime;
        private RecommendationPriority priority;
        private RecommendationStatus status;
        private List<RecommendationResource> impactedResources;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder actionSteps(List<ActionStep> actionSteps) {
            this.actionSteps = actionSteps;
            this.changedFields = changedFields.add("actionSteps");
            return this;
        }

        public Builder actionSteps(ActionStep... actionSteps) {
            return actionSteps(Arrays.asList(actionSteps));
        }

        public Builder actionStepsNextLink(String actionStepsNextLink) {
            this.actionStepsNextLink = actionStepsNextLink;
            this.changedFields = changedFields.add("actionSteps");
            return this;
        }

        public Builder benefits(String benefits) {
            this.benefits = benefits;
            this.changedFields = changedFields.add("benefits");
            return this;
        }

        public Builder category(RecommendationCategory category) {
            this.category = category;
            this.changedFields = changedFields.add("category");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder impactStartDateTime(OffsetDateTime impactStartDateTime) {
            this.impactStartDateTime = impactStartDateTime;
            this.changedFields = changedFields.add("impactStartDateTime");
            return this;
        }

        public Builder impactType(String impactType) {
            this.impactType = impactType;
            this.changedFields = changedFields.add("impactType");
            return this;
        }

        public Builder insights(String insights) {
            this.insights = insights;
            this.changedFields = changedFields.add("insights");
            return this;
        }

        public Builder lastCheckedDateTime(OffsetDateTime lastCheckedDateTime) {
            this.lastCheckedDateTime = lastCheckedDateTime;
            this.changedFields = changedFields.add("lastCheckedDateTime");
            return this;
        }

        public Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder postponeUntilDateTime(OffsetDateTime postponeUntilDateTime) {
            this.postponeUntilDateTime = postponeUntilDateTime;
            this.changedFields = changedFields.add("postponeUntilDateTime");
            return this;
        }

        public Builder priority(RecommendationPriority priority) {
            this.priority = priority;
            this.changedFields = changedFields.add("priority");
            return this;
        }

        public Builder status(RecommendationStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder impactedResources(List<RecommendationResource> impactedResources) {
            this.impactedResources = impactedResources;
            this.changedFields = changedFields.add("impactedResources");
            return this;
        }

        public Builder impactedResources(RecommendationResource... impactedResources) {
            return impactedResources(Arrays.asList(impactedResources));
        }

        public Recommendation build() {
            Recommendation _x = new Recommendation();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.recommendation";
            _x.id = id;
            _x.actionSteps = actionSteps;
            _x.actionStepsNextLink = actionStepsNextLink;
            _x.benefits = benefits;
            _x.category = category;
            _x.createdDateTime = createdDateTime;
            _x.displayName = displayName;
            _x.impactStartDateTime = impactStartDateTime;
            _x.impactType = impactType;
            _x.insights = insights;
            _x.lastCheckedDateTime = lastCheckedDateTime;
            _x.lastModifiedBy = lastModifiedBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.postponeUntilDateTime = postponeUntilDateTime;
            _x.priority = priority;
            _x.status = status;
            _x.impactedResources = impactedResources;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="actionSteps")
    @JsonIgnore
    public CollectionPage<ActionStep> getActionSteps() {
        return new CollectionPage<ActionStep>(contextPath, ActionStep.class, this.actionSteps, Optional.ofNullable(actionStepsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public Recommendation withActionSteps(List<ActionStep> actionSteps) {
        Recommendation _x = _copy();
        _x.changedFields = changedFields.add("actionSteps");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.recommendation");
        _x.actionSteps = actionSteps;
        return _x;
    }

    @Property(name="actionSteps")
    @JsonIgnore
    public CollectionPage<ActionStep> getActionSteps(HttpRequestOptions options) {
        return new CollectionPage<ActionStep>(contextPath, ActionStep.class, this.actionSteps, Optional.ofNullable(actionStepsNextLink), Collections.emptyList(), options);
    }

    @Property(name="benefits")
    @JsonIgnore
    public Optional<String> getBenefits() {
        return Optional.ofNullable(benefits);
    }

    public Recommendation withBenefits(String benefits) {
        Recommendation _x = _copy();
        _x.changedFields = changedFields.add("benefits");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.recommendation");
        _x.benefits = benefits;
        return _x;
    }

    @Property(name="category")
    @JsonIgnore
    public Optional<RecommendationCategory> getCategory() {
        return Optional.ofNullable(category);
    }

    public Recommendation withCategory(RecommendationCategory category) {
        Recommendation _x = _copy();
        _x.changedFields = changedFields.add("category");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.recommendation");
        _x.category = category;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public Recommendation withCreatedDateTime(OffsetDateTime createdDateTime) {
        Recommendation _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.recommendation");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public Recommendation withDisplayName(String displayName) {
        Recommendation _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.recommendation");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="impactStartDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getImpactStartDateTime() {
        return Optional.ofNullable(impactStartDateTime);
    }

    public Recommendation withImpactStartDateTime(OffsetDateTime impactStartDateTime) {
        Recommendation _x = _copy();
        _x.changedFields = changedFields.add("impactStartDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.recommendation");
        _x.impactStartDateTime = impactStartDateTime;
        return _x;
    }

    @Property(name="impactType")
    @JsonIgnore
    public Optional<String> getImpactType() {
        return Optional.ofNullable(impactType);
    }

    public Recommendation withImpactType(String impactType) {
        Recommendation _x = _copy();
        _x.changedFields = changedFields.add("impactType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.recommendation");
        _x.impactType = impactType;
        return _x;
    }

    @Property(name="insights")
    @JsonIgnore
    public Optional<String> getInsights() {
        return Optional.ofNullable(insights);
    }

    public Recommendation withInsights(String insights) {
        Recommendation _x = _copy();
        _x.changedFields = changedFields.add("insights");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.recommendation");
        _x.insights = insights;
        return _x;
    }

    @Property(name="lastCheckedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastCheckedDateTime() {
        return Optional.ofNullable(lastCheckedDateTime);
    }

    public Recommendation withLastCheckedDateTime(OffsetDateTime lastCheckedDateTime) {
        Recommendation _x = _copy();
        _x.changedFields = changedFields.add("lastCheckedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.recommendation");
        _x.lastCheckedDateTime = lastCheckedDateTime;
        return _x;
    }

    @Property(name="lastModifiedBy")
    @JsonIgnore
    public Optional<String> getLastModifiedBy() {
        return Optional.ofNullable(lastModifiedBy);
    }

    public Recommendation withLastModifiedBy(String lastModifiedBy) {
        Recommendation _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.recommendation");
        _x.lastModifiedBy = lastModifiedBy;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public Recommendation withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        Recommendation _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.recommendation");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="postponeUntilDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getPostponeUntilDateTime() {
        return Optional.ofNullable(postponeUntilDateTime);
    }

    public Recommendation withPostponeUntilDateTime(OffsetDateTime postponeUntilDateTime) {
        Recommendation _x = _copy();
        _x.changedFields = changedFields.add("postponeUntilDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.recommendation");
        _x.postponeUntilDateTime = postponeUntilDateTime;
        return _x;
    }

    @Property(name="priority")
    @JsonIgnore
    public Optional<RecommendationPriority> getPriority() {
        return Optional.ofNullable(priority);
    }

    public Recommendation withPriority(RecommendationPriority priority) {
        Recommendation _x = _copy();
        _x.changedFields = changedFields.add("priority");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.recommendation");
        _x.priority = priority;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<RecommendationStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public Recommendation withStatus(RecommendationStatus status) {
        Recommendation _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.recommendation");
        _x.status = status;
        return _x;
    }

    public Recommendation withUnmappedField(String name, Object value) {
        Recommendation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="impactedResources")
    @JsonIgnore
    public RecommendationResourceCollectionRequest getImpactedResources() {
        return new RecommendationResourceCollectionRequest(
                        contextPath.addSegment("impactedResources"), Optional.ofNullable(impactedResources));
    }

    public Recommendation withImpactedResources(List<RecommendationResource> impactedResources) {
        Recommendation _x = _copy();
        _x.changedFields = changedFields.add("impactedResources");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.recommendation");
        _x.impactedResources = impactedResources;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Recommendation patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Recommendation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Recommendation put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Recommendation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Recommendation _copy() {
        Recommendation _x = new Recommendation();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.actionSteps = actionSteps;
        _x.benefits = benefits;
        _x.category = category;
        _x.createdDateTime = createdDateTime;
        _x.displayName = displayName;
        _x.impactStartDateTime = impactStartDateTime;
        _x.impactType = impactType;
        _x.insights = insights;
        _x.lastCheckedDateTime = lastCheckedDateTime;
        _x.lastModifiedBy = lastModifiedBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.postponeUntilDateTime = postponeUntilDateTime;
        _x.priority = priority;
        _x.status = status;
        _x.impactedResources = impactedResources;
        return _x;
    }

    @Action(name = "complete")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Recommendation> complete() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<Recommendation>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.complete"), Recommendation.class, _parameters);
    }

    @Action(name = "dismiss")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Recommendation> dismiss(String dismissReason) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("dismissReason", "Edm.String", Checks.checkIsAscii(dismissReason))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Recommendation>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.dismiss"), Recommendation.class, _parameters);
    }

    @Action(name = "postpone")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Recommendation> postpone(OffsetDateTime postponeUntilDateTime) {
        Preconditions.checkNotNull(postponeUntilDateTime, "postponeUntilDateTime cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("postponeUntilDateTime", "Edm.DateTimeOffset", postponeUntilDateTime)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Recommendation>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.postpone"), Recommendation.class, _parameters);
    }

    @Action(name = "reactivate")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Recommendation> reactivate() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<Recommendation>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.reactivate"), Recommendation.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Recommendation[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("actionSteps=");
        b.append(this.actionSteps);
        b.append(", ");
        b.append("benefits=");
        b.append(this.benefits);
        b.append(", ");
        b.append("category=");
        b.append(this.category);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("impactStartDateTime=");
        b.append(this.impactStartDateTime);
        b.append(", ");
        b.append("impactType=");
        b.append(this.impactType);
        b.append(", ");
        b.append("insights=");
        b.append(this.insights);
        b.append(", ");
        b.append("lastCheckedDateTime=");
        b.append(this.lastCheckedDateTime);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("postponeUntilDateTime=");
        b.append(this.postponeUntilDateTime);
        b.append(", ");
        b.append("priority=");
        b.append(this.priority);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("impactedResources=");
        b.append(this.impactedResources);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
