package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.UnifiedRbacResourceNamespaceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UnifiedRoleAssignmentMultipleCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UnifiedRoleDefinitionCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "resourceNamespaces", 
    "roleAssignments", 
    "roleDefinitions"})
@JsonInclude(Include.NON_NULL)
public class RbacApplicationMultiple extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.rbacApplicationMultiple";
    }

    @JsonProperty("resourceNamespaces")
    protected List<UnifiedRbacResourceNamespace> resourceNamespaces;

    @JsonProperty("roleAssignments")
    protected List<UnifiedRoleAssignmentMultiple> roleAssignments;

    @JsonProperty("roleDefinitions")
    protected List<UnifiedRoleDefinition> roleDefinitions;

    protected RbacApplicationMultiple() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderRbacApplicationMultiple() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<UnifiedRbacResourceNamespace> resourceNamespaces;
        private List<UnifiedRoleAssignmentMultiple> roleAssignments;
        private List<UnifiedRoleDefinition> roleDefinitions;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder resourceNamespaces(List<UnifiedRbacResourceNamespace> resourceNamespaces) {
            this.resourceNamespaces = resourceNamespaces;
            this.changedFields = changedFields.add("resourceNamespaces");
            return this;
        }

        public Builder resourceNamespaces(UnifiedRbacResourceNamespace... resourceNamespaces) {
            return resourceNamespaces(Arrays.asList(resourceNamespaces));
        }

        public Builder roleAssignments(List<UnifiedRoleAssignmentMultiple> roleAssignments) {
            this.roleAssignments = roleAssignments;
            this.changedFields = changedFields.add("roleAssignments");
            return this;
        }

        public Builder roleAssignments(UnifiedRoleAssignmentMultiple... roleAssignments) {
            return roleAssignments(Arrays.asList(roleAssignments));
        }

        public Builder roleDefinitions(List<UnifiedRoleDefinition> roleDefinitions) {
            this.roleDefinitions = roleDefinitions;
            this.changedFields = changedFields.add("roleDefinitions");
            return this;
        }

        public Builder roleDefinitions(UnifiedRoleDefinition... roleDefinitions) {
            return roleDefinitions(Arrays.asList(roleDefinitions));
        }

        public RbacApplicationMultiple build() {
            RbacApplicationMultiple _x = new RbacApplicationMultiple();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.rbacApplicationMultiple";
            _x.id = id;
            _x.resourceNamespaces = resourceNamespaces;
            _x.roleAssignments = roleAssignments;
            _x.roleDefinitions = roleDefinitions;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public RbacApplicationMultiple withUnmappedField(String name, Object value) {
        RbacApplicationMultiple _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="resourceNamespaces")
    @JsonIgnore
    public UnifiedRbacResourceNamespaceCollectionRequest getResourceNamespaces() {
        return new UnifiedRbacResourceNamespaceCollectionRequest(
                        contextPath.addSegment("resourceNamespaces"), Optional.ofNullable(resourceNamespaces));
    }

    @NavigationProperty(name="roleAssignments")
    @JsonIgnore
    public UnifiedRoleAssignmentMultipleCollectionRequest getRoleAssignments() {
        return new UnifiedRoleAssignmentMultipleCollectionRequest(
                        contextPath.addSegment("roleAssignments"), Optional.ofNullable(roleAssignments));
    }

    @NavigationProperty(name="roleDefinitions")
    @JsonIgnore
    public UnifiedRoleDefinitionCollectionRequest getRoleDefinitions() {
        return new UnifiedRoleDefinitionCollectionRequest(
                        contextPath.addSegment("roleDefinitions"), Optional.ofNullable(roleDefinitions));
    }

    public RbacApplicationMultiple withResourceNamespaces(List<UnifiedRbacResourceNamespace> resourceNamespaces) {
        RbacApplicationMultiple _x = _copy();
        _x.changedFields = changedFields.add("resourceNamespaces");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.rbacApplicationMultiple");
        _x.resourceNamespaces = resourceNamespaces;
        return _x;
    }

    public RbacApplicationMultiple withRoleAssignments(List<UnifiedRoleAssignmentMultiple> roleAssignments) {
        RbacApplicationMultiple _x = _copy();
        _x.changedFields = changedFields.add("roleAssignments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.rbacApplicationMultiple");
        _x.roleAssignments = roleAssignments;
        return _x;
    }

    public RbacApplicationMultiple withRoleDefinitions(List<UnifiedRoleDefinition> roleDefinitions) {
        RbacApplicationMultiple _x = _copy();
        _x.changedFields = changedFields.add("roleDefinitions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.rbacApplicationMultiple");
        _x.roleDefinitions = roleDefinitions;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public RbacApplicationMultiple patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        RbacApplicationMultiple _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public RbacApplicationMultiple put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        RbacApplicationMultiple _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private RbacApplicationMultiple _copy() {
        RbacApplicationMultiple _x = new RbacApplicationMultiple();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.resourceNamespaces = resourceNamespaces;
        _x.roleAssignments = roleAssignments;
        _x.roleDefinitions = roleDefinitions;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RbacApplicationMultiple[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("resourceNamespaces=");
        b.append(this.resourceNamespaces);
        b.append(", ");
        b.append("roleAssignments=");
        b.append(this.roleAssignments);
        b.append(", ");
        b.append("roleDefinitions=");
        b.append(this.roleDefinitions);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
