package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

import odata.msgraph.client.beta.complex.PostalAddressType;
import odata.msgraph.client.beta.entity.collection.request.PurchaseInvoiceLineCollectionRequest;
import odata.msgraph.client.beta.entity.request.CurrencyRequest;
import odata.msgraph.client.beta.entity.request.VendorRequest;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
 * <p>
 * Deletable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
 * <p>
 * Insertable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
 * <p>
 * Updatable = true
 */@JsonPropertyOrder({
    "@odata.type", 
    "buyFromAddress", 
    "currencyCode", 
    "currencyId", 
    "discountAmount", 
    "discountAppliedBeforeTax", 
    "dueDate", 
    "invoiceDate", 
    "lastModifiedDateTime", 
    "number", 
    "payToAddress", 
    "payToContact", 
    "payToName", 
    "payToVendorId", 
    "payToVendorNumber", 
    "pricesIncludeTax", 
    "shipToAddress", 
    "shipToContact", 
    "shipToName", 
    "status", 
    "totalAmountExcludingTax", 
    "totalAmountIncludingTax", 
    "totalTaxAmount", 
    "vendorId", 
    "vendorInvoiceNumber", 
    "vendorName", 
    "vendorNumber", 
    "currency", 
    "purchaseInvoiceLines", 
    "vendor"})
@JsonInclude(Include.NON_NULL)
public class PurchaseInvoice extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.purchaseInvoice";
    }

    @JsonProperty("buyFromAddress")
    protected PostalAddressType buyFromAddress;

    @JsonProperty("currencyCode")
    protected String currencyCode;

    @JsonProperty("currencyId")
    protected UUID currencyId;

    @JsonProperty("discountAmount")
    protected BigDecimal discountAmount;

    @JsonProperty("discountAppliedBeforeTax")
    protected Boolean discountAppliedBeforeTax;

    @JsonProperty("dueDate")
    protected LocalDate dueDate;

    @JsonProperty("invoiceDate")
    protected LocalDate invoiceDate;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("number")
    protected String number;

    @JsonProperty("payToAddress")
    protected PostalAddressType payToAddress;

    @JsonProperty("payToContact")
    protected String payToContact;

    @JsonProperty("payToName")
    protected String payToName;

    @JsonProperty("payToVendorId")
    protected UUID payToVendorId;

    @JsonProperty("payToVendorNumber")
    protected String payToVendorNumber;

    @JsonProperty("pricesIncludeTax")
    protected Boolean pricesIncludeTax;

    @JsonProperty("shipToAddress")
    protected PostalAddressType shipToAddress;

    @JsonProperty("shipToContact")
    protected String shipToContact;

    @JsonProperty("shipToName")
    protected String shipToName;

    @JsonProperty("status")
    protected String status;

    @JsonProperty("totalAmountExcludingTax")
    protected BigDecimal totalAmountExcludingTax;

    @JsonProperty("totalAmountIncludingTax")
    protected BigDecimal totalAmountIncludingTax;

    @JsonProperty("totalTaxAmount")
    protected BigDecimal totalTaxAmount;

    @JsonProperty("vendorId")
    protected UUID vendorId;

    @JsonProperty("vendorInvoiceNumber")
    protected String vendorInvoiceNumber;

    @JsonProperty("vendorName")
    protected String vendorName;

    @JsonProperty("vendorNumber")
    protected String vendorNumber;

    @JsonProperty("currency")
    protected Currency currency;

    @JsonProperty("purchaseInvoiceLines")
    protected List<PurchaseInvoiceLine> purchaseInvoiceLines;

    @JsonProperty("vendor")
    protected Vendor vendor;

    protected PurchaseInvoice() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPurchaseInvoice() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private PostalAddressType buyFromAddress;
        private String currencyCode;
        private UUID currencyId;
        private BigDecimal discountAmount;
        private Boolean discountAppliedBeforeTax;
        private LocalDate dueDate;
        private LocalDate invoiceDate;
        private OffsetDateTime lastModifiedDateTime;
        private String number;
        private PostalAddressType payToAddress;
        private String payToContact;
        private String payToName;
        private UUID payToVendorId;
        private String payToVendorNumber;
        private Boolean pricesIncludeTax;
        private PostalAddressType shipToAddress;
        private String shipToContact;
        private String shipToName;
        private String status;
        private BigDecimal totalAmountExcludingTax;
        private BigDecimal totalAmountIncludingTax;
        private BigDecimal totalTaxAmount;
        private UUID vendorId;
        private String vendorInvoiceNumber;
        private String vendorName;
        private String vendorNumber;
        private Currency currency;
        private List<PurchaseInvoiceLine> purchaseInvoiceLines;
        private Vendor vendor;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder buyFromAddress(PostalAddressType buyFromAddress) {
            this.buyFromAddress = buyFromAddress;
            this.changedFields = changedFields.add("buyFromAddress");
            return this;
        }

        public Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            this.changedFields = changedFields.add("currencyCode");
            return this;
        }

        public Builder currencyId(UUID currencyId) {
            this.currencyId = currencyId;
            this.changedFields = changedFields.add("currencyId");
            return this;
        }

        public Builder discountAmount(BigDecimal discountAmount) {
            this.discountAmount = discountAmount;
            this.changedFields = changedFields.add("discountAmount");
            return this;
        }

        public Builder discountAppliedBeforeTax(Boolean discountAppliedBeforeTax) {
            this.discountAppliedBeforeTax = discountAppliedBeforeTax;
            this.changedFields = changedFields.add("discountAppliedBeforeTax");
            return this;
        }

        public Builder dueDate(LocalDate dueDate) {
            this.dueDate = dueDate;
            this.changedFields = changedFields.add("dueDate");
            return this;
        }

        public Builder invoiceDate(LocalDate invoiceDate) {
            this.invoiceDate = invoiceDate;
            this.changedFields = changedFields.add("invoiceDate");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder number(String number) {
            this.number = number;
            this.changedFields = changedFields.add("number");
            return this;
        }

        public Builder payToAddress(PostalAddressType payToAddress) {
            this.payToAddress = payToAddress;
            this.changedFields = changedFields.add("payToAddress");
            return this;
        }

        public Builder payToContact(String payToContact) {
            this.payToContact = payToContact;
            this.changedFields = changedFields.add("payToContact");
            return this;
        }

        public Builder payToName(String payToName) {
            this.payToName = payToName;
            this.changedFields = changedFields.add("payToName");
            return this;
        }

        public Builder payToVendorId(UUID payToVendorId) {
            this.payToVendorId = payToVendorId;
            this.changedFields = changedFields.add("payToVendorId");
            return this;
        }

        public Builder payToVendorNumber(String payToVendorNumber) {
            this.payToVendorNumber = payToVendorNumber;
            this.changedFields = changedFields.add("payToVendorNumber");
            return this;
        }

        public Builder pricesIncludeTax(Boolean pricesIncludeTax) {
            this.pricesIncludeTax = pricesIncludeTax;
            this.changedFields = changedFields.add("pricesIncludeTax");
            return this;
        }

        public Builder shipToAddress(PostalAddressType shipToAddress) {
            this.shipToAddress = shipToAddress;
            this.changedFields = changedFields.add("shipToAddress");
            return this;
        }

        public Builder shipToContact(String shipToContact) {
            this.shipToContact = shipToContact;
            this.changedFields = changedFields.add("shipToContact");
            return this;
        }

        public Builder shipToName(String shipToName) {
            this.shipToName = shipToName;
            this.changedFields = changedFields.add("shipToName");
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder totalAmountExcludingTax(BigDecimal totalAmountExcludingTax) {
            this.totalAmountExcludingTax = totalAmountExcludingTax;
            this.changedFields = changedFields.add("totalAmountExcludingTax");
            return this;
        }

        public Builder totalAmountIncludingTax(BigDecimal totalAmountIncludingTax) {
            this.totalAmountIncludingTax = totalAmountIncludingTax;
            this.changedFields = changedFields.add("totalAmountIncludingTax");
            return this;
        }

        public Builder totalTaxAmount(BigDecimal totalTaxAmount) {
            this.totalTaxAmount = totalTaxAmount;
            this.changedFields = changedFields.add("totalTaxAmount");
            return this;
        }

        public Builder vendorId(UUID vendorId) {
            this.vendorId = vendorId;
            this.changedFields = changedFields.add("vendorId");
            return this;
        }

        public Builder vendorInvoiceNumber(String vendorInvoiceNumber) {
            this.vendorInvoiceNumber = vendorInvoiceNumber;
            this.changedFields = changedFields.add("vendorInvoiceNumber");
            return this;
        }

        public Builder vendorName(String vendorName) {
            this.vendorName = vendorName;
            this.changedFields = changedFields.add("vendorName");
            return this;
        }

        public Builder vendorNumber(String vendorNumber) {
            this.vendorNumber = vendorNumber;
            this.changedFields = changedFields.add("vendorNumber");
            return this;
        }

        public Builder currency(Currency currency) {
            this.currency = currency;
            this.changedFields = changedFields.add("currency");
            return this;
        }

        public Builder purchaseInvoiceLines(List<PurchaseInvoiceLine> purchaseInvoiceLines) {
            this.purchaseInvoiceLines = purchaseInvoiceLines;
            this.changedFields = changedFields.add("purchaseInvoiceLines");
            return this;
        }

        public Builder purchaseInvoiceLines(PurchaseInvoiceLine... purchaseInvoiceLines) {
            return purchaseInvoiceLines(Arrays.asList(purchaseInvoiceLines));
        }

        public Builder vendor(Vendor vendor) {
            this.vendor = vendor;
            this.changedFields = changedFields.add("vendor");
            return this;
        }

        public PurchaseInvoice build() {
            PurchaseInvoice _x = new PurchaseInvoice();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.purchaseInvoice";
            _x.id = id;
            _x.buyFromAddress = buyFromAddress;
            _x.currencyCode = currencyCode;
            _x.currencyId = currencyId;
            _x.discountAmount = discountAmount;
            _x.discountAppliedBeforeTax = discountAppliedBeforeTax;
            _x.dueDate = dueDate;
            _x.invoiceDate = invoiceDate;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.number = number;
            _x.payToAddress = payToAddress;
            _x.payToContact = payToContact;
            _x.payToName = payToName;
            _x.payToVendorId = payToVendorId;
            _x.payToVendorNumber = payToVendorNumber;
            _x.pricesIncludeTax = pricesIncludeTax;
            _x.shipToAddress = shipToAddress;
            _x.shipToContact = shipToContact;
            _x.shipToName = shipToName;
            _x.status = status;
            _x.totalAmountExcludingTax = totalAmountExcludingTax;
            _x.totalAmountIncludingTax = totalAmountIncludingTax;
            _x.totalTaxAmount = totalTaxAmount;
            _x.vendorId = vendorId;
            _x.vendorInvoiceNumber = vendorInvoiceNumber;
            _x.vendorName = vendorName;
            _x.vendorNumber = vendorNumber;
            _x.currency = currency;
            _x.purchaseInvoiceLines = purchaseInvoiceLines;
            _x.vendor = vendor;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="buyFromAddress")
    @JsonIgnore
    public Optional<PostalAddressType> getBuyFromAddress() {
        return Optional.ofNullable(buyFromAddress);
    }

    public PurchaseInvoice withBuyFromAddress(PostalAddressType buyFromAddress) {
        PurchaseInvoice _x = _copy();
        _x.changedFields = changedFields.add("buyFromAddress");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoice");
        _x.buyFromAddress = buyFromAddress;
        return _x;
    }

    @Property(name="currencyCode")
    @JsonIgnore
    public Optional<String> getCurrencyCode() {
        return Optional.ofNullable(currencyCode);
    }

    public PurchaseInvoice withCurrencyCode(String currencyCode) {
        PurchaseInvoice _x = _copy();
        _x.changedFields = changedFields.add("currencyCode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoice");
        _x.currencyCode = currencyCode;
        return _x;
    }

    @Property(name="currencyId")
    @JsonIgnore
    public Optional<UUID> getCurrencyId() {
        return Optional.ofNullable(currencyId);
    }

    public PurchaseInvoice withCurrencyId(UUID currencyId) {
        PurchaseInvoice _x = _copy();
        _x.changedFields = changedFields.add("currencyId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoice");
        _x.currencyId = currencyId;
        return _x;
    }

    @Property(name="discountAmount")
    @JsonIgnore
    public Optional<BigDecimal> getDiscountAmount() {
        return Optional.ofNullable(discountAmount);
    }

    public PurchaseInvoice withDiscountAmount(BigDecimal discountAmount) {
        PurchaseInvoice _x = _copy();
        _x.changedFields = changedFields.add("discountAmount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoice");
        _x.discountAmount = discountAmount;
        return _x;
    }

    @Property(name="discountAppliedBeforeTax")
    @JsonIgnore
    public Optional<Boolean> getDiscountAppliedBeforeTax() {
        return Optional.ofNullable(discountAppliedBeforeTax);
    }

    public PurchaseInvoice withDiscountAppliedBeforeTax(Boolean discountAppliedBeforeTax) {
        PurchaseInvoice _x = _copy();
        _x.changedFields = changedFields.add("discountAppliedBeforeTax");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoice");
        _x.discountAppliedBeforeTax = discountAppliedBeforeTax;
        return _x;
    }

    @Property(name="dueDate")
    @JsonIgnore
    public Optional<LocalDate> getDueDate() {
        return Optional.ofNullable(dueDate);
    }

    public PurchaseInvoice withDueDate(LocalDate dueDate) {
        PurchaseInvoice _x = _copy();
        _x.changedFields = changedFields.add("dueDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoice");
        _x.dueDate = dueDate;
        return _x;
    }

    @Property(name="invoiceDate")
    @JsonIgnore
    public Optional<LocalDate> getInvoiceDate() {
        return Optional.ofNullable(invoiceDate);
    }

    public PurchaseInvoice withInvoiceDate(LocalDate invoiceDate) {
        PurchaseInvoice _x = _copy();
        _x.changedFields = changedFields.add("invoiceDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoice");
        _x.invoiceDate = invoiceDate;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public PurchaseInvoice withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        PurchaseInvoice _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoice");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="number")
    @JsonIgnore
    public Optional<String> getNumber() {
        return Optional.ofNullable(number);
    }

    public PurchaseInvoice withNumber(String number) {
        PurchaseInvoice _x = _copy();
        _x.changedFields = changedFields.add("number");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoice");
        _x.number = number;
        return _x;
    }

    @Property(name="payToAddress")
    @JsonIgnore
    public Optional<PostalAddressType> getPayToAddress() {
        return Optional.ofNullable(payToAddress);
    }

    public PurchaseInvoice withPayToAddress(PostalAddressType payToAddress) {
        PurchaseInvoice _x = _copy();
        _x.changedFields = changedFields.add("payToAddress");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoice");
        _x.payToAddress = payToAddress;
        return _x;
    }

    @Property(name="payToContact")
    @JsonIgnore
    public Optional<String> getPayToContact() {
        return Optional.ofNullable(payToContact);
    }

    public PurchaseInvoice withPayToContact(String payToContact) {
        PurchaseInvoice _x = _copy();
        _x.changedFields = changedFields.add("payToContact");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoice");
        _x.payToContact = payToContact;
        return _x;
    }

    @Property(name="payToName")
    @JsonIgnore
    public Optional<String> getPayToName() {
        return Optional.ofNullable(payToName);
    }

    public PurchaseInvoice withPayToName(String payToName) {
        PurchaseInvoice _x = _copy();
        _x.changedFields = changedFields.add("payToName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoice");
        _x.payToName = payToName;
        return _x;
    }

    @Property(name="payToVendorId")
    @JsonIgnore
    public Optional<UUID> getPayToVendorId() {
        return Optional.ofNullable(payToVendorId);
    }

    public PurchaseInvoice withPayToVendorId(UUID payToVendorId) {
        PurchaseInvoice _x = _copy();
        _x.changedFields = changedFields.add("payToVendorId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoice");
        _x.payToVendorId = payToVendorId;
        return _x;
    }

    @Property(name="payToVendorNumber")
    @JsonIgnore
    public Optional<String> getPayToVendorNumber() {
        return Optional.ofNullable(payToVendorNumber);
    }

    public PurchaseInvoice withPayToVendorNumber(String payToVendorNumber) {
        PurchaseInvoice _x = _copy();
        _x.changedFields = changedFields.add("payToVendorNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoice");
        _x.payToVendorNumber = payToVendorNumber;
        return _x;
    }

    @Property(name="pricesIncludeTax")
    @JsonIgnore
    public Optional<Boolean> getPricesIncludeTax() {
        return Optional.ofNullable(pricesIncludeTax);
    }

    public PurchaseInvoice withPricesIncludeTax(Boolean pricesIncludeTax) {
        PurchaseInvoice _x = _copy();
        _x.changedFields = changedFields.add("pricesIncludeTax");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoice");
        _x.pricesIncludeTax = pricesIncludeTax;
        return _x;
    }

    @Property(name="shipToAddress")
    @JsonIgnore
    public Optional<PostalAddressType> getShipToAddress() {
        return Optional.ofNullable(shipToAddress);
    }

    public PurchaseInvoice withShipToAddress(PostalAddressType shipToAddress) {
        PurchaseInvoice _x = _copy();
        _x.changedFields = changedFields.add("shipToAddress");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoice");
        _x.shipToAddress = shipToAddress;
        return _x;
    }

    @Property(name="shipToContact")
    @JsonIgnore
    public Optional<String> getShipToContact() {
        return Optional.ofNullable(shipToContact);
    }

    public PurchaseInvoice withShipToContact(String shipToContact) {
        PurchaseInvoice _x = _copy();
        _x.changedFields = changedFields.add("shipToContact");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoice");
        _x.shipToContact = shipToContact;
        return _x;
    }

    @Property(name="shipToName")
    @JsonIgnore
    public Optional<String> getShipToName() {
        return Optional.ofNullable(shipToName);
    }

    public PurchaseInvoice withShipToName(String shipToName) {
        PurchaseInvoice _x = _copy();
        _x.changedFields = changedFields.add("shipToName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoice");
        _x.shipToName = shipToName;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<String> getStatus() {
        return Optional.ofNullable(status);
    }

    public PurchaseInvoice withStatus(String status) {
        PurchaseInvoice _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoice");
        _x.status = status;
        return _x;
    }

    @Property(name="totalAmountExcludingTax")
    @JsonIgnore
    public Optional<BigDecimal> getTotalAmountExcludingTax() {
        return Optional.ofNullable(totalAmountExcludingTax);
    }

    public PurchaseInvoice withTotalAmountExcludingTax(BigDecimal totalAmountExcludingTax) {
        PurchaseInvoice _x = _copy();
        _x.changedFields = changedFields.add("totalAmountExcludingTax");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoice");
        _x.totalAmountExcludingTax = totalAmountExcludingTax;
        return _x;
    }

    @Property(name="totalAmountIncludingTax")
    @JsonIgnore
    public Optional<BigDecimal> getTotalAmountIncludingTax() {
        return Optional.ofNullable(totalAmountIncludingTax);
    }

    public PurchaseInvoice withTotalAmountIncludingTax(BigDecimal totalAmountIncludingTax) {
        PurchaseInvoice _x = _copy();
        _x.changedFields = changedFields.add("totalAmountIncludingTax");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoice");
        _x.totalAmountIncludingTax = totalAmountIncludingTax;
        return _x;
    }

    @Property(name="totalTaxAmount")
    @JsonIgnore
    public Optional<BigDecimal> getTotalTaxAmount() {
        return Optional.ofNullable(totalTaxAmount);
    }

    public PurchaseInvoice withTotalTaxAmount(BigDecimal totalTaxAmount) {
        PurchaseInvoice _x = _copy();
        _x.changedFields = changedFields.add("totalTaxAmount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoice");
        _x.totalTaxAmount = totalTaxAmount;
        return _x;
    }

    @Property(name="vendorId")
    @JsonIgnore
    public Optional<UUID> getVendorId() {
        return Optional.ofNullable(vendorId);
    }

    public PurchaseInvoice withVendorId(UUID vendorId) {
        PurchaseInvoice _x = _copy();
        _x.changedFields = changedFields.add("vendorId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoice");
        _x.vendorId = vendorId;
        return _x;
    }

    @Property(name="vendorInvoiceNumber")
    @JsonIgnore
    public Optional<String> getVendorInvoiceNumber() {
        return Optional.ofNullable(vendorInvoiceNumber);
    }

    public PurchaseInvoice withVendorInvoiceNumber(String vendorInvoiceNumber) {
        PurchaseInvoice _x = _copy();
        _x.changedFields = changedFields.add("vendorInvoiceNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoice");
        _x.vendorInvoiceNumber = vendorInvoiceNumber;
        return _x;
    }

    @Property(name="vendorName")
    @JsonIgnore
    public Optional<String> getVendorName() {
        return Optional.ofNullable(vendorName);
    }

    public PurchaseInvoice withVendorName(String vendorName) {
        PurchaseInvoice _x = _copy();
        _x.changedFields = changedFields.add("vendorName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoice");
        _x.vendorName = vendorName;
        return _x;
    }

    @Property(name="vendorNumber")
    @JsonIgnore
    public Optional<String> getVendorNumber() {
        return Optional.ofNullable(vendorNumber);
    }

    public PurchaseInvoice withVendorNumber(String vendorNumber) {
        PurchaseInvoice _x = _copy();
        _x.changedFields = changedFields.add("vendorNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoice");
        _x.vendorNumber = vendorNumber;
        return _x;
    }

    public PurchaseInvoice withUnmappedField(String name, Object value) {
        PurchaseInvoice _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="currency")
    @JsonIgnore
    public CurrencyRequest getCurrency() {
        return new CurrencyRequest(contextPath.addSegment("currency"), Optional.ofNullable(currency));
    }

    @NavigationProperty(name="purchaseInvoiceLines")
    @JsonIgnore
    public PurchaseInvoiceLineCollectionRequest getPurchaseInvoiceLines() {
        return new PurchaseInvoiceLineCollectionRequest(
                        contextPath.addSegment("purchaseInvoiceLines"), Optional.ofNullable(purchaseInvoiceLines));
    }

    @NavigationProperty(name="vendor")
    @JsonIgnore
    public VendorRequest getVendor() {
        return new VendorRequest(contextPath.addSegment("vendor"), Optional.ofNullable(vendor));
    }

    public PurchaseInvoice withCurrency(Currency currency) {
        PurchaseInvoice _x = _copy();
        _x.changedFields = changedFields.add("currency");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoice");
        _x.currency = currency;
        return _x;
    }

    public PurchaseInvoice withPurchaseInvoiceLines(List<PurchaseInvoiceLine> purchaseInvoiceLines) {
        PurchaseInvoice _x = _copy();
        _x.changedFields = changedFields.add("purchaseInvoiceLines");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoice");
        _x.purchaseInvoiceLines = purchaseInvoiceLines;
        return _x;
    }

    public PurchaseInvoice withVendor(Vendor vendor) {
        PurchaseInvoice _x = _copy();
        _x.changedFields = changedFields.add("vendor");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.purchaseInvoice");
        _x.vendor = vendor;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PurchaseInvoice patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        PurchaseInvoice _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PurchaseInvoice put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        PurchaseInvoice _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private PurchaseInvoice _copy() {
        PurchaseInvoice _x = new PurchaseInvoice();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.buyFromAddress = buyFromAddress;
        _x.currencyCode = currencyCode;
        _x.currencyId = currencyId;
        _x.discountAmount = discountAmount;
        _x.discountAppliedBeforeTax = discountAppliedBeforeTax;
        _x.dueDate = dueDate;
        _x.invoiceDate = invoiceDate;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.number = number;
        _x.payToAddress = payToAddress;
        _x.payToContact = payToContact;
        _x.payToName = payToName;
        _x.payToVendorId = payToVendorId;
        _x.payToVendorNumber = payToVendorNumber;
        _x.pricesIncludeTax = pricesIncludeTax;
        _x.shipToAddress = shipToAddress;
        _x.shipToContact = shipToContact;
        _x.shipToName = shipToName;
        _x.status = status;
        _x.totalAmountExcludingTax = totalAmountExcludingTax;
        _x.totalAmountIncludingTax = totalAmountIncludingTax;
        _x.totalTaxAmount = totalTaxAmount;
        _x.vendorId = vendorId;
        _x.vendorInvoiceNumber = vendorInvoiceNumber;
        _x.vendorName = vendorName;
        _x.vendorNumber = vendorNumber;
        _x.currency = currency;
        _x.purchaseInvoiceLines = purchaseInvoiceLines;
        _x.vendor = vendor;
        return _x;
    }

    @Action(name = "post")
    @JsonIgnore
    public ActionRequestNoReturn post() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.post"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PurchaseInvoice[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("buyFromAddress=");
        b.append(this.buyFromAddress);
        b.append(", ");
        b.append("currencyCode=");
        b.append(this.currencyCode);
        b.append(", ");
        b.append("currencyId=");
        b.append(this.currencyId);
        b.append(", ");
        b.append("discountAmount=");
        b.append(this.discountAmount);
        b.append(", ");
        b.append("discountAppliedBeforeTax=");
        b.append(this.discountAppliedBeforeTax);
        b.append(", ");
        b.append("dueDate=");
        b.append(this.dueDate);
        b.append(", ");
        b.append("invoiceDate=");
        b.append(this.invoiceDate);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("number=");
        b.append(this.number);
        b.append(", ");
        b.append("payToAddress=");
        b.append(this.payToAddress);
        b.append(", ");
        b.append("payToContact=");
        b.append(this.payToContact);
        b.append(", ");
        b.append("payToName=");
        b.append(this.payToName);
        b.append(", ");
        b.append("payToVendorId=");
        b.append(this.payToVendorId);
        b.append(", ");
        b.append("payToVendorNumber=");
        b.append(this.payToVendorNumber);
        b.append(", ");
        b.append("pricesIncludeTax=");
        b.append(this.pricesIncludeTax);
        b.append(", ");
        b.append("shipToAddress=");
        b.append(this.shipToAddress);
        b.append(", ");
        b.append("shipToContact=");
        b.append(this.shipToContact);
        b.append(", ");
        b.append("shipToName=");
        b.append(this.shipToName);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("totalAmountExcludingTax=");
        b.append(this.totalAmountExcludingTax);
        b.append(", ");
        b.append("totalAmountIncludingTax=");
        b.append(this.totalAmountIncludingTax);
        b.append(", ");
        b.append("totalTaxAmount=");
        b.append(this.totalTaxAmount);
        b.append(", ");
        b.append("vendorId=");
        b.append(this.vendorId);
        b.append(", ");
        b.append("vendorInvoiceNumber=");
        b.append(this.vendorInvoiceNumber);
        b.append(", ");
        b.append("vendorName=");
        b.append(this.vendorName);
        b.append(", ");
        b.append("vendorNumber=");
        b.append(this.vendorNumber);
        b.append(", ");
        b.append("currency=");
        b.append(this.currency);
        b.append(", ");
        b.append("purchaseInvoiceLines=");
        b.append(this.purchaseInvoiceLines);
        b.append(", ");
        b.append("vendor=");
        b.append(this.vendor);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
