package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.CountRestrictions</b>
 * <p>
 * Countable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
 * <p>
 * Filterable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.SelectRestrictions</b>
 * <p>
 * Selectable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.SkipSupported</b>
 * <p>
 * true
 * <p>
 * <b>Org.OData.Capabilities.V1.SortRestrictions</b>
 * <p>
 * Sortable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.TopSupported</b>
 * <p>
 * true
 */@JsonPropertyOrder({
    "@odata.type", 
    "azureTenantId", 
    "enabled", 
    "lastModifiedDateTime", 
    "provider", 
    "vendor"})
@JsonInclude(Include.NON_NULL)
public class ProviderTenantSetting extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.providerTenantSetting";
    }

    @JsonProperty("azureTenantId")
    protected String azureTenantId;

    @JsonProperty("enabled")
    protected Boolean enabled;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("provider")
    protected String provider;

    @JsonProperty("vendor")
    protected String vendor;

    protected ProviderTenantSetting() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderProviderTenantSetting() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String azureTenantId;
        private Boolean enabled;
        private OffsetDateTime lastModifiedDateTime;
        private String provider;
        private String vendor;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder azureTenantId(String azureTenantId) {
            this.azureTenantId = azureTenantId;
            this.changedFields = changedFields.add("azureTenantId");
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            this.changedFields = changedFields.add("enabled");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder provider(String provider) {
            this.provider = provider;
            this.changedFields = changedFields.add("provider");
            return this;
        }

        public Builder vendor(String vendor) {
            this.vendor = vendor;
            this.changedFields = changedFields.add("vendor");
            return this;
        }

        public ProviderTenantSetting build() {
            ProviderTenantSetting _x = new ProviderTenantSetting();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.providerTenantSetting";
            _x.id = id;
            _x.azureTenantId = azureTenantId;
            _x.enabled = enabled;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.provider = provider;
            _x.vendor = vendor;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="azureTenantId")
    @JsonIgnore
    public Optional<String> getAzureTenantId() {
        return Optional.ofNullable(azureTenantId);
    }

    public ProviderTenantSetting withAzureTenantId(String azureTenantId) {
        ProviderTenantSetting _x = _copy();
        _x.changedFields = changedFields.add("azureTenantId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.providerTenantSetting");
        _x.azureTenantId = azureTenantId;
        return _x;
    }

    @Property(name="enabled")
    @JsonIgnore
    public Optional<Boolean> getEnabled() {
        return Optional.ofNullable(enabled);
    }

    public ProviderTenantSetting withEnabled(Boolean enabled) {
        ProviderTenantSetting _x = _copy();
        _x.changedFields = changedFields.add("enabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.providerTenantSetting");
        _x.enabled = enabled;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public ProviderTenantSetting withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        ProviderTenantSetting _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.providerTenantSetting");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="provider")
    @JsonIgnore
    public Optional<String> getProvider() {
        return Optional.ofNullable(provider);
    }

    public ProviderTenantSetting withProvider(String provider) {
        ProviderTenantSetting _x = _copy();
        _x.changedFields = changedFields.add("provider");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.providerTenantSetting");
        _x.provider = provider;
        return _x;
    }

    @Property(name="vendor")
    @JsonIgnore
    public Optional<String> getVendor() {
        return Optional.ofNullable(vendor);
    }

    public ProviderTenantSetting withVendor(String vendor) {
        ProviderTenantSetting _x = _copy();
        _x.changedFields = changedFields.add("vendor");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.providerTenantSetting");
        _x.vendor = vendor;
        return _x;
    }

    public ProviderTenantSetting withUnmappedField(String name, Object value) {
        ProviderTenantSetting _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ProviderTenantSetting patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ProviderTenantSetting _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ProviderTenantSetting put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ProviderTenantSetting _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ProviderTenantSetting _copy() {
        ProviderTenantSetting _x = new ProviderTenantSetting();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.azureTenantId = azureTenantId;
        _x.enabled = enabled;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.provider = provider;
        _x.vendor = vendor;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ProviderTenantSetting[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("azureTenantId=");
        b.append(this.azureTenantId);
        b.append(", ");
        b.append("enabled=");
        b.append(this.enabled);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("provider=");
        b.append(this.provider);
        b.append(", ");
        b.append("vendor=");
        b.append(this.vendor);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
