package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.EducationalActivityCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ItemAddressCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ItemEmailCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ItemPatentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ItemPhoneCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ItemPublicationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.LanguageProficiencyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PersonAnnotationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PersonAnnualEventCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PersonAwardCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PersonCertificationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PersonInterestCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PersonNameCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PersonWebsiteCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ProjectParticipationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SkillProficiencyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserAccountInformationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WebAccountCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WorkPositionCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "account", 
    "addresses", 
    "anniversaries", 
    "awards", 
    "certifications", 
    "educationalActivities", 
    "emails", 
    "interests", 
    "languages", 
    "names", 
    "notes", 
    "patents", 
    "phones", 
    "positions", 
    "projects", 
    "publications", 
    "skills", 
    "webAccounts", 
    "websites"})
@JsonInclude(Include.NON_NULL)
public class Profile extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.profile";
    }

    @JsonProperty("account")
    protected List<UserAccountInformation> account;

    @JsonProperty("addresses")
    protected List<ItemAddress> addresses;

    @JsonProperty("anniversaries")
    protected List<PersonAnnualEvent> anniversaries;

    @JsonProperty("awards")
    protected List<PersonAward> awards;

    @JsonProperty("certifications")
    protected List<PersonCertification> certifications;

    @JsonProperty("educationalActivities")
    protected List<EducationalActivity> educationalActivities;

    @JsonProperty("emails")
    protected List<ItemEmail> emails;

    @JsonProperty("interests")
    protected List<PersonInterest> interests;

    @JsonProperty("languages")
    protected List<LanguageProficiency> languages;

    @JsonProperty("names")
    protected List<PersonName> names;

    @JsonProperty("notes")
    protected List<PersonAnnotation> notes;

    @JsonProperty("patents")
    protected List<ItemPatent> patents;

    @JsonProperty("phones")
    protected List<ItemPhone> phones;

    @JsonProperty("positions")
    protected List<WorkPosition> positions;

    @JsonProperty("projects")
    protected List<ProjectParticipation> projects;

    @JsonProperty("publications")
    protected List<ItemPublication> publications;

    @JsonProperty("skills")
    protected List<SkillProficiency> skills;

    @JsonProperty("webAccounts")
    protected List<WebAccount> webAccounts;

    @JsonProperty("websites")
    protected List<PersonWebsite> websites;

    protected Profile() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderProfile() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<UserAccountInformation> account;
        private List<ItemAddress> addresses;
        private List<PersonAnnualEvent> anniversaries;
        private List<PersonAward> awards;
        private List<PersonCertification> certifications;
        private List<EducationalActivity> educationalActivities;
        private List<ItemEmail> emails;
        private List<PersonInterest> interests;
        private List<LanguageProficiency> languages;
        private List<PersonName> names;
        private List<PersonAnnotation> notes;
        private List<ItemPatent> patents;
        private List<ItemPhone> phones;
        private List<WorkPosition> positions;
        private List<ProjectParticipation> projects;
        private List<ItemPublication> publications;
        private List<SkillProficiency> skills;
        private List<WebAccount> webAccounts;
        private List<PersonWebsite> websites;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder account(List<UserAccountInformation> account) {
            this.account = account;
            this.changedFields = changedFields.add("account");
            return this;
        }

        public Builder account(UserAccountInformation... account) {
            return account(Arrays.asList(account));
        }

        public Builder addresses(List<ItemAddress> addresses) {
            this.addresses = addresses;
            this.changedFields = changedFields.add("addresses");
            return this;
        }

        public Builder addresses(ItemAddress... addresses) {
            return addresses(Arrays.asList(addresses));
        }

        public Builder anniversaries(List<PersonAnnualEvent> anniversaries) {
            this.anniversaries = anniversaries;
            this.changedFields = changedFields.add("anniversaries");
            return this;
        }

        public Builder anniversaries(PersonAnnualEvent... anniversaries) {
            return anniversaries(Arrays.asList(anniversaries));
        }

        public Builder awards(List<PersonAward> awards) {
            this.awards = awards;
            this.changedFields = changedFields.add("awards");
            return this;
        }

        public Builder awards(PersonAward... awards) {
            return awards(Arrays.asList(awards));
        }

        public Builder certifications(List<PersonCertification> certifications) {
            this.certifications = certifications;
            this.changedFields = changedFields.add("certifications");
            return this;
        }

        public Builder certifications(PersonCertification... certifications) {
            return certifications(Arrays.asList(certifications));
        }

        public Builder educationalActivities(List<EducationalActivity> educationalActivities) {
            this.educationalActivities = educationalActivities;
            this.changedFields = changedFields.add("educationalActivities");
            return this;
        }

        public Builder educationalActivities(EducationalActivity... educationalActivities) {
            return educationalActivities(Arrays.asList(educationalActivities));
        }

        public Builder emails(List<ItemEmail> emails) {
            this.emails = emails;
            this.changedFields = changedFields.add("emails");
            return this;
        }

        public Builder emails(ItemEmail... emails) {
            return emails(Arrays.asList(emails));
        }

        public Builder interests(List<PersonInterest> interests) {
            this.interests = interests;
            this.changedFields = changedFields.add("interests");
            return this;
        }

        public Builder interests(PersonInterest... interests) {
            return interests(Arrays.asList(interests));
        }

        public Builder languages(List<LanguageProficiency> languages) {
            this.languages = languages;
            this.changedFields = changedFields.add("languages");
            return this;
        }

        public Builder languages(LanguageProficiency... languages) {
            return languages(Arrays.asList(languages));
        }

        public Builder names(List<PersonName> names) {
            this.names = names;
            this.changedFields = changedFields.add("names");
            return this;
        }

        public Builder names(PersonName... names) {
            return names(Arrays.asList(names));
        }

        public Builder notes(List<PersonAnnotation> notes) {
            this.notes = notes;
            this.changedFields = changedFields.add("notes");
            return this;
        }

        public Builder notes(PersonAnnotation... notes) {
            return notes(Arrays.asList(notes));
        }

        public Builder patents(List<ItemPatent> patents) {
            this.patents = patents;
            this.changedFields = changedFields.add("patents");
            return this;
        }

        public Builder patents(ItemPatent... patents) {
            return patents(Arrays.asList(patents));
        }

        public Builder phones(List<ItemPhone> phones) {
            this.phones = phones;
            this.changedFields = changedFields.add("phones");
            return this;
        }

        public Builder phones(ItemPhone... phones) {
            return phones(Arrays.asList(phones));
        }

        public Builder positions(List<WorkPosition> positions) {
            this.positions = positions;
            this.changedFields = changedFields.add("positions");
            return this;
        }

        public Builder positions(WorkPosition... positions) {
            return positions(Arrays.asList(positions));
        }

        public Builder projects(List<ProjectParticipation> projects) {
            this.projects = projects;
            this.changedFields = changedFields.add("projects");
            return this;
        }

        public Builder projects(ProjectParticipation... projects) {
            return projects(Arrays.asList(projects));
        }

        public Builder publications(List<ItemPublication> publications) {
            this.publications = publications;
            this.changedFields = changedFields.add("publications");
            return this;
        }

        public Builder publications(ItemPublication... publications) {
            return publications(Arrays.asList(publications));
        }

        public Builder skills(List<SkillProficiency> skills) {
            this.skills = skills;
            this.changedFields = changedFields.add("skills");
            return this;
        }

        public Builder skills(SkillProficiency... skills) {
            return skills(Arrays.asList(skills));
        }

        public Builder webAccounts(List<WebAccount> webAccounts) {
            this.webAccounts = webAccounts;
            this.changedFields = changedFields.add("webAccounts");
            return this;
        }

        public Builder webAccounts(WebAccount... webAccounts) {
            return webAccounts(Arrays.asList(webAccounts));
        }

        public Builder websites(List<PersonWebsite> websites) {
            this.websites = websites;
            this.changedFields = changedFields.add("websites");
            return this;
        }

        public Builder websites(PersonWebsite... websites) {
            return websites(Arrays.asList(websites));
        }

        public Profile build() {
            Profile _x = new Profile();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.profile";
            _x.id = id;
            _x.account = account;
            _x.addresses = addresses;
            _x.anniversaries = anniversaries;
            _x.awards = awards;
            _x.certifications = certifications;
            _x.educationalActivities = educationalActivities;
            _x.emails = emails;
            _x.interests = interests;
            _x.languages = languages;
            _x.names = names;
            _x.notes = notes;
            _x.patents = patents;
            _x.phones = phones;
            _x.positions = positions;
            _x.projects = projects;
            _x.publications = publications;
            _x.skills = skills;
            _x.webAccounts = webAccounts;
            _x.websites = websites;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public Profile withUnmappedField(String name, Object value) {
        Profile _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="account")
    @JsonIgnore
    public UserAccountInformationCollectionRequest getAccount() {
        return new UserAccountInformationCollectionRequest(
                        contextPath.addSegment("account"), Optional.ofNullable(account));
    }

    @NavigationProperty(name="addresses")
    @JsonIgnore
    public ItemAddressCollectionRequest getAddresses() {
        return new ItemAddressCollectionRequest(
                        contextPath.addSegment("addresses"), Optional.ofNullable(addresses));
    }

    @NavigationProperty(name="anniversaries")
    @JsonIgnore
    public PersonAnnualEventCollectionRequest getAnniversaries() {
        return new PersonAnnualEventCollectionRequest(
                        contextPath.addSegment("anniversaries"), Optional.ofNullable(anniversaries));
    }

    @NavigationProperty(name="awards")
    @JsonIgnore
    public PersonAwardCollectionRequest getAwards() {
        return new PersonAwardCollectionRequest(
                        contextPath.addSegment("awards"), Optional.ofNullable(awards));
    }

    @NavigationProperty(name="certifications")
    @JsonIgnore
    public PersonCertificationCollectionRequest getCertifications() {
        return new PersonCertificationCollectionRequest(
                        contextPath.addSegment("certifications"), Optional.ofNullable(certifications));
    }

    @NavigationProperty(name="educationalActivities")
    @JsonIgnore
    public EducationalActivityCollectionRequest getEducationalActivities() {
        return new EducationalActivityCollectionRequest(
                        contextPath.addSegment("educationalActivities"), Optional.ofNullable(educationalActivities));
    }

    @NavigationProperty(name="emails")
    @JsonIgnore
    public ItemEmailCollectionRequest getEmails() {
        return new ItemEmailCollectionRequest(
                        contextPath.addSegment("emails"), Optional.ofNullable(emails));
    }

    @NavigationProperty(name="interests")
    @JsonIgnore
    public PersonInterestCollectionRequest getInterests() {
        return new PersonInterestCollectionRequest(
                        contextPath.addSegment("interests"), Optional.ofNullable(interests));
    }

    @NavigationProperty(name="languages")
    @JsonIgnore
    public LanguageProficiencyCollectionRequest getLanguages() {
        return new LanguageProficiencyCollectionRequest(
                        contextPath.addSegment("languages"), Optional.ofNullable(languages));
    }

    @NavigationProperty(name="names")
    @JsonIgnore
    public PersonNameCollectionRequest getNames() {
        return new PersonNameCollectionRequest(
                        contextPath.addSegment("names"), Optional.ofNullable(names));
    }

    @NavigationProperty(name="notes")
    @JsonIgnore
    public PersonAnnotationCollectionRequest getNotes() {
        return new PersonAnnotationCollectionRequest(
                        contextPath.addSegment("notes"), Optional.ofNullable(notes));
    }

    @NavigationProperty(name="patents")
    @JsonIgnore
    public ItemPatentCollectionRequest getPatents() {
        return new ItemPatentCollectionRequest(
                        contextPath.addSegment("patents"), Optional.ofNullable(patents));
    }

    @NavigationProperty(name="phones")
    @JsonIgnore
    public ItemPhoneCollectionRequest getPhones() {
        return new ItemPhoneCollectionRequest(
                        contextPath.addSegment("phones"), Optional.ofNullable(phones));
    }

    @NavigationProperty(name="positions")
    @JsonIgnore
    public WorkPositionCollectionRequest getPositions() {
        return new WorkPositionCollectionRequest(
                        contextPath.addSegment("positions"), Optional.ofNullable(positions));
    }

    @NavigationProperty(name="projects")
    @JsonIgnore
    public ProjectParticipationCollectionRequest getProjects() {
        return new ProjectParticipationCollectionRequest(
                        contextPath.addSegment("projects"), Optional.ofNullable(projects));
    }

    @NavigationProperty(name="publications")
    @JsonIgnore
    public ItemPublicationCollectionRequest getPublications() {
        return new ItemPublicationCollectionRequest(
                        contextPath.addSegment("publications"), Optional.ofNullable(publications));
    }

    @NavigationProperty(name="skills")
    @JsonIgnore
    public SkillProficiencyCollectionRequest getSkills() {
        return new SkillProficiencyCollectionRequest(
                        contextPath.addSegment("skills"), Optional.ofNullable(skills));
    }

    @NavigationProperty(name="webAccounts")
    @JsonIgnore
    public WebAccountCollectionRequest getWebAccounts() {
        return new WebAccountCollectionRequest(
                        contextPath.addSegment("webAccounts"), Optional.ofNullable(webAccounts));
    }

    @NavigationProperty(name="websites")
    @JsonIgnore
    public PersonWebsiteCollectionRequest getWebsites() {
        return new PersonWebsiteCollectionRequest(
                        contextPath.addSegment("websites"), Optional.ofNullable(websites));
    }

    public Profile withAccount(List<UserAccountInformation> account) {
        Profile _x = _copy();
        _x.changedFields = changedFields.add("account");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.profile");
        _x.account = account;
        return _x;
    }

    public Profile withAddresses(List<ItemAddress> addresses) {
        Profile _x = _copy();
        _x.changedFields = changedFields.add("addresses");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.profile");
        _x.addresses = addresses;
        return _x;
    }

    public Profile withAnniversaries(List<PersonAnnualEvent> anniversaries) {
        Profile _x = _copy();
        _x.changedFields = changedFields.add("anniversaries");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.profile");
        _x.anniversaries = anniversaries;
        return _x;
    }

    public Profile withAwards(List<PersonAward> awards) {
        Profile _x = _copy();
        _x.changedFields = changedFields.add("awards");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.profile");
        _x.awards = awards;
        return _x;
    }

    public Profile withCertifications(List<PersonCertification> certifications) {
        Profile _x = _copy();
        _x.changedFields = changedFields.add("certifications");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.profile");
        _x.certifications = certifications;
        return _x;
    }

    public Profile withEducationalActivities(List<EducationalActivity> educationalActivities) {
        Profile _x = _copy();
        _x.changedFields = changedFields.add("educationalActivities");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.profile");
        _x.educationalActivities = educationalActivities;
        return _x;
    }

    public Profile withEmails(List<ItemEmail> emails) {
        Profile _x = _copy();
        _x.changedFields = changedFields.add("emails");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.profile");
        _x.emails = emails;
        return _x;
    }

    public Profile withInterests(List<PersonInterest> interests) {
        Profile _x = _copy();
        _x.changedFields = changedFields.add("interests");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.profile");
        _x.interests = interests;
        return _x;
    }

    public Profile withLanguages(List<LanguageProficiency> languages) {
        Profile _x = _copy();
        _x.changedFields = changedFields.add("languages");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.profile");
        _x.languages = languages;
        return _x;
    }

    public Profile withNames(List<PersonName> names) {
        Profile _x = _copy();
        _x.changedFields = changedFields.add("names");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.profile");
        _x.names = names;
        return _x;
    }

    public Profile withNotes(List<PersonAnnotation> notes) {
        Profile _x = _copy();
        _x.changedFields = changedFields.add("notes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.profile");
        _x.notes = notes;
        return _x;
    }

    public Profile withPatents(List<ItemPatent> patents) {
        Profile _x = _copy();
        _x.changedFields = changedFields.add("patents");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.profile");
        _x.patents = patents;
        return _x;
    }

    public Profile withPhones(List<ItemPhone> phones) {
        Profile _x = _copy();
        _x.changedFields = changedFields.add("phones");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.profile");
        _x.phones = phones;
        return _x;
    }

    public Profile withPositions(List<WorkPosition> positions) {
        Profile _x = _copy();
        _x.changedFields = changedFields.add("positions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.profile");
        _x.positions = positions;
        return _x;
    }

    public Profile withProjects(List<ProjectParticipation> projects) {
        Profile _x = _copy();
        _x.changedFields = changedFields.add("projects");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.profile");
        _x.projects = projects;
        return _x;
    }

    public Profile withPublications(List<ItemPublication> publications) {
        Profile _x = _copy();
        _x.changedFields = changedFields.add("publications");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.profile");
        _x.publications = publications;
        return _x;
    }

    public Profile withSkills(List<SkillProficiency> skills) {
        Profile _x = _copy();
        _x.changedFields = changedFields.add("skills");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.profile");
        _x.skills = skills;
        return _x;
    }

    public Profile withWebAccounts(List<WebAccount> webAccounts) {
        Profile _x = _copy();
        _x.changedFields = changedFields.add("webAccounts");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.profile");
        _x.webAccounts = webAccounts;
        return _x;
    }

    public Profile withWebsites(List<PersonWebsite> websites) {
        Profile _x = _copy();
        _x.changedFields = changedFields.add("websites");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.profile");
        _x.websites = websites;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Profile patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Profile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Profile put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Profile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Profile _copy() {
        Profile _x = new Profile();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.account = account;
        _x.addresses = addresses;
        _x.anniversaries = anniversaries;
        _x.awards = awards;
        _x.certifications = certifications;
        _x.educationalActivities = educationalActivities;
        _x.emails = emails;
        _x.interests = interests;
        _x.languages = languages;
        _x.names = names;
        _x.notes = notes;
        _x.patents = patents;
        _x.phones = phones;
        _x.positions = positions;
        _x.projects = projects;
        _x.publications = publications;
        _x.skills = skills;
        _x.webAccounts = webAccounts;
        _x.websites = websites;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Profile[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("account=");
        b.append(this.account);
        b.append(", ");
        b.append("addresses=");
        b.append(this.addresses);
        b.append(", ");
        b.append("anniversaries=");
        b.append(this.anniversaries);
        b.append(", ");
        b.append("awards=");
        b.append(this.awards);
        b.append(", ");
        b.append("certifications=");
        b.append(this.certifications);
        b.append(", ");
        b.append("educationalActivities=");
        b.append(this.educationalActivities);
        b.append(", ");
        b.append("emails=");
        b.append(this.emails);
        b.append(", ");
        b.append("interests=");
        b.append(this.interests);
        b.append(", ");
        b.append("languages=");
        b.append(this.languages);
        b.append(", ");
        b.append("names=");
        b.append(this.names);
        b.append(", ");
        b.append("notes=");
        b.append(this.notes);
        b.append(", ");
        b.append("patents=");
        b.append(this.patents);
        b.append(", ");
        b.append("phones=");
        b.append(this.phones);
        b.append(", ");
        b.append("positions=");
        b.append(this.positions);
        b.append(", ");
        b.append("projects=");
        b.append(this.projects);
        b.append(", ");
        b.append("publications=");
        b.append(this.publications);
        b.append(", ");
        b.append("skills=");
        b.append(this.skills);
        b.append(", ");
        b.append("webAccounts=");
        b.append(this.webAccounts);
        b.append(", ");
        b.append("websites=");
        b.append(this.websites);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
