package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.entity.request.PrivilegedRoleAssignmentRequestRequest;
import odata.msgraph.client.beta.entity.request.PrivilegedRoleRequest;
import odata.msgraph.client.beta.enums.ApprovalState;

@JsonPropertyOrder({
    "@odata.type", 
    "approvalDuration", 
    "approvalState", 
    "approvalType", 
    "approverReason", 
    "endDateTime", 
    "requestorReason", 
    "roleId", 
    "startDateTime", 
    "userId", 
    "roleInfo"})
@JsonInclude(Include.NON_NULL)
public class PrivilegedApproval extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.privilegedApproval";
    }

    @JsonProperty("approvalDuration")
    protected Duration approvalDuration;

    @JsonProperty("approvalState")
    protected ApprovalState approvalState;

    @JsonProperty("approvalType")
    protected String approvalType;

    @JsonProperty("approverReason")
    protected String approverReason;

    @JsonProperty("endDateTime")
    protected OffsetDateTime endDateTime;

    @JsonProperty("requestorReason")
    protected String requestorReason;

    @JsonProperty("roleId")
    protected String roleId;

    @JsonProperty("startDateTime")
    protected OffsetDateTime startDateTime;

    @JsonProperty("userId")
    protected String userId;

    @JsonProperty("roleInfo")
    protected PrivilegedRole roleInfo;

    protected PrivilegedApproval() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPrivilegedApproval() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Duration approvalDuration;
        private ApprovalState approvalState;
        private String approvalType;
        private String approverReason;
        private OffsetDateTime endDateTime;
        private String requestorReason;
        private String roleId;
        private OffsetDateTime startDateTime;
        private String userId;
        private PrivilegedRole roleInfo;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder approvalDuration(Duration approvalDuration) {
            this.approvalDuration = approvalDuration;
            this.changedFields = changedFields.add("approvalDuration");
            return this;
        }

        public Builder approvalState(ApprovalState approvalState) {
            this.approvalState = approvalState;
            this.changedFields = changedFields.add("approvalState");
            return this;
        }

        public Builder approvalType(String approvalType) {
            this.approvalType = approvalType;
            this.changedFields = changedFields.add("approvalType");
            return this;
        }

        public Builder approverReason(String approverReason) {
            this.approverReason = approverReason;
            this.changedFields = changedFields.add("approverReason");
            return this;
        }

        public Builder endDateTime(OffsetDateTime endDateTime) {
            this.endDateTime = endDateTime;
            this.changedFields = changedFields.add("endDateTime");
            return this;
        }

        public Builder requestorReason(String requestorReason) {
            this.requestorReason = requestorReason;
            this.changedFields = changedFields.add("requestorReason");
            return this;
        }

        public Builder roleId(String roleId) {
            this.roleId = roleId;
            this.changedFields = changedFields.add("roleId");
            return this;
        }

        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            this.changedFields = changedFields.add("userId");
            return this;
        }

        public Builder roleInfo(PrivilegedRole roleInfo) {
            this.roleInfo = roleInfo;
            this.changedFields = changedFields.add("roleInfo");
            return this;
        }

        public PrivilegedApproval build() {
            PrivilegedApproval _x = new PrivilegedApproval();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.privilegedApproval";
            _x.id = id;
            _x.approvalDuration = approvalDuration;
            _x.approvalState = approvalState;
            _x.approvalType = approvalType;
            _x.approverReason = approverReason;
            _x.endDateTime = endDateTime;
            _x.requestorReason = requestorReason;
            _x.roleId = roleId;
            _x.startDateTime = startDateTime;
            _x.userId = userId;
            _x.roleInfo = roleInfo;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="approvalDuration")
    @JsonIgnore
    public Optional<Duration> getApprovalDuration() {
        return Optional.ofNullable(approvalDuration);
    }

    public PrivilegedApproval withApprovalDuration(Duration approvalDuration) {
        PrivilegedApproval _x = _copy();
        _x.changedFields = changedFields.add("approvalDuration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privilegedApproval");
        _x.approvalDuration = approvalDuration;
        return _x;
    }

    @Property(name="approvalState")
    @JsonIgnore
    public Optional<ApprovalState> getApprovalState() {
        return Optional.ofNullable(approvalState);
    }

    public PrivilegedApproval withApprovalState(ApprovalState approvalState) {
        PrivilegedApproval _x = _copy();
        _x.changedFields = changedFields.add("approvalState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privilegedApproval");
        _x.approvalState = approvalState;
        return _x;
    }

    @Property(name="approvalType")
    @JsonIgnore
    public Optional<String> getApprovalType() {
        return Optional.ofNullable(approvalType);
    }

    public PrivilegedApproval withApprovalType(String approvalType) {
        PrivilegedApproval _x = _copy();
        _x.changedFields = changedFields.add("approvalType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privilegedApproval");
        _x.approvalType = approvalType;
        return _x;
    }

    @Property(name="approverReason")
    @JsonIgnore
    public Optional<String> getApproverReason() {
        return Optional.ofNullable(approverReason);
    }

    public PrivilegedApproval withApproverReason(String approverReason) {
        PrivilegedApproval _x = _copy();
        _x.changedFields = changedFields.add("approverReason");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privilegedApproval");
        _x.approverReason = approverReason;
        return _x;
    }

    @Property(name="endDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getEndDateTime() {
        return Optional.ofNullable(endDateTime);
    }

    public PrivilegedApproval withEndDateTime(OffsetDateTime endDateTime) {
        PrivilegedApproval _x = _copy();
        _x.changedFields = changedFields.add("endDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privilegedApproval");
        _x.endDateTime = endDateTime;
        return _x;
    }

    @Property(name="requestorReason")
    @JsonIgnore
    public Optional<String> getRequestorReason() {
        return Optional.ofNullable(requestorReason);
    }

    public PrivilegedApproval withRequestorReason(String requestorReason) {
        PrivilegedApproval _x = _copy();
        _x.changedFields = changedFields.add("requestorReason");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privilegedApproval");
        _x.requestorReason = requestorReason;
        return _x;
    }

    @Property(name="roleId")
    @JsonIgnore
    public Optional<String> getRoleId() {
        return Optional.ofNullable(roleId);
    }

    public PrivilegedApproval withRoleId(String roleId) {
        PrivilegedApproval _x = _copy();
        _x.changedFields = changedFields.add("roleId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privilegedApproval");
        _x.roleId = roleId;
        return _x;
    }

    @Property(name="startDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartDateTime() {
        return Optional.ofNullable(startDateTime);
    }

    public PrivilegedApproval withStartDateTime(OffsetDateTime startDateTime) {
        PrivilegedApproval _x = _copy();
        _x.changedFields = changedFields.add("startDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privilegedApproval");
        _x.startDateTime = startDateTime;
        return _x;
    }

    @Property(name="userId")
    @JsonIgnore
    public Optional<String> getUserId() {
        return Optional.ofNullable(userId);
    }

    public PrivilegedApproval withUserId(String userId) {
        PrivilegedApproval _x = _copy();
        _x.changedFields = changedFields.add("userId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privilegedApproval");
        _x.userId = userId;
        return _x;
    }

    public PrivilegedApproval withUnmappedField(String name, Object value) {
        PrivilegedApproval _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="request")
    @JsonIgnore
    public PrivilegedRoleAssignmentRequestRequest getRequest() {
        return new PrivilegedRoleAssignmentRequestRequest(contextPath.addSegment("request"), RequestHelper.getValue(unmappedFields, "request"));
    }

    @NavigationProperty(name="roleInfo")
    @JsonIgnore
    public PrivilegedRoleRequest getRoleInfo() {
        return new PrivilegedRoleRequest(contextPath.addSegment("roleInfo"), Optional.ofNullable(roleInfo));
    }

    public PrivilegedApproval withRoleInfo(PrivilegedRole roleInfo) {
        PrivilegedApproval _x = _copy();
        _x.changedFields = changedFields.add("roleInfo");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privilegedApproval");
        _x.roleInfo = roleInfo;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PrivilegedApproval patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        PrivilegedApproval _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PrivilegedApproval put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        PrivilegedApproval _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private PrivilegedApproval _copy() {
        PrivilegedApproval _x = new PrivilegedApproval();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.approvalDuration = approvalDuration;
        _x.approvalState = approvalState;
        _x.approvalType = approvalType;
        _x.approverReason = approverReason;
        _x.endDateTime = endDateTime;
        _x.requestorReason = requestorReason;
        _x.roleId = roleId;
        _x.startDateTime = startDateTime;
        _x.userId = userId;
        _x.roleInfo = roleInfo;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PrivilegedApproval[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("approvalDuration=");
        b.append(this.approvalDuration);
        b.append(", ");
        b.append("approvalState=");
        b.append(this.approvalState);
        b.append(", ");
        b.append("approvalType=");
        b.append(this.approvalType);
        b.append(", ");
        b.append("approverReason=");
        b.append(this.approverReason);
        b.append(", ");
        b.append("endDateTime=");
        b.append(this.endDateTime);
        b.append(", ");
        b.append("requestorReason=");
        b.append(this.requestorReason);
        b.append(", ");
        b.append("roleId=");
        b.append(this.roleId);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("userId=");
        b.append(this.userId);
        b.append(", ");
        b.append("roleInfo=");
        b.append(this.roleInfo);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
