package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.PrinterCapabilities;
import odata.msgraph.client.beta.complex.PrinterDefaults;
import odata.msgraph.client.beta.complex.PrinterLocation;
import odata.msgraph.client.beta.complex.PrinterStatus;
import odata.msgraph.client.beta.entity.collection.request.PrintJobCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "capabilities", 
    "defaults", 
    "displayName", 
    "isAcceptingJobs", 
    "location", 
    "manufacturer", 
    "model", 
    "name", 
    "status", 
    "jobs"})
@JsonInclude(Include.NON_NULL)
public class PrinterBase extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.printerBase";
    }

    @JsonProperty("capabilities")
    protected PrinterCapabilities capabilities;

    @JsonProperty("defaults")
    protected PrinterDefaults defaults;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("isAcceptingJobs")
    protected Boolean isAcceptingJobs;

    @JsonProperty("location")
    protected PrinterLocation location;

    @JsonProperty("manufacturer")
    protected String manufacturer;

    @JsonProperty("model")
    protected String model;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("status")
    protected PrinterStatus status;

    @JsonProperty("jobs")
    protected List<PrintJob> jobs;

    protected PrinterBase() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="capabilities")
    @JsonIgnore
    public Optional<PrinterCapabilities> getCapabilities() {
        return Optional.ofNullable(capabilities);
    }

    public PrinterBase withCapabilities(PrinterCapabilities capabilities) {
        PrinterBase _x = _copy();
        _x.changedFields = changedFields.add("capabilities");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerBase");
        _x.capabilities = capabilities;
        return _x;
    }

    @Property(name="defaults")
    @JsonIgnore
    public Optional<PrinterDefaults> getDefaults() {
        return Optional.ofNullable(defaults);
    }

    public PrinterBase withDefaults(PrinterDefaults defaults) {
        PrinterBase _x = _copy();
        _x.changedFields = changedFields.add("defaults");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerBase");
        _x.defaults = defaults;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public PrinterBase withDisplayName(String displayName) {
        PrinterBase _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerBase");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="isAcceptingJobs")
    @JsonIgnore
    public Optional<Boolean> getIsAcceptingJobs() {
        return Optional.ofNullable(isAcceptingJobs);
    }

    public PrinterBase withIsAcceptingJobs(Boolean isAcceptingJobs) {
        PrinterBase _x = _copy();
        _x.changedFields = changedFields.add("isAcceptingJobs");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerBase");
        _x.isAcceptingJobs = isAcceptingJobs;
        return _x;
    }

    @Property(name="location")
    @JsonIgnore
    public Optional<PrinterLocation> getLocation() {
        return Optional.ofNullable(location);
    }

    public PrinterBase withLocation(PrinterLocation location) {
        PrinterBase _x = _copy();
        _x.changedFields = changedFields.add("location");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerBase");
        _x.location = location;
        return _x;
    }

    @Property(name="manufacturer")
    @JsonIgnore
    public Optional<String> getManufacturer() {
        return Optional.ofNullable(manufacturer);
    }

    public PrinterBase withManufacturer(String manufacturer) {
        PrinterBase _x = _copy();
        _x.changedFields = changedFields.add("manufacturer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerBase");
        _x.manufacturer = manufacturer;
        return _x;
    }

    @Property(name="model")
    @JsonIgnore
    public Optional<String> getModel() {
        return Optional.ofNullable(model);
    }

    public PrinterBase withModel(String model) {
        PrinterBase _x = _copy();
        _x.changedFields = changedFields.add("model");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerBase");
        _x.model = model;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public PrinterBase withName(String name) {
        PrinterBase _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerBase");
        _x.name = name;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<PrinterStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public PrinterBase withStatus(PrinterStatus status) {
        PrinterBase _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerBase");
        _x.status = status;
        return _x;
    }

    public PrinterBase withUnmappedField(String name, Object value) {
        PrinterBase _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="jobs")
    @JsonIgnore
    public PrintJobCollectionRequest getJobs() {
        return new PrintJobCollectionRequest(
                        contextPath.addSegment("jobs"), Optional.ofNullable(jobs));
    }

    public PrinterBase withJobs(List<PrintJob> jobs) {
        PrinterBase _x = _copy();
        _x.changedFields = changedFields.add("jobs");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerBase");
        _x.jobs = jobs;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PrinterBase patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        PrinterBase _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PrinterBase put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        PrinterBase _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private PrinterBase _copy() {
        PrinterBase _x = new PrinterBase();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.capabilities = capabilities;
        _x.defaults = defaults;
        _x.displayName = displayName;
        _x.isAcceptingJobs = isAcceptingJobs;
        _x.location = location;
        _x.manufacturer = manufacturer;
        _x.model = model;
        _x.name = name;
        _x.status = status;
        _x.jobs = jobs;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PrinterBase[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("capabilities=");
        b.append(this.capabilities);
        b.append(", ");
        b.append("defaults=");
        b.append(this.defaults);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("isAcceptingJobs=");
        b.append(this.isAcceptingJobs);
        b.append(", ");
        b.append("location=");
        b.append(this.location);
        b.append(", ");
        b.append("manufacturer=");
        b.append(this.manufacturer);
        b.append(", ");
        b.append("model=");
        b.append(this.model);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("jobs=");
        b.append(this.jobs);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
