package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.PrinterCapabilities;
import odata.msgraph.client.beta.complex.PrinterDefaults;
import odata.msgraph.client.beta.complex.PrinterLocation;
import odata.msgraph.client.beta.complex.PrinterStatus;
import odata.msgraph.client.beta.entity.collection.request.PrintConnectorCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PrintTaskTriggerCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PrinterShareCollectionRequest;
import odata.msgraph.client.beta.entity.request.PrinterShareRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "acceptingJobs", 
    "hasPhysicalDevice", 
    "isShared", 
    "lastSeenDateTime", 
    "registeredDateTime", 
    "taskTriggers"})
@JsonInclude(Include.NON_NULL)
public class Printer extends PrinterBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.printer";
    }

    @JsonProperty("acceptingJobs")
    protected Boolean acceptingJobs;

    @JsonProperty("hasPhysicalDevice")
    protected Boolean hasPhysicalDevice;

    @JsonProperty("isShared")
    protected Boolean isShared;

    @JsonProperty("lastSeenDateTime")
    protected OffsetDateTime lastSeenDateTime;

    @JsonProperty("registeredDateTime")
    protected OffsetDateTime registeredDateTime;

    @JsonProperty("taskTriggers")
    protected List<PrintTaskTrigger> taskTriggers;

    protected Printer() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPrinter() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private PrinterCapabilities capabilities;
        private PrinterDefaults defaults;
        private String displayName;
        private Boolean isAcceptingJobs;
        private PrinterLocation location;
        private String manufacturer;
        private String model;
        private String name;
        private PrinterStatus status;
        private List<PrintJob> jobs;
        private Boolean acceptingJobs;
        private Boolean hasPhysicalDevice;
        private Boolean isShared;
        private OffsetDateTime lastSeenDateTime;
        private OffsetDateTime registeredDateTime;
        private List<PrintTaskTrigger> taskTriggers;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder capabilities(PrinterCapabilities capabilities) {
            this.capabilities = capabilities;
            this.changedFields = changedFields.add("capabilities");
            return this;
        }

        public Builder defaults(PrinterDefaults defaults) {
            this.defaults = defaults;
            this.changedFields = changedFields.add("defaults");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder isAcceptingJobs(Boolean isAcceptingJobs) {
            this.isAcceptingJobs = isAcceptingJobs;
            this.changedFields = changedFields.add("isAcceptingJobs");
            return this;
        }

        public Builder location(PrinterLocation location) {
            this.location = location;
            this.changedFields = changedFields.add("location");
            return this;
        }

        public Builder manufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
            this.changedFields = changedFields.add("manufacturer");
            return this;
        }

        public Builder model(String model) {
            this.model = model;
            this.changedFields = changedFields.add("model");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder status(PrinterStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder jobs(List<PrintJob> jobs) {
            this.jobs = jobs;
            this.changedFields = changedFields.add("jobs");
            return this;
        }

        public Builder jobs(PrintJob... jobs) {
            return jobs(Arrays.asList(jobs));
        }

        public Builder acceptingJobs(Boolean acceptingJobs) {
            this.acceptingJobs = acceptingJobs;
            this.changedFields = changedFields.add("acceptingJobs");
            return this;
        }

        public Builder hasPhysicalDevice(Boolean hasPhysicalDevice) {
            this.hasPhysicalDevice = hasPhysicalDevice;
            this.changedFields = changedFields.add("hasPhysicalDevice");
            return this;
        }

        public Builder isShared(Boolean isShared) {
            this.isShared = isShared;
            this.changedFields = changedFields.add("isShared");
            return this;
        }

        public Builder lastSeenDateTime(OffsetDateTime lastSeenDateTime) {
            this.lastSeenDateTime = lastSeenDateTime;
            this.changedFields = changedFields.add("lastSeenDateTime");
            return this;
        }

        public Builder registeredDateTime(OffsetDateTime registeredDateTime) {
            this.registeredDateTime = registeredDateTime;
            this.changedFields = changedFields.add("registeredDateTime");
            return this;
        }

        public Builder taskTriggers(List<PrintTaskTrigger> taskTriggers) {
            this.taskTriggers = taskTriggers;
            this.changedFields = changedFields.add("taskTriggers");
            return this;
        }

        public Builder taskTriggers(PrintTaskTrigger... taskTriggers) {
            return taskTriggers(Arrays.asList(taskTriggers));
        }

        public Printer build() {
            Printer _x = new Printer();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.printer";
            _x.id = id;
            _x.capabilities = capabilities;
            _x.defaults = defaults;
            _x.displayName = displayName;
            _x.isAcceptingJobs = isAcceptingJobs;
            _x.location = location;
            _x.manufacturer = manufacturer;
            _x.model = model;
            _x.name = name;
            _x.status = status;
            _x.jobs = jobs;
            _x.acceptingJobs = acceptingJobs;
            _x.hasPhysicalDevice = hasPhysicalDevice;
            _x.isShared = isShared;
            _x.lastSeenDateTime = lastSeenDateTime;
            _x.registeredDateTime = registeredDateTime;
            _x.taskTriggers = taskTriggers;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="acceptingJobs")
    @JsonIgnore
    public Optional<Boolean> getAcceptingJobs() {
        return Optional.ofNullable(acceptingJobs);
    }

    public Printer withAcceptingJobs(Boolean acceptingJobs) {
        Printer _x = _copy();
        _x.changedFields = changedFields.add("acceptingJobs");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printer");
        _x.acceptingJobs = acceptingJobs;
        return _x;
    }

    @Property(name="hasPhysicalDevice")
    @JsonIgnore
    public Optional<Boolean> getHasPhysicalDevice() {
        return Optional.ofNullable(hasPhysicalDevice);
    }

    public Printer withHasPhysicalDevice(Boolean hasPhysicalDevice) {
        Printer _x = _copy();
        _x.changedFields = changedFields.add("hasPhysicalDevice");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printer");
        _x.hasPhysicalDevice = hasPhysicalDevice;
        return _x;
    }

    @Property(name="isShared")
    @JsonIgnore
    public Optional<Boolean> getIsShared() {
        return Optional.ofNullable(isShared);
    }

    public Printer withIsShared(Boolean isShared) {
        Printer _x = _copy();
        _x.changedFields = changedFields.add("isShared");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printer");
        _x.isShared = isShared;
        return _x;
    }

    @Property(name="lastSeenDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastSeenDateTime() {
        return Optional.ofNullable(lastSeenDateTime);
    }

    public Printer withLastSeenDateTime(OffsetDateTime lastSeenDateTime) {
        Printer _x = _copy();
        _x.changedFields = changedFields.add("lastSeenDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printer");
        _x.lastSeenDateTime = lastSeenDateTime;
        return _x;
    }

    @Property(name="registeredDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getRegisteredDateTime() {
        return Optional.ofNullable(registeredDateTime);
    }

    public Printer withRegisteredDateTime(OffsetDateTime registeredDateTime) {
        Printer _x = _copy();
        _x.changedFields = changedFields.add("registeredDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printer");
        _x.registeredDateTime = registeredDateTime;
        return _x;
    }

    public Printer withUnmappedField(String name, Object value) {
        Printer _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="connectors")
    @JsonIgnore
    public PrintConnectorCollectionRequest getConnectors() {
        return new PrintConnectorCollectionRequest(
                        contextPath.addSegment("connectors"), RequestHelper.getValue(unmappedFields, "connectors"));
    }

    @NavigationProperty(name="share")
    @JsonIgnore
    public PrinterShareRequest getShare() {
        return new PrinterShareRequest(contextPath.addSegment("share"), RequestHelper.getValue(unmappedFields, "share"));
    }

    @NavigationProperty(name="shares")
    @JsonIgnore
    public PrinterShareCollectionRequest getShares() {
        return new PrinterShareCollectionRequest(
                        contextPath.addSegment("shares"), RequestHelper.getValue(unmappedFields, "shares"));
    }

    @NavigationProperty(name="taskTriggers")
    @JsonIgnore
    public PrintTaskTriggerCollectionRequest getTaskTriggers() {
        return new PrintTaskTriggerCollectionRequest(
                        contextPath.addSegment("taskTriggers"), Optional.ofNullable(taskTriggers));
    }

    public Printer withTaskTriggers(List<PrintTaskTrigger> taskTriggers) {
        Printer _x = _copy();
        _x.changedFields = changedFields.add("taskTriggers");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printer");
        _x.taskTriggers = taskTriggers;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Printer patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Printer _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Printer put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Printer _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Printer _copy() {
        Printer _x = new Printer();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.capabilities = capabilities;
        _x.defaults = defaults;
        _x.displayName = displayName;
        _x.isAcceptingJobs = isAcceptingJobs;
        _x.location = location;
        _x.manufacturer = manufacturer;
        _x.model = model;
        _x.name = name;
        _x.status = status;
        _x.jobs = jobs;
        _x.acceptingJobs = acceptingJobs;
        _x.hasPhysicalDevice = hasPhysicalDevice;
        _x.isShared = isShared;
        _x.lastSeenDateTime = lastSeenDateTime;
        _x.registeredDateTime = registeredDateTime;
        _x.taskTriggers = taskTriggers;
        return _x;
    }

    @Action(name = "resetDefaults")
    @JsonIgnore
    public ActionRequestNoReturn resetDefaults() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.resetDefaults"), _parameters);
    }

    @Action(name = "restoreFactoryDefaults")
    @JsonIgnore
    public ActionRequestNoReturn restoreFactoryDefaults() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.restoreFactoryDefaults"), _parameters);
    }

    @Function(name = "getCapabilities")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<PrinterCapabilities> getCapabilities_Function() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<PrinterCapabilities>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getCapabilities"), PrinterCapabilities.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Printer[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("capabilities=");
        b.append(this.capabilities);
        b.append(", ");
        b.append("defaults=");
        b.append(this.defaults);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("isAcceptingJobs=");
        b.append(this.isAcceptingJobs);
        b.append(", ");
        b.append("location=");
        b.append(this.location);
        b.append(", ");
        b.append("manufacturer=");
        b.append(this.manufacturer);
        b.append(", ");
        b.append("model=");
        b.append(this.model);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("jobs=");
        b.append(this.jobs);
        b.append(", ");
        b.append("acceptingJobs=");
        b.append(this.acceptingJobs);
        b.append(", ");
        b.append("hasPhysicalDevice=");
        b.append(this.hasPhysicalDevice);
        b.append(", ");
        b.append("isShared=");
        b.append(this.isShared);
        b.append(", ");
        b.append("lastSeenDateTime=");
        b.append(this.lastSeenDateTime);
        b.append(", ");
        b.append("registeredDateTime=");
        b.append(this.registeredDateTime);
        b.append(", ");
        b.append("taskTriggers=");
        b.append(this.taskTriggers);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
