package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.StreamProvider;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.PrintDocumentUploadProperties;
import odata.msgraph.client.beta.complex.PrinterDocumentConfiguration;
import odata.msgraph.client.beta.complex.UploadSession;

@JsonPropertyOrder({
    "@odata.type", 
    "configuration", 
    "contentType", 
    "displayName", 
    "size"})
@JsonInclude(Include.NON_NULL)
public class PrintDocument extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.printDocument";
    }

    @JsonProperty("configuration")
    protected PrinterDocumentConfiguration configuration;

    @JsonProperty("contentType")
    protected String contentType;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("size")
    protected Long size;

    protected PrintDocument() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPrintDocument() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private PrinterDocumentConfiguration configuration;
        private String contentType;
        private String displayName;
        private Long size;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder configuration(PrinterDocumentConfiguration configuration) {
            this.configuration = configuration;
            this.changedFields = changedFields.add("configuration");
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            this.changedFields = changedFields.add("contentType");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder size(Long size) {
            this.size = size;
            this.changedFields = changedFields.add("size");
            return this;
        }

        public PrintDocument build() {
            PrintDocument _x = new PrintDocument();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.printDocument";
            _x.id = id;
            _x.configuration = configuration;
            _x.contentType = contentType;
            _x.displayName = displayName;
            _x.size = size;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="configuration")
    @JsonIgnore
    public Optional<PrinterDocumentConfiguration> getConfiguration() {
        return Optional.ofNullable(configuration);
    }

    public PrintDocument withConfiguration(PrinterDocumentConfiguration configuration) {
        PrintDocument _x = _copy();
        _x.changedFields = changedFields.add("configuration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printDocument");
        _x.configuration = configuration;
        return _x;
    }

    @Property(name="contentType")
    @JsonIgnore
    public Optional<String> getContentType() {
        return Optional.ofNullable(contentType);
    }

    public PrintDocument withContentType(String contentType) {
        PrintDocument _x = _copy();
        _x.changedFields = changedFields.add("contentType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printDocument");
        _x.contentType = contentType;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public PrintDocument withDisplayName(String displayName) {
        PrintDocument _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printDocument");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="size")
    @JsonIgnore
    public Optional<Long> getSize() {
        return Optional.ofNullable(size);
    }

    public PrintDocument withSize(Long size) {
        PrintDocument _x = _copy();
        _x.changedFields = changedFields.add("size");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printDocument");
        _x.size = size;
        return _x;
    }

    public PrintDocument withUnmappedField(String name, Object value) {
        PrintDocument _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * If suitable metadata found a StreamProvider is returned otherwise returns
     * {@code Optional.empty()}. Normally for a stream to be available this entity
     * needs to have been hydrated with full metadata. Consider calling the builder
     * method {@code .metadataFull()} when getting this instance (either directly or
     * as part of a collection).
     *
     * @return StreamProvider if suitable metadata found otherwise returns
     *         {@code Optional.empty()}
     */
    @JsonIgnore
    public Optional<StreamProvider> getStream() {
        return RequestHelper.createStream(contextPath, this);
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PrintDocument patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        PrintDocument _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PrintDocument put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        PrintDocument _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private PrintDocument _copy() {
        PrintDocument _x = new PrintDocument();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.configuration = configuration;
        _x.contentType = contentType;
        _x.displayName = displayName;
        _x.size = size;
        return _x;
    }

    @Action(name = "createUploadSession")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<UploadSession> createUploadSession(PrintDocumentUploadProperties properties) {
        Preconditions.checkNotNull(properties, "properties cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("properties", "microsoft.graph.printDocumentUploadProperties", properties)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<UploadSession>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.createUploadSession"), UploadSession.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PrintDocument[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("configuration=");
        b.append(this.configuration);
        b.append(", ");
        b.append("contentType=");
        b.append(this.contentType);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("size=");
        b.append(this.size);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
