package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceHealth;
import odata.msgraph.client.beta.complex.PrinterLocation;

@JsonPropertyOrder({
    "@odata.type", 
    "appVersion", 
    "deviceHealth", 
    "displayName", 
    "fullyQualifiedDomainName", 
    "location", 
    "name", 
    "operatingSystem", 
    "registeredDateTime"})
@JsonInclude(Include.NON_NULL)
public class PrintConnector extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.printConnector";
    }

    @JsonProperty("appVersion")
    protected String appVersion;

    @JsonProperty("deviceHealth")
    protected DeviceHealth deviceHealth;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("fullyQualifiedDomainName")
    protected String fullyQualifiedDomainName;

    @JsonProperty("location")
    protected PrinterLocation location;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("operatingSystem")
    protected String operatingSystem;

    @JsonProperty("registeredDateTime")
    protected OffsetDateTime registeredDateTime;

    protected PrintConnector() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPrintConnector() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String appVersion;
        private DeviceHealth deviceHealth;
        private String displayName;
        private String fullyQualifiedDomainName;
        private PrinterLocation location;
        private String name;
        private String operatingSystem;
        private OffsetDateTime registeredDateTime;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder appVersion(String appVersion) {
            this.appVersion = appVersion;
            this.changedFields = changedFields.add("appVersion");
            return this;
        }

        public Builder deviceHealth(DeviceHealth deviceHealth) {
            this.deviceHealth = deviceHealth;
            this.changedFields = changedFields.add("deviceHealth");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder fullyQualifiedDomainName(String fullyQualifiedDomainName) {
            this.fullyQualifiedDomainName = fullyQualifiedDomainName;
            this.changedFields = changedFields.add("fullyQualifiedDomainName");
            return this;
        }

        public Builder location(PrinterLocation location) {
            this.location = location;
            this.changedFields = changedFields.add("location");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            this.changedFields = changedFields.add("operatingSystem");
            return this;
        }

        public Builder registeredDateTime(OffsetDateTime registeredDateTime) {
            this.registeredDateTime = registeredDateTime;
            this.changedFields = changedFields.add("registeredDateTime");
            return this;
        }

        public PrintConnector build() {
            PrintConnector _x = new PrintConnector();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.printConnector";
            _x.id = id;
            _x.appVersion = appVersion;
            _x.deviceHealth = deviceHealth;
            _x.displayName = displayName;
            _x.fullyQualifiedDomainName = fullyQualifiedDomainName;
            _x.location = location;
            _x.name = name;
            _x.operatingSystem = operatingSystem;
            _x.registeredDateTime = registeredDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="appVersion")
    @JsonIgnore
    public Optional<String> getAppVersion() {
        return Optional.ofNullable(appVersion);
    }

    public PrintConnector withAppVersion(String appVersion) {
        PrintConnector _x = _copy();
        _x.changedFields = changedFields.add("appVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printConnector");
        _x.appVersion = appVersion;
        return _x;
    }

    @Property(name="deviceHealth")
    @JsonIgnore
    public Optional<DeviceHealth> getDeviceHealth() {
        return Optional.ofNullable(deviceHealth);
    }

    public PrintConnector withDeviceHealth(DeviceHealth deviceHealth) {
        PrintConnector _x = _copy();
        _x.changedFields = changedFields.add("deviceHealth");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printConnector");
        _x.deviceHealth = deviceHealth;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public PrintConnector withDisplayName(String displayName) {
        PrintConnector _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printConnector");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="fullyQualifiedDomainName")
    @JsonIgnore
    public Optional<String> getFullyQualifiedDomainName() {
        return Optional.ofNullable(fullyQualifiedDomainName);
    }

    public PrintConnector withFullyQualifiedDomainName(String fullyQualifiedDomainName) {
        PrintConnector _x = _copy();
        _x.changedFields = changedFields.add("fullyQualifiedDomainName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printConnector");
        _x.fullyQualifiedDomainName = fullyQualifiedDomainName;
        return _x;
    }

    @Property(name="location")
    @JsonIgnore
    public Optional<PrinterLocation> getLocation() {
        return Optional.ofNullable(location);
    }

    public PrintConnector withLocation(PrinterLocation location) {
        PrintConnector _x = _copy();
        _x.changedFields = changedFields.add("location");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printConnector");
        _x.location = location;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public PrintConnector withName(String name) {
        PrintConnector _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printConnector");
        _x.name = name;
        return _x;
    }

    @Property(name="operatingSystem")
    @JsonIgnore
    public Optional<String> getOperatingSystem() {
        return Optional.ofNullable(operatingSystem);
    }

    public PrintConnector withOperatingSystem(String operatingSystem) {
        PrintConnector _x = _copy();
        _x.changedFields = changedFields.add("operatingSystem");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printConnector");
        _x.operatingSystem = operatingSystem;
        return _x;
    }

    @Property(name="registeredDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getRegisteredDateTime() {
        return Optional.ofNullable(registeredDateTime);
    }

    public PrintConnector withRegisteredDateTime(OffsetDateTime registeredDateTime) {
        PrintConnector _x = _copy();
        _x.changedFields = changedFields.add("registeredDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printConnector");
        _x.registeredDateTime = registeredDateTime;
        return _x;
    }

    public PrintConnector withUnmappedField(String name, Object value) {
        PrintConnector _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PrintConnector patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        PrintConnector _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PrintConnector put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        PrintConnector _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private PrintConnector _copy() {
        PrintConnector _x = new PrintConnector();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.appVersion = appVersion;
        _x.deviceHealth = deviceHealth;
        _x.displayName = displayName;
        _x.fullyQualifiedDomainName = fullyQualifiedDomainName;
        _x.location = location;
        _x.name = name;
        _x.operatingSystem = operatingSystem;
        _x.registeredDateTime = registeredDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PrintConnector[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("appVersion=");
        b.append(this.appVersion);
        b.append(", ");
        b.append("deviceHealth=");
        b.append(this.deviceHealth);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("fullyQualifiedDomainName=");
        b.append(this.fullyQualifiedDomainName);
        b.append(", ");
        b.append("location=");
        b.append(this.location);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("operatingSystem=");
        b.append(this.operatingSystem);
        b.append(", ");
        b.append("registeredDateTime=");
        b.append(this.registeredDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
