package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.PrintSettings;
import odata.msgraph.client.beta.entity.collection.request.PrintConnectorCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PrintOperationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PrintServiceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PrintTaskDefinitionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PrinterCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PrinterShareCollectionRequest;
import odata.msgraph.client.beta.entity.request.ReportRootRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "settings", 
    "connectors", 
    "operations", 
    "printers", 
    "printerShares", 
    "reports", 
    "services", 
    "shares", 
    "taskDefinitions"})
@JsonInclude(Include.NON_NULL)
public class Print implements ODataEntityType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JacksonInject
    @JsonIgnore
    protected ChangedFields changedFields;

    @Override
    public String odataTypeName() {
        return "microsoft.graph.print";
    }

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("settings")
    protected PrintSettings settings;

    @JsonProperty("connectors")
    protected List<PrintConnector> connectors;

    @JsonProperty("operations")
    protected List<PrintOperation> operations;

    @JsonProperty("printers")
    protected List<Printer> printers;

    @JsonProperty("printerShares")
    protected List<PrinterShare> printerShares;

    @JsonProperty("reports")
    protected ReportRoot reports;

    @JsonProperty("services")
    protected List<PrintService> services;

    @JsonProperty("shares")
    protected List<PrinterShare> shares;

    @JsonProperty("taskDefinitions")
    protected List<PrintTaskDefinition> taskDefinitions;

    protected Print() {
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private PrintSettings settings;
        private List<PrintConnector> connectors;
        private List<PrintOperation> operations;
        private List<Printer> printers;
        private List<PrinterShare> printerShares;
        private ReportRoot reports;
        private List<PrintService> services;
        private List<PrinterShare> shares;
        private List<PrintTaskDefinition> taskDefinitions;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder settings(PrintSettings settings) {
            this.settings = settings;
            this.changedFields = changedFields.add("settings");
            return this;
        }

        public Builder connectors(List<PrintConnector> connectors) {
            this.connectors = connectors;
            this.changedFields = changedFields.add("connectors");
            return this;
        }

        public Builder connectors(PrintConnector... connectors) {
            return connectors(Arrays.asList(connectors));
        }

        public Builder operations(List<PrintOperation> operations) {
            this.operations = operations;
            this.changedFields = changedFields.add("operations");
            return this;
        }

        public Builder operations(PrintOperation... operations) {
            return operations(Arrays.asList(operations));
        }

        public Builder printers(List<Printer> printers) {
            this.printers = printers;
            this.changedFields = changedFields.add("printers");
            return this;
        }

        public Builder printers(Printer... printers) {
            return printers(Arrays.asList(printers));
        }

        public Builder printerShares(List<PrinterShare> printerShares) {
            this.printerShares = printerShares;
            this.changedFields = changedFields.add("printerShares");
            return this;
        }

        public Builder printerShares(PrinterShare... printerShares) {
            return printerShares(Arrays.asList(printerShares));
        }

        public Builder reports(ReportRoot reports) {
            this.reports = reports;
            this.changedFields = changedFields.add("reports");
            return this;
        }

        public Builder services(List<PrintService> services) {
            this.services = services;
            this.changedFields = changedFields.add("services");
            return this;
        }

        public Builder services(PrintService... services) {
            return services(Arrays.asList(services));
        }

        public Builder shares(List<PrinterShare> shares) {
            this.shares = shares;
            this.changedFields = changedFields.add("shares");
            return this;
        }

        public Builder shares(PrinterShare... shares) {
            return shares(Arrays.asList(shares));
        }

        public Builder taskDefinitions(List<PrintTaskDefinition> taskDefinitions) {
            this.taskDefinitions = taskDefinitions;
            this.changedFields = changedFields.add("taskDefinitions");
            return this;
        }

        public Builder taskDefinitions(PrintTaskDefinition... taskDefinitions) {
            return taskDefinitions(Arrays.asList(taskDefinitions));
        }

        public Print build() {
            Print _x = new Print();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.print";
            _x.settings = settings;
            _x.connectors = connectors;
            _x.operations = operations;
            _x.printers = printers;
            _x.printerShares = printerShares;
            _x.reports = reports;
            _x.services = services;
            _x.shares = shares;
            _x.taskDefinitions = taskDefinitions;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath) {
            contextPath = contextPath.clearQueries();
        }
    }

    @Property(name="settings")
    @JsonIgnore
    public Optional<PrintSettings> getSettings() {
        return Optional.ofNullable(settings);
    }

    public Print withSettings(PrintSettings settings) {
        Print _x = _copy();
        _x.changedFields = changedFields.add("settings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.print");
        _x.settings = settings;
        return _x;
    }

    public Print withUnmappedField(String name, Object value) {
        Print _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="connectors")
    @JsonIgnore
    public PrintConnectorCollectionRequest getConnectors() {
        return new PrintConnectorCollectionRequest(
                        contextPath.addSegment("connectors"), Optional.ofNullable(connectors));
    }

    @NavigationProperty(name="operations")
    @JsonIgnore
    public PrintOperationCollectionRequest getOperations() {
        return new PrintOperationCollectionRequest(
                        contextPath.addSegment("operations"), Optional.ofNullable(operations));
    }

    @NavigationProperty(name="printers")
    @JsonIgnore
    public PrinterCollectionRequest getPrinters() {
        return new PrinterCollectionRequest(
                        contextPath.addSegment("printers"), Optional.ofNullable(printers));
    }

    @NavigationProperty(name="printerShares")
    @JsonIgnore
    public PrinterShareCollectionRequest getPrinterShares() {
        return new PrinterShareCollectionRequest(
                        contextPath.addSegment("printerShares"), Optional.ofNullable(printerShares));
    }

    @NavigationProperty(name="reports")
    @JsonIgnore
    public ReportRootRequest getReports() {
        return new ReportRootRequest(contextPath.addSegment("reports"), Optional.ofNullable(reports));
    }

    @NavigationProperty(name="services")
    @JsonIgnore
    public PrintServiceCollectionRequest getServices() {
        return new PrintServiceCollectionRequest(
                        contextPath.addSegment("services"), Optional.ofNullable(services));
    }

    @NavigationProperty(name="shares")
    @JsonIgnore
    public PrinterShareCollectionRequest getShares() {
        return new PrinterShareCollectionRequest(
                        contextPath.addSegment("shares"), Optional.ofNullable(shares));
    }

    @NavigationProperty(name="taskDefinitions")
    @JsonIgnore
    public PrintTaskDefinitionCollectionRequest getTaskDefinitions() {
        return new PrintTaskDefinitionCollectionRequest(
                        contextPath.addSegment("taskDefinitions"), Optional.ofNullable(taskDefinitions));
    }

    public Print withConnectors(List<PrintConnector> connectors) {
        Print _x = _copy();
        _x.changedFields = changedFields.add("connectors");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.print");
        _x.connectors = connectors;
        return _x;
    }

    public Print withOperations(List<PrintOperation> operations) {
        Print _x = _copy();
        _x.changedFields = changedFields.add("operations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.print");
        _x.operations = operations;
        return _x;
    }

    public Print withPrinters(List<Printer> printers) {
        Print _x = _copy();
        _x.changedFields = changedFields.add("printers");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.print");
        _x.printers = printers;
        return _x;
    }

    public Print withPrinterShares(List<PrinterShare> printerShares) {
        Print _x = _copy();
        _x.changedFields = changedFields.add("printerShares");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.print");
        _x.printerShares = printerShares;
        return _x;
    }

    public Print withReports(ReportRoot reports) {
        Print _x = _copy();
        _x.changedFields = changedFields.add("reports");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.print");
        _x.reports = reports;
        return _x;
    }

    public Print withServices(List<PrintService> services) {
        Print _x = _copy();
        _x.changedFields = changedFields.add("services");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.print");
        _x.services = services;
        return _x;
    }

    public Print withShares(List<PrinterShare> shares) {
        Print _x = _copy();
        _x.changedFields = changedFields.add("shares");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.print");
        _x.shares = shares;
        return _x;
    }

    public Print withTaskDefinitions(List<PrintTaskDefinition> taskDefinitions) {
        Print _x = _copy();
        _x.changedFields = changedFields.add("taskDefinitions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.print");
        _x.taskDefinitions = taskDefinitions;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Print patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Print _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Print put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Print _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Print _copy() {
        Print _x = new Print();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.settings = settings;
        _x.connectors = connectors;
        _x.operations = operations;
        _x.printers = printers;
        _x.printerShares = printerShares;
        _x.reports = reports;
        _x.services = services;
        _x.shares = shares;
        _x.taskDefinitions = taskDefinitions;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Print[");
        b.append("settings=");
        b.append(this.settings);
        b.append(", ");
        b.append("connectors=");
        b.append(this.connectors);
        b.append(", ");
        b.append("operations=");
        b.append(this.operations);
        b.append(", ");
        b.append("printers=");
        b.append(this.printers);
        b.append(", ");
        b.append("printerShares=");
        b.append(this.printerShares);
        b.append(", ");
        b.append("reports=");
        b.append(this.reports);
        b.append(", ");
        b.append("services=");
        b.append(this.services);
        b.append(", ");
        b.append("shares=");
        b.append(this.shares);
        b.append(", ");
        b.append("taskDefinitions=");
        b.append(this.taskDefinitions);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
