package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.OutOfOfficeSettings;

@JsonPropertyOrder({
    "@odata.type", 
    "activity", 
    "availability", 
    "outOfOfficeSettings"})
@JsonInclude(Include.NON_NULL)
public class Presence extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.presence";
    }

    @JsonProperty("activity")
    protected String activity;

    @JsonProperty("availability")
    protected String availability;

    @JsonProperty("outOfOfficeSettings")
    protected OutOfOfficeSettings outOfOfficeSettings;

    protected Presence() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPresence() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String activity;
        private String availability;
        private OutOfOfficeSettings outOfOfficeSettings;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder activity(String activity) {
            this.activity = activity;
            this.changedFields = changedFields.add("activity");
            return this;
        }

        public Builder availability(String availability) {
            this.availability = availability;
            this.changedFields = changedFields.add("availability");
            return this;
        }

        public Builder outOfOfficeSettings(OutOfOfficeSettings outOfOfficeSettings) {
            this.outOfOfficeSettings = outOfOfficeSettings;
            this.changedFields = changedFields.add("outOfOfficeSettings");
            return this;
        }

        public Presence build() {
            Presence _x = new Presence();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.presence";
            _x.id = id;
            _x.activity = activity;
            _x.availability = availability;
            _x.outOfOfficeSettings = outOfOfficeSettings;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="activity")
    @JsonIgnore
    public Optional<String> getActivity() {
        return Optional.ofNullable(activity);
    }

    public Presence withActivity(String activity) {
        Presence _x = _copy();
        _x.changedFields = changedFields.add("activity");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.presence");
        _x.activity = activity;
        return _x;
    }

    @Property(name="availability")
    @JsonIgnore
    public Optional<String> getAvailability() {
        return Optional.ofNullable(availability);
    }

    public Presence withAvailability(String availability) {
        Presence _x = _copy();
        _x.changedFields = changedFields.add("availability");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.presence");
        _x.availability = availability;
        return _x;
    }

    @Property(name="outOfOfficeSettings")
    @JsonIgnore
    public Optional<OutOfOfficeSettings> getOutOfOfficeSettings() {
        return Optional.ofNullable(outOfOfficeSettings);
    }

    public Presence withOutOfOfficeSettings(OutOfOfficeSettings outOfOfficeSettings) {
        Presence _x = _copy();
        _x.changedFields = changedFields.add("outOfOfficeSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.presence");
        _x.outOfOfficeSettings = outOfOfficeSettings;
        return _x;
    }

    public Presence withUnmappedField(String name, Object value) {
        Presence _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Presence patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Presence _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Presence put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Presence _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Presence _copy() {
        Presence _x = new Presence();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.activity = activity;
        _x.availability = availability;
        _x.outOfOfficeSettings = outOfOfficeSettings;
        return _x;
    }

    @Action(name = "clearPresence")
    @JsonIgnore
    public ActionRequestNoReturn clearPresence(String sessionId) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.clearPresence"), _parameters);
    }

    @Action(name = "clearUserPreferredPresence")
    @JsonIgnore
    public ActionRequestNoReturn clearUserPreferredPresence() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.clearUserPreferredPresence"), _parameters);
    }

    @Action(name = "setPresence")
    @JsonIgnore
    public ActionRequestNoReturn setPresence(String sessionId, String availability, String activity, Duration expirationDuration) {
        Preconditions.checkNotNull(availability, "availability cannot be null");
        Preconditions.checkNotNull(activity, "activity cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("availability", "Edm.String", Checks.checkIsAscii(availability))
            .put("activity", "Edm.String", Checks.checkIsAscii(activity))
            .put("expirationDuration", "Edm.Duration", expirationDuration)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.setPresence"), _parameters);
    }

    @Action(name = "setUserPreferredPresence")
    @JsonIgnore
    public ActionRequestNoReturn setUserPreferredPresence(String availability, String activity, Duration expirationDuration) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("availability", "Edm.String", Checks.checkIsAscii(availability))
            .put("activity", "Edm.String", Checks.checkIsAscii(activity))
            .put("expirationDuration", "Edm.Duration", expirationDuration)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.setUserPreferredPresence"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Presence[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("activity=");
        b.append(this.activity);
        b.append(", ");
        b.append("availability=");
        b.append(this.availability);
        b.append(", ");
        b.append("outOfOfficeSettings=");
        b.append(this.outOfOfficeSettings);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
