package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.PolicySetAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PolicySetItemCollectionRequest;
import odata.msgraph.client.beta.enums.ErrorCode;
import odata.msgraph.client.beta.enums.PolicySetStatus;


/**
 * <i>“A class containing the properties used for PolicySet.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "createdDateTime", 
    "description", 
    "displayName", 
    "errorCode", 
    "guidedDeploymentTags", 
    "lastModifiedDateTime", 
    "roleScopeTags", 
    "status", 
    "assignments", 
    "items"})
@JsonInclude(Include.NON_NULL)
public class PolicySet extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.policySet";
    }

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("errorCode")
    protected ErrorCode errorCode;

    @JsonProperty("guidedDeploymentTags")
    protected List<String> guidedDeploymentTags;

    @JsonProperty("guidedDeploymentTags@nextLink")
    protected String guidedDeploymentTagsNextLink;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("roleScopeTags")
    protected List<String> roleScopeTags;

    @JsonProperty("roleScopeTags@nextLink")
    protected String roleScopeTagsNextLink;

    @JsonProperty("status")
    protected PolicySetStatus status;

    @JsonProperty("assignments")
    protected List<PolicySetAssignment> assignments;

    @JsonProperty("items")
    protected List<PolicySetItem> items;

    protected PolicySet() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPolicySet() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private ErrorCode errorCode;
        private List<String> guidedDeploymentTags;
        private String guidedDeploymentTagsNextLink;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTags;
        private String roleScopeTagsNextLink;
        private PolicySetStatus status;
        private List<PolicySetAssignment> assignments;
        private List<PolicySetItem> items;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Creation time of the PolicySet.”</i>
         * 
         * @param createdDateTime
         *            value of {@code createdDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        /**
         * <i>“Description of the PolicySet.”</i>
         * 
         * @param description
         *            value of {@code description} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        /**
         * <i>“DisplayName of the PolicySet.”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“Error code if any occured.”</i>
         * 
         * @param errorCode
         *            value of {@code errorCode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder errorCode(ErrorCode errorCode) {
            this.errorCode = errorCode;
            this.changedFields = changedFields.add("errorCode");
            return this;
        }

        /**
         * <i>“Tags of the guided deployment”</i>
         * 
         * @param guidedDeploymentTags
         *            value of {@code guidedDeploymentTags} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder guidedDeploymentTags(List<String> guidedDeploymentTags) {
            this.guidedDeploymentTags = guidedDeploymentTags;
            this.changedFields = changedFields.add("guidedDeploymentTags");
            return this;
        }

        /**
         * <i>“Tags of the guided deployment”</i>
         * 
         * @param guidedDeploymentTags
         *            value of {@code guidedDeploymentTags} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder guidedDeploymentTags(String... guidedDeploymentTags) {
            return guidedDeploymentTags(Arrays.asList(guidedDeploymentTags));
        }

        /**
         * <i>“Tags of the guided deployment”</i>
         * 
         * @param guidedDeploymentTagsNextLink
         *            value of {@code guidedDeploymentTags@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder guidedDeploymentTagsNextLink(String guidedDeploymentTagsNextLink) {
            this.guidedDeploymentTagsNextLink = guidedDeploymentTagsNextLink;
            this.changedFields = changedFields.add("guidedDeploymentTags");
            return this;
        }

        /**
         * <i>“Last modified time of the PolicySet.”</i>
         * 
         * @param lastModifiedDateTime
         *            value of {@code lastModifiedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        /**
         * <i>“RoleScopeTags of the PolicySet”</i>
         * 
         * @param roleScopeTags
         *            value of {@code roleScopeTags} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTags(List<String> roleScopeTags) {
            this.roleScopeTags = roleScopeTags;
            this.changedFields = changedFields.add("roleScopeTags");
            return this;
        }

        /**
         * <i>“RoleScopeTags of the PolicySet”</i>
         * 
         * @param roleScopeTags
         *            value of {@code roleScopeTags} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTags(String... roleScopeTags) {
            return roleScopeTags(Arrays.asList(roleScopeTags));
        }

        /**
         * <i>“RoleScopeTags of the PolicySet”</i>
         * 
         * @param roleScopeTagsNextLink
         *            value of {@code roleScopeTags@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagsNextLink(String roleScopeTagsNextLink) {
            this.roleScopeTagsNextLink = roleScopeTagsNextLink;
            this.changedFields = changedFields.add("roleScopeTags");
            return this;
        }

        /**
         * <i>“Validation/assignment status of the PolicySet.”</i>
         * 
         * @param status
         *            value of {@code status} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder status(PolicySetStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        /**
         * <i>“Assignments of the PolicySet.”</i>
         * 
         * @param assignments
         *            value of {@code assignments} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder assignments(List<PolicySetAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        /**
         * <i>“Assignments of the PolicySet.”</i>
         * 
         * @param assignments
         *            value of {@code assignments} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder assignments(PolicySetAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        /**
         * <i>“Items of the PolicySet with maximum count 100.”</i>
         * 
         * @param items
         *            value of {@code items} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder items(List<PolicySetItem> items) {
            this.items = items;
            this.changedFields = changedFields.add("items");
            return this;
        }

        /**
         * <i>“Items of the PolicySet with maximum count 100.”</i>
         * 
         * @param items
         *            value of {@code items} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder items(PolicySetItem... items) {
            return items(Arrays.asList(items));
        }

        public PolicySet build() {
            PolicySet _x = new PolicySet();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.policySet";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.errorCode = errorCode;
            _x.guidedDeploymentTags = guidedDeploymentTags;
            _x.guidedDeploymentTagsNextLink = guidedDeploymentTagsNextLink;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTags = roleScopeTags;
            _x.roleScopeTagsNextLink = roleScopeTagsNextLink;
            _x.status = status;
            _x.assignments = assignments;
            _x.items = items;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Creation time of the PolicySet.”</i>
     * 
     * @return property createdDateTime
     */
    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code createdDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Creation time of the PolicySet.”</i>
     * 
     * @param createdDateTime
     *            new value of {@code createdDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code createdDateTime} field changed
     */
    public PolicySet withCreatedDateTime(OffsetDateTime createdDateTime) {
        PolicySet _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.policySet");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    /**
     * <i>“Description of the PolicySet.”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Description of the PolicySet.”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public PolicySet withDescription(String description) {
        PolicySet _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.policySet");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“DisplayName of the PolicySet.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“DisplayName of the PolicySet.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public PolicySet withDisplayName(String displayName) {
        PolicySet _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.policySet");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“Error code if any occured.”</i>
     * 
     * @return property errorCode
     */
    @Property(name="errorCode")
    @JsonIgnore
    public Optional<ErrorCode> getErrorCode() {
        return Optional.ofNullable(errorCode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code errorCode} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Error code if any occured.”</i>
     * 
     * @param errorCode
     *            new value of {@code errorCode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code errorCode} field changed
     */
    public PolicySet withErrorCode(ErrorCode errorCode) {
        PolicySet _x = _copy();
        _x.changedFields = changedFields.add("errorCode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.policySet");
        _x.errorCode = errorCode;
        return _x;
    }

    /**
     * <i>“Tags of the guided deployment”</i>
     * 
     * @return property guidedDeploymentTags
     */
    @Property(name="guidedDeploymentTags")
    @JsonIgnore
    public CollectionPage<String> getGuidedDeploymentTags() {
        return new CollectionPage<String>(contextPath, String.class, this.guidedDeploymentTags, Optional.ofNullable(guidedDeploymentTagsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * guidedDeploymentTags} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Tags of the guided deployment”</i>
     * 
     * @param guidedDeploymentTags
     *            new value of {@code guidedDeploymentTags} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code guidedDeploymentTags} field changed
     */
    public PolicySet withGuidedDeploymentTags(List<String> guidedDeploymentTags) {
        PolicySet _x = _copy();
        _x.changedFields = changedFields.add("guidedDeploymentTags");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.policySet");
        _x.guidedDeploymentTags = guidedDeploymentTags;
        return _x;
    }

    /**
     * <i>“Tags of the guided deployment”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property guidedDeploymentTags
     */
    @Property(name="guidedDeploymentTags")
    @JsonIgnore
    public CollectionPage<String> getGuidedDeploymentTags(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.guidedDeploymentTags, Optional.ofNullable(guidedDeploymentTagsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Last modified time of the PolicySet.”</i>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Last modified time of the PolicySet.”</i>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public PolicySet withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        PolicySet _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.policySet");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    /**
     * <i>“RoleScopeTags of the PolicySet”</i>
     * 
     * @return property roleScopeTags
     */
    @Property(name="roleScopeTags")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTags() {
        return new CollectionPage<String>(contextPath, String.class, this.roleScopeTags, Optional.ofNullable(roleScopeTagsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code roleScopeTags}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“RoleScopeTags of the PolicySet”</i>
     * 
     * @param roleScopeTags
     *            new value of {@code roleScopeTags} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code roleScopeTags} field changed
     */
    public PolicySet withRoleScopeTags(List<String> roleScopeTags) {
        PolicySet _x = _copy();
        _x.changedFields = changedFields.add("roleScopeTags");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.policySet");
        _x.roleScopeTags = roleScopeTags;
        return _x;
    }

    /**
     * <i>“RoleScopeTags of the PolicySet”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property roleScopeTags
     */
    @Property(name="roleScopeTags")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTags(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.roleScopeTags, Optional.ofNullable(roleScopeTagsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Validation/assignment status of the PolicySet.”</i>
     * 
     * @return property status
     */
    @Property(name="status")
    @JsonIgnore
    public Optional<PolicySetStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code status} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Validation/assignment status of the PolicySet.”</i>
     * 
     * @param status
     *            new value of {@code status} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code status} field changed
     */
    public PolicySet withStatus(PolicySetStatus status) {
        PolicySet _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.policySet");
        _x.status = status;
        return _x;
    }

    public PolicySet withUnmappedField(String name, Object value) {
        PolicySet _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“Assignments of the PolicySet.”</i>
     * 
     * @return navigational property assignments
     */
    @NavigationProperty(name="assignments")
    @JsonIgnore
    public PolicySetAssignmentCollectionRequest getAssignments() {
        return new PolicySetAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"), Optional.ofNullable(assignments));
    }

    /**
     * <i>“Items of the PolicySet with maximum count 100.”</i>
     * 
     * @return navigational property items
     */
    @NavigationProperty(name="items")
    @JsonIgnore
    public PolicySetItemCollectionRequest getItems() {
        return new PolicySetItemCollectionRequest(
                        contextPath.addSegment("items"), Optional.ofNullable(items));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code assignments}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Assignments of the PolicySet.”</i>
     * 
     * @param assignments
     *            new value of {@code assignments} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code assignments} field changed
     */
    public PolicySet withAssignments(List<PolicySetAssignment> assignments) {
        PolicySet _x = _copy();
        _x.changedFields = changedFields.add("assignments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.policySet");
        _x.assignments = assignments;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code items} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Items of the PolicySet with maximum count 100.”</i>
     * 
     * @param items
     *            new value of {@code items} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code items} field changed
     */
    public PolicySet withItems(List<PolicySetItem> items) {
        PolicySet _x = _copy();
        _x.changedFields = changedFields.add("items");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.policySet");
        _x.items = items;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PolicySet patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        PolicySet _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PolicySet put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        PolicySet _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private PolicySet _copy() {
        PolicySet _x = new PolicySet();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.errorCode = errorCode;
        _x.guidedDeploymentTags = guidedDeploymentTags;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTags = roleScopeTags;
        _x.status = status;
        _x.assignments = assignments;
        _x.items = items;
        return _x;
    }

    @Action(name = "update")
    @JsonIgnore
    public ActionRequestNoReturn update(List<PolicySetItem> addedPolicySetItems, List<PolicySetItem> updatedPolicySetItems, List<String> deletedPolicySetItems, List<PolicySetAssignment> assignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("addedPolicySetItems", "Collection(microsoft.graph.policySetItem)", addedPolicySetItems)
            .put("updatedPolicySetItems", "Collection(microsoft.graph.policySetItem)", updatedPolicySetItems)
            .put("deletedPolicySetItems", "Collection(Edm.String)", Checks.checkIsAscii(deletedPolicySetItems))
            .put("assignments", "Collection(microsoft.graph.policySetAssignment)", assignments)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.update"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PolicySet[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("errorCode=");
        b.append(this.errorCode);
        b.append(", ");
        b.append("guidedDeploymentTags=");
        b.append(this.guidedDeploymentTags);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTags=");
        b.append(this.roleScopeTags);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("items=");
        b.append(this.items);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
