package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.ActivityBasedTimeoutPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AppManagementPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AuthorizationPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ClaimsMappingPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ConditionalAccessPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.FeatureRolloutPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.HomeRealmDiscoveryPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MobilityManagementPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PermissionGrantPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ServicePrincipalCreationPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TokenIssuancePolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TokenLifetimePolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UnifiedRoleManagementPolicyAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UnifiedRoleManagementPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.request.AccessReviewPolicyRequest;
import odata.msgraph.client.beta.entity.request.AdminConsentRequestPolicyRequest;
import odata.msgraph.client.beta.entity.request.AuthenticationFlowsPolicyRequest;
import odata.msgraph.client.beta.entity.request.AuthenticationMethodsPolicyRequest;
import odata.msgraph.client.beta.entity.request.B2cAuthenticationMethodsPolicyRequest;
import odata.msgraph.client.beta.entity.request.CrossTenantAccessPolicyRequest;
import odata.msgraph.client.beta.entity.request.DirectoryRoleAccessReviewPolicyRequest;
import odata.msgraph.client.beta.entity.request.ExternalIdentitiesPolicyRequest;
import odata.msgraph.client.beta.entity.request.IdentitySecurityDefaultsEnforcementPolicyRequest;
import odata.msgraph.client.beta.entity.request.TenantAppManagementPolicyRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "authenticationMethodsPolicy", 
    "authenticationFlowsPolicy", 
    "b2cAuthenticationMethodsPolicy", 
    "activityBasedTimeoutPolicies", 
    "appManagementPolicies", 
    "authorizationPolicy", 
    "claimsMappingPolicies", 
    "crossTenantAccessPolicy", 
    "defaultAppManagementPolicy", 
    "externalIdentitiesPolicy", 
    "homeRealmDiscoveryPolicies", 
    "permissionGrantPolicies", 
    "servicePrincipalCreationPolicies", 
    "tokenIssuancePolicies", 
    "tokenLifetimePolicies", 
    "featureRolloutPolicies", 
    "accessReviewPolicy", 
    "adminConsentRequestPolicy", 
    "directoryRoleAccessReviewPolicy", 
    "conditionalAccessPolicies", 
    "identitySecurityDefaultsEnforcementPolicy", 
    "mobileAppManagementPolicies", 
    "mobileDeviceManagementPolicies", 
    "roleManagementPolicies", 
    "roleManagementPolicyAssignments"})
@JsonInclude(Include.NON_NULL)
public class PolicyRoot implements ODataEntityType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JacksonInject
    @JsonIgnore
    protected ChangedFields changedFields;

    @Override
    public String odataTypeName() {
        return "microsoft.graph.policyRoot";
    }

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("authenticationMethodsPolicy")
    protected AuthenticationMethodsPolicy authenticationMethodsPolicy;

    @JsonProperty("authenticationFlowsPolicy")
    protected AuthenticationFlowsPolicy authenticationFlowsPolicy;

    @JsonProperty("b2cAuthenticationMethodsPolicy")
    protected B2cAuthenticationMethodsPolicy b2cAuthenticationMethodsPolicy;

    @JsonProperty("activityBasedTimeoutPolicies")
    protected List<ActivityBasedTimeoutPolicy> activityBasedTimeoutPolicies;

    @JsonProperty("appManagementPolicies")
    protected List<AppManagementPolicy> appManagementPolicies;

    @JsonProperty("authorizationPolicy")
    protected List<AuthorizationPolicy> authorizationPolicy;

    @JsonProperty("claimsMappingPolicies")
    protected List<ClaimsMappingPolicy> claimsMappingPolicies;

    @JsonProperty("crossTenantAccessPolicy")
    protected CrossTenantAccessPolicy crossTenantAccessPolicy;

    @JsonProperty("defaultAppManagementPolicy")
    protected TenantAppManagementPolicy defaultAppManagementPolicy;

    @JsonProperty("externalIdentitiesPolicy")
    protected ExternalIdentitiesPolicy externalIdentitiesPolicy;

    @JsonProperty("homeRealmDiscoveryPolicies")
    protected List<HomeRealmDiscoveryPolicy> homeRealmDiscoveryPolicies;

    @JsonProperty("permissionGrantPolicies")
    protected List<PermissionGrantPolicy> permissionGrantPolicies;

    @JsonProperty("servicePrincipalCreationPolicies")
    protected List<ServicePrincipalCreationPolicy> servicePrincipalCreationPolicies;

    @JsonProperty("tokenIssuancePolicies")
    protected List<TokenIssuancePolicy> tokenIssuancePolicies;

    @JsonProperty("tokenLifetimePolicies")
    protected List<TokenLifetimePolicy> tokenLifetimePolicies;

    @JsonProperty("featureRolloutPolicies")
    protected List<FeatureRolloutPolicy> featureRolloutPolicies;

    @JsonProperty("accessReviewPolicy")
    protected AccessReviewPolicy accessReviewPolicy;

    @JsonProperty("adminConsentRequestPolicy")
    protected AdminConsentRequestPolicy adminConsentRequestPolicy;

    @JsonProperty("directoryRoleAccessReviewPolicy")
    protected DirectoryRoleAccessReviewPolicy directoryRoleAccessReviewPolicy;

    @JsonProperty("conditionalAccessPolicies")
    protected List<ConditionalAccessPolicy> conditionalAccessPolicies;

    @JsonProperty("identitySecurityDefaultsEnforcementPolicy")
    protected IdentitySecurityDefaultsEnforcementPolicy identitySecurityDefaultsEnforcementPolicy;

    @JsonProperty("mobileAppManagementPolicies")
    protected List<MobilityManagementPolicy> mobileAppManagementPolicies;

    @JsonProperty("mobileDeviceManagementPolicies")
    protected List<MobilityManagementPolicy> mobileDeviceManagementPolicies;

    @JsonProperty("roleManagementPolicies")
    protected List<UnifiedRoleManagementPolicy> roleManagementPolicies;

    @JsonProperty("roleManagementPolicyAssignments")
    protected List<UnifiedRoleManagementPolicyAssignment> roleManagementPolicyAssignments;

    protected PolicyRoot() {
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private AuthenticationMethodsPolicy authenticationMethodsPolicy;
        private AuthenticationFlowsPolicy authenticationFlowsPolicy;
        private B2cAuthenticationMethodsPolicy b2cAuthenticationMethodsPolicy;
        private List<ActivityBasedTimeoutPolicy> activityBasedTimeoutPolicies;
        private List<AppManagementPolicy> appManagementPolicies;
        private List<AuthorizationPolicy> authorizationPolicy;
        private List<ClaimsMappingPolicy> claimsMappingPolicies;
        private CrossTenantAccessPolicy crossTenantAccessPolicy;
        private TenantAppManagementPolicy defaultAppManagementPolicy;
        private ExternalIdentitiesPolicy externalIdentitiesPolicy;
        private List<HomeRealmDiscoveryPolicy> homeRealmDiscoveryPolicies;
        private List<PermissionGrantPolicy> permissionGrantPolicies;
        private List<ServicePrincipalCreationPolicy> servicePrincipalCreationPolicies;
        private List<TokenIssuancePolicy> tokenIssuancePolicies;
        private List<TokenLifetimePolicy> tokenLifetimePolicies;
        private List<FeatureRolloutPolicy> featureRolloutPolicies;
        private AccessReviewPolicy accessReviewPolicy;
        private AdminConsentRequestPolicy adminConsentRequestPolicy;
        private DirectoryRoleAccessReviewPolicy directoryRoleAccessReviewPolicy;
        private List<ConditionalAccessPolicy> conditionalAccessPolicies;
        private IdentitySecurityDefaultsEnforcementPolicy identitySecurityDefaultsEnforcementPolicy;
        private List<MobilityManagementPolicy> mobileAppManagementPolicies;
        private List<MobilityManagementPolicy> mobileDeviceManagementPolicies;
        private List<UnifiedRoleManagementPolicy> roleManagementPolicies;
        private List<UnifiedRoleManagementPolicyAssignment> roleManagementPolicyAssignments;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder authenticationMethodsPolicy(AuthenticationMethodsPolicy authenticationMethodsPolicy) {
            this.authenticationMethodsPolicy = authenticationMethodsPolicy;
            this.changedFields = changedFields.add("authenticationMethodsPolicy");
            return this;
        }

        public Builder authenticationFlowsPolicy(AuthenticationFlowsPolicy authenticationFlowsPolicy) {
            this.authenticationFlowsPolicy = authenticationFlowsPolicy;
            this.changedFields = changedFields.add("authenticationFlowsPolicy");
            return this;
        }

        public Builder b2cAuthenticationMethodsPolicy(B2cAuthenticationMethodsPolicy b2cAuthenticationMethodsPolicy) {
            this.b2cAuthenticationMethodsPolicy = b2cAuthenticationMethodsPolicy;
            this.changedFields = changedFields.add("b2cAuthenticationMethodsPolicy");
            return this;
        }

        public Builder activityBasedTimeoutPolicies(List<ActivityBasedTimeoutPolicy> activityBasedTimeoutPolicies) {
            this.activityBasedTimeoutPolicies = activityBasedTimeoutPolicies;
            this.changedFields = changedFields.add("activityBasedTimeoutPolicies");
            return this;
        }

        public Builder activityBasedTimeoutPolicies(ActivityBasedTimeoutPolicy... activityBasedTimeoutPolicies) {
            return activityBasedTimeoutPolicies(Arrays.asList(activityBasedTimeoutPolicies));
        }

        public Builder appManagementPolicies(List<AppManagementPolicy> appManagementPolicies) {
            this.appManagementPolicies = appManagementPolicies;
            this.changedFields = changedFields.add("appManagementPolicies");
            return this;
        }

        public Builder appManagementPolicies(AppManagementPolicy... appManagementPolicies) {
            return appManagementPolicies(Arrays.asList(appManagementPolicies));
        }

        public Builder authorizationPolicy(List<AuthorizationPolicy> authorizationPolicy) {
            this.authorizationPolicy = authorizationPolicy;
            this.changedFields = changedFields.add("authorizationPolicy");
            return this;
        }

        public Builder authorizationPolicy(AuthorizationPolicy... authorizationPolicy) {
            return authorizationPolicy(Arrays.asList(authorizationPolicy));
        }

        public Builder claimsMappingPolicies(List<ClaimsMappingPolicy> claimsMappingPolicies) {
            this.claimsMappingPolicies = claimsMappingPolicies;
            this.changedFields = changedFields.add("claimsMappingPolicies");
            return this;
        }

        public Builder claimsMappingPolicies(ClaimsMappingPolicy... claimsMappingPolicies) {
            return claimsMappingPolicies(Arrays.asList(claimsMappingPolicies));
        }

        public Builder crossTenantAccessPolicy(CrossTenantAccessPolicy crossTenantAccessPolicy) {
            this.crossTenantAccessPolicy = crossTenantAccessPolicy;
            this.changedFields = changedFields.add("crossTenantAccessPolicy");
            return this;
        }

        public Builder defaultAppManagementPolicy(TenantAppManagementPolicy defaultAppManagementPolicy) {
            this.defaultAppManagementPolicy = defaultAppManagementPolicy;
            this.changedFields = changedFields.add("defaultAppManagementPolicy");
            return this;
        }

        public Builder externalIdentitiesPolicy(ExternalIdentitiesPolicy externalIdentitiesPolicy) {
            this.externalIdentitiesPolicy = externalIdentitiesPolicy;
            this.changedFields = changedFields.add("externalIdentitiesPolicy");
            return this;
        }

        public Builder homeRealmDiscoveryPolicies(List<HomeRealmDiscoveryPolicy> homeRealmDiscoveryPolicies) {
            this.homeRealmDiscoveryPolicies = homeRealmDiscoveryPolicies;
            this.changedFields = changedFields.add("homeRealmDiscoveryPolicies");
            return this;
        }

        public Builder homeRealmDiscoveryPolicies(HomeRealmDiscoveryPolicy... homeRealmDiscoveryPolicies) {
            return homeRealmDiscoveryPolicies(Arrays.asList(homeRealmDiscoveryPolicies));
        }

        public Builder permissionGrantPolicies(List<PermissionGrantPolicy> permissionGrantPolicies) {
            this.permissionGrantPolicies = permissionGrantPolicies;
            this.changedFields = changedFields.add("permissionGrantPolicies");
            return this;
        }

        public Builder permissionGrantPolicies(PermissionGrantPolicy... permissionGrantPolicies) {
            return permissionGrantPolicies(Arrays.asList(permissionGrantPolicies));
        }

        public Builder servicePrincipalCreationPolicies(List<ServicePrincipalCreationPolicy> servicePrincipalCreationPolicies) {
            this.servicePrincipalCreationPolicies = servicePrincipalCreationPolicies;
            this.changedFields = changedFields.add("servicePrincipalCreationPolicies");
            return this;
        }

        public Builder servicePrincipalCreationPolicies(ServicePrincipalCreationPolicy... servicePrincipalCreationPolicies) {
            return servicePrincipalCreationPolicies(Arrays.asList(servicePrincipalCreationPolicies));
        }

        public Builder tokenIssuancePolicies(List<TokenIssuancePolicy> tokenIssuancePolicies) {
            this.tokenIssuancePolicies = tokenIssuancePolicies;
            this.changedFields = changedFields.add("tokenIssuancePolicies");
            return this;
        }

        public Builder tokenIssuancePolicies(TokenIssuancePolicy... tokenIssuancePolicies) {
            return tokenIssuancePolicies(Arrays.asList(tokenIssuancePolicies));
        }

        public Builder tokenLifetimePolicies(List<TokenLifetimePolicy> tokenLifetimePolicies) {
            this.tokenLifetimePolicies = tokenLifetimePolicies;
            this.changedFields = changedFields.add("tokenLifetimePolicies");
            return this;
        }

        public Builder tokenLifetimePolicies(TokenLifetimePolicy... tokenLifetimePolicies) {
            return tokenLifetimePolicies(Arrays.asList(tokenLifetimePolicies));
        }

        public Builder featureRolloutPolicies(List<FeatureRolloutPolicy> featureRolloutPolicies) {
            this.featureRolloutPolicies = featureRolloutPolicies;
            this.changedFields = changedFields.add("featureRolloutPolicies");
            return this;
        }

        public Builder featureRolloutPolicies(FeatureRolloutPolicy... featureRolloutPolicies) {
            return featureRolloutPolicies(Arrays.asList(featureRolloutPolicies));
        }

        public Builder accessReviewPolicy(AccessReviewPolicy accessReviewPolicy) {
            this.accessReviewPolicy = accessReviewPolicy;
            this.changedFields = changedFields.add("accessReviewPolicy");
            return this;
        }

        public Builder adminConsentRequestPolicy(AdminConsentRequestPolicy adminConsentRequestPolicy) {
            this.adminConsentRequestPolicy = adminConsentRequestPolicy;
            this.changedFields = changedFields.add("adminConsentRequestPolicy");
            return this;
        }

        public Builder directoryRoleAccessReviewPolicy(DirectoryRoleAccessReviewPolicy directoryRoleAccessReviewPolicy) {
            this.directoryRoleAccessReviewPolicy = directoryRoleAccessReviewPolicy;
            this.changedFields = changedFields.add("directoryRoleAccessReviewPolicy");
            return this;
        }

        public Builder conditionalAccessPolicies(List<ConditionalAccessPolicy> conditionalAccessPolicies) {
            this.conditionalAccessPolicies = conditionalAccessPolicies;
            this.changedFields = changedFields.add("conditionalAccessPolicies");
            return this;
        }

        public Builder conditionalAccessPolicies(ConditionalAccessPolicy... conditionalAccessPolicies) {
            return conditionalAccessPolicies(Arrays.asList(conditionalAccessPolicies));
        }

        public Builder identitySecurityDefaultsEnforcementPolicy(IdentitySecurityDefaultsEnforcementPolicy identitySecurityDefaultsEnforcementPolicy) {
            this.identitySecurityDefaultsEnforcementPolicy = identitySecurityDefaultsEnforcementPolicy;
            this.changedFields = changedFields.add("identitySecurityDefaultsEnforcementPolicy");
            return this;
        }

        public Builder mobileAppManagementPolicies(List<MobilityManagementPolicy> mobileAppManagementPolicies) {
            this.mobileAppManagementPolicies = mobileAppManagementPolicies;
            this.changedFields = changedFields.add("mobileAppManagementPolicies");
            return this;
        }

        public Builder mobileAppManagementPolicies(MobilityManagementPolicy... mobileAppManagementPolicies) {
            return mobileAppManagementPolicies(Arrays.asList(mobileAppManagementPolicies));
        }

        public Builder mobileDeviceManagementPolicies(List<MobilityManagementPolicy> mobileDeviceManagementPolicies) {
            this.mobileDeviceManagementPolicies = mobileDeviceManagementPolicies;
            this.changedFields = changedFields.add("mobileDeviceManagementPolicies");
            return this;
        }

        public Builder mobileDeviceManagementPolicies(MobilityManagementPolicy... mobileDeviceManagementPolicies) {
            return mobileDeviceManagementPolicies(Arrays.asList(mobileDeviceManagementPolicies));
        }

        public Builder roleManagementPolicies(List<UnifiedRoleManagementPolicy> roleManagementPolicies) {
            this.roleManagementPolicies = roleManagementPolicies;
            this.changedFields = changedFields.add("roleManagementPolicies");
            return this;
        }

        public Builder roleManagementPolicies(UnifiedRoleManagementPolicy... roleManagementPolicies) {
            return roleManagementPolicies(Arrays.asList(roleManagementPolicies));
        }

        public Builder roleManagementPolicyAssignments(List<UnifiedRoleManagementPolicyAssignment> roleManagementPolicyAssignments) {
            this.roleManagementPolicyAssignments = roleManagementPolicyAssignments;
            this.changedFields = changedFields.add("roleManagementPolicyAssignments");
            return this;
        }

        public Builder roleManagementPolicyAssignments(UnifiedRoleManagementPolicyAssignment... roleManagementPolicyAssignments) {
            return roleManagementPolicyAssignments(Arrays.asList(roleManagementPolicyAssignments));
        }

        public PolicyRoot build() {
            PolicyRoot _x = new PolicyRoot();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.policyRoot";
            _x.authenticationMethodsPolicy = authenticationMethodsPolicy;
            _x.authenticationFlowsPolicy = authenticationFlowsPolicy;
            _x.b2cAuthenticationMethodsPolicy = b2cAuthenticationMethodsPolicy;
            _x.activityBasedTimeoutPolicies = activityBasedTimeoutPolicies;
            _x.appManagementPolicies = appManagementPolicies;
            _x.authorizationPolicy = authorizationPolicy;
            _x.claimsMappingPolicies = claimsMappingPolicies;
            _x.crossTenantAccessPolicy = crossTenantAccessPolicy;
            _x.defaultAppManagementPolicy = defaultAppManagementPolicy;
            _x.externalIdentitiesPolicy = externalIdentitiesPolicy;
            _x.homeRealmDiscoveryPolicies = homeRealmDiscoveryPolicies;
            _x.permissionGrantPolicies = permissionGrantPolicies;
            _x.servicePrincipalCreationPolicies = servicePrincipalCreationPolicies;
            _x.tokenIssuancePolicies = tokenIssuancePolicies;
            _x.tokenLifetimePolicies = tokenLifetimePolicies;
            _x.featureRolloutPolicies = featureRolloutPolicies;
            _x.accessReviewPolicy = accessReviewPolicy;
            _x.adminConsentRequestPolicy = adminConsentRequestPolicy;
            _x.directoryRoleAccessReviewPolicy = directoryRoleAccessReviewPolicy;
            _x.conditionalAccessPolicies = conditionalAccessPolicies;
            _x.identitySecurityDefaultsEnforcementPolicy = identitySecurityDefaultsEnforcementPolicy;
            _x.mobileAppManagementPolicies = mobileAppManagementPolicies;
            _x.mobileDeviceManagementPolicies = mobileDeviceManagementPolicies;
            _x.roleManagementPolicies = roleManagementPolicies;
            _x.roleManagementPolicyAssignments = roleManagementPolicyAssignments;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath) {
            contextPath = contextPath.clearQueries();
        }
    }

    public PolicyRoot withUnmappedField(String name, Object value) {
        PolicyRoot _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="authenticationMethodsPolicy")
    @JsonIgnore
    public AuthenticationMethodsPolicyRequest getAuthenticationMethodsPolicy() {
        return new AuthenticationMethodsPolicyRequest(contextPath.addSegment("authenticationMethodsPolicy"), Optional.ofNullable(authenticationMethodsPolicy));
    }

    @NavigationProperty(name="authenticationFlowsPolicy")
    @JsonIgnore
    public AuthenticationFlowsPolicyRequest getAuthenticationFlowsPolicy() {
        return new AuthenticationFlowsPolicyRequest(contextPath.addSegment("authenticationFlowsPolicy"), Optional.ofNullable(authenticationFlowsPolicy));
    }

    @NavigationProperty(name="b2cAuthenticationMethodsPolicy")
    @JsonIgnore
    public B2cAuthenticationMethodsPolicyRequest getB2cAuthenticationMethodsPolicy() {
        return new B2cAuthenticationMethodsPolicyRequest(contextPath.addSegment("b2cAuthenticationMethodsPolicy"), Optional.ofNullable(b2cAuthenticationMethodsPolicy));
    }

    @NavigationProperty(name="activityBasedTimeoutPolicies")
    @JsonIgnore
    public ActivityBasedTimeoutPolicyCollectionRequest getActivityBasedTimeoutPolicies() {
        return new ActivityBasedTimeoutPolicyCollectionRequest(
                        contextPath.addSegment("activityBasedTimeoutPolicies"), Optional.ofNullable(activityBasedTimeoutPolicies));
    }

    @NavigationProperty(name="appManagementPolicies")
    @JsonIgnore
    public AppManagementPolicyCollectionRequest getAppManagementPolicies() {
        return new AppManagementPolicyCollectionRequest(
                        contextPath.addSegment("appManagementPolicies"), Optional.ofNullable(appManagementPolicies));
    }

    @NavigationProperty(name="authorizationPolicy")
    @JsonIgnore
    public AuthorizationPolicyCollectionRequest getAuthorizationPolicy() {
        return new AuthorizationPolicyCollectionRequest(
                        contextPath.addSegment("authorizationPolicy"), Optional.ofNullable(authorizationPolicy));
    }

    @NavigationProperty(name="claimsMappingPolicies")
    @JsonIgnore
    public ClaimsMappingPolicyCollectionRequest getClaimsMappingPolicies() {
        return new ClaimsMappingPolicyCollectionRequest(
                        contextPath.addSegment("claimsMappingPolicies"), Optional.ofNullable(claimsMappingPolicies));
    }

    @NavigationProperty(name="crossTenantAccessPolicy")
    @JsonIgnore
    public CrossTenantAccessPolicyRequest getCrossTenantAccessPolicy() {
        return new CrossTenantAccessPolicyRequest(contextPath.addSegment("crossTenantAccessPolicy"), Optional.ofNullable(crossTenantAccessPolicy));
    }

    @NavigationProperty(name="defaultAppManagementPolicy")
    @JsonIgnore
    public TenantAppManagementPolicyRequest getDefaultAppManagementPolicy() {
        return new TenantAppManagementPolicyRequest(contextPath.addSegment("defaultAppManagementPolicy"), Optional.ofNullable(defaultAppManagementPolicy));
    }

    @NavigationProperty(name="externalIdentitiesPolicy")
    @JsonIgnore
    public ExternalIdentitiesPolicyRequest getExternalIdentitiesPolicy() {
        return new ExternalIdentitiesPolicyRequest(contextPath.addSegment("externalIdentitiesPolicy"), Optional.ofNullable(externalIdentitiesPolicy));
    }

    @NavigationProperty(name="homeRealmDiscoveryPolicies")
    @JsonIgnore
    public HomeRealmDiscoveryPolicyCollectionRequest getHomeRealmDiscoveryPolicies() {
        return new HomeRealmDiscoveryPolicyCollectionRequest(
                        contextPath.addSegment("homeRealmDiscoveryPolicies"), Optional.ofNullable(homeRealmDiscoveryPolicies));
    }

    @NavigationProperty(name="permissionGrantPolicies")
    @JsonIgnore
    public PermissionGrantPolicyCollectionRequest getPermissionGrantPolicies() {
        return new PermissionGrantPolicyCollectionRequest(
                        contextPath.addSegment("permissionGrantPolicies"), Optional.ofNullable(permissionGrantPolicies));
    }

    @NavigationProperty(name="servicePrincipalCreationPolicies")
    @JsonIgnore
    public ServicePrincipalCreationPolicyCollectionRequest getServicePrincipalCreationPolicies() {
        return new ServicePrincipalCreationPolicyCollectionRequest(
                        contextPath.addSegment("servicePrincipalCreationPolicies"), Optional.ofNullable(servicePrincipalCreationPolicies));
    }

    @NavigationProperty(name="tokenIssuancePolicies")
    @JsonIgnore
    public TokenIssuancePolicyCollectionRequest getTokenIssuancePolicies() {
        return new TokenIssuancePolicyCollectionRequest(
                        contextPath.addSegment("tokenIssuancePolicies"), Optional.ofNullable(tokenIssuancePolicies));
    }

    @NavigationProperty(name="tokenLifetimePolicies")
    @JsonIgnore
    public TokenLifetimePolicyCollectionRequest getTokenLifetimePolicies() {
        return new TokenLifetimePolicyCollectionRequest(
                        contextPath.addSegment("tokenLifetimePolicies"), Optional.ofNullable(tokenLifetimePolicies));
    }

    @NavigationProperty(name="featureRolloutPolicies")
    @JsonIgnore
    public FeatureRolloutPolicyCollectionRequest getFeatureRolloutPolicies() {
        return new FeatureRolloutPolicyCollectionRequest(
                        contextPath.addSegment("featureRolloutPolicies"), Optional.ofNullable(featureRolloutPolicies));
    }

    @NavigationProperty(name="accessReviewPolicy")
    @JsonIgnore
    public AccessReviewPolicyRequest getAccessReviewPolicy() {
        return new AccessReviewPolicyRequest(contextPath.addSegment("accessReviewPolicy"), Optional.ofNullable(accessReviewPolicy));
    }

    @NavigationProperty(name="adminConsentRequestPolicy")
    @JsonIgnore
    public AdminConsentRequestPolicyRequest getAdminConsentRequestPolicy() {
        return new AdminConsentRequestPolicyRequest(contextPath.addSegment("adminConsentRequestPolicy"), Optional.ofNullable(adminConsentRequestPolicy));
    }

    @NavigationProperty(name="directoryRoleAccessReviewPolicy")
    @JsonIgnore
    public DirectoryRoleAccessReviewPolicyRequest getDirectoryRoleAccessReviewPolicy() {
        return new DirectoryRoleAccessReviewPolicyRequest(contextPath.addSegment("directoryRoleAccessReviewPolicy"), Optional.ofNullable(directoryRoleAccessReviewPolicy));
    }

    @NavigationProperty(name="conditionalAccessPolicies")
    @JsonIgnore
    public ConditionalAccessPolicyCollectionRequest getConditionalAccessPolicies() {
        return new ConditionalAccessPolicyCollectionRequest(
                        contextPath.addSegment("conditionalAccessPolicies"), Optional.ofNullable(conditionalAccessPolicies));
    }

    @NavigationProperty(name="identitySecurityDefaultsEnforcementPolicy")
    @JsonIgnore
    public IdentitySecurityDefaultsEnforcementPolicyRequest getIdentitySecurityDefaultsEnforcementPolicy() {
        return new IdentitySecurityDefaultsEnforcementPolicyRequest(contextPath.addSegment("identitySecurityDefaultsEnforcementPolicy"), Optional.ofNullable(identitySecurityDefaultsEnforcementPolicy));
    }

    @NavigationProperty(name="mobileAppManagementPolicies")
    @JsonIgnore
    public MobilityManagementPolicyCollectionRequest getMobileAppManagementPolicies() {
        return new MobilityManagementPolicyCollectionRequest(
                        contextPath.addSegment("mobileAppManagementPolicies"), Optional.ofNullable(mobileAppManagementPolicies));
    }

    @NavigationProperty(name="mobileDeviceManagementPolicies")
    @JsonIgnore
    public MobilityManagementPolicyCollectionRequest getMobileDeviceManagementPolicies() {
        return new MobilityManagementPolicyCollectionRequest(
                        contextPath.addSegment("mobileDeviceManagementPolicies"), Optional.ofNullable(mobileDeviceManagementPolicies));
    }

    @NavigationProperty(name="roleManagementPolicies")
    @JsonIgnore
    public UnifiedRoleManagementPolicyCollectionRequest getRoleManagementPolicies() {
        return new UnifiedRoleManagementPolicyCollectionRequest(
                        contextPath.addSegment("roleManagementPolicies"), Optional.ofNullable(roleManagementPolicies));
    }

    @NavigationProperty(name="roleManagementPolicyAssignments")
    @JsonIgnore
    public UnifiedRoleManagementPolicyAssignmentCollectionRequest getRoleManagementPolicyAssignments() {
        return new UnifiedRoleManagementPolicyAssignmentCollectionRequest(
                        contextPath.addSegment("roleManagementPolicyAssignments"), Optional.ofNullable(roleManagementPolicyAssignments));
    }

    public PolicyRoot withAuthenticationMethodsPolicy(AuthenticationMethodsPolicy authenticationMethodsPolicy) {
        PolicyRoot _x = _copy();
        _x.changedFields = changedFields.add("authenticationMethodsPolicy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.policyRoot");
        _x.authenticationMethodsPolicy = authenticationMethodsPolicy;
        return _x;
    }

    public PolicyRoot withAuthenticationFlowsPolicy(AuthenticationFlowsPolicy authenticationFlowsPolicy) {
        PolicyRoot _x = _copy();
        _x.changedFields = changedFields.add("authenticationFlowsPolicy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.policyRoot");
        _x.authenticationFlowsPolicy = authenticationFlowsPolicy;
        return _x;
    }

    public PolicyRoot withB2cAuthenticationMethodsPolicy(B2cAuthenticationMethodsPolicy b2cAuthenticationMethodsPolicy) {
        PolicyRoot _x = _copy();
        _x.changedFields = changedFields.add("b2cAuthenticationMethodsPolicy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.policyRoot");
        _x.b2cAuthenticationMethodsPolicy = b2cAuthenticationMethodsPolicy;
        return _x;
    }

    public PolicyRoot withActivityBasedTimeoutPolicies(List<ActivityBasedTimeoutPolicy> activityBasedTimeoutPolicies) {
        PolicyRoot _x = _copy();
        _x.changedFields = changedFields.add("activityBasedTimeoutPolicies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.policyRoot");
        _x.activityBasedTimeoutPolicies = activityBasedTimeoutPolicies;
        return _x;
    }

    public PolicyRoot withAppManagementPolicies(List<AppManagementPolicy> appManagementPolicies) {
        PolicyRoot _x = _copy();
        _x.changedFields = changedFields.add("appManagementPolicies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.policyRoot");
        _x.appManagementPolicies = appManagementPolicies;
        return _x;
    }

    public PolicyRoot withAuthorizationPolicy(List<AuthorizationPolicy> authorizationPolicy) {
        PolicyRoot _x = _copy();
        _x.changedFields = changedFields.add("authorizationPolicy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.policyRoot");
        _x.authorizationPolicy = authorizationPolicy;
        return _x;
    }

    public PolicyRoot withClaimsMappingPolicies(List<ClaimsMappingPolicy> claimsMappingPolicies) {
        PolicyRoot _x = _copy();
        _x.changedFields = changedFields.add("claimsMappingPolicies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.policyRoot");
        _x.claimsMappingPolicies = claimsMappingPolicies;
        return _x;
    }

    public PolicyRoot withCrossTenantAccessPolicy(CrossTenantAccessPolicy crossTenantAccessPolicy) {
        PolicyRoot _x = _copy();
        _x.changedFields = changedFields.add("crossTenantAccessPolicy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.policyRoot");
        _x.crossTenantAccessPolicy = crossTenantAccessPolicy;
        return _x;
    }

    public PolicyRoot withDefaultAppManagementPolicy(TenantAppManagementPolicy defaultAppManagementPolicy) {
        PolicyRoot _x = _copy();
        _x.changedFields = changedFields.add("defaultAppManagementPolicy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.policyRoot");
        _x.defaultAppManagementPolicy = defaultAppManagementPolicy;
        return _x;
    }

    public PolicyRoot withExternalIdentitiesPolicy(ExternalIdentitiesPolicy externalIdentitiesPolicy) {
        PolicyRoot _x = _copy();
        _x.changedFields = changedFields.add("externalIdentitiesPolicy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.policyRoot");
        _x.externalIdentitiesPolicy = externalIdentitiesPolicy;
        return _x;
    }

    public PolicyRoot withHomeRealmDiscoveryPolicies(List<HomeRealmDiscoveryPolicy> homeRealmDiscoveryPolicies) {
        PolicyRoot _x = _copy();
        _x.changedFields = changedFields.add("homeRealmDiscoveryPolicies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.policyRoot");
        _x.homeRealmDiscoveryPolicies = homeRealmDiscoveryPolicies;
        return _x;
    }

    public PolicyRoot withPermissionGrantPolicies(List<PermissionGrantPolicy> permissionGrantPolicies) {
        PolicyRoot _x = _copy();
        _x.changedFields = changedFields.add("permissionGrantPolicies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.policyRoot");
        _x.permissionGrantPolicies = permissionGrantPolicies;
        return _x;
    }

    public PolicyRoot withServicePrincipalCreationPolicies(List<ServicePrincipalCreationPolicy> servicePrincipalCreationPolicies) {
        PolicyRoot _x = _copy();
        _x.changedFields = changedFields.add("servicePrincipalCreationPolicies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.policyRoot");
        _x.servicePrincipalCreationPolicies = servicePrincipalCreationPolicies;
        return _x;
    }

    public PolicyRoot withTokenIssuancePolicies(List<TokenIssuancePolicy> tokenIssuancePolicies) {
        PolicyRoot _x = _copy();
        _x.changedFields = changedFields.add("tokenIssuancePolicies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.policyRoot");
        _x.tokenIssuancePolicies = tokenIssuancePolicies;
        return _x;
    }

    public PolicyRoot withTokenLifetimePolicies(List<TokenLifetimePolicy> tokenLifetimePolicies) {
        PolicyRoot _x = _copy();
        _x.changedFields = changedFields.add("tokenLifetimePolicies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.policyRoot");
        _x.tokenLifetimePolicies = tokenLifetimePolicies;
        return _x;
    }

    public PolicyRoot withFeatureRolloutPolicies(List<FeatureRolloutPolicy> featureRolloutPolicies) {
        PolicyRoot _x = _copy();
        _x.changedFields = changedFields.add("featureRolloutPolicies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.policyRoot");
        _x.featureRolloutPolicies = featureRolloutPolicies;
        return _x;
    }

    public PolicyRoot withAccessReviewPolicy(AccessReviewPolicy accessReviewPolicy) {
        PolicyRoot _x = _copy();
        _x.changedFields = changedFields.add("accessReviewPolicy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.policyRoot");
        _x.accessReviewPolicy = accessReviewPolicy;
        return _x;
    }

    public PolicyRoot withAdminConsentRequestPolicy(AdminConsentRequestPolicy adminConsentRequestPolicy) {
        PolicyRoot _x = _copy();
        _x.changedFields = changedFields.add("adminConsentRequestPolicy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.policyRoot");
        _x.adminConsentRequestPolicy = adminConsentRequestPolicy;
        return _x;
    }

    public PolicyRoot withDirectoryRoleAccessReviewPolicy(DirectoryRoleAccessReviewPolicy directoryRoleAccessReviewPolicy) {
        PolicyRoot _x = _copy();
        _x.changedFields = changedFields.add("directoryRoleAccessReviewPolicy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.policyRoot");
        _x.directoryRoleAccessReviewPolicy = directoryRoleAccessReviewPolicy;
        return _x;
    }

    public PolicyRoot withConditionalAccessPolicies(List<ConditionalAccessPolicy> conditionalAccessPolicies) {
        PolicyRoot _x = _copy();
        _x.changedFields = changedFields.add("conditionalAccessPolicies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.policyRoot");
        _x.conditionalAccessPolicies = conditionalAccessPolicies;
        return _x;
    }

    public PolicyRoot withIdentitySecurityDefaultsEnforcementPolicy(IdentitySecurityDefaultsEnforcementPolicy identitySecurityDefaultsEnforcementPolicy) {
        PolicyRoot _x = _copy();
        _x.changedFields = changedFields.add("identitySecurityDefaultsEnforcementPolicy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.policyRoot");
        _x.identitySecurityDefaultsEnforcementPolicy = identitySecurityDefaultsEnforcementPolicy;
        return _x;
    }

    public PolicyRoot withMobileAppManagementPolicies(List<MobilityManagementPolicy> mobileAppManagementPolicies) {
        PolicyRoot _x = _copy();
        _x.changedFields = changedFields.add("mobileAppManagementPolicies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.policyRoot");
        _x.mobileAppManagementPolicies = mobileAppManagementPolicies;
        return _x;
    }

    public PolicyRoot withMobileDeviceManagementPolicies(List<MobilityManagementPolicy> mobileDeviceManagementPolicies) {
        PolicyRoot _x = _copy();
        _x.changedFields = changedFields.add("mobileDeviceManagementPolicies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.policyRoot");
        _x.mobileDeviceManagementPolicies = mobileDeviceManagementPolicies;
        return _x;
    }

    public PolicyRoot withRoleManagementPolicies(List<UnifiedRoleManagementPolicy> roleManagementPolicies) {
        PolicyRoot _x = _copy();
        _x.changedFields = changedFields.add("roleManagementPolicies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.policyRoot");
        _x.roleManagementPolicies = roleManagementPolicies;
        return _x;
    }

    public PolicyRoot withRoleManagementPolicyAssignments(List<UnifiedRoleManagementPolicyAssignment> roleManagementPolicyAssignments) {
        PolicyRoot _x = _copy();
        _x.changedFields = changedFields.add("roleManagementPolicyAssignments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.policyRoot");
        _x.roleManagementPolicyAssignments = roleManagementPolicyAssignments;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PolicyRoot patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        PolicyRoot _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PolicyRoot put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        PolicyRoot _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private PolicyRoot _copy() {
        PolicyRoot _x = new PolicyRoot();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.authenticationMethodsPolicy = authenticationMethodsPolicy;
        _x.authenticationFlowsPolicy = authenticationFlowsPolicy;
        _x.b2cAuthenticationMethodsPolicy = b2cAuthenticationMethodsPolicy;
        _x.activityBasedTimeoutPolicies = activityBasedTimeoutPolicies;
        _x.appManagementPolicies = appManagementPolicies;
        _x.authorizationPolicy = authorizationPolicy;
        _x.claimsMappingPolicies = claimsMappingPolicies;
        _x.crossTenantAccessPolicy = crossTenantAccessPolicy;
        _x.defaultAppManagementPolicy = defaultAppManagementPolicy;
        _x.externalIdentitiesPolicy = externalIdentitiesPolicy;
        _x.homeRealmDiscoveryPolicies = homeRealmDiscoveryPolicies;
        _x.permissionGrantPolicies = permissionGrantPolicies;
        _x.servicePrincipalCreationPolicies = servicePrincipalCreationPolicies;
        _x.tokenIssuancePolicies = tokenIssuancePolicies;
        _x.tokenLifetimePolicies = tokenLifetimePolicies;
        _x.featureRolloutPolicies = featureRolloutPolicies;
        _x.accessReviewPolicy = accessReviewPolicy;
        _x.adminConsentRequestPolicy = adminConsentRequestPolicy;
        _x.directoryRoleAccessReviewPolicy = directoryRoleAccessReviewPolicy;
        _x.conditionalAccessPolicies = conditionalAccessPolicies;
        _x.identitySecurityDefaultsEnforcementPolicy = identitySecurityDefaultsEnforcementPolicy;
        _x.mobileAppManagementPolicies = mobileAppManagementPolicies;
        _x.mobileDeviceManagementPolicies = mobileDeviceManagementPolicies;
        _x.roleManagementPolicies = roleManagementPolicies;
        _x.roleManagementPolicyAssignments = roleManagementPolicyAssignments;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PolicyRoot[");
        b.append("authenticationMethodsPolicy=");
        b.append(this.authenticationMethodsPolicy);
        b.append(", ");
        b.append("authenticationFlowsPolicy=");
        b.append(this.authenticationFlowsPolicy);
        b.append(", ");
        b.append("b2cAuthenticationMethodsPolicy=");
        b.append(this.b2cAuthenticationMethodsPolicy);
        b.append(", ");
        b.append("activityBasedTimeoutPolicies=");
        b.append(this.activityBasedTimeoutPolicies);
        b.append(", ");
        b.append("appManagementPolicies=");
        b.append(this.appManagementPolicies);
        b.append(", ");
        b.append("authorizationPolicy=");
        b.append(this.authorizationPolicy);
        b.append(", ");
        b.append("claimsMappingPolicies=");
        b.append(this.claimsMappingPolicies);
        b.append(", ");
        b.append("crossTenantAccessPolicy=");
        b.append(this.crossTenantAccessPolicy);
        b.append(", ");
        b.append("defaultAppManagementPolicy=");
        b.append(this.defaultAppManagementPolicy);
        b.append(", ");
        b.append("externalIdentitiesPolicy=");
        b.append(this.externalIdentitiesPolicy);
        b.append(", ");
        b.append("homeRealmDiscoveryPolicies=");
        b.append(this.homeRealmDiscoveryPolicies);
        b.append(", ");
        b.append("permissionGrantPolicies=");
        b.append(this.permissionGrantPolicies);
        b.append(", ");
        b.append("servicePrincipalCreationPolicies=");
        b.append(this.servicePrincipalCreationPolicies);
        b.append(", ");
        b.append("tokenIssuancePolicies=");
        b.append(this.tokenIssuancePolicies);
        b.append(", ");
        b.append("tokenLifetimePolicies=");
        b.append(this.tokenLifetimePolicies);
        b.append(", ");
        b.append("featureRolloutPolicies=");
        b.append(this.featureRolloutPolicies);
        b.append(", ");
        b.append("accessReviewPolicy=");
        b.append(this.accessReviewPolicy);
        b.append(", ");
        b.append("adminConsentRequestPolicy=");
        b.append(this.adminConsentRequestPolicy);
        b.append(", ");
        b.append("directoryRoleAccessReviewPolicy=");
        b.append(this.directoryRoleAccessReviewPolicy);
        b.append(", ");
        b.append("conditionalAccessPolicies=");
        b.append(this.conditionalAccessPolicies);
        b.append(", ");
        b.append("identitySecurityDefaultsEnforcementPolicy=");
        b.append(this.identitySecurityDefaultsEnforcementPolicy);
        b.append(", ");
        b.append("mobileAppManagementPolicies=");
        b.append(this.mobileAppManagementPolicies);
        b.append(", ");
        b.append("mobileDeviceManagementPolicies=");
        b.append(this.mobileDeviceManagementPolicies);
        b.append(", ");
        b.append("roleManagementPolicies=");
        b.append(this.roleManagementPolicies);
        b.append(", ");
        b.append("roleManagementPolicyAssignments=");
        b.append(this.roleManagementPolicyAssignments);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
