package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.complex.PlannerFavoritePlanReferenceCollection;
import odata.msgraph.client.beta.complex.PlannerRecentPlanReferenceCollection;
import odata.msgraph.client.beta.entity.collection.request.PlannerDeltaCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PlannerPlanCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PlannerTaskCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "favoritePlanReferences", 
    "recentPlanReferences"})
@JsonInclude(Include.NON_NULL)
public class PlannerUser extends PlannerDelta implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.plannerUser";
    }

    @JsonProperty("favoritePlanReferences")
    protected PlannerFavoritePlanReferenceCollection favoritePlanReferences;

    @JsonProperty("recentPlanReferences")
    protected PlannerRecentPlanReferenceCollection recentPlanReferences;

    protected PlannerUser() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPlannerUser() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private PlannerFavoritePlanReferenceCollection favoritePlanReferences;
        private PlannerRecentPlanReferenceCollection recentPlanReferences;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder favoritePlanReferences(PlannerFavoritePlanReferenceCollection favoritePlanReferences) {
            this.favoritePlanReferences = favoritePlanReferences;
            this.changedFields = changedFields.add("favoritePlanReferences");
            return this;
        }

        public Builder recentPlanReferences(PlannerRecentPlanReferenceCollection recentPlanReferences) {
            this.recentPlanReferences = recentPlanReferences;
            this.changedFields = changedFields.add("recentPlanReferences");
            return this;
        }

        public PlannerUser build() {
            PlannerUser _x = new PlannerUser();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.plannerUser";
            _x.id = id;
            _x.favoritePlanReferences = favoritePlanReferences;
            _x.recentPlanReferences = recentPlanReferences;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="favoritePlanReferences")
    @JsonIgnore
    public Optional<PlannerFavoritePlanReferenceCollection> getFavoritePlanReferences() {
        return Optional.ofNullable(favoritePlanReferences);
    }

    public PlannerUser withFavoritePlanReferences(PlannerFavoritePlanReferenceCollection favoritePlanReferences) {
        PlannerUser _x = _copy();
        _x.changedFields = changedFields.add("favoritePlanReferences");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerUser");
        _x.favoritePlanReferences = favoritePlanReferences;
        return _x;
    }

    @Property(name="recentPlanReferences")
    @JsonIgnore
    public Optional<PlannerRecentPlanReferenceCollection> getRecentPlanReferences() {
        return Optional.ofNullable(recentPlanReferences);
    }

    public PlannerUser withRecentPlanReferences(PlannerRecentPlanReferenceCollection recentPlanReferences) {
        PlannerUser _x = _copy();
        _x.changedFields = changedFields.add("recentPlanReferences");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerUser");
        _x.recentPlanReferences = recentPlanReferences;
        return _x;
    }

    public PlannerUser withUnmappedField(String name, Object value) {
        PlannerUser _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = true
     * 
     * @return navigational property all
     */
    @NavigationProperty(name="all")
    @JsonIgnore
    public PlannerDeltaCollectionRequest getAll() {
        return new PlannerDeltaCollectionRequest(
                        contextPath.addSegment("all"), RequestHelper.getValue(unmappedFields, "all"));
    }

    @NavigationProperty(name="favoritePlans")
    @JsonIgnore
    public PlannerPlanCollectionRequest getFavoritePlans() {
        return new PlannerPlanCollectionRequest(
                        contextPath.addSegment("favoritePlans"), RequestHelper.getValue(unmappedFields, "favoritePlans"));
    }

    @NavigationProperty(name="plans")
    @JsonIgnore
    public PlannerPlanCollectionRequest getPlans() {
        return new PlannerPlanCollectionRequest(
                        contextPath.addSegment("plans"), RequestHelper.getValue(unmappedFields, "plans"));
    }

    @NavigationProperty(name="recentPlans")
    @JsonIgnore
    public PlannerPlanCollectionRequest getRecentPlans() {
        return new PlannerPlanCollectionRequest(
                        contextPath.addSegment("recentPlans"), RequestHelper.getValue(unmappedFields, "recentPlans"));
    }

    @NavigationProperty(name="rosterPlans")
    @JsonIgnore
    public PlannerPlanCollectionRequest getRosterPlans() {
        return new PlannerPlanCollectionRequest(
                        contextPath.addSegment("rosterPlans"), RequestHelper.getValue(unmappedFields, "rosterPlans"));
    }

    @NavigationProperty(name="tasks")
    @JsonIgnore
    public PlannerTaskCollectionRequest getTasks() {
        return new PlannerTaskCollectionRequest(
                        contextPath.addSegment("tasks"), RequestHelper.getValue(unmappedFields, "tasks"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PlannerUser patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        PlannerUser _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PlannerUser put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        PlannerUser _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private PlannerUser _copy() {
        PlannerUser _x = new PlannerUser();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.favoritePlanReferences = favoritePlanReferences;
        _x.recentPlanReferences = recentPlanReferences;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PlannerUser[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("favoritePlanReferences=");
        b.append(this.favoritePlanReferences);
        b.append(", ");
        b.append("recentPlanReferences=");
        b.append(this.recentPlanReferences);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
