package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.complex.PlannerChecklistItems;
import odata.msgraph.client.beta.complex.PlannerExternalReferences;
import odata.msgraph.client.beta.enums.PlannerPreviewType;

@JsonPropertyOrder({
    "@odata.type", 
    "checklist", 
    "description", 
    "previewType", 
    "references"})
@JsonInclude(Include.NON_NULL)
public class PlannerTaskDetails extends PlannerDelta implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.plannerTaskDetails";
    }

    @JsonProperty("checklist")
    protected PlannerChecklistItems checklist;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("previewType")
    protected PlannerPreviewType previewType;

    @JsonProperty("references")
    protected PlannerExternalReferences references;

    protected PlannerTaskDetails() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPlannerTaskDetails() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private PlannerChecklistItems checklist;
        private String description;
        private PlannerPreviewType previewType;
        private PlannerExternalReferences references;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder checklist(PlannerChecklistItems checklist) {
            this.checklist = checklist;
            this.changedFields = changedFields.add("checklist");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder previewType(PlannerPreviewType previewType) {
            this.previewType = previewType;
            this.changedFields = changedFields.add("previewType");
            return this;
        }

        public Builder references(PlannerExternalReferences references) {
            this.references = references;
            this.changedFields = changedFields.add("references");
            return this;
        }

        public PlannerTaskDetails build() {
            PlannerTaskDetails _x = new PlannerTaskDetails();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.plannerTaskDetails";
            _x.id = id;
            _x.checklist = checklist;
            _x.description = description;
            _x.previewType = previewType;
            _x.references = references;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="checklist")
    @JsonIgnore
    public Optional<PlannerChecklistItems> getChecklist() {
        return Optional.ofNullable(checklist);
    }

    public PlannerTaskDetails withChecklist(PlannerChecklistItems checklist) {
        PlannerTaskDetails _x = _copy();
        _x.changedFields = changedFields.add("checklist");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerTaskDetails");
        _x.checklist = checklist;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public PlannerTaskDetails withDescription(String description) {
        PlannerTaskDetails _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerTaskDetails");
        _x.description = description;
        return _x;
    }

    @Property(name="previewType")
    @JsonIgnore
    public Optional<PlannerPreviewType> getPreviewType() {
        return Optional.ofNullable(previewType);
    }

    public PlannerTaskDetails withPreviewType(PlannerPreviewType previewType) {
        PlannerTaskDetails _x = _copy();
        _x.changedFields = changedFields.add("previewType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerTaskDetails");
        _x.previewType = previewType;
        return _x;
    }

    @Property(name="references")
    @JsonIgnore
    public Optional<PlannerExternalReferences> getReferences() {
        return Optional.ofNullable(references);
    }

    public PlannerTaskDetails withReferences(PlannerExternalReferences references) {
        PlannerTaskDetails _x = _copy();
        _x.changedFields = changedFields.add("references");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerTaskDetails");
        _x.references = references;
        return _x;
    }

    public PlannerTaskDetails withUnmappedField(String name, Object value) {
        PlannerTaskDetails _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PlannerTaskDetails patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        PlannerTaskDetails _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PlannerTaskDetails put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        PlannerTaskDetails _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private PlannerTaskDetails _copy() {
        PlannerTaskDetails _x = new PlannerTaskDetails();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.checklist = checklist;
        _x.description = description;
        _x.previewType = previewType;
        _x.references = references;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PlannerTaskDetails[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("checklist=");
        b.append(this.checklist);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("previewType=");
        b.append(this.previewType);
        b.append(", ");
        b.append("references=");
        b.append(this.references);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
