package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.complex.PlannerPlanContainer;
import odata.msgraph.client.beta.complex.PlannerPlanContextCollection;
import odata.msgraph.client.beta.entity.collection.request.PlannerBucketCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PlannerTaskCollectionRequest;
import odata.msgraph.client.beta.entity.request.PlannerPlanDetailsRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "container", 
    "contexts", 
    "createdBy", 
    "createdDateTime", 
    "owner", 
    "title", 
    "details"})
@JsonInclude(Include.NON_NULL)
public class PlannerPlan extends PlannerDelta implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.plannerPlan";
    }

    @JsonProperty("container")
    protected PlannerPlanContainer container;

    @JsonProperty("contexts")
    protected PlannerPlanContextCollection contexts;

    @JsonProperty("createdBy")
    protected IdentitySet createdBy;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("owner")
    protected String owner;

    @JsonProperty("title")
    protected String title;

    @JsonProperty("details")
    protected PlannerPlanDetails details;

    protected PlannerPlan() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPlannerPlan() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private PlannerPlanContainer container;
        private PlannerPlanContextCollection contexts;
        private IdentitySet createdBy;
        private OffsetDateTime createdDateTime;
        private String owner;
        private String title;
        private PlannerPlanDetails details;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder container(PlannerPlanContainer container) {
            this.container = container;
            this.changedFields = changedFields.add("container");
            return this;
        }

        public Builder contexts(PlannerPlanContextCollection contexts) {
            this.contexts = contexts;
            this.changedFields = changedFields.add("contexts");
            return this;
        }

        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Revisions</b>
         * 
         * @param owner
         *            value of {@code owner} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder owner(String owner) {
            this.owner = owner;
            this.changedFields = changedFields.add("owner");
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            this.changedFields = changedFields.add("title");
            return this;
        }

        public Builder details(PlannerPlanDetails details) {
            this.details = details;
            this.changedFields = changedFields.add("details");
            return this;
        }

        public PlannerPlan build() {
            PlannerPlan _x = new PlannerPlan();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.plannerPlan";
            _x.id = id;
            _x.container = container;
            _x.contexts = contexts;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.owner = owner;
            _x.title = title;
            _x.details = details;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="container")
    @JsonIgnore
    public Optional<PlannerPlanContainer> getContainer() {
        return Optional.ofNullable(container);
    }

    public PlannerPlan withContainer(PlannerPlanContainer container) {
        PlannerPlan _x = _copy();
        _x.changedFields = changedFields.add("container");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerPlan");
        _x.container = container;
        return _x;
    }

    @Property(name="contexts")
    @JsonIgnore
    public Optional<PlannerPlanContextCollection> getContexts() {
        return Optional.ofNullable(contexts);
    }

    public PlannerPlan withContexts(PlannerPlanContextCollection contexts) {
        PlannerPlan _x = _copy();
        _x.changedFields = changedFields.add("contexts");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerPlan");
        _x.contexts = contexts;
        return _x;
    }

    @Property(name="createdBy")
    @JsonIgnore
    public Optional<IdentitySet> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    public PlannerPlan withCreatedBy(IdentitySet createdBy) {
        PlannerPlan _x = _copy();
        _x.changedFields = changedFields.add("createdBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerPlan");
        _x.createdBy = createdBy;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public PlannerPlan withCreatedDateTime(OffsetDateTime createdDateTime) {
        PlannerPlan _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerPlan");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Revisions</b>
     * 
     * @return property owner
     */
    @Property(name="owner")
    @JsonIgnore
    public Optional<String> getOwner() {
        return Optional.ofNullable(owner);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code owner} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Core.V1.Revisions</b>
     * 
     * @param owner
     *            new value of {@code owner} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code owner} field changed
     */
    public PlannerPlan withOwner(String owner) {
        PlannerPlan _x = _copy();
        _x.changedFields = changedFields.add("owner");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerPlan");
        _x.owner = owner;
        return _x;
    }

    @Property(name="title")
    @JsonIgnore
    public Optional<String> getTitle() {
        return Optional.ofNullable(title);
    }

    public PlannerPlan withTitle(String title) {
        PlannerPlan _x = _copy();
        _x.changedFields = changedFields.add("title");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerPlan");
        _x.title = title;
        return _x;
    }

    public PlannerPlan withUnmappedField(String name, Object value) {
        PlannerPlan _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="buckets")
    @JsonIgnore
    public PlannerBucketCollectionRequest getBuckets() {
        return new PlannerBucketCollectionRequest(
                        contextPath.addSegment("buckets"), RequestHelper.getValue(unmappedFields, "buckets"));
    }

    @NavigationProperty(name="details")
    @JsonIgnore
    public PlannerPlanDetailsRequest getDetails() {
        return new PlannerPlanDetailsRequest(contextPath.addSegment("details"), Optional.ofNullable(details));
    }

    @NavigationProperty(name="tasks")
    @JsonIgnore
    public PlannerTaskCollectionRequest getTasks() {
        return new PlannerTaskCollectionRequest(
                        contextPath.addSegment("tasks"), RequestHelper.getValue(unmappedFields, "tasks"));
    }

    public PlannerPlan withDetails(PlannerPlanDetails details) {
        PlannerPlan _x = _copy();
        _x.changedFields = changedFields.add("details");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerPlan");
        _x.details = details;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PlannerPlan patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        PlannerPlan _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PlannerPlan put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        PlannerPlan _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private PlannerPlan _copy() {
        PlannerPlan _x = new PlannerPlan();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.container = container;
        _x.contexts = contexts;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.owner = owner;
        _x.title = title;
        _x.details = details;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PlannerPlan[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("container=");
        b.append(this.container);
        b.append(", ");
        b.append("contexts=");
        b.append(this.contexts);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("owner=");
        b.append(this.owner);
        b.append(", ");
        b.append("title=");
        b.append(this.title);
        b.append(", ");
        b.append("details=");
        b.append(this.details);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
