package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.PlannerBucketCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PlannerPlanCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PlannerRosterCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PlannerTaskCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "buckets", 
    "plans", 
    "rosters", 
    "tasks"})
@JsonInclude(Include.NON_NULL)
public class Planner implements ODataEntityType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JacksonInject
    @JsonIgnore
    protected ChangedFields changedFields;

    @Override
    public String odataTypeName() {
        return "microsoft.graph.planner";
    }

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("buckets")
    protected List<PlannerBucket> buckets;

    @JsonProperty("plans")
    protected List<PlannerPlan> plans;

    @JsonProperty("rosters")
    protected List<PlannerRoster> rosters;

    @JsonProperty("tasks")
    protected List<PlannerTask> tasks;

    protected Planner() {
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<PlannerBucket> buckets;
        private List<PlannerPlan> plans;
        private List<PlannerRoster> rosters;
        private List<PlannerTask> tasks;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder buckets(List<PlannerBucket> buckets) {
            this.buckets = buckets;
            this.changedFields = changedFields.add("buckets");
            return this;
        }

        public Builder buckets(PlannerBucket... buckets) {
            return buckets(Arrays.asList(buckets));
        }

        public Builder plans(List<PlannerPlan> plans) {
            this.plans = plans;
            this.changedFields = changedFields.add("plans");
            return this;
        }

        public Builder plans(PlannerPlan... plans) {
            return plans(Arrays.asList(plans));
        }

        public Builder rosters(List<PlannerRoster> rosters) {
            this.rosters = rosters;
            this.changedFields = changedFields.add("rosters");
            return this;
        }

        public Builder rosters(PlannerRoster... rosters) {
            return rosters(Arrays.asList(rosters));
        }

        public Builder tasks(List<PlannerTask> tasks) {
            this.tasks = tasks;
            this.changedFields = changedFields.add("tasks");
            return this;
        }

        public Builder tasks(PlannerTask... tasks) {
            return tasks(Arrays.asList(tasks));
        }

        public Planner build() {
            Planner _x = new Planner();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.planner";
            _x.buckets = buckets;
            _x.plans = plans;
            _x.rosters = rosters;
            _x.tasks = tasks;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath) {
            contextPath = contextPath.clearQueries();
        }
    }

    public Planner withUnmappedField(String name, Object value) {
        Planner _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="buckets")
    @JsonIgnore
    public PlannerBucketCollectionRequest getBuckets() {
        return new PlannerBucketCollectionRequest(
                        contextPath.addSegment("buckets"), Optional.ofNullable(buckets));
    }

    @NavigationProperty(name="plans")
    @JsonIgnore
    public PlannerPlanCollectionRequest getPlans() {
        return new PlannerPlanCollectionRequest(
                        contextPath.addSegment("plans"), Optional.ofNullable(plans));
    }

    @NavigationProperty(name="rosters")
    @JsonIgnore
    public PlannerRosterCollectionRequest getRosters() {
        return new PlannerRosterCollectionRequest(
                        contextPath.addSegment("rosters"), Optional.ofNullable(rosters));
    }

    @NavigationProperty(name="tasks")
    @JsonIgnore
    public PlannerTaskCollectionRequest getTasks() {
        return new PlannerTaskCollectionRequest(
                        contextPath.addSegment("tasks"), Optional.ofNullable(tasks));
    }

    public Planner withBuckets(List<PlannerBucket> buckets) {
        Planner _x = _copy();
        _x.changedFields = changedFields.add("buckets");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.planner");
        _x.buckets = buckets;
        return _x;
    }

    public Planner withPlans(List<PlannerPlan> plans) {
        Planner _x = _copy();
        _x.changedFields = changedFields.add("plans");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.planner");
        _x.plans = plans;
        return _x;
    }

    public Planner withRosters(List<PlannerRoster> rosters) {
        Planner _x = _copy();
        _x.changedFields = changedFields.add("rosters");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.planner");
        _x.rosters = rosters;
        return _x;
    }

    public Planner withTasks(List<PlannerTask> tasks) {
        Planner _x = _copy();
        _x.changedFields = changedFields.add("tasks");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.planner");
        _x.tasks = tasks;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Planner patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Planner _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Planner put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Planner _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Planner _copy() {
        Planner _x = new Planner();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.buckets = buckets;
        _x.plans = plans;
        _x.rosters = rosters;
        _x.tasks = tasks;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Planner[");
        b.append("buckets=");
        b.append(this.buckets);
        b.append(", ");
        b.append("plans=");
        b.append(this.plans);
        b.append(", ");
        b.append("rosters=");
        b.append(this.rosters);
        b.append(", ");
        b.append("tasks=");
        b.append(this.tasks);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
