package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.complex.InferenceData;
import odata.msgraph.client.beta.complex.PersonDataSources;
import odata.msgraph.client.beta.enums.AllowedAudiences;

@JsonPropertyOrder({
    "@odata.type", 
    "collaborationTags", 
    "description", 
    "displayName", 
    "thumbnailUrl", 
    "webUrl"})
@JsonInclude(Include.NON_NULL)
public class PersonResponsibility extends ItemFacet implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.personResponsibility";
    }

    @JsonProperty("collaborationTags")
    protected List<String> collaborationTags;

    @JsonProperty("collaborationTags@nextLink")
    protected String collaborationTagsNextLink;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("thumbnailUrl")
    protected String thumbnailUrl;

    @JsonProperty("webUrl")
    protected String webUrl;

    protected PersonResponsibility() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPersonResponsibility() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private AllowedAudiences allowedAudiences;
        private IdentitySet createdBy;
        private OffsetDateTime createdDateTime;
        private InferenceData inference;
        private Boolean isSearchable;
        private IdentitySet lastModifiedBy;
        private OffsetDateTime lastModifiedDateTime;
        private PersonDataSources source;
        private List<String> collaborationTags;
        private String collaborationTagsNextLink;
        private String description;
        private String displayName;
        private String thumbnailUrl;
        private String webUrl;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder allowedAudiences(AllowedAudiences allowedAudiences) {
            this.allowedAudiences = allowedAudiences;
            this.changedFields = changedFields.add("allowedAudiences");
            return this;
        }

        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder inference(InferenceData inference) {
            this.inference = inference;
            this.changedFields = changedFields.add("inference");
            return this;
        }

        public Builder isSearchable(Boolean isSearchable) {
            this.isSearchable = isSearchable;
            this.changedFields = changedFields.add("isSearchable");
            return this;
        }

        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder source(PersonDataSources source) {
            this.source = source;
            this.changedFields = changedFields.add("source");
            return this;
        }

        public Builder collaborationTags(List<String> collaborationTags) {
            this.collaborationTags = collaborationTags;
            this.changedFields = changedFields.add("collaborationTags");
            return this;
        }

        public Builder collaborationTags(String... collaborationTags) {
            return collaborationTags(Arrays.asList(collaborationTags));
        }

        public Builder collaborationTagsNextLink(String collaborationTagsNextLink) {
            this.collaborationTagsNextLink = collaborationTagsNextLink;
            this.changedFields = changedFields.add("collaborationTags");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder thumbnailUrl(String thumbnailUrl) {
            this.thumbnailUrl = thumbnailUrl;
            this.changedFields = changedFields.add("thumbnailUrl");
            return this;
        }

        public Builder webUrl(String webUrl) {
            this.webUrl = webUrl;
            this.changedFields = changedFields.add("webUrl");
            return this;
        }

        public PersonResponsibility build() {
            PersonResponsibility _x = new PersonResponsibility();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.personResponsibility";
            _x.id = id;
            _x.allowedAudiences = allowedAudiences;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.inference = inference;
            _x.isSearchable = isSearchable;
            _x.lastModifiedBy = lastModifiedBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.source = source;
            _x.collaborationTags = collaborationTags;
            _x.collaborationTagsNextLink = collaborationTagsNextLink;
            _x.description = description;
            _x.displayName = displayName;
            _x.thumbnailUrl = thumbnailUrl;
            _x.webUrl = webUrl;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="collaborationTags")
    @JsonIgnore
    public CollectionPage<String> getCollaborationTags() {
        return new CollectionPage<String>(contextPath, String.class, this.collaborationTags, Optional.ofNullable(collaborationTagsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public PersonResponsibility withCollaborationTags(List<String> collaborationTags) {
        PersonResponsibility _x = _copy();
        _x.changedFields = changedFields.add("collaborationTags");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.personResponsibility");
        _x.collaborationTags = collaborationTags;
        return _x;
    }

    @Property(name="collaborationTags")
    @JsonIgnore
    public CollectionPage<String> getCollaborationTags(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.collaborationTags, Optional.ofNullable(collaborationTagsNextLink), Collections.emptyList(), options);
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public PersonResponsibility withDescription(String description) {
        PersonResponsibility _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.personResponsibility");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public PersonResponsibility withDisplayName(String displayName) {
        PersonResponsibility _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.personResponsibility");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="thumbnailUrl")
    @JsonIgnore
    public Optional<String> getThumbnailUrl() {
        return Optional.ofNullable(thumbnailUrl);
    }

    public PersonResponsibility withThumbnailUrl(String thumbnailUrl) {
        PersonResponsibility _x = _copy();
        _x.changedFields = changedFields.add("thumbnailUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.personResponsibility");
        _x.thumbnailUrl = thumbnailUrl;
        return _x;
    }

    @Property(name="webUrl")
    @JsonIgnore
    public Optional<String> getWebUrl() {
        return Optional.ofNullable(webUrl);
    }

    public PersonResponsibility withWebUrl(String webUrl) {
        PersonResponsibility _x = _copy();
        _x.changedFields = changedFields.add("webUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.personResponsibility");
        _x.webUrl = webUrl;
        return _x;
    }

    public PersonResponsibility withUnmappedField(String name, Object value) {
        PersonResponsibility _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PersonResponsibility patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        PersonResponsibility _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PersonResponsibility put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        PersonResponsibility _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private PersonResponsibility _copy() {
        PersonResponsibility _x = new PersonResponsibility();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.allowedAudiences = allowedAudiences;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.inference = inference;
        _x.isSearchable = isSearchable;
        _x.lastModifiedBy = lastModifiedBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.source = source;
        _x.collaborationTags = collaborationTags;
        _x.description = description;
        _x.displayName = displayName;
        _x.thumbnailUrl = thumbnailUrl;
        _x.webUrl = webUrl;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PersonResponsibility[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("allowedAudiences=");
        b.append(this.allowedAudiences);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("inference=");
        b.append(this.inference);
        b.append(", ");
        b.append("isSearchable=");
        b.append(this.isSearchable);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("source=");
        b.append(this.source);
        b.append(", ");
        b.append("collaborationTags=");
        b.append(this.collaborationTags);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("thumbnailUrl=");
        b.append(this.thumbnailUrl);
        b.append(", ");
        b.append("webUrl=");
        b.append(this.webUrl);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
