package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.Location;
import odata.msgraph.client.beta.complex.PersonDataSource;
import odata.msgraph.client.beta.complex.Phone;
import odata.msgraph.client.beta.complex.RankedEmailAddress;
import odata.msgraph.client.beta.complex.Website;

@JsonPropertyOrder({
    "@odata.type", 
    "birthday", 
    "companyName", 
    "department", 
    "displayName", 
    "emailAddresses", 
    "givenName", 
    "isFavorite", 
    "mailboxType", 
    "officeLocation", 
    "personNotes", 
    "personType", 
    "phones", 
    "postalAddresses", 
    "profession", 
    "sources", 
    "surname", 
    "title", 
    "userPrincipalName", 
    "websites", 
    "yomiCompany"})
@JsonInclude(Include.NON_NULL)
public class Person extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.person";
    }

    @JsonProperty("birthday")
    protected String birthday;

    @JsonProperty("companyName")
    protected String companyName;

    @JsonProperty("department")
    protected String department;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("emailAddresses")
    protected List<RankedEmailAddress> emailAddresses;

    @JsonProperty("emailAddresses@nextLink")
    protected String emailAddressesNextLink;

    @JsonProperty("givenName")
    protected String givenName;

    @JsonProperty("isFavorite")
    protected Boolean isFavorite;

    @JsonProperty("mailboxType")
    protected String mailboxType;

    @JsonProperty("officeLocation")
    protected String officeLocation;

    @JsonProperty("personNotes")
    protected String personNotes;

    @JsonProperty("personType")
    protected String personType;

    @JsonProperty("phones")
    protected List<Phone> phones;

    @JsonProperty("phones@nextLink")
    protected String phonesNextLink;

    @JsonProperty("postalAddresses")
    protected List<Location> postalAddresses;

    @JsonProperty("postalAddresses@nextLink")
    protected String postalAddressesNextLink;

    @JsonProperty("profession")
    protected String profession;

    @JsonProperty("sources")
    protected List<PersonDataSource> sources;

    @JsonProperty("sources@nextLink")
    protected String sourcesNextLink;

    @JsonProperty("surname")
    protected String surname;

    @JsonProperty("title")
    protected String title;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    @JsonProperty("websites")
    protected List<Website> websites;

    @JsonProperty("websites@nextLink")
    protected String websitesNextLink;

    @JsonProperty("yomiCompany")
    protected String yomiCompany;

    protected Person() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPerson() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String birthday;
        private String companyName;
        private String department;
        private String displayName;
        private List<RankedEmailAddress> emailAddresses;
        private String emailAddressesNextLink;
        private String givenName;
        private Boolean isFavorite;
        private String mailboxType;
        private String officeLocation;
        private String personNotes;
        private String personType;
        private List<Phone> phones;
        private String phonesNextLink;
        private List<Location> postalAddresses;
        private String postalAddressesNextLink;
        private String profession;
        private List<PersonDataSource> sources;
        private String sourcesNextLink;
        private String surname;
        private String title;
        private String userPrincipalName;
        private List<Website> websites;
        private String websitesNextLink;
        private String yomiCompany;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder birthday(String birthday) {
            this.birthday = birthday;
            this.changedFields = changedFields.add("birthday");
            return this;
        }

        public Builder companyName(String companyName) {
            this.companyName = companyName;
            this.changedFields = changedFields.add("companyName");
            return this;
        }

        public Builder department(String department) {
            this.department = department;
            this.changedFields = changedFields.add("department");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder emailAddresses(List<RankedEmailAddress> emailAddresses) {
            this.emailAddresses = emailAddresses;
            this.changedFields = changedFields.add("emailAddresses");
            return this;
        }

        public Builder emailAddresses(RankedEmailAddress... emailAddresses) {
            return emailAddresses(Arrays.asList(emailAddresses));
        }

        public Builder emailAddressesNextLink(String emailAddressesNextLink) {
            this.emailAddressesNextLink = emailAddressesNextLink;
            this.changedFields = changedFields.add("emailAddresses");
            return this;
        }

        public Builder givenName(String givenName) {
            this.givenName = givenName;
            this.changedFields = changedFields.add("givenName");
            return this;
        }

        public Builder isFavorite(Boolean isFavorite) {
            this.isFavorite = isFavorite;
            this.changedFields = changedFields.add("isFavorite");
            return this;
        }

        public Builder mailboxType(String mailboxType) {
            this.mailboxType = mailboxType;
            this.changedFields = changedFields.add("mailboxType");
            return this;
        }

        public Builder officeLocation(String officeLocation) {
            this.officeLocation = officeLocation;
            this.changedFields = changedFields.add("officeLocation");
            return this;
        }

        public Builder personNotes(String personNotes) {
            this.personNotes = personNotes;
            this.changedFields = changedFields.add("personNotes");
            return this;
        }

        public Builder personType(String personType) {
            this.personType = personType;
            this.changedFields = changedFields.add("personType");
            return this;
        }

        public Builder phones(List<Phone> phones) {
            this.phones = phones;
            this.changedFields = changedFields.add("phones");
            return this;
        }

        public Builder phones(Phone... phones) {
            return phones(Arrays.asList(phones));
        }

        public Builder phonesNextLink(String phonesNextLink) {
            this.phonesNextLink = phonesNextLink;
            this.changedFields = changedFields.add("phones");
            return this;
        }

        public Builder postalAddresses(List<Location> postalAddresses) {
            this.postalAddresses = postalAddresses;
            this.changedFields = changedFields.add("postalAddresses");
            return this;
        }

        public Builder postalAddresses(Location... postalAddresses) {
            return postalAddresses(Arrays.asList(postalAddresses));
        }

        public Builder postalAddressesNextLink(String postalAddressesNextLink) {
            this.postalAddressesNextLink = postalAddressesNextLink;
            this.changedFields = changedFields.add("postalAddresses");
            return this;
        }

        public Builder profession(String profession) {
            this.profession = profession;
            this.changedFields = changedFields.add("profession");
            return this;
        }

        public Builder sources(List<PersonDataSource> sources) {
            this.sources = sources;
            this.changedFields = changedFields.add("sources");
            return this;
        }

        public Builder sources(PersonDataSource... sources) {
            return sources(Arrays.asList(sources));
        }

        public Builder sourcesNextLink(String sourcesNextLink) {
            this.sourcesNextLink = sourcesNextLink;
            this.changedFields = changedFields.add("sources");
            return this;
        }

        public Builder surname(String surname) {
            this.surname = surname;
            this.changedFields = changedFields.add("surname");
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            this.changedFields = changedFields.add("title");
            return this;
        }

        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public Builder websites(List<Website> websites) {
            this.websites = websites;
            this.changedFields = changedFields.add("websites");
            return this;
        }

        public Builder websites(Website... websites) {
            return websites(Arrays.asList(websites));
        }

        public Builder websitesNextLink(String websitesNextLink) {
            this.websitesNextLink = websitesNextLink;
            this.changedFields = changedFields.add("websites");
            return this;
        }

        public Builder yomiCompany(String yomiCompany) {
            this.yomiCompany = yomiCompany;
            this.changedFields = changedFields.add("yomiCompany");
            return this;
        }

        public Person build() {
            Person _x = new Person();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.person";
            _x.id = id;
            _x.birthday = birthday;
            _x.companyName = companyName;
            _x.department = department;
            _x.displayName = displayName;
            _x.emailAddresses = emailAddresses;
            _x.emailAddressesNextLink = emailAddressesNextLink;
            _x.givenName = givenName;
            _x.isFavorite = isFavorite;
            _x.mailboxType = mailboxType;
            _x.officeLocation = officeLocation;
            _x.personNotes = personNotes;
            _x.personType = personType;
            _x.phones = phones;
            _x.phonesNextLink = phonesNextLink;
            _x.postalAddresses = postalAddresses;
            _x.postalAddressesNextLink = postalAddressesNextLink;
            _x.profession = profession;
            _x.sources = sources;
            _x.sourcesNextLink = sourcesNextLink;
            _x.surname = surname;
            _x.title = title;
            _x.userPrincipalName = userPrincipalName;
            _x.websites = websites;
            _x.websitesNextLink = websitesNextLink;
            _x.yomiCompany = yomiCompany;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="birthday")
    @JsonIgnore
    public Optional<String> getBirthday() {
        return Optional.ofNullable(birthday);
    }

    public Person withBirthday(String birthday) {
        Person _x = _copy();
        _x.changedFields = changedFields.add("birthday");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.person");
        _x.birthday = birthday;
        return _x;
    }

    @Property(name="companyName")
    @JsonIgnore
    public Optional<String> getCompanyName() {
        return Optional.ofNullable(companyName);
    }

    public Person withCompanyName(String companyName) {
        Person _x = _copy();
        _x.changedFields = changedFields.add("companyName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.person");
        _x.companyName = companyName;
        return _x;
    }

    @Property(name="department")
    @JsonIgnore
    public Optional<String> getDepartment() {
        return Optional.ofNullable(department);
    }

    public Person withDepartment(String department) {
        Person _x = _copy();
        _x.changedFields = changedFields.add("department");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.person");
        _x.department = department;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public Person withDisplayName(String displayName) {
        Person _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.person");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="emailAddresses")
    @JsonIgnore
    public CollectionPage<RankedEmailAddress> getEmailAddresses() {
        return new CollectionPage<RankedEmailAddress>(contextPath, RankedEmailAddress.class, this.emailAddresses, Optional.ofNullable(emailAddressesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public Person withEmailAddresses(List<RankedEmailAddress> emailAddresses) {
        Person _x = _copy();
        _x.changedFields = changedFields.add("emailAddresses");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.person");
        _x.emailAddresses = emailAddresses;
        return _x;
    }

    @Property(name="emailAddresses")
    @JsonIgnore
    public CollectionPage<RankedEmailAddress> getEmailAddresses(HttpRequestOptions options) {
        return new CollectionPage<RankedEmailAddress>(contextPath, RankedEmailAddress.class, this.emailAddresses, Optional.ofNullable(emailAddressesNextLink), Collections.emptyList(), options);
    }

    @Property(name="givenName")
    @JsonIgnore
    public Optional<String> getGivenName() {
        return Optional.ofNullable(givenName);
    }

    public Person withGivenName(String givenName) {
        Person _x = _copy();
        _x.changedFields = changedFields.add("givenName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.person");
        _x.givenName = givenName;
        return _x;
    }

    @Property(name="isFavorite")
    @JsonIgnore
    public Optional<Boolean> getIsFavorite() {
        return Optional.ofNullable(isFavorite);
    }

    public Person withIsFavorite(Boolean isFavorite) {
        Person _x = _copy();
        _x.changedFields = changedFields.add("isFavorite");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.person");
        _x.isFavorite = isFavorite;
        return _x;
    }

    @Property(name="mailboxType")
    @JsonIgnore
    public Optional<String> getMailboxType() {
        return Optional.ofNullable(mailboxType);
    }

    public Person withMailboxType(String mailboxType) {
        Person _x = _copy();
        _x.changedFields = changedFields.add("mailboxType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.person");
        _x.mailboxType = mailboxType;
        return _x;
    }

    @Property(name="officeLocation")
    @JsonIgnore
    public Optional<String> getOfficeLocation() {
        return Optional.ofNullable(officeLocation);
    }

    public Person withOfficeLocation(String officeLocation) {
        Person _x = _copy();
        _x.changedFields = changedFields.add("officeLocation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.person");
        _x.officeLocation = officeLocation;
        return _x;
    }

    @Property(name="personNotes")
    @JsonIgnore
    public Optional<String> getPersonNotes() {
        return Optional.ofNullable(personNotes);
    }

    public Person withPersonNotes(String personNotes) {
        Person _x = _copy();
        _x.changedFields = changedFields.add("personNotes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.person");
        _x.personNotes = personNotes;
        return _x;
    }

    @Property(name="personType")
    @JsonIgnore
    public Optional<String> getPersonType() {
        return Optional.ofNullable(personType);
    }

    public Person withPersonType(String personType) {
        Person _x = _copy();
        _x.changedFields = changedFields.add("personType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.person");
        _x.personType = personType;
        return _x;
    }

    @Property(name="phones")
    @JsonIgnore
    public CollectionPage<Phone> getPhones() {
        return new CollectionPage<Phone>(contextPath, Phone.class, this.phones, Optional.ofNullable(phonesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public Person withPhones(List<Phone> phones) {
        Person _x = _copy();
        _x.changedFields = changedFields.add("phones");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.person");
        _x.phones = phones;
        return _x;
    }

    @Property(name="phones")
    @JsonIgnore
    public CollectionPage<Phone> getPhones(HttpRequestOptions options) {
        return new CollectionPage<Phone>(contextPath, Phone.class, this.phones, Optional.ofNullable(phonesNextLink), Collections.emptyList(), options);
    }

    @Property(name="postalAddresses")
    @JsonIgnore
    public CollectionPage<Location> getPostalAddresses() {
        return new CollectionPage<Location>(contextPath, Location.class, this.postalAddresses, Optional.ofNullable(postalAddressesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public Person withPostalAddresses(List<Location> postalAddresses) {
        Person _x = _copy();
        _x.changedFields = changedFields.add("postalAddresses");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.person");
        _x.postalAddresses = postalAddresses;
        return _x;
    }

    @Property(name="postalAddresses")
    @JsonIgnore
    public CollectionPage<Location> getPostalAddresses(HttpRequestOptions options) {
        return new CollectionPage<Location>(contextPath, Location.class, this.postalAddresses, Optional.ofNullable(postalAddressesNextLink), Collections.emptyList(), options);
    }

    @Property(name="profession")
    @JsonIgnore
    public Optional<String> getProfession() {
        return Optional.ofNullable(profession);
    }

    public Person withProfession(String profession) {
        Person _x = _copy();
        _x.changedFields = changedFields.add("profession");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.person");
        _x.profession = profession;
        return _x;
    }

    @Property(name="sources")
    @JsonIgnore
    public CollectionPage<PersonDataSource> getSources() {
        return new CollectionPage<PersonDataSource>(contextPath, PersonDataSource.class, this.sources, Optional.ofNullable(sourcesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public Person withSources(List<PersonDataSource> sources) {
        Person _x = _copy();
        _x.changedFields = changedFields.add("sources");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.person");
        _x.sources = sources;
        return _x;
    }

    @Property(name="sources")
    @JsonIgnore
    public CollectionPage<PersonDataSource> getSources(HttpRequestOptions options) {
        return new CollectionPage<PersonDataSource>(contextPath, PersonDataSource.class, this.sources, Optional.ofNullable(sourcesNextLink), Collections.emptyList(), options);
    }

    @Property(name="surname")
    @JsonIgnore
    public Optional<String> getSurname() {
        return Optional.ofNullable(surname);
    }

    public Person withSurname(String surname) {
        Person _x = _copy();
        _x.changedFields = changedFields.add("surname");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.person");
        _x.surname = surname;
        return _x;
    }

    @Property(name="title")
    @JsonIgnore
    public Optional<String> getTitle() {
        return Optional.ofNullable(title);
    }

    public Person withTitle(String title) {
        Person _x = _copy();
        _x.changedFields = changedFields.add("title");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.person");
        _x.title = title;
        return _x;
    }

    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    public Person withUserPrincipalName(String userPrincipalName) {
        Person _x = _copy();
        _x.changedFields = changedFields.add("userPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.person");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Property(name="websites")
    @JsonIgnore
    public CollectionPage<Website> getWebsites() {
        return new CollectionPage<Website>(contextPath, Website.class, this.websites, Optional.ofNullable(websitesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public Person withWebsites(List<Website> websites) {
        Person _x = _copy();
        _x.changedFields = changedFields.add("websites");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.person");
        _x.websites = websites;
        return _x;
    }

    @Property(name="websites")
    @JsonIgnore
    public CollectionPage<Website> getWebsites(HttpRequestOptions options) {
        return new CollectionPage<Website>(contextPath, Website.class, this.websites, Optional.ofNullable(websitesNextLink), Collections.emptyList(), options);
    }

    @Property(name="yomiCompany")
    @JsonIgnore
    public Optional<String> getYomiCompany() {
        return Optional.ofNullable(yomiCompany);
    }

    public Person withYomiCompany(String yomiCompany) {
        Person _x = _copy();
        _x.changedFields = changedFields.add("yomiCompany");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.person");
        _x.yomiCompany = yomiCompany;
        return _x;
    }

    public Person withUnmappedField(String name, Object value) {
        Person _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Person patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Person _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Person put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Person _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Person _copy() {
        Person _x = new Person();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.birthday = birthday;
        _x.companyName = companyName;
        _x.department = department;
        _x.displayName = displayName;
        _x.emailAddresses = emailAddresses;
        _x.givenName = givenName;
        _x.isFavorite = isFavorite;
        _x.mailboxType = mailboxType;
        _x.officeLocation = officeLocation;
        _x.personNotes = personNotes;
        _x.personType = personType;
        _x.phones = phones;
        _x.postalAddresses = postalAddresses;
        _x.profession = profession;
        _x.sources = sources;
        _x.surname = surname;
        _x.title = title;
        _x.userPrincipalName = userPrincipalName;
        _x.websites = websites;
        _x.yomiCompany = yomiCompany;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Person[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("birthday=");
        b.append(this.birthday);
        b.append(", ");
        b.append("companyName=");
        b.append(this.companyName);
        b.append(", ");
        b.append("department=");
        b.append(this.department);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("emailAddresses=");
        b.append(this.emailAddresses);
        b.append(", ");
        b.append("givenName=");
        b.append(this.givenName);
        b.append(", ");
        b.append("isFavorite=");
        b.append(this.isFavorite);
        b.append(", ");
        b.append("mailboxType=");
        b.append(this.mailboxType);
        b.append(", ");
        b.append("officeLocation=");
        b.append(this.officeLocation);
        b.append(", ");
        b.append("personNotes=");
        b.append(this.personNotes);
        b.append(", ");
        b.append("personType=");
        b.append(this.personType);
        b.append(", ");
        b.append("phones=");
        b.append(this.phones);
        b.append(", ");
        b.append("postalAddresses=");
        b.append(this.postalAddresses);
        b.append(", ");
        b.append("profession=");
        b.append(this.profession);
        b.append(", ");
        b.append("sources=");
        b.append(this.sources);
        b.append(", ");
        b.append("surname=");
        b.append(this.surname);
        b.append(", ");
        b.append("title=");
        b.append(this.title);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append(", ");
        b.append("websites=");
        b.append(this.websites);
        b.append(", ");
        b.append("yomiCompany=");
        b.append(this.yomiCompany);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
