package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.AssignmentFilterPayloadType;
import odata.msgraph.client.beta.enums.DevicePlatformType;


/**
 * <i>“A class containing the properties used for Payload Compatible Assignment Filter.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "payloadType"})
@JsonInclude(Include.NON_NULL)
public class PayloadCompatibleAssignmentFilter extends DeviceAndAppManagementAssignmentFilter implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.payloadCompatibleAssignmentFilter";
    }

    @JsonProperty("payloadType")
    protected AssignmentFilterPayloadType payloadType;

    protected PayloadCompatibleAssignmentFilter() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPayloadCompatibleAssignmentFilter() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private OffsetDateTime lastModifiedDateTime;
        private DevicePlatformType platform;
        private List<String> roleScopeTags;
        private String roleScopeTagsNextLink;
        private String rule;
        private AssignmentFilterPayloadType payloadType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder platform(DevicePlatformType platform) {
            this.platform = platform;
            this.changedFields = changedFields.add("platform");
            return this;
        }

        public Builder roleScopeTags(List<String> roleScopeTags) {
            this.roleScopeTags = roleScopeTags;
            this.changedFields = changedFields.add("roleScopeTags");
            return this;
        }

        public Builder roleScopeTags(String... roleScopeTags) {
            return roleScopeTags(Arrays.asList(roleScopeTags));
        }

        public Builder roleScopeTagsNextLink(String roleScopeTagsNextLink) {
            this.roleScopeTagsNextLink = roleScopeTagsNextLink;
            this.changedFields = changedFields.add("roleScopeTags");
            return this;
        }

        public Builder rule(String rule) {
            this.rule = rule;
            this.changedFields = changedFields.add("rule");
            return this;
        }

        /**
         * <i>“PayloadType of the Assignment Filter.”</i>
         * 
         * @param payloadType
         *            value of {@code payloadType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder payloadType(AssignmentFilterPayloadType payloadType) {
            this.payloadType = payloadType;
            this.changedFields = changedFields.add("payloadType");
            return this;
        }

        public PayloadCompatibleAssignmentFilter build() {
            PayloadCompatibleAssignmentFilter _x = new PayloadCompatibleAssignmentFilter();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.payloadCompatibleAssignmentFilter";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.platform = platform;
            _x.roleScopeTags = roleScopeTags;
            _x.roleScopeTagsNextLink = roleScopeTagsNextLink;
            _x.rule = rule;
            _x.payloadType = payloadType;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“PayloadType of the Assignment Filter.”</i>
     * 
     * @return property payloadType
     */
    @Property(name="payloadType")
    @JsonIgnore
    public Optional<AssignmentFilterPayloadType> getPayloadType() {
        return Optional.ofNullable(payloadType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code payloadType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“PayloadType of the Assignment Filter.”</i>
     * 
     * @param payloadType
     *            new value of {@code payloadType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code payloadType} field changed
     */
    public PayloadCompatibleAssignmentFilter withPayloadType(AssignmentFilterPayloadType payloadType) {
        PayloadCompatibleAssignmentFilter _x = _copy();
        _x.changedFields = changedFields.add("payloadType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.payloadCompatibleAssignmentFilter");
        _x.payloadType = payloadType;
        return _x;
    }

    public PayloadCompatibleAssignmentFilter withUnmappedField(String name, Object value) {
        PayloadCompatibleAssignmentFilter _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PayloadCompatibleAssignmentFilter patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        PayloadCompatibleAssignmentFilter _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PayloadCompatibleAssignmentFilter put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        PayloadCompatibleAssignmentFilter _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private PayloadCompatibleAssignmentFilter _copy() {
        PayloadCompatibleAssignmentFilter _x = new PayloadCompatibleAssignmentFilter();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.platform = platform;
        _x.roleScopeTags = roleScopeTags;
        _x.rule = rule;
        _x.payloadType = payloadType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PayloadCompatibleAssignmentFilter[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("platform=");
        b.append(this.platform);
        b.append(", ");
        b.append("roleScopeTags=");
        b.append(this.roleScopeTags);
        b.append(", ");
        b.append("rule=");
        b.append(this.rule);
        b.append(", ");
        b.append("payloadType=");
        b.append(this.payloadType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
