package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.entity.request.CallRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "participantId", 
    "call"})
@JsonInclude(Include.NON_NULL)
public class ParticipantLeftNotification extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.participantLeftNotification";
    }

    @JsonProperty("participantId")
    protected String participantId;

    @JsonProperty("call")
    protected Call call;

    protected ParticipantLeftNotification() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderParticipantLeftNotification() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String participantId;
        private Call call;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder participantId(String participantId) {
            this.participantId = participantId;
            this.changedFields = changedFields.add("participantId");
            return this;
        }

        public Builder call(Call call) {
            this.call = call;
            this.changedFields = changedFields.add("call");
            return this;
        }

        public ParticipantLeftNotification build() {
            ParticipantLeftNotification _x = new ParticipantLeftNotification();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.participantLeftNotification";
            _x.id = id;
            _x.participantId = participantId;
            _x.call = call;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="participantId")
    @JsonIgnore
    public Optional<String> getParticipantId() {
        return Optional.ofNullable(participantId);
    }

    public ParticipantLeftNotification withParticipantId(String participantId) {
        ParticipantLeftNotification _x = _copy();
        _x.changedFields = changedFields.add("participantId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.participantLeftNotification");
        _x.participantId = participantId;
        return _x;
    }

    public ParticipantLeftNotification withUnmappedField(String name, Object value) {
        ParticipantLeftNotification _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="call")
    @JsonIgnore
    public CallRequest getCall() {
        return new CallRequest(contextPath.addSegment("call"), Optional.ofNullable(call));
    }

    public ParticipantLeftNotification withCall(Call call) {
        ParticipantLeftNotification _x = _copy();
        _x.changedFields = changedFields.add("call");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.participantLeftNotification");
        _x.call = call;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ParticipantLeftNotification patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ParticipantLeftNotification _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ParticipantLeftNotification put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ParticipantLeftNotification _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ParticipantLeftNotification _copy() {
        ParticipantLeftNotification _x = new ParticipantLeftNotification();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.participantId = participantId;
        _x.call = call;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ParticipantLeftNotification[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("participantId=");
        b.append(this.participantId);
        b.append(", ");
        b.append("call=");
        b.append(this.call);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
