package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.LocaleInfo;
import odata.msgraph.client.beta.complex.TimeZoneInformation;
import odata.msgraph.client.beta.entity.collection.request.OutlookCategoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OutlookTaskCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OutlookTaskFolderCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OutlookTaskGroupCollectionRequest;
import odata.msgraph.client.beta.enums.TimeZoneStandard;

@JsonPropertyOrder({
    "@odata.type", 
    "masterCategories", 
    "taskFolders", 
    "taskGroups", 
    "tasks"})
@JsonInclude(Include.NON_NULL)
public class OutlookUser extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.outlookUser";
    }

    @JsonProperty("masterCategories")
    protected List<OutlookCategory> masterCategories;

    @JsonProperty("taskFolders")
    protected List<OutlookTaskFolder> taskFolders;

    @JsonProperty("taskGroups")
    protected List<OutlookTaskGroup> taskGroups;

    @JsonProperty("tasks")
    protected List<OutlookTask> tasks;

    protected OutlookUser() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderOutlookUser() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<OutlookCategory> masterCategories;
        private List<OutlookTaskFolder> taskFolders;
        private List<OutlookTaskGroup> taskGroups;
        private List<OutlookTask> tasks;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * 
         * @param masterCategories
         *            value of {@code masterCategories} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder masterCategories(List<OutlookCategory> masterCategories) {
            this.masterCategories = masterCategories;
            this.changedFields = changedFields.add("masterCategories");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * 
         * @param masterCategories
         *            value of {@code masterCategories} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder masterCategories(OutlookCategory... masterCategories) {
            return masterCategories(Arrays.asList(masterCategories));
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * 
         * @param taskFolders
         *            value of {@code taskFolders} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder taskFolders(List<OutlookTaskFolder> taskFolders) {
            this.taskFolders = taskFolders;
            this.changedFields = changedFields.add("taskFolders");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * 
         * @param taskFolders
         *            value of {@code taskFolders} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder taskFolders(OutlookTaskFolder... taskFolders) {
            return taskFolders(Arrays.asList(taskFolders));
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * 
         * @param taskGroups
         *            value of {@code taskGroups} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder taskGroups(List<OutlookTaskGroup> taskGroups) {
            this.taskGroups = taskGroups;
            this.changedFields = changedFields.add("taskGroups");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * 
         * @param taskGroups
         *            value of {@code taskGroups} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder taskGroups(OutlookTaskGroup... taskGroups) {
            return taskGroups(Arrays.asList(taskGroups));
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * 
         * @param tasks
         *            value of {@code tasks} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder tasks(List<OutlookTask> tasks) {
            this.tasks = tasks;
            this.changedFields = changedFields.add("tasks");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * 
         * @param tasks
         *            value of {@code tasks} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder tasks(OutlookTask... tasks) {
            return tasks(Arrays.asList(tasks));
        }

        public OutlookUser build() {
            OutlookUser _x = new OutlookUser();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.outlookUser";
            _x.id = id;
            _x.masterCategories = masterCategories;
            _x.taskFolders = taskFolders;
            _x.taskGroups = taskGroups;
            _x.tasks = tasks;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public OutlookUser withUnmappedField(String name, Object value) {
        OutlookUser _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @return navigational property masterCategories
     */
    @NavigationProperty(name="masterCategories")
    @JsonIgnore
    public OutlookCategoryCollectionRequest getMasterCategories() {
        return new OutlookCategoryCollectionRequest(
                        contextPath.addSegment("masterCategories"), Optional.ofNullable(masterCategories));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @return navigational property taskFolders
     */
    @NavigationProperty(name="taskFolders")
    @JsonIgnore
    public OutlookTaskFolderCollectionRequest getTaskFolders() {
        return new OutlookTaskFolderCollectionRequest(
                        contextPath.addSegment("taskFolders"), Optional.ofNullable(taskFolders));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @return navigational property taskGroups
     */
    @NavigationProperty(name="taskGroups")
    @JsonIgnore
    public OutlookTaskGroupCollectionRequest getTaskGroups() {
        return new OutlookTaskGroupCollectionRequest(
                        contextPath.addSegment("taskGroups"), Optional.ofNullable(taskGroups));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @return navigational property tasks
     */
    @NavigationProperty(name="tasks")
    @JsonIgnore
    public OutlookTaskCollectionRequest getTasks() {
        return new OutlookTaskCollectionRequest(
                        contextPath.addSegment("tasks"), Optional.ofNullable(tasks));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code masterCategories}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @param masterCategories
     *            new value of {@code masterCategories} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code masterCategories} field changed
     */
    public OutlookUser withMasterCategories(List<OutlookCategory> masterCategories) {
        OutlookUser _x = _copy();
        _x.changedFields = changedFields.add("masterCategories");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.outlookUser");
        _x.masterCategories = masterCategories;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code taskFolders}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @param taskFolders
     *            new value of {@code taskFolders} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code taskFolders} field changed
     */
    public OutlookUser withTaskFolders(List<OutlookTaskFolder> taskFolders) {
        OutlookUser _x = _copy();
        _x.changedFields = changedFields.add("taskFolders");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.outlookUser");
        _x.taskFolders = taskFolders;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code taskGroups} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @param taskGroups
     *            new value of {@code taskGroups} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code taskGroups} field changed
     */
    public OutlookUser withTaskGroups(List<OutlookTaskGroup> taskGroups) {
        OutlookUser _x = _copy();
        _x.changedFields = changedFields.add("taskGroups");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.outlookUser");
        _x.taskGroups = taskGroups;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code tasks} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @param tasks
     *            new value of {@code tasks} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code tasks} field changed
     */
    public OutlookUser withTasks(List<OutlookTask> tasks) {
        OutlookUser _x = _copy();
        _x.changedFields = changedFields.add("tasks");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.outlookUser");
        _x.tasks = tasks;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OutlookUser patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        OutlookUser _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OutlookUser put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        OutlookUser _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private OutlookUser _copy() {
        OutlookUser _x = new OutlookUser();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.masterCategories = masterCategories;
        _x.taskFolders = taskFolders;
        _x.taskGroups = taskGroups;
        _x.tasks = tasks;
        return _x;
    }

    @Function(name = "supportedLanguages")
    @JsonIgnore
    public CollectionPageNonEntityRequest<LocaleInfo> supportedLanguages() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.supportedLanguages"), LocaleInfo.class, _parameters);
    }

    @Function(name = "supportedTimeZones")
    @JsonIgnore
    public CollectionPageNonEntityRequest<TimeZoneInformation> supportedTimeZones() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.supportedTimeZones"), TimeZoneInformation.class, _parameters);
    }

    @Function(name = "supportedTimeZones")
    @JsonIgnore
    public CollectionPageNonEntityRequest<TimeZoneInformation> supportedTimeZones_Function(TimeZoneStandard timeZoneStandard) {
        Preconditions.checkNotNull(timeZoneStandard, "timeZoneStandard cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("TimeZoneStandard", "microsoft.graph.timeZoneStandard", timeZoneStandard)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.supportedTimeZones"), TimeZoneInformation.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OutlookUser[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("masterCategories=");
        b.append(this.masterCategories);
        b.append(", ");
        b.append("taskFolders=");
        b.append(this.taskFolders);
        b.append(", ");
        b.append("taskGroups=");
        b.append(this.taskGroups);
        b.append(", ");
        b.append("tasks=");
        b.append(this.tasks);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
