package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

import odata.msgraph.client.beta.entity.collection.request.MultiValueLegacyExtendedPropertyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OutlookTaskCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SingleValueLegacyExtendedPropertyCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "changeKey", 
    "isDefaultFolder", 
    "name", 
    "parentGroupKey", 
    "multiValueExtendedProperties", 
    "singleValueExtendedProperties", 
    "tasks"})
@JsonInclude(Include.NON_NULL)
public class OutlookTaskFolder extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.outlookTaskFolder";
    }

    @JsonProperty("changeKey")
    protected String changeKey;

    @JsonProperty("isDefaultFolder")
    protected Boolean isDefaultFolder;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("parentGroupKey")
    protected UUID parentGroupKey;

    @JsonProperty("multiValueExtendedProperties")
    protected List<MultiValueLegacyExtendedProperty> multiValueExtendedProperties;

    @JsonProperty("singleValueExtendedProperties")
    protected List<SingleValueLegacyExtendedProperty> singleValueExtendedProperties;

    @JsonProperty("tasks")
    protected List<OutlookTask> tasks;

    protected OutlookTaskFolder() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderOutlookTaskFolder() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String changeKey;
        private Boolean isDefaultFolder;
        private String name;
        private UUID parentGroupKey;
        private List<MultiValueLegacyExtendedProperty> multiValueExtendedProperties;
        private List<SingleValueLegacyExtendedProperty> singleValueExtendedProperties;
        private List<OutlookTask> tasks;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder changeKey(String changeKey) {
            this.changeKey = changeKey;
            this.changedFields = changedFields.add("changeKey");
            return this;
        }

        public Builder isDefaultFolder(Boolean isDefaultFolder) {
            this.isDefaultFolder = isDefaultFolder;
            this.changedFields = changedFields.add("isDefaultFolder");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder parentGroupKey(UUID parentGroupKey) {
            this.parentGroupKey = parentGroupKey;
            this.changedFields = changedFields.add("parentGroupKey");
            return this;
        }

        public Builder multiValueExtendedProperties(List<MultiValueLegacyExtendedProperty> multiValueExtendedProperties) {
            this.multiValueExtendedProperties = multiValueExtendedProperties;
            this.changedFields = changedFields.add("multiValueExtendedProperties");
            return this;
        }

        public Builder multiValueExtendedProperties(MultiValueLegacyExtendedProperty... multiValueExtendedProperties) {
            return multiValueExtendedProperties(Arrays.asList(multiValueExtendedProperties));
        }

        public Builder singleValueExtendedProperties(List<SingleValueLegacyExtendedProperty> singleValueExtendedProperties) {
            this.singleValueExtendedProperties = singleValueExtendedProperties;
            this.changedFields = changedFields.add("singleValueExtendedProperties");
            return this;
        }

        public Builder singleValueExtendedProperties(SingleValueLegacyExtendedProperty... singleValueExtendedProperties) {
            return singleValueExtendedProperties(Arrays.asList(singleValueExtendedProperties));
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * 
         * @param tasks
         *            value of {@code tasks} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder tasks(List<OutlookTask> tasks) {
            this.tasks = tasks;
            this.changedFields = changedFields.add("tasks");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * 
         * @param tasks
         *            value of {@code tasks} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder tasks(OutlookTask... tasks) {
            return tasks(Arrays.asList(tasks));
        }

        public OutlookTaskFolder build() {
            OutlookTaskFolder _x = new OutlookTaskFolder();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.outlookTaskFolder";
            _x.id = id;
            _x.changeKey = changeKey;
            _x.isDefaultFolder = isDefaultFolder;
            _x.name = name;
            _x.parentGroupKey = parentGroupKey;
            _x.multiValueExtendedProperties = multiValueExtendedProperties;
            _x.singleValueExtendedProperties = singleValueExtendedProperties;
            _x.tasks = tasks;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="changeKey")
    @JsonIgnore
    public Optional<String> getChangeKey() {
        return Optional.ofNullable(changeKey);
    }

    public OutlookTaskFolder withChangeKey(String changeKey) {
        OutlookTaskFolder _x = _copy();
        _x.changedFields = changedFields.add("changeKey");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.outlookTaskFolder");
        _x.changeKey = changeKey;
        return _x;
    }

    @Property(name="isDefaultFolder")
    @JsonIgnore
    public Optional<Boolean> getIsDefaultFolder() {
        return Optional.ofNullable(isDefaultFolder);
    }

    public OutlookTaskFolder withIsDefaultFolder(Boolean isDefaultFolder) {
        OutlookTaskFolder _x = _copy();
        _x.changedFields = changedFields.add("isDefaultFolder");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.outlookTaskFolder");
        _x.isDefaultFolder = isDefaultFolder;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public OutlookTaskFolder withName(String name) {
        OutlookTaskFolder _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.outlookTaskFolder");
        _x.name = name;
        return _x;
    }

    @Property(name="parentGroupKey")
    @JsonIgnore
    public Optional<UUID> getParentGroupKey() {
        return Optional.ofNullable(parentGroupKey);
    }

    public OutlookTaskFolder withParentGroupKey(UUID parentGroupKey) {
        OutlookTaskFolder _x = _copy();
        _x.changedFields = changedFields.add("parentGroupKey");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.outlookTaskFolder");
        _x.parentGroupKey = parentGroupKey;
        return _x;
    }

    public OutlookTaskFolder withUnmappedField(String name, Object value) {
        OutlookTaskFolder _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="multiValueExtendedProperties")
    @JsonIgnore
    public MultiValueLegacyExtendedPropertyCollectionRequest getMultiValueExtendedProperties() {
        return new MultiValueLegacyExtendedPropertyCollectionRequest(
                        contextPath.addSegment("multiValueExtendedProperties"), Optional.ofNullable(multiValueExtendedProperties));
    }

    @NavigationProperty(name="singleValueExtendedProperties")
    @JsonIgnore
    public SingleValueLegacyExtendedPropertyCollectionRequest getSingleValueExtendedProperties() {
        return new SingleValueLegacyExtendedPropertyCollectionRequest(
                        contextPath.addSegment("singleValueExtendedProperties"), Optional.ofNullable(singleValueExtendedProperties));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @return navigational property tasks
     */
    @NavigationProperty(name="tasks")
    @JsonIgnore
    public OutlookTaskCollectionRequest getTasks() {
        return new OutlookTaskCollectionRequest(
                        contextPath.addSegment("tasks"), Optional.ofNullable(tasks));
    }

    public OutlookTaskFolder withMultiValueExtendedProperties(List<MultiValueLegacyExtendedProperty> multiValueExtendedProperties) {
        OutlookTaskFolder _x = _copy();
        _x.changedFields = changedFields.add("multiValueExtendedProperties");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.outlookTaskFolder");
        _x.multiValueExtendedProperties = multiValueExtendedProperties;
        return _x;
    }

    public OutlookTaskFolder withSingleValueExtendedProperties(List<SingleValueLegacyExtendedProperty> singleValueExtendedProperties) {
        OutlookTaskFolder _x = _copy();
        _x.changedFields = changedFields.add("singleValueExtendedProperties");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.outlookTaskFolder");
        _x.singleValueExtendedProperties = singleValueExtendedProperties;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code tasks} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @param tasks
     *            new value of {@code tasks} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code tasks} field changed
     */
    public OutlookTaskFolder withTasks(List<OutlookTask> tasks) {
        OutlookTaskFolder _x = _copy();
        _x.changedFields = changedFields.add("tasks");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.outlookTaskFolder");
        _x.tasks = tasks;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OutlookTaskFolder patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        OutlookTaskFolder _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OutlookTaskFolder put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        OutlookTaskFolder _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private OutlookTaskFolder _copy() {
        OutlookTaskFolder _x = new OutlookTaskFolder();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.changeKey = changeKey;
        _x.isDefaultFolder = isDefaultFolder;
        _x.name = name;
        _x.parentGroupKey = parentGroupKey;
        _x.multiValueExtendedProperties = multiValueExtendedProperties;
        _x.singleValueExtendedProperties = singleValueExtendedProperties;
        _x.tasks = tasks;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OutlookTaskFolder[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("changeKey=");
        b.append(this.changeKey);
        b.append(", ");
        b.append("isDefaultFolder=");
        b.append(this.isDefaultFolder);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("parentGroupKey=");
        b.append(this.parentGroupKey);
        b.append(", ");
        b.append("multiValueExtendedProperties=");
        b.append(this.multiValueExtendedProperties);
        b.append(", ");
        b.append("singleValueExtendedProperties=");
        b.append(this.singleValueExtendedProperties);
        b.append(", ");
        b.append("tasks=");
        b.append(this.tasks);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
