package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;

import odata.msgraph.client.beta.complex.LoginPageTextVisibilitySettings;

@JsonPropertyOrder({
    "@odata.type"})
@JsonInclude(Include.NON_NULL)
public class OrganizationalBrandingLocalization extends OrganizationalBrandingProperties implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.organizationalBrandingLocalization";
    }

    protected OrganizationalBrandingLocalization() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderOrganizationalBrandingLocalization() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String backgroundColor;
        private String backgroundImage;
        private String backgroundImageRelativeUrl;
        private String bannerLogo;
        private String bannerLogoRelativeUrl;
        private List<String> cdnList;
        private String cdnListNextLink;
        private String customAccountResetCredentialsUrl;
        private String customCannotAccessYourAccountText;
        private String customCannotAccessYourAccountUrl;
        private String customForgotMyPasswordText;
        private String customPrivacyAndCookiesText;
        private String customPrivacyAndCookiesUrl;
        private String customResetItNowText;
        private String customTermsOfUseText;
        private String customTermsOfUseUrl;
        private String favicon;
        private String faviconRelativeUrl;
        private String headerBackgroundColor;
        private LoginPageTextVisibilitySettings loginPageTextVisibilitySettings;
        private String signInPageText;
        private String squareLogo;
        private String squareLogoRelativeUrl;
        private String usernameHintText;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder backgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
            this.changedFields = changedFields.add("backgroundColor");
            return this;
        }

        public Builder backgroundImage(String backgroundImage) {
            this.backgroundImage = backgroundImage;
            this.changedFields = changedFields.add("backgroundImage");
            return this;
        }

        public Builder backgroundImageRelativeUrl(String backgroundImageRelativeUrl) {
            this.backgroundImageRelativeUrl = backgroundImageRelativeUrl;
            this.changedFields = changedFields.add("backgroundImageRelativeUrl");
            return this;
        }

        public Builder bannerLogo(String bannerLogo) {
            this.bannerLogo = bannerLogo;
            this.changedFields = changedFields.add("bannerLogo");
            return this;
        }

        public Builder bannerLogoRelativeUrl(String bannerLogoRelativeUrl) {
            this.bannerLogoRelativeUrl = bannerLogoRelativeUrl;
            this.changedFields = changedFields.add("bannerLogoRelativeUrl");
            return this;
        }

        public Builder cdnList(List<String> cdnList) {
            this.cdnList = cdnList;
            this.changedFields = changedFields.add("cdnList");
            return this;
        }

        public Builder cdnList(String... cdnList) {
            return cdnList(Arrays.asList(cdnList));
        }

        public Builder cdnListNextLink(String cdnListNextLink) {
            this.cdnListNextLink = cdnListNextLink;
            this.changedFields = changedFields.add("cdnList");
            return this;
        }

        public Builder customAccountResetCredentialsUrl(String customAccountResetCredentialsUrl) {
            this.customAccountResetCredentialsUrl = customAccountResetCredentialsUrl;
            this.changedFields = changedFields.add("customAccountResetCredentialsUrl");
            return this;
        }

        public Builder customCannotAccessYourAccountText(String customCannotAccessYourAccountText) {
            this.customCannotAccessYourAccountText = customCannotAccessYourAccountText;
            this.changedFields = changedFields.add("customCannotAccessYourAccountText");
            return this;
        }

        public Builder customCannotAccessYourAccountUrl(String customCannotAccessYourAccountUrl) {
            this.customCannotAccessYourAccountUrl = customCannotAccessYourAccountUrl;
            this.changedFields = changedFields.add("customCannotAccessYourAccountUrl");
            return this;
        }

        public Builder customForgotMyPasswordText(String customForgotMyPasswordText) {
            this.customForgotMyPasswordText = customForgotMyPasswordText;
            this.changedFields = changedFields.add("customForgotMyPasswordText");
            return this;
        }

        public Builder customPrivacyAndCookiesText(String customPrivacyAndCookiesText) {
            this.customPrivacyAndCookiesText = customPrivacyAndCookiesText;
            this.changedFields = changedFields.add("customPrivacyAndCookiesText");
            return this;
        }

        public Builder customPrivacyAndCookiesUrl(String customPrivacyAndCookiesUrl) {
            this.customPrivacyAndCookiesUrl = customPrivacyAndCookiesUrl;
            this.changedFields = changedFields.add("customPrivacyAndCookiesUrl");
            return this;
        }

        public Builder customResetItNowText(String customResetItNowText) {
            this.customResetItNowText = customResetItNowText;
            this.changedFields = changedFields.add("customResetItNowText");
            return this;
        }

        public Builder customTermsOfUseText(String customTermsOfUseText) {
            this.customTermsOfUseText = customTermsOfUseText;
            this.changedFields = changedFields.add("customTermsOfUseText");
            return this;
        }

        public Builder customTermsOfUseUrl(String customTermsOfUseUrl) {
            this.customTermsOfUseUrl = customTermsOfUseUrl;
            this.changedFields = changedFields.add("customTermsOfUseUrl");
            return this;
        }

        public Builder favicon(String favicon) {
            this.favicon = favicon;
            this.changedFields = changedFields.add("favicon");
            return this;
        }

        public Builder faviconRelativeUrl(String faviconRelativeUrl) {
            this.faviconRelativeUrl = faviconRelativeUrl;
            this.changedFields = changedFields.add("faviconRelativeUrl");
            return this;
        }

        public Builder headerBackgroundColor(String headerBackgroundColor) {
            this.headerBackgroundColor = headerBackgroundColor;
            this.changedFields = changedFields.add("headerBackgroundColor");
            return this;
        }

        public Builder loginPageTextVisibilitySettings(LoginPageTextVisibilitySettings loginPageTextVisibilitySettings) {
            this.loginPageTextVisibilitySettings = loginPageTextVisibilitySettings;
            this.changedFields = changedFields.add("loginPageTextVisibilitySettings");
            return this;
        }

        public Builder signInPageText(String signInPageText) {
            this.signInPageText = signInPageText;
            this.changedFields = changedFields.add("signInPageText");
            return this;
        }

        public Builder squareLogo(String squareLogo) {
            this.squareLogo = squareLogo;
            this.changedFields = changedFields.add("squareLogo");
            return this;
        }

        public Builder squareLogoRelativeUrl(String squareLogoRelativeUrl) {
            this.squareLogoRelativeUrl = squareLogoRelativeUrl;
            this.changedFields = changedFields.add("squareLogoRelativeUrl");
            return this;
        }

        public Builder usernameHintText(String usernameHintText) {
            this.usernameHintText = usernameHintText;
            this.changedFields = changedFields.add("usernameHintText");
            return this;
        }

        public OrganizationalBrandingLocalization build() {
            OrganizationalBrandingLocalization _x = new OrganizationalBrandingLocalization();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.organizationalBrandingLocalization";
            _x.id = id;
            _x.backgroundColor = backgroundColor;
            _x.backgroundImage = backgroundImage;
            _x.backgroundImageRelativeUrl = backgroundImageRelativeUrl;
            _x.bannerLogo = bannerLogo;
            _x.bannerLogoRelativeUrl = bannerLogoRelativeUrl;
            _x.cdnList = cdnList;
            _x.cdnListNextLink = cdnListNextLink;
            _x.customAccountResetCredentialsUrl = customAccountResetCredentialsUrl;
            _x.customCannotAccessYourAccountText = customCannotAccessYourAccountText;
            _x.customCannotAccessYourAccountUrl = customCannotAccessYourAccountUrl;
            _x.customForgotMyPasswordText = customForgotMyPasswordText;
            _x.customPrivacyAndCookiesText = customPrivacyAndCookiesText;
            _x.customPrivacyAndCookiesUrl = customPrivacyAndCookiesUrl;
            _x.customResetItNowText = customResetItNowText;
            _x.customTermsOfUseText = customTermsOfUseText;
            _x.customTermsOfUseUrl = customTermsOfUseUrl;
            _x.favicon = favicon;
            _x.faviconRelativeUrl = faviconRelativeUrl;
            _x.headerBackgroundColor = headerBackgroundColor;
            _x.loginPageTextVisibilitySettings = loginPageTextVisibilitySettings;
            _x.signInPageText = signInPageText;
            _x.squareLogo = squareLogo;
            _x.squareLogoRelativeUrl = squareLogoRelativeUrl;
            _x.usernameHintText = usernameHintText;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public OrganizationalBrandingLocalization withUnmappedField(String name, Object value) {
        OrganizationalBrandingLocalization _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OrganizationalBrandingLocalization patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        OrganizationalBrandingLocalization _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OrganizationalBrandingLocalization put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        OrganizationalBrandingLocalization _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private OrganizationalBrandingLocalization _copy() {
        OrganizationalBrandingLocalization _x = new OrganizationalBrandingLocalization();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.backgroundColor = backgroundColor;
        _x.backgroundImage = backgroundImage;
        _x.backgroundImageRelativeUrl = backgroundImageRelativeUrl;
        _x.bannerLogo = bannerLogo;
        _x.bannerLogoRelativeUrl = bannerLogoRelativeUrl;
        _x.cdnList = cdnList;
        _x.customAccountResetCredentialsUrl = customAccountResetCredentialsUrl;
        _x.customCannotAccessYourAccountText = customCannotAccessYourAccountText;
        _x.customCannotAccessYourAccountUrl = customCannotAccessYourAccountUrl;
        _x.customForgotMyPasswordText = customForgotMyPasswordText;
        _x.customPrivacyAndCookiesText = customPrivacyAndCookiesText;
        _x.customPrivacyAndCookiesUrl = customPrivacyAndCookiesUrl;
        _x.customResetItNowText = customResetItNowText;
        _x.customTermsOfUseText = customTermsOfUseText;
        _x.customTermsOfUseUrl = customTermsOfUseUrl;
        _x.favicon = favicon;
        _x.faviconRelativeUrl = faviconRelativeUrl;
        _x.headerBackgroundColor = headerBackgroundColor;
        _x.loginPageTextVisibilitySettings = loginPageTextVisibilitySettings;
        _x.signInPageText = signInPageText;
        _x.squareLogo = squareLogo;
        _x.squareLogoRelativeUrl = squareLogoRelativeUrl;
        _x.usernameHintText = usernameHintText;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OrganizationalBrandingLocalization[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("backgroundColor=");
        b.append(this.backgroundColor);
        b.append(", ");
        b.append("backgroundImage=");
        b.append(this.backgroundImage);
        b.append(", ");
        b.append("backgroundImageRelativeUrl=");
        b.append(this.backgroundImageRelativeUrl);
        b.append(", ");
        b.append("bannerLogo=");
        b.append(this.bannerLogo);
        b.append(", ");
        b.append("bannerLogoRelativeUrl=");
        b.append(this.bannerLogoRelativeUrl);
        b.append(", ");
        b.append("cdnList=");
        b.append(this.cdnList);
        b.append(", ");
        b.append("customAccountResetCredentialsUrl=");
        b.append(this.customAccountResetCredentialsUrl);
        b.append(", ");
        b.append("customCannotAccessYourAccountText=");
        b.append(this.customCannotAccessYourAccountText);
        b.append(", ");
        b.append("customCannotAccessYourAccountUrl=");
        b.append(this.customCannotAccessYourAccountUrl);
        b.append(", ");
        b.append("customForgotMyPasswordText=");
        b.append(this.customForgotMyPasswordText);
        b.append(", ");
        b.append("customPrivacyAndCookiesText=");
        b.append(this.customPrivacyAndCookiesText);
        b.append(", ");
        b.append("customPrivacyAndCookiesUrl=");
        b.append(this.customPrivacyAndCookiesUrl);
        b.append(", ");
        b.append("customResetItNowText=");
        b.append(this.customResetItNowText);
        b.append(", ");
        b.append("customTermsOfUseText=");
        b.append(this.customTermsOfUseText);
        b.append(", ");
        b.append("customTermsOfUseUrl=");
        b.append(this.customTermsOfUseUrl);
        b.append(", ");
        b.append("favicon=");
        b.append(this.favicon);
        b.append(", ");
        b.append("faviconRelativeUrl=");
        b.append(this.faviconRelativeUrl);
        b.append(", ");
        b.append("headerBackgroundColor=");
        b.append(this.headerBackgroundColor);
        b.append(", ");
        b.append("loginPageTextVisibilitySettings=");
        b.append(this.loginPageTextVisibilitySettings);
        b.append(", ");
        b.append("signInPageText=");
        b.append(this.signInPageText);
        b.append(", ");
        b.append("squareLogo=");
        b.append(this.squareLogo);
        b.append(", ");
        b.append("squareLogoRelativeUrl=");
        b.append(this.squareLogoRelativeUrl);
        b.append(", ");
        b.append("usernameHintText=");
        b.append(this.usernameHintText);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
