package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.ProfileCardPropertyCollectionRequest;
import odata.msgraph.client.beta.entity.request.InsightsSettingsRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "itemInsights", 
    "peopleInsights", 
    "profileCardProperties"})
@JsonInclude(Include.NON_NULL)
public class OrganizationSettings extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.organizationSettings";
    }

    @JsonProperty("itemInsights")
    protected InsightsSettings itemInsights;

    @JsonProperty("peopleInsights")
    protected InsightsSettings peopleInsights;

    @JsonProperty("profileCardProperties")
    protected List<ProfileCardProperty> profileCardProperties;

    protected OrganizationSettings() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderOrganizationSettings() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private InsightsSettings itemInsights;
        private InsightsSettings peopleInsights;
        private List<ProfileCardProperty> profileCardProperties;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder itemInsights(InsightsSettings itemInsights) {
            this.itemInsights = itemInsights;
            this.changedFields = changedFields.add("itemInsights");
            return this;
        }

        public Builder peopleInsights(InsightsSettings peopleInsights) {
            this.peopleInsights = peopleInsights;
            this.changedFields = changedFields.add("peopleInsights");
            return this;
        }

        public Builder profileCardProperties(List<ProfileCardProperty> profileCardProperties) {
            this.profileCardProperties = profileCardProperties;
            this.changedFields = changedFields.add("profileCardProperties");
            return this;
        }

        public Builder profileCardProperties(ProfileCardProperty... profileCardProperties) {
            return profileCardProperties(Arrays.asList(profileCardProperties));
        }

        public OrganizationSettings build() {
            OrganizationSettings _x = new OrganizationSettings();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.organizationSettings";
            _x.id = id;
            _x.itemInsights = itemInsights;
            _x.peopleInsights = peopleInsights;
            _x.profileCardProperties = profileCardProperties;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public OrganizationSettings withUnmappedField(String name, Object value) {
        OrganizationSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="itemInsights")
    @JsonIgnore
    public InsightsSettingsRequest getItemInsights() {
        return new InsightsSettingsRequest(contextPath.addSegment("itemInsights"), Optional.ofNullable(itemInsights));
    }

    @NavigationProperty(name="peopleInsights")
    @JsonIgnore
    public InsightsSettingsRequest getPeopleInsights() {
        return new InsightsSettingsRequest(contextPath.addSegment("peopleInsights"), Optional.ofNullable(peopleInsights));
    }

    @NavigationProperty(name="profileCardProperties")
    @JsonIgnore
    public ProfileCardPropertyCollectionRequest getProfileCardProperties() {
        return new ProfileCardPropertyCollectionRequest(
                        contextPath.addSegment("profileCardProperties"), Optional.ofNullable(profileCardProperties));
    }

    public OrganizationSettings withItemInsights(InsightsSettings itemInsights) {
        OrganizationSettings _x = _copy();
        _x.changedFields = changedFields.add("itemInsights");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.organizationSettings");
        _x.itemInsights = itemInsights;
        return _x;
    }

    public OrganizationSettings withPeopleInsights(InsightsSettings peopleInsights) {
        OrganizationSettings _x = _copy();
        _x.changedFields = changedFields.add("peopleInsights");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.organizationSettings");
        _x.peopleInsights = peopleInsights;
        return _x;
    }

    public OrganizationSettings withProfileCardProperties(List<ProfileCardProperty> profileCardProperties) {
        OrganizationSettings _x = _copy();
        _x.changedFields = changedFields.add("profileCardProperties");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.organizationSettings");
        _x.profileCardProperties = profileCardProperties;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OrganizationSettings patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        OrganizationSettings _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OrganizationSettings put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        OrganizationSettings _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private OrganizationSettings _copy() {
        OrganizationSettings _x = new OrganizationSettings();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.itemInsights = itemInsights;
        _x.peopleInsights = peopleInsights;
        _x.profileCardProperties = profileCardProperties;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OrganizationSettings[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("itemInsights=");
        b.append(this.itemInsights);
        b.append(", ");
        b.append("peopleInsights=");
        b.append(this.peopleInsights);
        b.append(", ");
        b.append("profileCardProperties=");
        b.append(this.profileCardProperties);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
